/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.pluggable.analyzer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.cluster.verification.pluggable.analyzer.PluggableJavaAnalyzer;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

public class PluggableNetworkBondingAnalyzer
implements PluggableJavaAnalyzer {
    private ExecutableInfo m_execInfo;

    @Override
    public ResultSet analyze(ResultSet resultSet) {
        ResultSet analyzerResultSet = new ResultSet();
        if (resultSet != null) {
            Set<String> nodeList = resultSet.getResultTable().keySet();
            Hashtable<Integer, Hashtable<String, Set<String>>> modeWiseNodePvtNICs = new Hashtable<Integer, Hashtable<String, Set<String>>>();
            for (String node : nodeList) {
                Result nodeResult = resultSet.getResult(node);
                if (nodeResult.getStatus() == 1) {
                    analyzerResultSet.addResult(node, nodeResult);
                    continue;
                }
                if (nodeResult.getStatus() == 4) {
                    try {
                        String output = nodeResult.getActualValue();
                        Trace.out((String)("The output of CI Bonding check pluggable script on the node (" + node + " is (" + output + ")"));
                        Trace.out((String)("Processing Network bonding configuration for private interfaces retrieved from node (" + node + ")"));
                        Hashtable<Integer, Set<String>> modeWiseNICListTable = this.processNodeWisePluggableScriptOutput(output);
                        if (modeWiseNICListTable != null && !modeWiseNICListTable.isEmpty()) {
                            Trace.out((String)("Collected the network bonding configuration information for pvt NIC's on node " + node));
                            for (int mode : modeWiseNICListTable.keySet()) {
                                if (!modeWiseNodePvtNICs.containsKey(mode)) {
                                    Hashtable<String, Set<String>> nodeNicList = new Hashtable<String, Set<String>>();
                                    nodeNicList.put(node, modeWiseNICListTable.get(mode));
                                    modeWiseNodePvtNICs.put(mode, nodeNicList);
                                    continue;
                                }
                                if (!modeWiseNodePvtNICs.get(mode).containsKey(node)) {
                                    HashSet nicList = new HashSet();
                                    modeWiseNodePvtNICs.get(mode).put(node, nicList);
                                }
                                modeWiseNodePvtNICs.get(mode).get(node).addAll((Collection<String>)modeWiseNICListTable.get(mode));
                            }
                            continue;
                        }
                        analyzerResultSet.addResult(node, 2);
                    }
                    catch (ResultValuesUnavailableException rvue) {
                        Trace.out((String)("No output from node  " + node));
                        analyzerResultSet.addResult(node, 2);
                    }
                    continue;
                }
                analyzerResultSet.addResult(node, nodeResult);
            }
            if (!modeWiseNodePvtNICs.isEmpty()) {
                analyzerResultSet = this.checkNetworkBondingModeAndConsistency(modeWiseNodePvtNICs, analyzerResultSet, nodeList);
            }
        }
        return analyzerResultSet;
    }

    private ResultSet checkNetworkBondingModeAndConsistency(Hashtable<Integer, Hashtable<String, Set<String>>> modeWiseNodePvtNICs, ResultSet inputResultSet, Set<String> nodeList) {
        HashSet<String> failedNodes = new HashSet<String>();
        Hashtable InconsistentModeNodes = new Hashtable();
        for (int mode : modeWiseNodePvtNICs.keySet()) {
            if (mode > 1) {
                for (String node : modeWiseNodePvtNICs.get(mode).keySet()) {
                    inputResultSet.addErrorDescription(node, new ErrorDescription(s_eMsgBundle.getMessage("0463", true, (Object[])new String[]{node, this.getBondString(mode), VerificationUtil.strCollection2String((Collection)modeWiseNodePvtNICs.get(mode).get(node))})));
                    inputResultSet.addResult(node, 3);
                    failedNodes.add(node);
                }
                if (failedNodes.isEmpty()) continue;
                inputResultSet.addErrorDescription(new ErrorDescription(s_eMsgBundle.getMessage("0464", true, (Object[])new String[]{VerificationUtil.strCollection2String(failedNodes)})));
                continue;
            }
            if (!modeWiseNodePvtNICs.get(mode).keySet().containsAll(nodeList)) {
                ArrayList<String> nodeInfoMsgList = new ArrayList<String>();
                for (String node : modeWiseNodePvtNICs.get(mode).keySet()) {
                    nodeInfoMsgList.add(s_eMsgBundle.getMessage("0462", false, (Object[])new String[]{Integer.toString(mode), VerificationUtil.strCollection2String((Collection)modeWiseNodePvtNICs.get(mode).get(node)), node}));
                    InconsistentModeNodes.put(node, nodeInfoMsgList);
                }
                continue;
            }
            inputResultSet.addResult(modeWiseNodePvtNICs.get(mode).keySet(), 1);
        }
        if (!InconsistentModeNodes.isEmpty()) {
            String detailedMsg = "";
            for (String node : InconsistentModeNodes.keySet()) {
                for (String nodeMsg : (List)InconsistentModeNodes.get(node)) {
                    if (!VerificationUtil.isStringGood(nodeMsg)) continue;
                    detailedMsg = (VerificationUtil.isStringGood(detailedMsg) ? detailedMsg + VerificationConstants.LINE_SEPARATOR : detailedMsg) + nodeMsg;
                    Trace.out((String)nodeMsg);
                }
            }
            detailedMsg = s_eMsgBundle.getMessage("0465", true, (Object[])new String[]{VerificationUtil.strCollection2String(InconsistentModeNodes.keySet()), detailedMsg});
            Trace.out((String)detailedMsg);
            inputResultSet.addErrorDescription(new ErrorDescription(detailedMsg));
            inputResultSet.addResult(InconsistentModeNodes.keySet(), 3);
        }
        return inputResultSet;
    }

    private Hashtable<Integer, Set<String>> processNodeWisePluggableScriptOutput(String data) {
        String[] commaSplit;
        Hashtable<Integer, Set<String>> modeWiseNICListTable = new Hashtable<Integer, Set<String>>();
        if (VerificationUtil.isStringGood(data) && (commaSplit = data.split(",")) != null && commaSplit.length > 0) {
            for (String str : commaSplit) {
                Trace.out((String)("Processing (" + str + ")"));
                String[] equalSplit = str.split("=");
                if (equalSplit == null || equalSplit.length <= 1) continue;
                String bondModeStr = equalSplit[0];
                String participatingPvtNICs = equalSplit[1];
                Trace.out((String)("The bond mode is (" + bondModeStr + ") and " + "participating private NIC's are (" + participatingPvtNICs + ")"));
                String[] nicNamesSplit = participatingPvtNICs.trim().split("\\s+");
                if (nicNamesSplit == null || nicNamesSplit.length <= 0) continue;
                int bondMode = Integer.parseInt(bondModeStr);
                if (modeWiseNICListTable.containsKey(bondMode)) {
                    modeWiseNICListTable.get(bondMode).addAll(Arrays.asList(nicNamesSplit));
                    continue;
                }
                HashSet<String> nicList = new HashSet<String>();
                nicList.addAll(Arrays.asList(nicNamesSplit));
                modeWiseNICListTable.put(bondMode, nicList);
            }
        }
        return modeWiseNICListTable;
    }

    private String getBondString(int mode) {
        if (mode == 0) {
            return "balance-rr";
        }
        if (mode == 1) {
            return "active-backup";
        }
        if (mode == 2) {
            return "balance-xor";
        }
        if (mode == 3) {
            return "broadcast";
        }
        if (mode == 4) {
            return "802.3ad";
        }
        if (mode == 5) {
            return "balance-tlb";
        }
        if (mode == 6) {
            return "balance-alb";
        }
        return null;
    }

    @Override
    public void setExecutableInfo(ExecutableInfo execInfo) {
        this.m_execInfo = execInfo;
    }
}

