/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.pluggable.analyzer;

import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import javax.sql.rowset.CachedRowSet;
import oracle.cluster.verification.pluggable.PluggableTaskUtil;
import oracle.cluster.verification.pluggable.VerificationExecutableException;
import oracle.cluster.verification.pluggable.analyzer.PluggableJavaAnalyzer;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.data.ArgType;
import oracle.ops.verification.framework.engine.factory.data.DataType;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.factory.data.ExecutableResultType;
import oracle.ops.verification.framework.engine.factory.data.ExecutableType;
import oracle.ops.verification.framework.util.VerificationUtil;

public class DBScriptAnalyzer
implements PluggableJavaAnalyzer {
    protected static MessageBundle s_eMsgBundle = VerificationUtil.getMessageBundle("Prve");
    private ExecutableInfo m_execInfo;

    @Override
    public ResultSet analyze(ResultSet resultSet) {
        ResultSet analyzerResultSet = new ResultSet();
        if (resultSet == null) {
            analyzerResultSet.setStatus(2);
            return analyzerResultSet;
        }
        ExecutableArgument scriptNameArgument = this.m_execInfo.getExecutableArgs().remove(0);
        ExecutableArgument dbNameArgument = this.m_execInfo.getExecutableArgs().remove(0);
        List<ExecutableArgument> scriptArguments = this.m_execInfo.getExecutableArgs();
        Set keySet = resultSet.getResultTable().keySet();
        for (String key : keySet) {
            try {
                Result result = resultSet.getResult(key);
                CachedRowSet rowSet = (CachedRowSet)result.getResultInfoSet().firstElement();
                int columnCount = rowSet.getMetaData().getColumnCount();
                String node = null;
                String dbInstanceID = null;
                while (rowSet.next()) {
                    ExecutableInfo execScriptInfo = new ExecutableInfo(scriptNameArgument.getArgVal(false), ExecutableType.SCRIPT, ExecutableResultType.ANALYZED);
                    execScriptInfo.addExecArgument(dbNameArgument);
                    for (int i = 0; i < columnCount; ++i) {
                        if (i == 0) {
                            node = rowSet.getString(i + 1);
                            execScriptInfo.addExecArgument(new ExecutableArgument(node, ArgType.DEFINED, DataType.STRING, node));
                            continue;
                        }
                        if (i == 1) {
                            dbInstanceID = rowSet.getString(i + 1);
                            execScriptInfo.addExecArgument(new ExecutableArgument(dbInstanceID, ArgType.DEFINED, DataType.STRING, dbInstanceID));
                            continue;
                        }
                        String val = rowSet.getString(i + 1);
                        execScriptInfo.addExecArgument(new ExecutableArgument(val, ArgType.DEFINED, DataType.STRING, val));
                    }
                    for (ExecutableArgument execArg : scriptArguments) {
                        execScriptInfo.addExecArgument(execArg);
                    }
                    ResultSet scriptRS = PluggableTaskUtil.execExecutable(new String[]{node}, execScriptInfo);
                    analyzerResultSet.uploadResultSet(scriptRS);
                }
            }
            catch (SQLException e) {
                Trace.out((Exception)e);
                analyzerResultSet.addResult(key, 2);
                analyzerResultSet.addErrorDescription(key, new ErrorDescription(e.getMessage()));
            }
            catch (VerificationExecutableException e) {
                Trace.out((Exception)e);
                analyzerResultSet.addResult(key, 2);
                analyzerResultSet.addErrorDescription(key, new ErrorDescription(e.getMessage()));
            }
        }
        return analyzerResultSet;
    }

    @Override
    public void setExecutableInfo(ExecutableInfo execInfo) {
        this.m_execInfo = execInfo;
    }
}

