/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.pluggable;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.rowset.CachedRowSet;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.pluggable.PluggableMsgType;
import oracle.cluster.verification.pluggable.PluggableTaskUtil;
import oracle.cluster.verification.pluggable.ReferenceInfo;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultKeyType;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.data.DataComparator;
import oracle.ops.verification.framework.engine.factory.data.DataComparatorType;
import oracle.ops.verification.framework.engine.factory.data.DataType;
import oracle.ops.verification.framework.engine.factory.data.ResultAnalyzerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.RangeOperator;
import oracle.ops.verification.framework.util.RangeType;

public class SQLDataComparator
extends DataComparator {
    protected String m_refColumn = null;
    protected String m_taskID = null;
    protected List<ReferenceInfo> m_columnReferenceList = null;
    protected List<String> m_columnNameList = null;
    protected boolean m_emptyResultSetImpliesSuccess = true;

    public SQLDataComparator(String taskID, String refColumn, List<String> columnNameList, List<ReferenceInfo> columnReferenceList, boolean emptyResultSetImpliesSuccess) {
        this.m_refColumn = refColumn;
        this.m_columnNameList = columnNameList;
        this.m_columnReferenceList = columnReferenceList;
        this.m_taskID = taskID;
        this.m_emptyResultSetImpliesSuccess = emptyResultSetImpliesSuccess;
        Trace.out((int)1, (String)("taskID: '" + taskID + "' refColumn: '" + refColumn + "'\ncolumnNameList: '" + columnNameList + "' columnReferenceList: '" + columnReferenceList + "'"));
    }

    @Override
    public ResultSet analyzeResult(ResultSet vfnResult) throws ResultAnalyzerException {
        ResultSet rsltSet = new ResultSet();
        Hashtable ht = vfnResult.getResultTable();
        Enumeration e = ht.keys();
        ResultKeyType resKeyType = null;
        Result tempRes = null;
        while (e.hasMoreElements()) {
            String dbName = (String)e.nextElement();
            Result result = (Result)ht.get(dbName);
            resKeyType = result.getType();
            boolean resultSetEmpty = true;
            String resultName = null;
            Trace.out((int)1, (String)("Processing result object: \n" + result.traceResultInfo()));
            if (result.getStatus() == 1) {
                CachedRowSet collected = (CachedRowSet)result.getResultInfoSet().firstElement();
                try {
                    String expectedValue;
                    String availableValue;
                    while (collected.next()) {
                        resultSetEmpty = false;
                        int columntCount = 1;
                        resultName = dbName;
                        switch (resKeyType) {
                            case ASM: {
                                if (this.m_taskID == null) break;
                                resultName = this.m_taskID;
                                break;
                            }
                            case DB_INSTANCE: 
                            case ASMINSTANCE: {
                                if (this.m_refColumn == null) break;
                                resultName = dbName + "(" + collected.getString(columntCount++) + ")";
                                break;
                            }
                            case ASMDISK: 
                            case ASMDISKGROUP: {
                                if (this.m_refColumn == null) break;
                                resultName = collected.getString(columntCount++);
                            }
                        }
                        tempRes = new Result(resultName, resKeyType);
                        availableValue = this.getAvailableValue(collected, this.m_columnReferenceList);
                        expectedValue = this.getExpectedValue(this.m_columnReferenceList);
                        tempRes.setActualValue(availableValue);
                        tempRes.setExpectedValue(expectedValue);
                        tempRes.setHasResultValues(true);
                        for (ReferenceInfo referenceInfo : this.m_columnReferenceList) {
                            String actualValue = this.getActualValue(collected, columntCount++);
                            try {
                                if (this.verify(actualValue, referenceInfo)) {
                                    tempRes.setStatus(1);
                                } else {
                                    tempRes.setStatus(3);
                                    ArrayList<String> errArgList = new ArrayList<String>();
                                    errArgList.add(collected.getCommand());
                                    int colCount = 1;
                                    while (colCount <= collected.getMetaData().getColumnCount()) {
                                        errArgList.add(collected.getString(colCount++));
                                    }
                                    errArgList.add(referenceInfo.getRefDataVal().toString());
                                    String vfailMsg = new PluggableTaskUtil().getPluggableMsg(PluggableMsgType.TASK_VFAIL, this.m_taskID, errArgList.toArray(new String[0]), true);
                                    tempRes.addErrorDescription(new ErrorDescription(vfailMsg));
                                    Trace.out((String)("vfailMsg: " + vfailMsg));
                                }
                                Trace.out((String)("Adding result for '" + resultName + "' key type: " + resKeyType.getResultKeyStr() + "\n" + tempRes.traceResultInfo()));
                                rsltSet.addResult(resultName, tempRes);
                            }
                            catch (VerificationException e1) {
                                Trace.out((int)1, (String)("VERIFICATIONEXCEPTION: " + e1.getMessage()));
                                rsltSet.addResult(resultName, 2, resKeyType);
                                rsltSet.addErrorDescription(resultName, new ErrorDescription(e1.getMessage()));
                            }
                        }
                    }
                    if (!resultSetEmpty) continue;
                    String refColumn = dbName;
                    tempRes = new Result(refColumn, resKeyType);
                    availableValue = ReportUtil.UNDEFINED;
                    expectedValue = this.getExpectedValue(this.m_columnReferenceList);
                    tempRes.setActualValue(availableValue);
                    tempRes.setExpectedValue(expectedValue);
                    tempRes.setHasResultValues(true);
                    if (this.m_emptyResultSetImpliesSuccess) {
                        tempRes.setStatus(1);
                        tempRes.setActualValue(expectedValue);
                    } else {
                        tempRes.setStatus(3);
                        String vfailMsg = new PluggableTaskUtil().getPluggableMsg(PluggableMsgType.TASK_VFAIL, this.m_taskID);
                        tempRes.addErrorDescription(new ErrorDescription(vfailMsg));
                    }
                    Trace.out((String)("Adding result for '" + refColumn + "' key type: " + resKeyType.getResultKeyStr() + "\n" + tempRes.traceResultInfo()));
                    rsltSet.addResult(refColumn, tempRes);
                }
                catch (SQLException e1) {
                    rsltSet.setStatus(2);
                    rsltSet.addErrorDescription(new ErrorDescription(e1.getMessage()));
                }
                continue;
            }
            Trace.out((String)("The status of execution result for node '" + dbName + "'+ is :" + Result.resultStatusString(result.getStatus()) + ";Hence skipped."));
            rsltSet.addResult(dbName, 2, resKeyType);
        }
        return rsltSet;
    }

    private String getExpectedValue(List<ReferenceInfo> m_columnReferenceList) {
        String value = "";
        for (int i = 0; i < m_columnReferenceList.size(); ++i) {
            ReferenceInfo referenceInfo = m_columnReferenceList.get(i);
            RangeOfValue expectedRange = null;
            String expected = null;
            if (i != 0) {
                value = value + "; ";
            }
            value = value + this.m_columnNameList.get(i);
            value = referenceInfo.getDataComparatorType() == DataComparatorType.NE || referenceInfo.getDataComparatorType() == DataComparatorType.NOT_IN ? value + " <> " : (referenceInfo.getDataComparatorType() == DataComparatorType.RE ? value + " ~ " : (referenceInfo.getDataComparatorType() == DataComparatorType.LE ? value + " <= " : (referenceInfo.getDataComparatorType() == DataComparatorType.LT ? value + " < " : (referenceInfo.getDataComparatorType() == DataComparatorType.GE ? value + " >= " : (referenceInfo.getDataComparatorType() == DataComparatorType.GT ? value + " > " : value + " = ")))));
            if (referenceInfo.getDataComparatorType() == DataComparatorType.RANGE) {
                expectedRange = (RangeOfValue)referenceInfo.getRefDataVal();
                value = value + expectedRange.toString();
                continue;
            }
            expected = ((String)referenceInfo.getRefDataVal()).trim();
            value = value + expected;
        }
        return value;
    }

    protected String getAvailableValue(CachedRowSet rowSet, List<ReferenceInfo> m_columnReferenceList) {
        String value = "";
        boolean first = true;
        int startIndex = this.m_refColumn != null ? 2 : 1;
        for (int i = 0; i < m_columnReferenceList.size(); ++i) {
            if (first) {
                first = false;
            } else {
                value = value + "; ";
            }
            value = value + this.m_columnNameList.get(i) + " = ";
            try {
                value = value + rowSet.getString(startIndex + i);
                continue;
            }
            catch (SQLException e) {
                Trace.out((Exception)e);
            }
        }
        return value;
    }

    protected String getActualValue(CachedRowSet rowSet, int colNo) throws SQLException {
        return rowSet.getString(colNo);
    }

    private boolean verify(String collected, ReferenceInfo referenceInfo) throws VerificationException {
        RangeOfValue expectedRange = null;
        String expected = null;
        DataComparatorType comparatorType = referenceInfo.getDataComparatorType();
        if (comparatorType == DataComparatorType.RANGE) {
            expectedRange = (RangeOfValue)referenceInfo.getRefDataVal();
        } else {
            expected = ((String)referenceInfo.getRefDataVal()).trim();
        }
        Trace.out((String)("expected=" + expected));
        Trace.out((String)("expectedRange=" + expectedRange));
        Trace.out((String)("collected=" + collected));
        Trace.out((String)("Datatype =" + (Object)((Object)referenceInfo.getDataType())));
        String obj = collected;
        RangeOfValue rov = null;
        switch (referenceInfo.getDataType()) {
            case STRING: 
            case VERSION: {
                if (referenceInfo.getDataType().equals((Object)DataType.STRING)) {
                    Trace.out((String)"Handling String datatype");
                    rov = new RangeOfValue(RangeType.STRING);
                } else {
                    Trace.out((String)"Handling Version datatype");
                    rov = new RangeOfValue(RangeType.VERSION);
                }
                try {
                    RangeOperator ro = this.getDataComparatorType(referenceInfo);
                    if (ro == null) {
                        Trace.out((String)"The given operator is not supported.");
                        throw new VerificationException(s_msgBundle.getMessage("0004", false));
                    }
                    if (comparatorType == DataComparatorType.IN || comparatorType == DataComparatorType.NOT_IN) {
                        String[] expectedArr = expected.split(Pattern.quote("|"));
                        if (comparatorType == DataComparatorType.IN) {
                            for (String expectedValue : expectedArr) {
                                rov.include(ro, expectedValue);
                                Trace.out((String)("Added " + expectedValue + " to the include list"));
                            }
                        } else {
                            rov.include(ro, collected);
                            for (String expectedValue : expectedArr) {
                                rov.exclude(ro, expectedValue);
                                Trace.out((String)("Added " + expectedValue + " to the exclude list"));
                            }
                        }
                    } else {
                        rov.include(ro, expected);
                    }
                    if (!rov.contains(obj)) {
                        return false;
                    }
                }
                catch (InvalidRangeManipulationException irme) {
                    throw new VerificationException(irme.getMessage(), irme);
                }
                return true;
            }
            case NUMERIC: {
                if (expectedRange != null) {
                    try {
                        if (!expectedRange.contains(obj)) {
                            return false;
                        }
                    }
                    catch (InvalidRangeManipulationException irme) {
                        throw new VerificationException(irme.getMessage(), irme);
                    }
                    return true;
                }
                if (collected.lastIndexOf("-") > 0 || collected.lastIndexOf("+") > 0 || expected.lastIndexOf("-") > 0 || expected.lastIndexOf("+") > 0) {
                    Trace.out((String)"String is not Numeric.");
                    throw new VerificationException(s_msgBundle.getMessage("0005", false));
                }
                String tempCollected = collected.replaceFirst("[\\+\\-]", "0").replaceFirst("\\.", "0");
                String tempExpected = expected.replaceFirst("[\\+\\-]", "0").replaceFirst("\\.", "0");
                Pattern p = Pattern.compile("\\D");
                Matcher mc = p.matcher(tempCollected);
                Matcher me = p.matcher(tempExpected);
                if (mc.matches() || me.matches()) {
                    Trace.out((String)"String is not Numeric");
                    throw new VerificationException(s_msgBundle.getMessage("0005", false));
                }
                try {
                    rov = new RangeOfValue(collected.indexOf(".") > 0 || expected.indexOf(".") > 0 ? RangeType.FLOAT : RangeType.INTEGER);
                    RangeOperator ro = this.getDataComparatorType(referenceInfo);
                    if (ro == null) {
                        Trace.out((String)"Unable to get appropriate Operator");
                        throw new VerificationException(s_msgBundle.getMessage("0004", false));
                    }
                    rov.include(ro, expected);
                    if (!rov.contains(obj)) {
                        return false;
                    }
                }
                catch (InvalidRangeManipulationException irme) {
                    throw new VerificationException(irme.getMessage(), irme);
                }
                return true;
            }
            case LIST: {
                throw new VerificationException("not supported");
            }
        }
        return false;
    }

    private RangeOperator getDataComparatorType(ReferenceInfo m_referenceInfo) {
        switch (m_referenceInfo.getDataComparatorType()) {
            case EQ: 
            case IN: 
            case NOT_IN: {
                return RangeOperator.EQ;
            }
            case EQ_NO_CASE: {
                return RangeOperator.EQ_NO_CASE;
            }
            case GE: {
                return RangeOperator.GE;
            }
            case LE: {
                return RangeOperator.LE;
            }
            case GT: {
                return RangeOperator.GT;
            }
            case LT: {
                return RangeOperator.LT;
            }
            case NE: {
                return RangeOperator.NE;
            }
            case RE: {
                return RangeOperator.RE;
            }
        }
        return null;
    }
}

