/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.pluggable;

import java.lang.reflect.Field;
import oracle.cluster.verification.pluggable.PluggableMsgType;
import oracle.cluster.verification.pluggable.PluggableTaskUtil;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.VerificationUtil;

public class DarwinPluggableTaskUtil
extends PluggableTaskUtil {
    private static MessageBundle[] m_darwinMsgBundles = new MessageBundle[4];
    private static Class[] m_darwinMsgRsrcCls = new Class[4];

    DarwinPluggableTaskUtil() {
        this.initDarwinMsgBundles();
    }

    @Override
    public String getPluggableMsg(PluggableMsgType msgType, String taskID, String[] msgParams) {
        String msgStr = "";
        try {
            for (int i = 0; i < m_darwinMsgBundles.length; ++i) {
                try {
                    String fieldName = msgType.getMsgIDExtn() + "_" + taskID;
                    if (m_darwinMsgRsrcCls[i] == null) continue;
                    Field f = m_darwinMsgRsrcCls[i].getField(fieldName);
                    String msgKey = (String)f.get(null);
                    if (m_darwinMsgBundles[i] == null) continue;
                    msgStr = m_darwinMsgBundles[i].getMessage(msgKey, false, (Object[])msgParams);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
        }
        catch (IllegalAccessException iaEx) {
            Trace.out((String)("IllegalAccessException encountered:" + iaEx));
        }
        return msgStr;
    }

    private void initDarwinMsgBundles() {
        try {
            String facilityName;
            if (m_darwinMsgBundles[0] == null) {
                DarwinPluggableTaskUtil.m_darwinMsgRsrcCls[0] = Class.forName("oracle.ops.verification.resources.PrvdMsgID");
                facilityName = (String)m_darwinMsgRsrcCls[0].getField("facility").get(null);
                DarwinPluggableTaskUtil.m_darwinMsgBundles[0] = VerificationUtil.getMessageBundle(facilityName);
                Trace.out((String)"Prvd message bundle is initialized");
            }
            if (m_darwinMsgBundles[1] == null) {
                DarwinPluggableTaskUtil.m_darwinMsgRsrcCls[1] = Class.forName("oracle.ops.verification.resources.PrvrMsgID");
                facilityName = (String)m_darwinMsgRsrcCls[1].getField("facility").get(null);
                DarwinPluggableTaskUtil.m_darwinMsgBundles[1] = VerificationUtil.getMessageBundle(facilityName);
                Trace.out((String)"Prvr message bundle is initialized");
            }
            if (m_darwinMsgBundles[2] == null) {
                DarwinPluggableTaskUtil.m_darwinMsgRsrcCls[2] = Class.forName("oracle.ops.verification.resources.PrvwMsgID");
                facilityName = (String)m_darwinMsgRsrcCls[2].getField("facility").get(null);
                DarwinPluggableTaskUtil.m_darwinMsgBundles[2] = VerificationUtil.getMessageBundle(facilityName);
                Trace.out((String)"Prvw message bundle is initialized");
            }
            if (m_darwinMsgBundles[3] == null) {
                DarwinPluggableTaskUtil.m_darwinMsgRsrcCls[3] = Class.forName("oracle.ops.verification.resources.PrvnMsgID");
                facilityName = (String)m_darwinMsgRsrcCls[3].getField("facility").get(null);
                DarwinPluggableTaskUtil.m_darwinMsgBundles[3] = VerificationUtil.getMessageBundle(facilityName);
                Trace.out((String)"Prvn message bundle is initialized");
            }
        }
        catch (ClassNotFoundException e) {
            Trace.out((String)("ClassNotFoundException encountered:" + e));
        }
        catch (NoSuchFieldException e) {
            Trace.out((String)("NoSuchFieldException encountered:" + e));
        }
        catch (IllegalAccessException e) {
            Trace.out((String)("IllegalAccessException encountered:" + e));
        }
    }
}

