/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.gpnp;

import oracle.cluster.verification.gpnp.GPnPASMProfile;
import oracle.cluster.verification.gpnp.GPnPBigClusterProfile;
import oracle.cluster.verification.gpnp.GPnPCSSProfile;
import oracle.cluster.verification.gpnp.GPnPNetworkProfile;
import oracle.cluster.verification.gpnp.GPnPOCRProfile;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GPnPProfile {
    private String m_profileSequence;
    private String m_clusterUid;
    private String m_clusterName;
    private String m_paLocation;
    private GPnPNetworkProfile m_networkProfile;
    private GPnPBigClusterProfile m_bigClusterProfile;
    private GPnPASMProfile m_asmProfile;
    private GPnPCSSProfile m_cssProfile;
    private GPnPOCRProfile m_ocrProfile;
    private static final String ASM_MODE_LEGACY = "legacy";
    private static final String ASM_MODE_REMOTE = "remote";
    private static final String ASM_MODE_CLIENT = "client";

    public GPnPProfile(String profileSequence, String clusterUid, String clusterName, String paLocation) {
        this.m_profileSequence = profileSequence;
        this.m_clusterUid = clusterUid;
        this.m_clusterName = clusterName;
        this.m_paLocation = paLocation;
    }

    public String getProfileSequence() {
        return this.m_profileSequence;
    }

    public String getClusterUid() {
        return this.m_clusterUid;
    }

    public String getClusterName() {
        return this.m_clusterName;
    }

    public String getPaLocation() {
        return this.m_paLocation;
    }

    public GPnPNetworkProfile getNetworkProfile() {
        return this.m_networkProfile;
    }

    public GPnPBigClusterProfile getBigClusterProfile() {
        return this.m_bigClusterProfile;
    }

    public GPnPASMProfile getAsmProfile() {
        return this.m_asmProfile;
    }

    public GPnPCSSProfile getCssProfile() {
        return this.m_cssProfile;
    }

    public GPnPOCRProfile getOcrProfile() {
        return this.m_ocrProfile;
    }

    public GPnPNetworkProfile createNetworkProfile() {
        this.m_networkProfile = new GPnPNetworkProfile();
        return this.m_networkProfile;
    }

    public GPnPBigClusterProfile createBigClusterProfile(String id, String discoveryVIP) {
        this.m_bigClusterProfile = new GPnPBigClusterProfile(id, discoveryVIP);
        return this.m_bigClusterProfile;
    }

    public GPnPASMProfile createASMProfile(String id, String discoveryString, String spFile, String mode) {
        GPnPASMProfile.GPnPASMMode asmMode = null;
        if (VerificationUtil.isStringGood(mode)) {
            if (mode.equals(ASM_MODE_LEGACY)) {
                asmMode = GPnPASMProfile.GPnPASMMode.LEGACY;
            }
            if (mode.equals(ASM_MODE_REMOTE)) {
                asmMode = GPnPASMProfile.GPnPASMMode.REMOTE;
            }
            if (mode.equals(ASM_MODE_CLIENT)) {
                asmMode = GPnPASMProfile.GPnPASMMode.CLIENT;
            }
        }
        this.m_asmProfile = new GPnPASMProfile(id, discoveryString, spFile, asmMode);
        return this.m_asmProfile;
    }

    public GPnPCSSProfile createCSSProfile(String id, String discoveryString, long leaseDuration) {
        this.m_cssProfile = new GPnPCSSProfile(id, discoveryString, leaseDuration);
        return this.m_cssProfile;
    }

    public GPnPOCRProfile createOCRProfile(String id, String ocrId) {
        this.m_ocrProfile = new GPnPOCRProfile(id, ocrId);
        return this.m_ocrProfile;
    }

    public String toString() {
        StringBuffer gpnpProfileString = new StringBuffer();
        gpnpProfileString.append("profileSequence[" + this.m_profileSequence + "] " + "clusterId[" + this.m_clusterUid + "] " + "clusterName[" + this.m_clusterName + "] " + "paLocation[" + this.m_paLocation + "]");
        if (this.m_networkProfile != null) {
            gpnpProfileString.append(this.m_networkProfile.toString() + "\n");
        }
        if (this.m_bigClusterProfile != null) {
            gpnpProfileString.append(this.m_bigClusterProfile.toString() + "\n");
        }
        if (this.m_asmProfile != null) {
            gpnpProfileString.append(this.m_asmProfile.toString() + "\n");
        }
        if (this.m_cssProfile != null) {
            gpnpProfileString.append(this.m_cssProfile.toString() + "\n");
        }
        if (this.m_ocrProfile != null) {
            gpnpProfileString.append(this.m_ocrProfile.toString() + "\n");
        }
        return gpnpProfileString.toString();
    }
}

