/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.gpnp;

import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.gpnp.GPnPHAIP;
import oracle.cluster.verification.gpnp.GPnPHostNetwork;

public class GPnPNetworkProfile {
    private List<GPnPHAIP> m_haips;
    private List<GPnPHostNetwork> m_hostNetworks = new Vector<GPnPHostNetwork>();

    public GPnPNetworkProfile() {
        this.m_haips = new Vector<GPnPHAIP>();
    }

    public void addHAIP(GPnPHAIP haip) {
        this.m_haips.add(haip);
    }

    public void addHostNetwork(GPnPHostNetwork hostNetwork) {
        this.m_hostNetworks.add(hostNetwork);
    }

    public List<GPnPHAIP> getHAIPs() {
        return this.m_haips;
    }

    public List<GPnPHostNetwork> getHostNetworks() {
        return this.m_hostNetworks;
    }

    public GPnPHostNetwork findHostNetworkById(String id) {
        for (GPnPHostNetwork hostNetwork : this.m_hostNetworks) {
            if (!hostNetwork.getId().equals(id)) continue;
            return hostNetwork;
        }
        return null;
    }

    public GPnPHAIP findHAIPById(String id) {
        for (GPnPHAIP haip : this.m_haips) {
            if (!haip.getId().equals(id)) continue;
            return haip;
        }
        return null;
    }

    public String toString() {
        StringBuffer networkProfileString = new StringBuffer();
        for (GPnPHostNetwork hostNetwork : this.m_hostNetworks) {
            networkProfileString.append("  " + hostNetwork.toString() + "\n");
        }
        for (GPnPHAIP haip : this.m_haips) {
            networkProfileString.append("  " + haip.toString() + "\n");
        }
        return networkProfileString.toString();
    }
}

