/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.gpnp;

import java.net.InetAddress;

public class GPnPNetwork {
    private String m_id;
    private InetAddress m_ip;
    private String m_use;
    private String m_nameTempl;
    private GPnPNetworkAutoIP m_autoIp;
    private String m_adapter;

    public GPnPNetwork(String id, InetAddress ip, String use, String nameTempl, String adapter) {
        this(id, ip, use, nameTempl, GPnPNetworkAutoIP.NONE, adapter);
    }

    public GPnPNetwork(String id, InetAddress ip, String use, String nameTempl, GPnPNetworkAutoIP autoIP, String adapter) {
        this.m_id = id;
        this.m_ip = ip;
        this.m_use = use;
        this.m_nameTempl = nameTempl;
        this.m_autoIp = autoIP;
        this.m_adapter = adapter;
    }

    public String getId() {
        return this.m_id;
    }

    public InetAddress getIpAddress() {
        return this.m_ip;
    }

    public String getUse() {
        return this.m_use;
    }

    public String getNameTempl() {
        return this.m_nameTempl;
    }

    public GPnPNetworkAutoIP getAutoIp() {
        return this.m_autoIp;
    }

    public String getAdapter() {
        return this.m_adapter;
    }

    public String toString() {
        return "id[" + this.m_id + "]  ip[" + this.m_ip + "]  use[" + this.m_use + "] nameTempl[" + this.m_nameTempl + "]  autoIp[" + (Object)((Object)this.m_autoIp) + "]  adapter[" + this.m_adapter + "]";
    }

    public static enum GPnPNetworkAutoIP {
        NONE,
        DHCP,
        ZEROCONF;

    }
}

