/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.gpnp;

import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.gpnp.GPnPNetwork;

public class GPnPHostNetwork {
    private String m_id;
    private String m_hostName;
    private List<GPnPNetwork> m_networks = new Vector<GPnPNetwork>();

    public GPnPHostNetwork(String id, String hostName) {
        this.m_id = id;
        this.m_hostName = hostName;
    }

    public void addNetwork(GPnPNetwork network) {
        this.m_networks.add(network);
    }

    public GPnPNetwork findById(String id) {
        for (GPnPNetwork network : this.m_networks) {
            if (!network.getId().equals(id)) continue;
            return network;
        }
        return null;
    }

    public String getId() {
        return this.m_id;
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public List<GPnPNetwork> getNetworks() {
        return this.m_networks;
    }

    public String toString() {
        StringBuffer hostNetworkString = new StringBuffer();
        hostNetworkString.append("id[" + this.m_id + "] hostname[" + this.m_hostName + "]\n");
        for (GPnPNetwork network : this.m_networks) {
            hostNetworkString.append("  " + network.toString() + "\n");
        }
        return hostNetworkString.toString();
    }
}

