/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.fixup.datagenerator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.cluster.impl.verification.FixupResultImpl;
import oracle.cluster.verification.FixupException;
import oracle.cluster.verification.FixupResult;
import oracle.cluster.verification.FixupStatus;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.fixup.CVUFixup;
import oracle.cluster.verification.fixup.FixupData;
import oracle.cluster.verification.fixup.FixupUtility;
import oracle.cluster.verification.fixup.FixupXmlParser;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FixupDataFile
extends FixupXmlParser {
    private static FixupDataFile m_fixupDataFileObj = null;
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    public static FixupDataFile getInstance() throws FixupException {
        if (m_fixupDataFileObj == null) {
            m_fixupDataFileObj = new FixupDataFile();
        }
        return m_fixupDataFileObj;
    }

    private FixupDataFile() throws FixupException {
        super(FixupUtility.getFixupDataFileCompletePath());
    }

    protected FixupDataFile(CVUFixup fixupObj) throws ParserConfigurationException {
        DocumentBuilderFactory m_cvDocBldFact = DocumentBuilderFactory.newInstance();
        DocumentBuilder m_cvDocBuilder = m_cvDocBldFact.newDocumentBuilder();
        this.m_fixupDoc = m_cvDocBuilder.newDocument();
        this.m_fixupDOMRoot = this.m_fixupDoc.createElement("CVU_FIXUP_ROOT");
        Element taskListElem = this.m_fixupDoc.createElement("TASK_LIST");
        HashMap<String, Element> taskElementMap = new HashMap<String, Element>();
        List<Task> fixableTaskList = fixupObj.getFixableTaskList();
        Trace.out((int)5, (String)("Total number of fixable fixup tasks is " + fixableTaskList.size()));
        for (Task taskObj : fixableTaskList) {
            String taskID = taskObj.getDefaultTaskID();
            FixupData fixData = taskObj.getFixupData();
            if (fixData.getFixableNodes().isEmpty()) {
                Trace.out((String)("No participating node to be fixed for fixup of task '" + taskID + "' - Skipping to update the fixup xml for this task"));
                VerificationLogData.logInfo("No participating node for fixup of task '" + taskID + "' - Skipping to update the fixup xml for this task");
                continue;
            }
            Element taskElem = null;
            Element fixupDataListElem = null;
            if (taskElementMap.containsKey(taskID)) {
                taskElem = (Element)taskElementMap.get(taskID);
                fixupDataListElem = this.getFirstChildNodeByTagName(taskElem, "FIXUP_DATA_LIST");
                fixupDataListElem.appendChild(this.createFixupDataElem(fixData));
            } else {
                taskElem = this.m_fixupDoc.createElement("TASK");
                taskElem.setAttribute("ID", taskID);
                fixupDataListElem = this.m_fixupDoc.createElement("FIXUP_DATA_LIST");
                fixupDataListElem.appendChild(this.createFixupDataElem(fixData));
                taskElem.appendChild(fixupDataListElem);
            }
            taskElementMap.put(taskID, taskElem);
        }
        Collection taskElemList = taskElementMap.values();
        for (Element taskElem : taskElemList) {
            taskListElem.appendChild(taskElem);
        }
        this.m_fixupDOMRoot.appendChild(taskListElem);
        this.m_fixupDoc.appendChild(this.m_fixupDOMRoot);
        m_fixupDataFileObj = this;
    }

    private Element createNodeListElem(FixupData fixData) {
        List<String> nodes = fixData.getFixableNodes();
        Element nodeListElem = this.m_fixupDoc.createElement("NODE_LIST");
        for (String node : nodes) {
            String expectedValueForNode;
            Element nodeElem = this.m_fixupDoc.createElement("NODE");
            nodeElem.setAttribute("NAME", node);
            String actualValueForNode = fixData.getActualVal(node);
            if (VerificationUtil.isStringGood(actualValueForNode)) {
                nodeElem.setAttribute("ACT_VAL", actualValueForNode);
            }
            if (VerificationUtil.isStringGood(expectedValueForNode = fixData.getExpectedVal(node))) {
                nodeElem.setAttribute("EXP_VAL", expectedValueForNode);
            }
            nodeListElem.appendChild(nodeElem);
        }
        return nodeListElem;
    }

    private Element createFixupDataElem(FixupData fixData) {
        Element fixupDataElem = this.m_fixupDoc.createElement("FIXUP_DATA");
        fixupDataElem.appendChild(this.createNodeListElem(fixData));
        fixupDataElem.appendChild(this.createFixupDataListElem(fixData));
        fixupDataElem.appendChild(this.createFixupScriptListElem(fixData));
        Element overAllStatusElem = this.m_fixupDoc.createElement("OVERALL_STATUS");
        Trace.out((int)5, (String)("Setting OverAll Status as " + FixupStatus.UNKNOWN.toString() + " to begin with"));
        overAllStatusElem.setTextContent(FixupStatus.UNKNOWN.toString());
        fixupDataElem.appendChild(overAllStatusElem);
        return fixupDataElem;
    }

    private Element createFixupDataListElem(FixupData fixupData) {
        HashMap<String, String> fixData = fixupData.getFixupInstructions();
        Element fixupDataListElem = this.m_fixupDoc.createElement("DATA_LIST");
        Set<String> dataKeys = fixData.keySet();
        for (String key : dataKeys) {
            Element dataElem = this.m_fixupDoc.createElement("DATA");
            dataElem.setAttribute("NAME", key);
            dataElem.setAttribute("VAL", fixData.get(key));
            fixupDataListElem.appendChild(dataElem);
        }
        return fixupDataListElem;
    }

    private Element createFixupScriptListElem(FixupData fixData) {
        Element fixupScriptListElem = this.m_fixupDoc.createElement("FIXUP_SCRIPTS");
        List<FixupData.FixupScript> scriptList = fixData.getFixupScriptList();
        for (FixupData.FixupScript script : scriptList) {
            Element scriptElem = this.m_fixupDoc.createElement("SCRIPT");
            scriptElem.setAttribute("NAME", script.getScriptName());
            scriptElem.setAttribute("TYPE", script.getType().toString());
            List<String> arguments = script.getArgumentList();
            if (arguments != null && arguments.size() > 0) {
                Element argListElem = this.m_fixupDoc.createElement("ARG_LIST");
                for (String argument : arguments) {
                    Element argElem = this.m_fixupDoc.createElement("ARG");
                    argElem.setTextContent(argument);
                    argListElem.appendChild(argElem);
                }
                scriptElem.appendChild(argListElem);
            }
            fixupScriptListElem.appendChild(scriptElem);
        }
        return fixupScriptListElem;
    }

    public void saveToFile() throws FixupException {
        String errMsg = null;
        TransformerFactory transFact = TransformerFactory.newInstance();
        Transformer trans = null;
        String xmlFilePath = FixupUtility.getFixupDataFileCompletePath();
        try {
            trans = transFact.newTransformer();
            DOMSource origSrc = new DOMSource(this.m_fixupDoc);
            File dir = new File(FixupUtility.getDefaultFixupScriptsLocation());
            if (dir.exists()) {
                FileWriter xmlFileWriter = new FileWriter(xmlFilePath);
                StreamResult streamResult = new StreamResult(xmlFileWriter);
                trans.setOutputProperty("encoding", "UTF-8");
                trans.setOutputProperty("indent", "yes");
                trans.transform(origSrc, streamResult);
                xmlFileWriter.close();
                m_fixupDataFileObj = null;
            }
        }
        catch (TransformerConfigurationException tce) {
            VerificationLogData.logError("TransformerConfigurationException: " + tce.getMessage());
            errMsg = tce.getMessage();
            Trace.out((String)("Caught TransformerConfigurationException with Error as " + errMsg));
            if (VerificationUtil.isStringGood(errMsg)) {
                errMsg = s_gMsgBundle.getMessage("9004", true, (Object[])new String[]{errMsg});
            }
            Trace.out((String)("Failed to save the fixupdata file at location ( " + xmlFilePath + ")  and hence throwing FixupException with" + " error " + errMsg));
            throw new FixupException(errMsg, tce);
        }
        catch (TransformerException te) {
            errMsg = te.getMessage();
            VerificationLogData.logError("TransformerException: " + errMsg);
            Trace.out((String)("Caught TransformerException with Error as " + errMsg));
            if (VerificationUtil.isStringGood(errMsg)) {
                errMsg = s_gMsgBundle.getMessage("9004", true, (Object[])new String[]{errMsg});
            }
            VerificationUtil.traceAndLogError("Failed to save the fixupdata file at location ( " + xmlFilePath + ") and hence throwing FixupException" + " with error " + errMsg);
            throw new FixupException(errMsg, te);
        }
        catch (IOException ioe) {
            errMsg = ioe.getMessage();
            VerificationLogData.logError("IOException: " + errMsg);
            Trace.out((String)("Caught IOException with Error as " + errMsg));
            if (VerificationUtil.isStringGood(errMsg)) {
                errMsg = s_gMsgBundle.getMessage("9004", true, (Object[])new String[]{errMsg});
            }
            VerificationUtil.traceAndLogError("Failed to save the fixupdata file at location ( " + xmlFilePath + ") and hence throwing" + " FixupException with error " + errMsg);
            throw new FixupException(errMsg, ioe);
        }
    }

    @Override
    public synchronized void addOutputElementforTask(String node, String taskID, Element outputElement, int elementIndex) {
        super.addOutputElementforTask(node, taskID, outputElement, elementIndex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FixupResult getTaskResultForNode(String node, String taskID, int taskIndex) {
        NodeList nlsErrList;
        Element nlsErrosrElem;
        NodeList errList;
        Element statusElem;
        String status;
        Element outputElement;
        List<Element> dataListElemForTask;
        FixupResultImpl result = new FixupResultImpl(node);
        Element taskElement = this.getTaskElement(taskID);
        if (null == taskElement || null == (dataListElemForTask = this.getFixupDataElementListForTask(taskElement)) || dataListElemForTask.size() <= taskIndex || null == (outputElement = this.getOutputDataElementForNode(dataListElemForTask.get(taskIndex), node)) || !VerificationUtil.isStringGood(status = (statusElem = this.getFirstChildNodeByTagName(outputElement, "STATUS")).getTextContent())) return result;
        FixupStatus fixStatus = FixupStatus.valueOf(status);
        result.setStatus(fixStatus);
        VerificationLogData.log("The Fixup status of task " + taskID + " on node " + node + " is " + fixStatus.toString());
        if (fixStatus == FixupStatus.SUCCESSFUL || fixStatus == FixupStatus.UNKNOWN) return result;
        Element nativeErrList = this.getFirstChildNodeByTagName(outputElement, "NATIVE_ERRORS");
        if (null != nativeErrList && nativeErrList.hasChildNodes() && null != (errList = nativeErrList.getElementsByTagName("ERROR")) && errList.getLength() > 0) {
            for (int cnt = 0; cnt < errList.getLength(); ++cnt) {
                Element errElem = (Element)errList.item(cnt);
                String errMsg = errElem.getTextContent();
                if (!VerificationUtil.isStringGood(errMsg)) continue;
                result.addErrorDescription(new ErrorDescription(FixupUtility.createNativeErrorMsg(errMsg, node)));
            }
        }
        if (null == (nlsErrosrElem = this.getFirstChildNodeByTagName(outputElement, "NLS_ERRORS")) || !nlsErrosrElem.hasChildNodes() || null == (nlsErrList = nlsErrosrElem.getElementsByTagName("NLS_MSG")) || nlsErrList.getLength() <= 0) return result;
        for (int cnt = 0; cnt < nlsErrList.getLength(); ++cnt) {
            Element nlsMsgElem = (Element)nlsErrList.item(cnt);
            String msgId = nlsMsgElem.getAttribute("ID");
            String facility = nlsMsgElem.getAttribute("FACILITY");
            boolean displayFacility = false;
            String dispFacStr = nlsMsgElem.getAttribute("DISPLAY_ID");
            if (VerificationUtil.isStringGood(dispFacStr)) {
                displayFacility = Boolean.parseBoolean(dispFacStr.trim());
            }
            Element msgArgListElem = this.getFirstChildNodeByTagName(nlsMsgElem, "MSG_ARG_LIST");
            ArrayList<String> msgArguments = new ArrayList<String>();
            if (null != msgArgListElem) {
                NodeList msgArgElemList = msgArgListElem.getElementsByTagName("MSG_ARG");
                for (int argidx = 0; argidx < msgArgElemList.getLength(); ++argidx) {
                    Element msgArgElem = (Element)msgArgElemList.item(argidx);
                    String argVal = msgArgElem.getTextContent();
                    if (!VerificationUtil.isStringGood(argVal)) continue;
                    msgArguments.add(argVal);
                }
            }
            VerificationError nlsError = null;
            try {
                nlsError = msgArguments.size() > 0 ? FixupUtility.buildVerificationErrorFromNlsMessage(facility, msgId, msgArguments.toArray(new String[0]), displayFacility) : FixupUtility.buildVerificationErrorFromNlsMessage(facility, msgId, null, displayFacility);
            }
            catch (FixupException fe) {
                VerificationLogData.logError("Failed to build an NLS error Message using facility :" + facility + " and ID " + msgId);
                Trace.out((String)("Failed to build an NLS error Message using facility :" + facility + " and ID " + msgId));
            }
            if (null == nlsError) continue;
            result.addErrorDescription((ErrorDescription)nlsError);
        }
        return result;
    }
}

