/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.fixup.controller;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.install.UserInfo;
import oracle.cluster.remote.RemoteFactory;
import oracle.cluster.remote.SecureFileTransfer;
import oracle.cluster.remote.SecureFileTransferException;
import oracle.cluster.verification.fixup.SSHSetupConstants;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public abstract class SSHSetupNodeThread
extends Thread
implements SSHSetupConstants {
    protected String m_node;
    protected Result m_result;
    protected UserInfo m_userInfo;
    protected boolean m_isLocalNode;
    protected String m_userName;

    private SSHSetupNodeThread(String node, UserInfo userInfo) {
        this.m_node = node;
        this.m_isLocalNode = VerificationUtil.isLocalNode(this.m_node);
        this.m_userInfo = userInfo;
        if (this.m_userInfo != null) {
            this.m_userName = VerificationUtil.isStringGood(this.m_userInfo.getUsername()) ? this.m_userInfo.getUsername() : Utils.getRootUserName();
        }
        this.m_result = new Result(this.m_node);
        this.setName(this.getNode() + this.getOperation());
    }

    public String getNode() {
        return this.m_node;
    }

    public Result getResult() {
        return this.m_result;
    }

    public abstract String getOperation();

    public static class SetupExportKeyFileThread
    extends SSHSetupNodeThread {
        public SetupExportKeyFileThread(String node, UserInfo userInfo) {
            super(node, userInfo);
        }

        @Override
        public void run() {
            if (!this.m_isLocalNode) {
                Trace.out((String)("Starting thread to [Setup export key file] for node (" + this.m_node));
                Trace.out((String)("Export public key file location is (" + EXPORT_PUBLIC_KEY_FILE_PATH + ")"));
                SecureFileTransfer secureFileTransfer = null;
                try {
                    secureFileTransfer = RemoteFactory.getInstance().getSecureFileTransfer(this.m_node, this.m_userInfo);
                    try {
                        String exportKeyFileLoc = new File(EXPORT_PUBLIC_KEY_FILE_PATH).getParent();
                        Trace.out((String)("Changing the local directory to (" + exportKeyFileLoc + ")"));
                        secureFileTransfer.lcd(exportKeyFileLoc);
                        Trace.out((String)("Changed to the local directory (" + exportKeyFileLoc + ")"));
                        Trace.out((String)("Changing to directory (" + SSH_SETUP_WORK_DIRECTORY + ") on node " + this.m_node));
                        secureFileTransfer.cd(SSH_SETUP_WORK_DIRECTORY);
                        Trace.out((String)("Changed to directory (" + SSH_SETUP_WORK_DIRECTORY + ") on node " + this.m_node));
                        Trace.out((String)("Exporting the public keys file to location (" + SSH_SETUP_WORK_DIRECTORY + ") on node " + this.m_node + " from local node location (" + EXPORT_PUBLIC_KEY_FILE_PATH + ")"));
                        secureFileTransfer.put("export_key.pub", "export_key.pub");
                        secureFileTransfer.put("rsa_host_keys.export", "rsa_host_keys.export");
                        Trace.out((String)("Successfully copied the export public key file to location (" + SSH_SETUP_WORK_DIRECTORY + ") on node " + this.m_node + " from local node location (" + EXPORT_PUBLIC_KEY_FILE_PATH + ")"));
                        this.m_result.setStatus(1);
                        secureFileTransfer.disconnect();
                    }
                    catch (SecureFileTransferException se) {
                        secureFileTransfer.disconnect();
                        this.m_result.setStatus(2);
                        this.m_result.addErrorDescription(new ErrorDescription(se.getMessage()));
                        VerificationUtil.traceAndLogError("Failed to setup export key file  on node " + this.m_node + " error is " + se.getMessage());
                    }
                }
                catch (SecureFileTransferException ce) {
                    this.m_result.setStatus(2);
                    this.m_result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("9086", true, (Object[])new String[]{this.m_node, this.m_userName}) + LSEP + ce.getMessage()));
                    VerificationUtil.traceAndLogError("Failed to connect to node " + this.m_node + " via SFTP using specified" + " credentials. for user " + this.m_userName + " Error is " + ce.getMessage());
                }
                catch (InvalidArgsException iae) {
                    this.m_result.setStatus(2);
                    this.m_result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("9086", true, (Object[])new String[]{this.m_node, this.m_userName}) + LSEP + iae.getMessage()));
                    VerificationUtil.traceAndLogError("Failed to connect to node " + this.m_node + " via SFTP using specified" + " credentials. for user " + this.m_userName + " Error is " + iae.getMessage());
                }
            } else {
                Trace.out((String)("Local node: The public key file is generated itself at (" + EXPORT_PUBLIC_KEY_FILE_PATH + ") hence export not required."));
                this.m_result.setStatus(1);
            }
        }

        @Override
        public String getOperation() {
            return "_exportKey_thread";
        }
    }

    public static class ImportPublicKeyThread
    extends ImportFileThread {
        public ImportPublicKeyThread(String publicKeyFilePath, String node, UserInfo userInfo) {
            super(publicKeyFilePath, SSH_SETUP_WORK_DIRECTORY + node + "_import.pub", true, node, userInfo);
        }

        @Override
        public void run() {
            super.run();
            ImportPublicKeyThread.addKeyToExportKeyFile(this.m_destFilePath, this.m_result);
        }

        @Override
        public String getOperation() {
            return "_importKey_thread";
        }

        private static synchronized void addKeyToExportKeyFile(String importKeyFilePath, Result result) {
            String file = importKeyFilePath;
            try {
                String line;
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                file = EXPORT_PUBLIC_KEY_FILE_PATH;
                FileWriter fileWriter = new FileWriter(file, true);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                while ((line = bufferedReader.readLine()) != null) {
                    bufferedWriter.write(line);
                    bufferedWriter.newLine();
                }
                bufferedReader.close();
                bufferedWriter.close();
                new File(importKeyFilePath).delete();
                result.setStatus(1);
            }
            catch (FileNotFoundException ex) {
                result.setStatus(2);
                String errorMsg = s_msgBundle.getMessage("5311", true, (Object[])new String[]{file, VerificationUtil.getLocalNode()});
                VerificationUtil.traceAndLogError(errorMsg);
                result.addErrorDescription(new ErrorDescription(errorMsg));
            }
            catch (IOException ex) {
                result.setStatus(2);
                String errorMsg = s_gMsgBundle.getMessage("9081", true, (Object[])new String[]{file, VerificationUtil.getLocalNode(), ex.getMessage()});
                VerificationUtil.traceAndLogError(errorMsg);
                result.addErrorDescription(new ErrorDescription(errorMsg));
            }
        }
    }

    public static class ImportFileThread
    extends SSHSetupNodeThread {
        private String m_sourceFilePath = null;
        protected String m_destFilePath = null;
        private boolean m_removeSrcFile = false;

        public ImportFileThread(String srcFilePath, String destFilePath, boolean removeSrcFile, String node, UserInfo userInfo) {
            super(node, userInfo);
            this.m_sourceFilePath = srcFilePath;
            this.m_destFilePath = destFilePath;
            this.m_removeSrcFile = removeSrcFile;
        }

        @Override
        public void run() {
            Trace.out((String)("Starting [Import file] thread for node (" + this.m_node));
            Trace.out((String)("Import file file will be copied as (" + this.m_destFilePath + ")"));
            if (!this.m_isLocalNode) {
                SecureFileTransfer sFtp = null;
                try {
                    sFtp = RemoteFactory.getInstance().getSecureFileTransfer(this.m_node, this.m_userInfo);
                    try {
                        String srcileName = new File(this.m_sourceFilePath).getName();
                        String srcFileLoc = new File(this.m_sourceFilePath).getParent();
                        String destFileName = new File(this.m_destFilePath).getName();
                        String destFileLoc = new File(this.m_destFilePath).getParent();
                        Trace.out((String)("Changing the local directory to (" + destFileLoc + ")"));
                        sFtp.lcd(destFileLoc);
                        Trace.out((String)("Changed to the local directory (" + destFileLoc + ")"));
                        Trace.out((String)("Changing to directory (" + srcFileLoc + ") on node " + this.m_node));
                        sFtp.cd(srcFileLoc);
                        Trace.out((String)("Changed to directory (" + srcFileLoc + ") on node " + this.m_node));
                        Trace.out((String)("Importing the file from location (" + this.m_sourceFilePath + ") on node " + this.m_node + " to local node location (" + this.m_destFilePath + ")"));
                        sFtp.get(srcileName, destFileName);
                        Trace.out((String)("Successfully copied the file from location (" + this.m_sourceFilePath + ") on node " + this.m_node + " to local node location (" + this.m_destFilePath + ")"));
                        if (this.m_removeSrcFile) {
                            Trace.out((String)("Deleting the file (" + this.m_sourceFilePath + ") from remote node (" + this.m_node + ")"));
                            sFtp.rm(this.m_sourceFilePath);
                            Trace.out((String)("Successfully Deleted the file (" + this.m_sourceFilePath + ") from remote node (" + this.m_node + ")"));
                        }
                        this.m_result.setStatus(1);
                        sFtp.disconnect();
                    }
                    catch (SecureFileTransferException se) {
                        sFtp.disconnect();
                        this.m_result.setStatus(2);
                        this.m_result.addErrorDescription(new ErrorDescription(MessageBundle.getMessageBundle((String)"Prkc").getMessage("1108", true, (Object[])new String[]{this.m_sourceFilePath, this.m_node, this.m_destFilePath, "localnode", se.getMessage()})));
                        VerificationUtil.traceAndLogError("Failed to copy the file " + this.m_sourceFilePath + " from node " + this.m_node + " to a local destination" + this.m_destFilePath + " error is " + se.getMessage());
                    }
                }
                catch (InvalidArgsException iae) {
                    this.m_result.setStatus(2);
                    this.m_result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("9086", true, (Object[])new String[]{this.m_node, this.m_userName}) + LSEP + iae.getMessage()));
                    VerificationUtil.traceAndLogError("Failed to connect to node " + this.m_node + " via SFTP using specified" + " credentials. for user " + this.m_userName + " Error is " + iae.getMessage());
                }
                catch (SecureFileTransferException ce) {
                    this.m_result.setStatus(2);
                    this.m_result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("9086", true, (Object[])new String[]{this.m_node, this.m_userName}) + LSEP + ce.getMessage()));
                    VerificationUtil.traceAndLogError("Failed to connect to node " + this.m_node + " via SFTP using specified" + " credentials. for user " + this.m_userName + " Error is " + ce.getMessage());
                }
            } else {
                try {
                    if (!this.m_sourceFilePath.equals(this.m_destFilePath)) {
                        ClusterCmd clusterCmd = new ClusterCmd();
                        clusterCmd.copyFileBetweenNodes(this.m_node, this.m_sourceFilePath, this.m_node, this.m_destFilePath, true);
                        Trace.out((String)("Successfully Copied the file from location (" + this.m_sourceFilePath + ") to location (" + this.m_destFilePath + ") on local node."));
                    }
                    if (this.m_removeSrcFile) {
                        Trace.out((String)("Deleting the file (" + this.m_sourceFilePath + ") from node (" + this.m_node + ")"));
                        new File(this.m_sourceFilePath).delete();
                        Trace.out((String)("Successfully Deleted the file (" + this.m_sourceFilePath + ") from node (" + this.m_node + ")"));
                    }
                    this.m_result.setStatus(1);
                }
                catch (ClusterException ce) {
                    this.m_result.setStatus(2);
                    this.m_result.addErrorDescription(new ErrorDescription(MessageBundle.getMessageBundle((String)"Prkc").getMessage("1108", true, (Object[])new String[]{this.m_sourceFilePath, this.m_node, this.m_destFilePath, "localnode", ce.getMessage()})));
                    VerificationUtil.traceAndLogError("Failed to setup the work directory on local node " + this.m_node + " error is " + ce.getMessage());
                }
            }
        }

        @Override
        public String getOperation() {
            return "_importFile_thread";
        }
    }

    public static class CheckHomeSharednessThread
    extends SSHSetupNodeThread {
        Collection<String> m_keyLocationList;
        private Set<String> m_nodesSharingHomeWith;

        public CheckHomeSharednessThread(String node, UserInfo userInfo, Collection<String> keyLocationList) {
            super(node, userInfo);
            this.m_keyLocationList = keyLocationList;
            this.m_nodesSharingHomeWith = new HashSet<String>();
            this.m_nodesSharingHomeWith.add(node);
        }

        @Override
        public void run() {
            String keyFileName;
            File keyFile;
            Trace.out((String)("Starting SSH User equivalence thread on node (" + this.m_node + ") to check the sharedness of user's" + " home directory"));
            String sshDir = null;
            ArrayList<String> keyFileLocationUnderSameSSHDir = new ArrayList<String>();
            for (String string : this.m_keyLocationList) {
                keyFile = new File(string);
                if (!keyFile.getName().startsWith(this.m_node)) continue;
                sshDir = keyFile.getParent();
                break;
            }
            if (sshDir != null) {
                for (String string : this.m_keyLocationList) {
                    keyFile = new File(string);
                    keyFileName = keyFile.getName();
                    String keyFileDir = keyFile.getParent();
                    if (keyFileName.startsWith(this.m_node) || !keyFileDir.equals(sshDir)) continue;
                    keyFileLocationUnderSameSSHDir.add(string);
                }
            }
            Trace.out((String)("The input list of locations was \n" + VerificationUtil.strCollection2String(this.m_keyLocationList)));
            Trace.out((String)("The locations found sharing same .ssh directory ( " + sshDir + ") as this node (" + this.m_node + ") are \n" + VerificationUtil.strCollection2String(keyFileLocationUnderSameSSHDir)));
            if (!keyFileLocationUnderSameSSHDir.isEmpty()) {
                if (!this.m_isLocalNode) {
                    SecureFileTransfer sftp = null;
                    try {
                        sftp = RemoteFactory.getInstance().getSecureFileTransfer(this.m_node, this.m_userInfo);
                        try {
                            Trace.out((String)("Changing to directory (" + sshDir + ") on node " + this.m_node));
                            sftp.cd(sshDir);
                            for (String keyFileLocation : keyFileLocationUnderSameSSHDir) {
                                File keyFile2 = new File(keyFileLocation);
                                String keyFileName2 = keyFile2.getName();
                                Trace.out((String)("Checking if file (" + keyFileName2 + ") exists at location (" + sshDir + ") on node (" + this.m_node + ")"));
                                if (sftp.isExist(keyFileName2)) {
                                    Trace.out((String)("Key file (" + keyFileName2 + ") is visible on node (" + this.m_node + ")"));
                                    String nodeName = keyFileName2.trim().substring(0, keyFileName2.indexOf("."));
                                    Trace.out((String)("Node (" + nodeName + ") shares home with node (" + this.m_node + ")"));
                                    this.m_nodesSharingHomeWith.add(nodeName);
                                    continue;
                                }
                                Trace.out((String)("Key file (" + keyFileName2 + ") is NOT visible on node (" + this.m_node + ")"));
                            }
                            this.m_result.setStatus(1);
                            sftp.disconnect();
                        }
                        catch (SecureFileTransferException secureFileTransferException) {
                            sftp.disconnect();
                            this.m_result.setStatus(2);
                            this.m_result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("9085", true, (Object[])new String[]{SSH_SETUP_WORK_DIRECTORY, this.m_node}) + LSEP + secureFileTransferException.getMessage()));
                            VerificationUtil.traceAndLogError("Failed to setup the work directory on node " + this.m_node + " error is " + secureFileTransferException.getMessage());
                        }
                    }
                    catch (InvalidArgsException invalidArgsException) {
                        this.m_result.setStatus(2);
                        this.m_result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("9086", true, (Object[])new String[]{this.m_node, this.m_userName}) + LSEP + invalidArgsException.getMessage()));
                        VerificationUtil.traceAndLogError("Failed to connect to node " + this.m_node + " via SFTP using specified" + " credentials. for user " + this.m_userName + " Error is " + invalidArgsException.getMessage());
                    }
                    catch (SecureFileTransferException secureFileTransferException) {
                        this.m_result.setStatus(2);
                        this.m_result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("9086", true, (Object[])new String[]{this.m_node, this.m_userName}) + LSEP + secureFileTransferException.getMessage()));
                        VerificationUtil.traceAndLogError("Failed to connect to node " + this.m_node + " via SFTP using specified" + " credentials. for user " + this.m_userName + " Error is " + secureFileTransferException.getMessage());
                    }
                } else {
                    for (String string : keyFileLocationUnderSameSSHDir) {
                        keyFile = new File(string);
                        keyFileName = keyFile.getName();
                        if (keyFile.exists()) {
                            Trace.out((String)("Key file (" + keyFileName + ") is visible on node (" + this.m_node + ")"));
                            String nodeName = keyFileName.trim().substring(0, keyFileName.indexOf("."));
                            Trace.out((String)("Node (" + nodeName + ") shares home with node (" + this.m_node + ")"));
                            this.m_nodesSharingHomeWith.add(nodeName);
                            continue;
                        }
                        Trace.out((String)("Key file (" + keyFileName + ") is NOT visible on node (" + this.m_node + ")"));
                    }
                    this.m_result.setStatus(1);
                }
            } else {
                this.m_result.setStatus(1);
            }
        }

        public Set<String> getNodesSharingHome() {
            return this.m_nodesSharingHomeWith;
        }

        @Override
        public String getOperation() {
            return "_checkHomeShared_thread";
        }
    }

    public static class generateRSAHostKeyThread
    extends SSHSetupNodeThread {
        public generateRSAHostKeyThread(String node) {
            super(node, null);
        }

        @Override
        public void run() {
            String[] rsaKey = null;
            String keyScanCommand = "/usr/bin/ssh-keyscan -t rsa " + this.m_node;
            Trace.out((String)("Executing command (" + keyScanCommand + ")"));
            String[] output = null;
            String[] cmd = new String[]{"/usr/bin/ssh-keyscan", "-t", "rsa", this.m_node};
            RuntimeExec rt = new RuntimeExec(cmd, null, null);
            rt.runCommand();
            String[] error = rt.getError();
            output = rt.getOutput();
            if (rt.getExitValue() == 0) {
                if (output != null && output.length > 0) {
                    Trace.out((String)("Generated the RSA host key for host (" + this.m_node + " ) successfully. now adding it to export file"));
                    rsaKey = output;
                    generateRSAHostKeyThread.addRSAHostKeyToExportKeyFile(rsaKey, this.m_result);
                } else {
                    Trace.out((String)("ssh-keyscan command did not return any host key for host (" + this.m_node + "). output is empty."));
                    this.m_result.setStatus(2);
                    String errMsg = s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{keyScanCommand, VerificationUtil.getLocalNode(), "0"});
                    this.m_result.addErrorDescription(new ErrorDescription(errMsg));
                    VerificationUtil.traceAndLogError(errMsg);
                    output = new String[]{""};
                }
            } else {
                this.m_result.setStatus(2);
                String errMsg = s_gMsgBundle.getMessage("9078", true, (Object[])new String[]{VerificationUtil.getLocalNode(), keyScanCommand, error != null ? VerificationUtil.strArr2List(error) : ""});
                this.m_result.addErrorDescription(new ErrorDescription(errMsg));
                VerificationUtil.traceAndLogError(errMsg);
            }
        }

        private static synchronized void addRSAHostKeyToExportKeyFile(String[] rsaKey, Result result) {
            String file = null;
            try {
                file = EXPORT_RSA_HOST_KEY_FILE_PATH;
                FileWriter fileWriter = new FileWriter(file, true);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                for (String line : rsaKey) {
                    bufferedWriter.write(line);
                    bufferedWriter.newLine();
                }
                bufferedWriter.close();
                result.setStatus(1);
            }
            catch (IOException ex) {
                result.setStatus(2);
                String errorMsg = s_gMsgBundle.getMessage("9081", true, (Object[])new String[]{file, VerificationUtil.getLocalNode(), ex.getMessage()});
                VerificationUtil.traceAndLogError(errorMsg);
                result.addErrorDescription(new ErrorDescription(errorMsg));
            }
        }

        @Override
        public String getOperation() {
            return "_generateRSAHostKey_thread";
        }
    }

    public static class SetupWorkDirectoryThread
    extends SSHSetupNodeThread {
        public SetupWorkDirectoryThread(String node, UserInfo userInfo) {
            super(node, userInfo);
        }

        @Override
        public void run() {
            block13: {
                Trace.out((String)("Setting up work directory on node (" + this.m_node + ")"));
                SecureFileTransfer sftp = null;
                try {
                    if (!this.m_isLocalNode) {
                        sftp = RemoteFactory.getInstance().getSecureFileTransfer(this.m_node, this.m_userInfo);
                        try {
                            Trace.out((String)("Changing the local directory to (" + CVU_SUBDIR_LOC + ")"));
                            sftp.lcd(CVU_SUBDIR_LOC);
                            Trace.out((String)("Checking existence of path  (" + DEST_LOC + ") on node " + this.m_node));
                            if (sftp.isExist(DEST_LOC)) {
                                Trace.out((String)("Path (" + DEST_LOC + ") Exists on node " + this.m_node));
                                sftp.cd(DEST_LOC);
                                if (!sftp.isExist(SSH_SETUP_WORK_DIR_NAME)) {
                                    Trace.out((String)("Directory(" + SSH_SETUP_WORK_DIR_NAME + ") does not exist on node " + this.m_node));
                                    Trace.out((String)("Creating directory (" + SSH_SETUP_WORK_DIR_NAME + ") on node " + this.m_node));
                                    sftp.mkdir(SSH_SETUP_WORK_DIR_NAME);
                                    Trace.out((String)("Directory(" + SSH_SETUP_WORK_DIR_NAME + " created on node " + this.m_node));
                                }
                                sftp.chmod(511, SSH_SETUP_WORK_DIR_NAME);
                                Trace.out((String)("Changing to directory (" + SSH_SETUP_WORK_DIR_NAME + ") on node " + this.m_node));
                                sftp.cd(SSH_SETUP_WORK_DIR_NAME);
                                Trace.out((String)("Changed to directory (" + SSH_SETUP_WORK_DIR_NAME + ") on node " + this.m_node));
                                if (sftp.isExist("exectask" + EXECTASK_EXTN)) {
                                    Trace.out((String)("Exectask executable (exectask" + EXECTASK_EXTN + ") Already exists on node " + this.m_node + " Removing it."));
                                    sftp.rm("exectask" + EXECTASK_EXTN);
                                    Trace.out((String)("Exectask executable (exectask" + EXECTASK_EXTN + ") Successfully deleted from node " + this.m_node));
                                }
                                if (sftp.isExist("exectask" + EXECTASK_SCRIPT_EXTN)) {
                                    Trace.out((String)("Exectask wrapper script (exectask" + EXECTASK_SCRIPT_EXTN + ") Already exists" + " on node " + this.m_node + " Removing it."));
                                    sftp.rm("exectask" + EXECTASK_SCRIPT_EXTN);
                                    Trace.out((String)("Exectask wrapper script (exectask" + EXECTASK_SCRIPT_EXTN + ") Successfully deleted" + " from node " + this.m_node));
                                }
                                Trace.out((String)("Copying (exectask" + EXECTASK_EXTN + ") to directory" + " (" + SSH_SETUP_WORK_DIR_NAME + ") on node " + this.m_node));
                                sftp.put("exectask" + EXECTASK_EXTN, "exectask" + EXECTASK_EXTN);
                                Trace.out((String)("Copied (exectask" + EXECTASK_EXTN + ") to directory " + "(" + SSH_SETUP_WORK_DIR_NAME + ") on node " + this.m_node));
                                Trace.out((String)("Changing permissions of (exectask" + EXECTASK_EXTN + ") to 755"));
                                sftp.chmod(493, "exectask" + EXECTASK_EXTN);
                                Trace.out((String)("Copying (exectask" + EXECTASK_SCRIPT_EXTN + ") to " + "directory (" + SSH_SETUP_WORK_DIR_NAME + ") on node " + this.m_node));
                                sftp.put("exectask" + EXECTASK_SCRIPT_EXTN, "exectask" + EXECTASK_SCRIPT_EXTN);
                                Trace.out((String)("Copied (exectask" + EXECTASK_SCRIPT_EXTN + ")  to directory (" + SSH_SETUP_WORK_DIR_NAME + ") on node " + this.m_node));
                                Trace.out((String)("Changing permissions of  (exectask" + EXECTASK_SCRIPT_EXTN + ") to 755"));
                                sftp.chmod(493, "exectask" + EXECTASK_SCRIPT_EXTN);
                                Trace.out((String)"Permissions changed successfully.");
                                this.m_result.setStatus(1);
                                sftp.disconnect();
                                break block13;
                            }
                            sftp.disconnect();
                            this.m_result.setStatus(2);
                            String errorMsg = s_msgBundle.getMessage("9016", true);
                            VerificationUtil.traceAndLogError(errorMsg);
                            this.m_result.addErrorDescription(new ErrorDescription(errorMsg));
                            VerificationUtil.traceAndLogError("DEST LOC does not exists on node " + this.m_node);
                        }
                        catch (SecureFileTransferException se) {
                            sftp.disconnect();
                            this.m_result.setStatus(2);
                            this.m_result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("9085", true, (Object[])new String[]{SSH_SETUP_WORK_DIRECTORY, this.m_node}) + LSEP + se.getMessage()));
                            VerificationUtil.traceAndLogError("Failed to setup the work directory on node " + this.m_node + " error is " + se.getMessage());
                        }
                        break block13;
                    }
                    File workDir = new File(SSH_SETUP_WORK_DIRECTORY);
                    try {
                        ClusterCmd clusterCmd = new ClusterCmd();
                        if (workDir.exists()) {
                            Trace.out((String)(SSH_SETUP_WORK_DIRECTORY + " already exist on" + " local node. Cleaning it up...."));
                            clusterCmd.removeDirectory(new String[]{this.m_node}, SSH_SETUP_WORK_DIRECTORY, true);
                        }
                        Trace.out((String)("Setting up the SSH setup work directory (" + SSH_SETUP_WORK_DIRECTORY + ") on local node"));
                        clusterCmd.createDirWithPermissionsOnNodes(new String[]{this.m_node}, SSH_SETUP_WORK_DIRECTORY, "777");
                        clusterCmd.copyFileBetweenNodes(this.m_node, CVU_SUBDIR_LOC + "exectask" + EXECTASK_EXTN, this.m_node, SSH_SETUP_WORK_DIRECTORY + "exectask" + EXECTASK_EXTN, true);
                        clusterCmd.copyFileBetweenNodes(this.m_node, CVU_SUBDIR_LOC + "exectask" + EXECTASK_SCRIPT_EXTN, this.m_node, SSH_SETUP_WORK_DIRECTORY + "exectask" + EXECTASK_SCRIPT_EXTN, true);
                        Trace.out((String)("Successfully setup the SSH setup work directory (" + SSH_SETUP_WORK_DIRECTORY + ") on local node"));
                        this.m_result.setStatus(1);
                    }
                    catch (ClusterException ce) {
                        this.m_result.setStatus(2);
                        this.m_result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("9085", true, (Object[])new String[]{SSH_SETUP_WORK_DIRECTORY, this.m_node}) + LSEP + ce.getMessage()));
                        VerificationUtil.traceAndLogError("Failed to setup the work directory on local node " + this.m_node + " error is " + ce.getMessage());
                    }
                }
                catch (InvalidArgsException iae) {
                    this.m_result.setStatus(2);
                    this.m_result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("9086", true, (Object[])new String[]{this.m_node, this.m_userName}) + LSEP + iae.getMessage()));
                    VerificationUtil.traceAndLogError("Failed to connect to node " + this.m_node + " via SFTP using specified" + " credentials. for user " + this.m_userName + " Error is " + iae.getMessage());
                }
                catch (SecureFileTransferException ce) {
                    this.m_result.setStatus(2);
                    this.m_result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("9086", true, (Object[])new String[]{this.m_node, this.m_userName}) + LSEP + ce.getMessage()));
                    VerificationUtil.traceAndLogError("Failed to connect to node " + this.m_node + " via SFTP using specified" + " credentials. for user " + this.m_userName + " Error is " + ce.getMessage());
                }
            }
        }

        @Override
        public String getOperation() {
            return "_workDirSetup_thread";
        }
    }
}

