/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.fixup.controller;

import java.util.List;
import oracle.cluster.verification.FixupException;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.fixup.FixupUtility;
import oracle.cluster.verification.fixup.FixupXmlParser;
import oracle.cluster.verification.fixup.datagenerator.FixupDataFile;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.w3c.dom.Element;

public class FixupNodeThread
extends Thread {
    private String m_node = null;
    private Result m_result = null;
    private String m_fixupOutFileCompletePathRemote = null;
    private String m_fixupOutFileCompletePathLocal = null;
    private FixupXmlParser m_xmlParser = null;

    public FixupNodeThread(String node, String remoteOutfilePath) {
        this.m_node = node;
        this.m_result = new Result(this.m_node);
        this.m_fixupOutFileCompletePathRemote = remoteOutfilePath;
        this.m_fixupOutFileCompletePathLocal = FixupUtility.getFixupOutputFileCompletePath(node);
        this.setName("FixupNodeThread-" + this.m_node);
    }

    @Override
    public void run() {
        Trace.out((String)("Starting Fixup Thread for node " + this.m_node));
        Trace.out((String)("The Remote output file path is " + this.m_fixupOutFileCompletePathRemote));
        Trace.out((String)("Fixup ouput file will be copied from remote node at path " + this.m_fixupOutFileCompletePathLocal));
        try {
            FixupUtility.assertPath(this.m_fixupOutFileCompletePathRemote, false);
            FixupUtility.assertFixupExecutionOnNode(this.m_node, this.m_fixupOutFileCompletePathRemote);
            NativeSystem m_native = new SystemFactory().CreateSystem();
            m_native.copyFile(this.m_node, this.m_fixupOutFileCompletePathRemote, VerificationUtil.isLocalNode(this.m_node) ? this.m_node : "localnode", this.m_fixupOutFileCompletePathLocal);
            FixupUtility.assertPath(this.m_fixupOutFileCompletePathLocal, true);
            this.updateFixupDataFileWithOutput();
            this.m_result.setStatus(1);
            m_native.removeFile(this.m_node, this.m_fixupOutFileCompletePathRemote);
            m_native.removeFile("localnode", this.m_fixupOutFileCompletePathLocal);
        }
        catch (InvalidPathException ipe) {
            VerificationLogData.logError("InvalidPathException:" + ipe.getMessage());
            Trace.out((String)("Caught an InvalidPathException in Thread for node " + this.m_node + " Error is : " + ipe.getMessage()));
            this.m_result.addErrorDescription(new ErrorDescription(ipe.getMessage()));
            this.m_result.setStatus(2);
        }
        catch (FixupException fe) {
            VerificationLogData.logError("FixupException:" + fe.getMessage());
            Trace.out((String)("Caught an FixupException in Thread for node " + this.m_node + " Error is : " + fe.getMessage()));
            this.m_result.addErrorDescription(new ErrorDescription(fe.getMessage()));
            this.m_result.setStatus(2);
        }
    }

    private void updateFixupDataFileWithOutput() throws FixupException {
        FixupDataFile m_fixupDataFile = FixupDataFile.getInstance();
        this.m_xmlParser = new FixupXmlParser(this.m_fixupOutFileCompletePathLocal);
        List<Element> fixupTaskListForNode = this.m_xmlParser.getListOfTasksForNode(this.m_node);
        for (Element taskElem : fixupTaskListForNode) {
            List<Element> fixupDataElemListForTask = this.m_xmlParser.getFixupDataElementListForTask(taskElem);
            String taskID = taskElem.getAttribute("ID");
            int taskIndex = 0;
            for (Element fixupDataElem : fixupDataElemListForTask) {
                Element fixupOutputData = this.m_xmlParser.getOutputDataElementForNode(fixupDataElem, this.m_node);
                if (null != fixupOutputData) {
                    m_fixupDataFile.addOutputElementforTask(this.m_node, taskID, fixupOutputData, taskIndex);
                }
                ++taskIndex;
            }
        }
    }

    public Result getResult() {
        return this.m_result;
    }
}

