/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.fixup.controller;

import java.util.HashMap;
import java.util.List;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.UserInfo;
import oracle.cluster.verification.FixupException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.fixup.CVUFixup;
import oracle.cluster.verification.fixup.FixupUtility;
import oracle.cluster.verification.fixup.RootAutomationException;
import oracle.cluster.verification.fixup.controller.FixupNodeThread;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.RootUserCredentials;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class FixupController {
    private static FixupController m_fixupController = null;
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private CVUFixup m_fixupObj = null;
    private HashMap<String, String> m_fixupOutputFilePathMap = null;

    private FixupController(CVUFixup fixupObj) {
        this.m_fixupObj = fixupObj;
        this.m_fixupOutputFilePathMap = new HashMap();
        List<String> participatingNodes = this.m_fixupObj.getFixableNodes();
        for (String node : participatingNodes) {
            this.m_fixupOutputFilePathMap.put(node, FixupUtility.getFixupOutputFileCompletePath(node));
        }
    }

    public static FixupController getInstance(CVUFixup fixupObj) {
        if (m_fixupController == null) {
            m_fixupController = new FixupController(fixupObj);
        }
        return m_fixupController;
    }

    public void performFixup() throws RootAutomationException, FixupException {
        List<String> participatingNodes = this.m_fixupObj.getFixableNodes();
        RootUserCredentials userCredentials = null;
        String[] nodeList = participatingNodes.toArray(new String[0]);
        ConfigurationSetup.ConfigMethod configMode = null;
        ResultSet rootExecRsltSet = new ResultSet();
        try {
            userCredentials = RootAutomationUtility.getRootExecutionInfo();
            FixupUtility.validateRootAutomationSetup(nodeList, userCredentials);
            configMode = userCredentials.getRootExecutionMode();
            GlobalExecution globalExec = new GlobalExecution();
            UserInfo credentials = userCredentials.getRootUserCredentials();
            String[] args = new String[]{"-runfixup", FixupUtility.getFixupDataFileCompletePath(), "-tracelevel", Integer.toString(Trace.getCurrentTraceLevel())};
            globalExec.runGenericCmdAsRoot(nodeList, FixupUtility.getExectaskCompletePath(), null, args, credentials, configMode, userCredentials.getSudoPbrunLocation(), 1000, rootExecRsltSet);
        }
        catch (RootAutomationNotConfiguredException rance) {
            VerificationLogData.logError("RootAutomationNotConfiguredException:" + rance.getMessage());
            Trace.out((String)("Caught RootAutomationNotConfiguredException while attempt to use root automation. Error is " + rance.getMessage()));
            throw new RootAutomationException(rance);
        }
        catch (VerificationException ve) {
            VerificationLogData.logError("VerificationException:" + ve.getMessage());
            Trace.out((String)("Caught VerificationException while attempt to use root automation. Error is " + ve.getMessage()));
            throw new RootAutomationException(ve);
        }
        for (String node : participatingNodes) {
            ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
            Result nodeResult = rootExecRsltSet.getResult(node);
            if (nodeResult.getStatus() == 1) {
                String outputXmlPathForNode;
                String output = (String)nodeResult.getResultInfoSet().get(0);
                Result analyzerResult = new Result(node);
                analyzer.parseRunFixupOutput(output, analyzerResult);
                if (!this.m_fixupOutputFilePathMap.containsKey(node) || analyzerResult.getStatus() != 1 || !VerificationUtil.isStringGood(outputXmlPathForNode = (String)analyzerResult.getResultInfoSet().get(0))) continue;
                this.m_fixupOutputFilePathMap.remove(node);
                this.m_fixupOutputFilePathMap.put(node, outputXmlPathForNode);
                continue;
            }
            String command = FixupUtility.getDriverScriptCompletePath();
            String errorMsg = s_gMsgBundle.getMessage("9015", true, (Object[])new String[]{command, configMode.toString(), node, FixupUtility.getCompleteErrorMessageFromErrorList(nodeResult.getErrors())});
            nodeResult.addErrorDescription(new ErrorDescription(errorMsg));
            VerificationLogData.logError(errorMsg);
            this.m_fixupObj.updateNodeResult(nodeResult);
        }
    }

    public void copyAndProcessFixupOutFiles(List<String> nodeList) throws FixupException {
        int cnt;
        int numOfNodes = nodeList.size();
        FixupNodeThread[] nodeThreadArray = new FixupNodeThread[numOfNodes];
        for (cnt = 0; cnt < numOfNodes; ++cnt) {
            String node = nodeList.get(cnt);
            nodeThreadArray[cnt] = new FixupNodeThread(node, this.m_fixupOutputFilePathMap.get(node));
        }
        for (cnt = 0; cnt < numOfNodes; ++cnt) {
            FixupNodeThread t = nodeThreadArray[cnt];
            Trace.out((int)5, (String)(" Running node fixup thread " + t.getName()));
            t.start();
        }
        try {
            for (cnt = 0; cnt < numOfNodes; ++cnt) {
                Trace.out((int)5, (String)("Waiting to join " + nodeThreadArray[cnt].getName()));
                nodeThreadArray[cnt].join();
                Trace.out((int)5, (String)("Joined " + nodeThreadArray[cnt].getName()));
            }
        }
        catch (InterruptedException ie) {
            VerificationLogData.logError("InterruptedException-" + ie.getMessage());
            Trace.out((String)("Caught InterruptedException - Could not join thread list and Error is : " + ie.getMessage()));
            throw new FixupException(ie);
        }
        for (FixupNodeThread thread : nodeThreadArray) {
            Result thrdRes = thread.getResult();
            if (thrdRes.getStatus() == 1) {
                Trace.out((int)5, (String)("The thread for node " + thrdRes.getNode() + " is successful"));
                continue;
            }
            this.m_fixupObj.updateNodeResult(thrdRes);
            Trace.out((int)5, (String)("Failure in thread for node " + thrdRes.getNode() + " failed to retrieve the node output from the fixup-output file on node"));
        }
    }

    public static void destroy() {
        m_fixupController = null;
    }
}

