/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.fixup;

import java.util.Calendar;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.util.VerificationUtil;

public interface SSHSetupConstants {
    public static final String DEST_LOC = VerificationUtil.getDestLoc();
    public static final String CVU_SUBDIR_LOC = VerificationUtil.getCVUSubDirPath();
    public static final String SSH_SETUP_WORK_DIR_NAME = "CVU_" + Calendar.getInstance().getTimeInMillis() + "_SSH_SETUP";
    public static final String SSH_SETUP_WORK_DIRECTORY = VerificationUtil.getDestLoc() + SSH_SETUP_WORK_DIR_NAME + VerificationConstants.FILE_SEPARATOR;
    public static final String EXPORT_PUBLIC_KEY_FILE_NAME = "export_key.pub";
    public static final String EXPORT_PUBLIC_KEY_FILE_PATH = SSH_SETUP_WORK_DIRECTORY + "export_key.pub";
    public static final String EXPORT_RSA_HOST_KEY_FILE_NAME = "rsa_host_keys.export";
    public static final String EXPORT_RSA_HOST_KEY_FILE_PATH = SSH_SETUP_WORK_DIRECTORY + "rsa_host_keys.export";
    public static final String EXECTASK = "exectask";
    public static final String EXECTASK_EXTN = VerificationUtil.isPlatformWindows() ? ".exe" : "";
    public static final String EXECTASK_SCRIPT_EXTN = VerificationUtil.isPlatformWindows() ? ".bat" : ".sh";
    public static final String EXECTASK_COMPLETE_PATH = SSH_SETUP_WORK_DIRECTORY + "exectask" + EXECTASK_SCRIPT_EXTN;
    public static final String[] EXECTASK_GENERATE_SSH_KEYS_ARGS = new String[]{"-setupUserEquivalence", "-generateKeys", "-tracelevel 0"};
    public static final String[] EXECTASK_UPDATE_AUTH_KEYS_ARGS = new String[]{"-setupUserEquivalence", "-updateKeys", EXPORT_PUBLIC_KEY_FILE_PATH, "authorized_keys", " -tracelevel 0"};
    public static final String[] EXECTASK_UPDATE_RSA_HOST_KEYS_ARGS = new String[]{"-setupUserEquivalence", "-updateKeys", EXPORT_RSA_HOST_KEY_FILE_PATH, "known_hosts", " -tracelevel 0"};
    public static final String CVU_FIXUP_TRACE_FILE_NAME = "cvu_fixup_trace_0.log";
    public static final String CVU_FIXUP_TRACE_FILE_LOC = SSH_SETUP_WORK_DIRECTORY + "cvu_fixup_trace_0.log";
    public static final String LSEP = VerificationConstants.LINE_SEPARATOR;
    public static final String SSH_KEYSCAN_LOCATION = "/usr/bin/ssh-keyscan";
    public static final String SSH_KEYSCAN_ARG_TYPE = "-t";
    public static final String SSH_KEYSCAN_ARG_RSA = "rsa";
    public static final MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    public static final MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");

    public static enum KeysFileType {
        AUTHORIZED_KEYS,
        KNOWN_HOSTS;

    }

    public static class Tags {
        public static final String GENERATE = "GENERATE";
        public static final String UPDATE = "UPDATE";
        public static final String PUB_KEY = "PUB_KEY";
    }
}

