/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.constraints;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.ShellLimitType;
import oracle.cluster.verification.ShellResourceType;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.cluster.verification.constraints.CDMMemoryConstraints;
import oracle.cluster.verification.constraints.CDMOperatingSystem;
import oracle.cluster.verification.constraints.CDMProcessChecks;
import oracle.cluster.verification.constraints.CDMShellLimitChecks;
import oracle.cluster.verification.constraints.CDMSpaceConstraints;
import oracle.cluster.verification.constraints.CDMSystem;
import oracle.cluster.verification.constraints.CDMUserGroups;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.constraints.parser.XmlParser;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskArchitecture;
import oracle.ops.verification.framework.engine.task.TaskAvailableMemory;
import oracle.ops.verification.framework.engine.task.TaskCheckEnvVariable;
import oracle.ops.verification.framework.engine.task.TaskContainerFreeSpace;
import oracle.ops.verification.framework.engine.task.TaskContainerKernelParams;
import oracle.ops.verification.framework.engine.task.TaskContainerPackages;
import oracle.ops.verification.framework.engine.task.TaskGroupExistence;
import oracle.ops.verification.framework.engine.task.TaskGroupMembership;
import oracle.ops.verification.framework.engine.task.TaskKernelParam;
import oracle.ops.verification.framework.engine.task.TaskKernelVersion;
import oracle.ops.verification.framework.engine.task.TaskOSPatch;
import oracle.ops.verification.framework.engine.task.TaskOraclePatch;
import oracle.ops.verification.framework.engine.task.TaskPackage;
import oracle.ops.verification.framework.engine.task.TaskPhysicalMemory;
import oracle.ops.verification.framework.engine.task.TaskPortAvail;
import oracle.ops.verification.framework.engine.task.TaskProcessAlive;
import oracle.ops.verification.framework.engine.task.TaskRunLevel;
import oracle.ops.verification.framework.engine.task.TaskShellLimits;
import oracle.ops.verification.framework.engine.task.TaskSwapSize;
import oracle.ops.verification.framework.engine.task.TaskUpgradeSuitability;
import oracle.ops.verification.framework.engine.task.TaskUserExistence;
import oracle.ops.verification.framework.engine.task.sTaskKernelParam;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.InvalidStepException;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.RangeOperator;
import oracle.ops.verification.framework.util.RangeType;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class XmlTaskFactory {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static XmlTaskFactory m_xmlFactory = null;
    private XmlParser m_xmlParser;
    private File m_xmlFile;
    private String[] m_xmlNodeList;

    public static XmlTaskFactory getInstance() {
        if (m_xmlFactory == null) {
            m_xmlFactory = new XmlTaskFactory();
        }
        return m_xmlFactory;
    }

    private XmlTaskFactory() {
    }

    public Task[] getTasks(String filePath, String systemId, String[] nodeList) throws XmlParserException, PreReqNotSupportedException {
        return this.getTasks(VerificationType.PREREQ_CRS_INST, filePath, systemId, nodeList);
    }

    public Task[] getTasks(VerificationType vType, String filePath, String systemId, String[] nodeList) throws XmlParserException, PreReqNotSupportedException {
        return this.getTasks(vType, filePath, systemId, nodeList, false, null);
    }

    /*
     * Unable to fully structure code
     */
    public Task[] getTasks(VerificationType vType, String filePath, String systemId, String[] nodeList, boolean isLocalNodeCRSRunning, String[] limitedAddDelNodeList) throws XmlParserException, PreReqNotSupportedException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("XmlTaskFactory.getTasks:  File Path = " + filePath + " , System ID = " + systemId + " Node List: " + VerificationUtil.strArr2List(nodeList)));
        }
        this.m_xmlNodeList = nodeList;
        this.m_xmlFile = new File(filePath);
        this.m_xmlParser = new XmlParser(this.m_xmlFile);
        this.m_xmlParser.parse(vType);
        cdmHost = this.m_xmlParser.getCDMData();
        if (cdmHost == null) {
            Trace.out((String)"ERROR: Invalid root element");
            msg = XmlTaskFactory.s_msgBundle.getMessage("1108", false);
            throw new XmlParserException(msg);
        }
        csList = cdmHost.getCDMCertifiedSystems();
        if (csList.size() != 1) {
            msgParams = new String[]{Integer.toString(csList.size())};
            msg = XmlTaskFactory.s_msgBundle.getMessage("1099", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        cs = csList.elementAt(0);
        cdmSystems = cdmHost.getCDMSystems();
        if (cdmSystems.size() != 1) {
            msgParams = new String[]{Integer.toString(csList.size())};
            msg = XmlTaskFactory.s_msgBundle.getMessage("1100", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        cdmSystem = cdmSystems.elementAt(0);
        tasksList = new Vector<Task>();
        cdmMCList = cdmSystem.getCDMMemoryConstraints();
        if (cdmMCList.size() > 1) {
            msgParams = new String[]{Integer.toString(cdmMCList.size())};
            msg = XmlTaskFactory.s_msgBundle.getMessage("1101", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (cdmMCList.size() == 1) {
            cdmMC = cdmMCList.elementAt(0);
            tpm = this.createTaskPhysicalMemory(cdmMC);
            if (tpm != null) {
                tasksList.add(tpm);
            }
            if ((tam = this.createTaskAvailableMemory(cdmMC)) != null) {
                tasksList.add(tam);
            }
            if ((tss = this.createTaskSwapSize(cdmMC)) != null) {
                tasksList.add(tss);
            }
        }
        if ((tcfs = this.createTaskContainerFreeSpace(cdmSystem)) != null) {
            tasksList.add(tcfs);
        }
        cdmUG = cdmSystem.getCDMUserGroups();
        for (ugIndex = 0; ugIndex < cdmUG.size(); ++ugIndex) {
            tueList = this.createTaskUserExistence(cdmUG.elementAt(ugIndex));
            tgeList = this.createTaskGroupExistence(cdmUG.elementAt(ugIndex));
            tgmList = this.createTaskGroupMembership(cdmUG.elementAt(ugIndex));
            tasksList.addAll(tueList);
            tasksList.addAll(tgeList);
            tasksList.addAll(tgmList);
        }
        trl = this.createTaskRunLevel(cdmSystem);
        if (trl != null) {
            tasksList.add(trl);
        }
        if (new SystemFactory().CreateSystem().isUnixSystem()) {
            cdmSlc = cdmSystem.getCDMShellLimitChecks();
            for (slcIndex = 0; slcIndex < cdmSlc.size(); ++slcIndex) {
                tslList = this.createTaskShellLimits(cdmSlc.elementAt(slcIndex));
                tasksList.addAll(Arrays.asList(tslList));
            }
        }
        cdmPC = cdmSystem.getCDMProcessChecks();
        for (pcIndex = 0; pcIndex < cdmPC.size(); ++pcIndex) {
            tpaList = this.createTaskProcessAlive(cdmPC.elementAt(pcIndex));
            tasksList.addAll(Arrays.asList(tpaList));
        }
        sourceHomePatches = this.createHomeTaskOraclePatches(vType, cdmSystem.getSourceHomePatches());
        if (sourceHomePatches != null && sourceHomePatches.length > 0) {
            tasksList.addAll(Arrays.asList(sourceHomePatches));
        }
        if ((destHomePatches = this.createHomeTaskOraclePatches(vType, cdmSystem.getDestinationHomePatches())) != null && destHomePatches.length > 0) {
            tasksList.addAll(Arrays.asList(destHomePatches));
        }
        if ((racHomePatches = this.createRACHomeTaskOraclePatches(vType, cdmSystem.getRACHomePatches())) != null && racHomePatches.length > 0) {
            tasksList.addAll(Arrays.asList(racHomePatches));
        }
        if ((taskUpgradeSuitability = this.createUpgradeSuitability(cdmSystem)) != null) {
            tasksList.add(taskUpgradeSuitability);
        }
        cdmOS = cs.getCDMOS(systemId);
        releaseVersion = CVUVariables.getValue(CVUVariableConstants.RELEASE);
        if (!VerificationUtil.isStringGood(releaseVersion)) {
            releaseVersion = "12.2";
        }
        if (cdmOS == null) {
            osRefDataAvailable = false;
            osName = System.getProperty("os.name");
            curOSDist = osName + " " + systemId;
            if (VerificationUtil.isPlatformLinux()) {
                osReleaseList = new ArrayList<String>();
                sysId = systemId;
                sysId = sysId.replaceAll("[0-9]", "");
                for (String osRelease : cs.getOSReleaseList()) {
                    if (!osRelease.startsWith(sysId) && (!sysId.startsWith("OL") || !osRelease.startsWith("OEL"))) continue;
                    osReleaseList.add(osRelease);
                }
            } else {
                osReleaseList = cs.getOSReleaseList();
            }
            Trace.out((String)("OS release list: " + osReleaseList));
            if (!osReleaseList.isEmpty()) {
                systemIdToUse = osReleaseList.get(osReleaseList.size() - 1);
                Trace.out((String)("Distribution ID to use " + systemIdToUse));
                if (VerificationUtil.isVersionPre(systemIdToUse, systemId) && !VerificationUtil.isCVUTestEnv()) {
                    osDistToUse = osName + " " + systemIdToUse;
                    msg = XmlTaskFactory.s_gMsgBundle.getMessage("0286", false, (Object[])new String[]{releaseVersion, curOSDist, osDistToUse});
                    Trace.out((String)msg);
                    ReportUtil.processAlert(VerificationConstants.LSEP + ReportUtil.WARNING + VerificationConstants.LSEP + msg);
                    cdmOS = cs.getCDMOS(systemIdToUse);
                    osRefDataAvailable = true;
                }
            }
            if (!osRefDataAvailable) {
                if (VerificationUtil.isCVUTestEnv()) {
                    msg = XmlTaskFactory.s_msgBundle.getMessage("9811", true, (Object[])new String[]{releaseVersion, curOSDist});
                    Trace.out((String)msg);
                    throw new PreReqNotSupportedException(msg);
                }
                VerificationUtil.traceAndLog("Ignoring the unavailability of Reference data for the OS distribution " + curOSDist);
                return tasksList.toArray(new Task[tasksList.size()]);
            }
        }
        if ((ta = this.createTaskArchitecture(cdmOS)) != null) {
            tasksList.add(ta);
        }
        if ((tkv = this.createTaskKernelVersion(cdmOS)) != null) {
            tasksList.add(tkv);
        }
        if ((tckp = this.createTaskContainerKernelParams(cdmOS)) != null) {
            tasksList.add(tckp);
        }
        if ((tcp = this.createTaskContainerPackages(cdmOS)) != null) {
            tasksList.add(tcp);
        }
        if ((tcEnv = this.createTaskCheckEnvVariable(cdmOS)) != null) {
            tasksList.addAll(Arrays.asList(tcEnv));
        }
        if ((tosp = this.createTaskOSPatches(cdmOS)) != null) {
            tasksList.addAll(Arrays.asList(tosp));
        }
        if (!(VerificationUtil.isUpgrade() || VerificationUtil.isCRSSoftwareOnlyInstall() || VerificationUtil.isCVUResource() || vType != VerificationType.PREREQ_CRS_INST && vType != VerificationType.BESTPRACTICE_PRE_CRS_INST && vType != VerificationType.PREREQ_SI_HA_INST && vType != VerificationType.PREREQ_NODE_ADD)) {
            Trace.out((String)("The verification type is " + vType.getID() + "\n With local node crs running status as " + isLocalNodeCRSRunning));
            addTaskPort = true;
            v0 = nodeListForTaskPort = null != limitedAddDelNodeList && limitedAddDelNodeList.length > 0 ? limitedAddDelNodeList : nodeList;
            if (vType == VerificationType.PREREQ_NODE_ADD && isLocalNodeCRSRunning) {
                Trace.out((String)("Pre-Node add scenario with local node CRS Running and node list as " + VerificationUtil.strArr2List(nodeListForTaskPort)));
                VerificationLogData.logInfo("Pre-Node add scenario with local node CRS Running and node list as " + VerificationUtil.strArr2List(nodeListForTaskPort));
                try {
                    localNodeName = VerificationUtil.getLocalNodename();
                    if (nodeListForTaskPort == null) ** GOTO lbl166
                    for (String node : nodeListForTaskPort) {
                        if (!node.equalsIgnoreCase(localNodeName)) continue;
                        Trace.out((String)("Local node " + localNodeName + " has CRS running and is also a part of nodeList " + VerificationUtil.strArr2List(nodeListForTaskPort) + " for this check, hence not adding port availability check"));
                        VerificationLogData.logInfo("Local node " + localNodeName + " has CRS running and is also a part of nodeList " + VerificationUtil.strArr2List(nodeListForTaskPort) + " for this check, hence not adding port availability check");
                        addTaskPort = false;
                    }
                }
                catch (NodelistNotFoundException e) {
                    Trace.out((String)"Caught NodelistNotFoundException : Ignored as nodelist node found");
                }
            } else {
                v1 = addTaskPort = isLocalNodeCRSRunning == false;
            }
lbl166:
            // 5 sources

            if (addTaskPort && (tportList = this.createTaskPortAvail(cdmHost.getIpPortConstraint())) != null && tportList.size() > 0) {
                for (TaskPortAvail tpa : tportList) {
                    if (null != limitedAddDelNodeList && limitedAddDelNodeList.length > 0) {
                        Trace.out((String)("Reseting the list of nodes for Port availability check, current node list to reset is  (" + VerificationUtil.strArr2List(tpa.getNodeList()) + ") and new list of nodes to set is (" + VerificationUtil.strArr2List(limitedAddDelNodeList) + ")"));
                        VerificationLogData.log("Reseting the list of nodes for Port availability check, current node list to reset is  (" + VerificationUtil.strArr2List(tpa.getNodeList()) + ") and new list of nodes to set is (" + VerificationUtil.strArr2List(limitedAddDelNodeList) + ")");
                        tpa.setNodeList(limitedAddDelNodeList);
                        Trace.out((String)("After reseting, the list of nodes for Port availability check is  (" + VerificationUtil.strArr2List(tpa.getNodeList()) + ") "));
                        VerificationLogData.log("After reseting, the list of nodes for Port availability check is  (" + VerificationUtil.strArr2List(tpa.getNodeList()) + ") ");
                    }
                    tasksList.add(tpa);
                }
            }
        }
        return tasksList.toArray(new Task[tasksList.size()]);
    }

    private TaskUpgradeSuitability createUpgradeSuitability(CDMSystem cdmSystem) throws XmlParserException {
        HashMap h = cdmSystem.getUpgradeSuitabilityHash();
        List srcHomeRangeList = (List)h.get(CDMConstraintTypes.RANGE);
        TaskUpgradeSuitability task = null;
        if (srcHomeRangeList != null && srcHomeRangeList.size() > 0) {
            String destinationVersion;
            SeverityType severity = this.getSeverityAttributeValue((String)h.get(CDMConstraintTypes.SEVERITY));
            String srcHome = CVUVariables.getValue(CVUVariableConstants.oracle_install_crs_configuredCRSHome);
            String string = destinationVersion = CVUVariables.getValue(CVUVariableConstants.DEST_VERSION) != null ? CVUVariables.getValue(CVUVariableConstants.DEST_VERSION) : "12.2.0.1.0";
            if (srcHome == null) {
                Result result = new Result(VerificationUtil.getLocalNode());
                String asmHome = CVUHelperUtil.getASMhome(result);
                if (asmHome != null) {
                    srcHome = asmHome;
                } else {
                    Trace.out((int)5, (String)"Source CRS Home was not passed; Could not determine ASM Home skipping upgrade suitability check");
                    return null;
                }
            }
            task = new TaskUpgradeSuitability(srcHome, srcHomeRangeList, destinationVersion);
            task.setSeverity(severity);
            task.setNodeList(this.m_xmlNodeList);
        }
        return task;
    }

    private List<TaskPortAvail> createTaskPortAvail(Hashtable<String, HashMap<String, HashMap<NetworkConstants.NetworkProtocol, NetworkConstants.NetworkType>>> portTable) {
        boolean isNetWorkInfoAvailable = false;
        ParamManager pm = null;
        try {
            pm = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        isNetWorkInfoAvailable = VerificationUtil.isCLIMode() ? CVUVariables.getValue(CVUVariableConstants.NETWORK_LIST) != null : VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.INTERCONNECT_LIST));
        Set<NetworkInfo> clusterNetworks = null;
        if (isNetWorkInfoAvailable) {
            String localNode = VerificationUtil.getLocalNode();
            ResultSet networksResultSet = new ResultSet();
            try {
                clusterNetworks = NetworkUtility.getNetworkInfo(networksResultSet);
                if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
                    Trace.out((String)"Could not discover the network details successfully while creating TaskPortAvail objects");
                    NetworkUtility.reportResultSet(networksResultSet, null, false);
                }
            }
            catch (CVUException cvuEx) {
                String errorMessage = cvuEx.getMessage();
                Trace.out((String)("Exception occured while getting network information. msg=" + errorMessage));
                VerificationLogData.logInfo(errorMessage);
                ReportUtil.printError(errorMessage);
            }
        }
        ArrayList<TaskPortAvail> tPortList = new ArrayList<TaskPortAvail>();
        if (portTable != null && portTable.size() > 0) {
            for (String comp : portTable.keySet()) {
                HashMap<String, HashMap<NetworkConstants.NetworkProtocol, NetworkConstants.NetworkType>> portMap = portTable.get(comp);
                NetworkConstants.NetworkType netWorkTypeForComponent = NetworkConstants.NetworkType.ALL;
                for (String port : portMap.keySet()) {
                    HashMap<NetworkConstants.NetworkProtocol, NetworkConstants.NetworkType> protoTypeMap = portMap.get(port);
                    if (null == protoTypeMap) continue;
                    for (NetworkConstants.NetworkProtocol proto : protoTypeMap.keySet()) {
                        if (null == protoTypeMap.get((Object)proto)) continue;
                        netWorkTypeForComponent = protoTypeMap.get((Object)proto);
                    }
                }
                if (clusterNetworks != null && netWorkTypeForComponent != NetworkConstants.NetworkType.ALL) {
                    if (NetworkUtility.isNetworkTypeClassified(clusterNetworks, netWorkTypeForComponent)) {
                        tPortList.add(new TaskPortAvail(this.m_xmlNodeList, comp, portMap));
                        continue;
                    }
                    VerificationUtil.traceAndLog("Not adding port check for component " + comp + " as the required network type " + (Object)((Object)netWorkTypeForComponent) + " was not classified in network " + "information");
                    continue;
                }
                if (netWorkTypeForComponent != NetworkConstants.NetworkType.ALL) continue;
                tPortList.add(new TaskPortAvail(this.m_xmlNodeList, comp, portMap));
            }
        }
        return tPortList;
    }

    private TaskPhysicalMemory createTaskPhysicalMemory(CDMMemoryConstraints cdmMC) throws XmlParserException {
        HashMap<String, String> pmem = cdmMC.getPhyMemory();
        if (pmem == null) {
            return null;
        }
        String value = pmem.get(CDMConstraintTypes.VALUE);
        String rim = pmem.get(CDMConstraintTypes.RIM);
        String units = pmem.get(CDMConstraintTypes.UNIT);
        SeverityType severity = this.getSeverityAttributeValue(pmem.get(CDMConstraintTypes.SEVERITY));
        StorageUnit su = this.getStorageUnits(units);
        try {
            TaskPhysicalMemory tpm = new TaskPhysicalMemory(new StorageSize(Double.parseDouble(value), su));
            if (rim != null) {
                tpm.setRimValue(new StorageSize(Double.parseDouble(rim), su));
            }
            tpm.setSeverity(severity);
            tpm.setNodeList(this.m_xmlNodeList);
            return tpm;
        }
        catch (NumberFormatException nfe) {
            Object[] msgParams = new String[]{value, CDMConstraintTypes.VALUE, CDMConstraintTypes.PHYSICAL_MEMORY};
            String msg = s_msgBundle.getMessage("1095", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg, nfe);
        }
    }

    private TaskAvailableMemory createTaskAvailableMemory(CDMMemoryConstraints cdmMC) throws XmlParserException {
        HashMap<String, String> amem = cdmMC.getAvailMemory();
        if (amem == null) {
            return null;
        }
        String value = amem.get(CDMConstraintTypes.VALUE);
        String rim = amem.get(CDMConstraintTypes.RIM);
        String units = amem.get(CDMConstraintTypes.UNIT);
        StorageUnit su = this.getStorageUnits(units);
        SeverityType severity = this.getSeverityAttributeValue(amem.get(CDMConstraintTypes.SEVERITY));
        try {
            TaskAvailableMemory tam = new TaskAvailableMemory(new StorageSize(Double.parseDouble(value), su));
            if (rim != null) {
                tam.setRimValue(new StorageSize(Double.parseDouble(rim), su));
            }
            tam.setSeverity(severity);
            tam.setNodeList(this.m_xmlNodeList);
            return tam;
        }
        catch (NumberFormatException nfe) {
            Object[] msgParams = new String[]{value, CDMConstraintTypes.VALUE, CDMConstraintTypes.AVAILABLE_MEMORY};
            String msg = s_msgBundle.getMessage("1095", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg, nfe);
        }
    }

    private TaskSwapSize createTaskSwapSize(CDMMemoryConstraints cdmMC) throws XmlParserException {
        HashMap<String, String> swapMem = cdmMC.getSwapMemory();
        if (swapMem != null) {
            String value = swapMem.get(CDMConstraintTypes.VALUE);
            String rim = swapMem.get(CDMConstraintTypes.RIM);
            String units = swapMem.get(CDMConstraintTypes.UNIT);
            String minValue = swapMem.get(CDMConstraintTypes.MIN_VALUE);
            String minUnits = swapMem.get(CDMConstraintTypes.MIN_UNIT);
            String maxValue = swapMem.get(CDMConstraintTypes.MAX_VALUE);
            String maxUnits = swapMem.get(CDMConstraintTypes.MAX_UNIT);
            SeverityType severity = this.getSeverityAttributeValue(swapMem.get(CDMConstraintTypes.SEVERITY));
            StorageUnit su = this.getStorageUnits(units);
            try {
                TaskSwapSize tss = new TaskSwapSize(new StorageSize(Double.parseDouble(value), su));
                tss.setSeverity(severity);
                tss.setNodeList(this.m_xmlNodeList);
                if (rim != null) {
                    tss.setRimValue(new StorageSize(Double.parseDouble(rim), su));
                }
                if (minValue != null) {
                    tss.setMinSwapSize(new StorageSize(Double.parseDouble(minValue), this.getStorageUnits(minUnits)));
                }
                if (maxValue != null) {
                    tss.setMaxSwapSize(new StorageSize(Double.parseDouble(maxValue), this.getStorageUnits(maxUnits)));
                }
                return tss;
            }
            catch (NumberFormatException nfe) {
                Object[] msgParams = new String[]{value, CDMConstraintTypes.VALUE, CDMConstraintTypes.SWAP_SIZE};
                String msg = s_msgBundle.getMessage("1095", false, msgParams);
                Trace.out((String)msg);
                throw new XmlParserException(msg, nfe);
            }
        }
        Vector<HashMap<String, String>> swapElems = cdmMC.getSwapMemorySteps();
        if (swapElems == null) {
            return null;
        }
        TaskSwapSize tss = null;
        for (int i = 0; i < swapElems.size(); ++i) {
            HashMap<String, String> swapElem = swapElems.elementAt(i);
            if (tss == null) {
                tss = new TaskSwapSize(swapElem.get(CDMConstraintTypes.NAME));
                SeverityType severity = this.getSeverityAttributeValue(swapElem.get(CDMConstraintTypes.SEVERITY));
                tss.setSeverity(severity);
                String minValue = swapElem.get(CDMConstraintTypes.MIN_VALUE);
                String minUnits = swapElem.get(CDMConstraintTypes.MIN_UNIT);
                String maxValue = swapElem.get(CDMConstraintTypes.MAX_VALUE);
                String maxUnits = swapElem.get(CDMConstraintTypes.MAX_UNIT);
                if (minValue != null) {
                    tss.setMinSwapSize(new StorageSize(Double.parseDouble(minValue), this.getStorageUnits(minUnits)));
                }
                if (maxValue != null) {
                    tss.setMaxSwapSize(new StorageSize(Double.parseDouble(maxValue), this.getStorageUnits(maxUnits)));
                }
            }
            this.addTaskSwapSizeStep(swapElem, tss);
        }
        if (tss == null) {
            Object[] msgParams = new String[]{CDMConstraintTypes.SWAP_SIZE};
            String msg = s_msgBundle.getMessage("1110", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        return tss;
    }

    private void addTaskSwapSizeStep(HashMap<String, String> swapElem, TaskSwapSize tss) throws XmlParserException {
        Float multipleF;
        String units = swapElem.get(CDMConstraintTypes.UNIT);
        StorageUnit su = this.getStorageUnits(units);
        RangeOfValue r = new RangeOfValue(RangeType.STORAGE_SIZE);
        StorageSize valueSS = null;
        StorageSize atleastSS = null;
        StorageSize atmostSS = null;
        StorageSize gthanSS = null;
        StorageSize lthanSS = null;
        String value = swapElem.get(CDMConstraintTypes.VALUE);
        String atleast = swapElem.get(CDMConstraintTypes.ATLEAST);
        String atmost = swapElem.get(CDMConstraintTypes.ATMOST);
        String gthan = swapElem.get(CDMConstraintTypes.GREATER_THAN);
        String lthan = swapElem.get(CDMConstraintTypes.LESS_THAN);
        try {
            if (value != null) {
                valueSS = new StorageSize(Double.parseDouble(value), su);
            }
            if (atleast != null) {
                atleastSS = new StorageSize(Double.parseDouble(atleast), su);
            }
            if (atmost != null) {
                atmostSS = new StorageSize(Double.parseDouble(atmost), su);
            }
            if (gthan != null) {
                gthanSS = new StorageSize(Double.parseDouble(gthan), su);
            }
            if (lthan != null) {
                lthanSS = new StorageSize(Double.parseDouble(lthan), su);
            }
        }
        catch (NumberFormatException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        try {
            this.manipulateRange(r, valueSS, atleastSS, atmostSS, gthanSS, lthanSS, false);
        }
        catch (InvalidRangeManipulationException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        String multiple = swapElem.get(CDMConstraintTypes.MULTIPLE);
        try {
            multipleF = Float.valueOf(Float.parseFloat(multiple));
        }
        catch (NumberFormatException nfe) {
            Object[] msgParams = new String[]{multiple, CDMConstraintTypes.MULTIPLE, CDMConstraintTypes.STEP};
            String msg = s_msgBundle.getMessage("1097", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg, nfe);
        }
        try {
            tss.addStep(r, su, multipleF.floatValue());
        }
        catch (InvalidStepException ise) {
            throw new XmlParserException(ise.getMessage(), ise);
        }
    }

    private TaskContainerFreeSpace createTaskContainerFreeSpace(CDMSystem cdmSystem) throws XmlParserException {
        Vector<CDMSpaceConstraints> cdmSCList;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        if ((cdmSCList = cdmSystem.getCDMSpaceConstraints()).size() == 0) {
            return null;
        }
        TaskContainerFreeSpace tcfs = new TaskContainerFreeSpace(this.m_xmlNodeList);
        for (int i = 0; i < cdmSCList.size(); ++i) {
            CDMSpaceConstraints cdmSC = cdmSCList.elementAt(i);
            this.addFreeSpaceLoc(cdmSC, tcfs);
        }
        tcfs.generateTaskFreeSpaceList();
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return tcfs;
    }

    private void addFreeSpaceLoc(CDMSpaceConstraints cdmSC, TaskContainerFreeSpace tcfs) throws XmlParserException {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        this.updateSpaceReqForCHMOS(cdmSC);
        Hashtable<String, HashMap> installLocs = cdmSC.getInstallLocations();
        Iterator<HashMap> iter = installLocs.values().iterator();
        for (int i = 0; i < installLocs.size(); ++i) {
            HashMap installLoc = iter.next();
            String sUnits = (String)installLoc.get(CDMConstraintTypes.UNIT);
            String sTemp = (String)installLoc.get(CDMConstraintTypes.TEMP);
            String sSize = (String)installLoc.get(CDMConstraintTypes.SIZE);
            String rim = (String)installLoc.get(CDMConstraintTypes.SIZE);
            String sVar = (String)installLoc.get(CDMConstraintTypes.VAR);
            String sVal = (String)installLoc.get(CDMConstraintTypes.VALUE);
            SeverityType severity = this.getSeverityAttributeValue((String)installLoc.get(CDMConstraintTypes.SEVERITY));
            StorageUnit su = this.getStorageUnits(sUnits);
            String loc = null;
            if (sVar != null && !sVar.equals("") && sVal != null && !sVal.equals("")) {
                Object[] msgParams = new String[]{CDMConstraintTypes.LOC};
                String msg = s_msgBundle.getMessage("1109", false, msgParams);
                Trace.out((String)msg);
                throw new XmlParserException(msg);
            }
            if (sVar != null) {
                File crsHomePath;
                loc = CVUVariables.getValue(sVar);
                if (!VerificationUtil.isStringGood(loc)) {
                    if (!Trace.isLevelEnabled((int)1)) continue;
                    Trace.out((String)("Value for variable " + sVar + " returned null, skipping loc tag."));
                    continue;
                }
                if (VerificationUtil.isUpgrade() && sVar.equalsIgnoreCase(CVUVariableConstants.CRS_HOME.toString()) && (crsHomePath = new File(loc)).exists()) {
                    Trace.out((String)("Skipping the free space check for an existing/configured CRS home (" + loc + ") during upgrade."));
                    continue;
                }
            } else if (sVal != null) {
                loc = sVal;
            }
            try {
                Double sSizeDbl;
                Double rimSizeDbl = sSizeDbl = new Double(sSize);
                if (VerificationUtil.isStringGood(rim)) {
                    try {
                        rimSizeDbl = new Double(rim);
                    }
                    catch (NumberFormatException rnfe) {
                        Object[] msgParams = new String[]{rim, CDMConstraintTypes.RIM, CDMConstraintTypes.SPACE};
                        String msg = s_msgBundle.getMessage("1097", false, msgParams);
                        Trace.out((String)msg);
                        throw new XmlParserException(msg, rnfe);
                    }
                }
                tcfs.addPathDetails(loc, new StorageSize((double)sSizeDbl, su), new StorageSize((double)rimSizeDbl, su), Boolean.parseBoolean(sTemp), severity);
                continue;
            }
            catch (NumberFormatException nfe) {
                Object[] msgParams = new String[]{sSize, CDMConstraintTypes.SIZE, CDMConstraintTypes.SPACE};
                String msg = s_msgBundle.getMessage("1097", false, msgParams);
                Trace.out((String)msg);
                throw new XmlParserException(msg, nfe);
            }
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
    }

    private void updateSpaceReqForCHMOS(CDMSpaceConstraints cdmSC) throws XmlParserException {
        if (cdmSC.hasInstallLocation("CRS_HOME") && cdmSC.hasInstallLocation("CHM_OS")) {
            int numOfNodes = 1;
            try {
                String[] nodeList = VerificationUtil.getStaticNodelist();
                if (nodeList != null && nodeList.length > 0) {
                    numOfNodes = nodeList.length;
                }
            }
            catch (NodelistNotFoundException e) {
                Trace.out((int)5, (String)("Failed to retrieve static nodeList ERROR Details - " + e.getMessage()));
            }
            if (this.m_xmlNodeList != null && numOfNodes < this.m_xmlNodeList.length) {
                numOfNodes = this.m_xmlNodeList.length;
            }
            HashMap crsHomeSpaceDetails = cdmSC.getInstallLocation("CRS_HOME");
            String crsHomeUnits = (String)crsHomeSpaceDetails.get(CDMConstraintTypes.UNIT);
            String crsHomeSize = (String)crsHomeSpaceDetails.get(CDMConstraintTypes.SIZE);
            StorageUnit crsHomesu = this.getStorageUnits(crsHomeUnits);
            Double crsHomeSizeDbl = new Double(crsHomeSize);
            StorageSize crsHomeStorageSize = new StorageSize((double)crsHomeSizeDbl, crsHomesu);
            HashMap chmOsSpaceDetails = cdmSC.getInstallLocation("CHM_OS");
            String chmOsUnits = (String)chmOsSpaceDetails.get(CDMConstraintTypes.UNIT);
            String chmOsSize = (String)chmOsSpaceDetails.get(CDMConstraintTypes.SIZE);
            StorageUnit chmOssu = this.getStorageUnits(chmOsUnits);
            Double chmOsSizeDbl = new Double(chmOsSize);
            StorageSize chmOsStorageSize = new StorageSize((double)chmOsSizeDbl, chmOssu);
            StorageSize totalChmOsReqSize = new StorageSize(0.0, StorageUnit.MBYTE);
            for (int i = 0; i < numOfNodes; ++i) {
                totalChmOsReqSize.add(chmOsStorageSize);
            }
            totalChmOsReqSize.add(crsHomeStorageSize);
            String finalSize = Double.toString(totalChmOsReqSize.sizeIn(crsHomesu));
            cdmSC.removeInstallLocation("CRS_HOME");
            cdmSC.removeInstallLocation("CHM_OS");
            cdmSC.addInstallLocation("CRS_HOME", (String)crsHomeSpaceDetails.get(CDMConstraintTypes.VALUE), (String)crsHomeSpaceDetails.get(CDMConstraintTypes.TEMP), finalSize, null, (String)crsHomeSpaceDetails.get(CDMConstraintTypes.UNIT), (String)crsHomeSpaceDetails.get(CDMConstraintTypes.SEVERITY));
        }
    }

    private List<TaskUserExistence> createTaskUserExistence(CDMUserGroups cdmUG) throws XmlParserException {
        Vector<HashMap<String, String>> users = cdmUG.getUserConstraints();
        ArrayList<TaskUserExistence> tuelist = new ArrayList<TaskUserExistence>();
        for (int i = 0; i < users.size(); ++i) {
            HashMap<String, String> userMap = users.elementAt(i);
            SeverityType severity = this.getSeverityAttributeValue(userMap.get(CDMConstraintTypes.SEVERITY));
            String user = userMap.get(CDMConstraintTypes.USER_VALUE);
            TaskUserExistence tue = TaskUserExistence.generate(user, this.m_xmlNodeList);
            tue.setSeverity(severity);
            tuelist.add(tue);
        }
        return tuelist;
    }

    private List<Task> createTaskGroupExistence(CDMUserGroups cdmUG) throws XmlParserException {
        Vector<HashMap<String, String>> groups = cdmUG.getGroupConstraints();
        TaskGroupExistence[] tgeList = new TaskGroupExistence[groups.size()];
        Vector<Task> retTasks = new Vector<Task>();
        for (int i = 0; i < groups.size(); ++i) {
            HashMap<String, String> groupMap = groups.elementAt(i);
            String group = groupMap.get(CDMConstraintTypes.GROUP_VALUE);
            SeverityType severity = this.getSeverityAttributeValue(groupMap.get(CDMConstraintTypes.SEVERITY));
            if (!VerificationUtil.isStringGood(group)) continue;
            tgeList[i] = TaskGroupExistence.generate(group, this.m_xmlNodeList);
            tgeList[i].setSeverity(severity);
            retTasks.add(tgeList[i]);
        }
        return retTasks;
    }

    private List<Task> createTaskGroupMembership(CDMUserGroups cdmUG) throws XmlParserException {
        Vector<HashMap<String, String>> groups = cdmUG.getUserGroups();
        TaskGroupMembership[] tgmList = new TaskGroupMembership[groups.size()];
        Vector<Task> retTasks = new Vector<Task>();
        for (int i = 0; i < groups.size(); ++i) {
            HashMap<String, String> groupMap = groups.elementAt(i);
            String user = groupMap.get(CDMConstraintTypes.USER_VALUE);
            String group = groupMap.get(CDMConstraintTypes.GROUP_VALUE);
            SeverityType severity = this.getSeverityAttributeValue(groupMap.get(CDMConstraintTypes.SEVERITY));
            String active = groupMap.get(CDMConstraintTypes.ACTIVE);
            tgmList[i] = TaskGroupMembership.generate(user, group, Boolean.parseBoolean(active), this.m_xmlNodeList);
            tgmList[i].setSeverity(severity);
            retTasks.add(tgmList[i]);
        }
        return retTasks;
    }

    private TaskRunLevel createTaskRunLevel(CDMSystem cdmSystem) throws XmlParserException {
        HashMap runLevel = cdmSystem.getRunLevelCheck();
        if (runLevel == null) {
            return null;
        }
        List runLevels = (List)runLevel.get(CDMConstraintTypes.VALUE);
        SeverityType severity = this.getSeverityAttributeValue((String)runLevel.get(CDMConstraintTypes.SEVERITY));
        TaskRunLevel trl = new TaskRunLevel(runLevels);
        trl.setSeverity(severity);
        trl.setNodeList(this.m_xmlNodeList);
        return trl;
    }

    private TaskShellLimits[] createTaskShellLimits(CDMShellLimitChecks cdmSlc) throws XmlParserException {
        List<TaskShellLimits.ShellLimitData> fdSoftLimits = cdmSlc.getSoftFileDescriptorLimits();
        List<TaskShellLimits.ShellLimitData> fdHardLimits = cdmSlc.getHardFileDescriptorLimits();
        List<TaskShellLimits.ShellLimitData> mpSoftLimits = cdmSlc.getSoftMaxProcessLimits();
        List<TaskShellLimits.ShellLimitData> mpHardLimits = cdmSlc.getHardMaxProcessLimits();
        List<TaskShellLimits.ShellLimitData> stackSoftLimits = cdmSlc.getSoftStackLimits();
        List<TaskShellLimits.ShellLimitData> stackHardLimits = cdmSlc.getHardStackLimits();
        TaskShellLimits.ShellLimitValue defaultExpectedFileDescSoft = cdmSlc.getDefaultExpectedFileDescLimits(ShellLimitType.SOFT);
        TaskShellLimits.ShellLimitValue defaultExpectedFileDescHard = cdmSlc.getDefaultExpectedFileDescLimits(ShellLimitType.HARD);
        TaskShellLimits.ShellLimitValue defaultExpectedMaxProcSoft = cdmSlc.getDefaultExpectedMaxProcLimits(ShellLimitType.SOFT);
        TaskShellLimits.ShellLimitValue defaultExpectedMaxProccHard = cdmSlc.getDefaultExpectedMaxProcLimits(ShellLimitType.HARD);
        TaskShellLimits.ShellLimitValue defaultExpectedStackSoft = cdmSlc.getDefaultExpectedStackLimits(ShellLimitType.SOFT);
        TaskShellLimits.ShellLimitValue defaultExpectedStackHard = cdmSlc.getDefaultExpectedStackLimits(ShellLimitType.HARD);
        ArrayList<TaskShellLimits> tslList = new ArrayList<TaskShellLimits>();
        TaskShellLimits task = null;
        if (fdHardLimits != null) {
            Trace.out((String)"Checking if Task shell Limit for Hard Limit - Maximum File Descriptors is applicable for login shell on current set of nodes");
            task = new TaskShellLimits(this.m_xmlNodeList, ShellLimitType.HARD, ShellResourceType.MAX_FILEDESC, defaultExpectedFileDescHard, fdHardLimits);
            task.setNodeList(this.m_xmlNodeList);
            if (task.isLimitApplicable()) {
                Trace.out((String)"Adding the task as applicable login shell for Hard Limit - Maximum File Descriptors was found on one or more nodes");
                tslList.add(task);
            } else {
                Trace.out((String)"Not adding Task shell Limit for Hard Limit - Maximum File Descriptors as there is no default limit available for the login shell(s) on nodes.");
            }
        }
        if (fdSoftLimits != null) {
            Trace.out((String)"Checking if Task shell Limit for Soft Limit - Maximum File Descriptors is applicable for login shell on current set of nodes");
            task = new TaskShellLimits(this.m_xmlNodeList, ShellLimitType.SOFT, ShellResourceType.MAX_FILEDESC, defaultExpectedFileDescSoft, fdSoftLimits);
            task.setNodeList(this.m_xmlNodeList);
            if (task.isLimitApplicable()) {
                Trace.out((String)"Adding the task as applicable login shell for Soft Limit - Maximum File Descriptors was found on one or more nodes");
                tslList.add(task);
            } else {
                Trace.out((String)"Not adding Task shell Limit for Soft Limit - Maximum File Descriptors as there is no default limit available for the login shell(s) on nodes.");
            }
        }
        if (mpHardLimits != null) {
            Trace.out((String)"Checking if Task shell Limit for Hard Limit - Maximum user processes is applicable for login shell on current set of nodes");
            task = new TaskShellLimits(this.m_xmlNodeList, ShellLimitType.HARD, ShellResourceType.MAX_PROC, defaultExpectedMaxProccHard, mpHardLimits);
            task.setNodeList(this.m_xmlNodeList);
            if (task.isLimitApplicable()) {
                Trace.out((String)"Adding the task as applicable login shell for Hard Limit - Maximum user processes was found on one or more nodes");
                tslList.add(task);
            } else {
                Trace.out((String)"Not adding Task shell Limit for Hard Limit - Maximum user processes as there is no default limit available for the login shell(s) on nodes.");
            }
        }
        if (mpSoftLimits != null) {
            Trace.out((String)"Checking if Task shell Limit for Soft Limit - Maximum user processes is applicable for login shell on current set of nodes");
            task = new TaskShellLimits(this.m_xmlNodeList, ShellLimitType.SOFT, ShellResourceType.MAX_PROC, defaultExpectedMaxProcSoft, mpSoftLimits);
            task.setNodeList(this.m_xmlNodeList);
            if (task.isLimitApplicable()) {
                Trace.out((String)"Adding the task as applicable login shell for Soft Limit - Maximum user processes was found on one or more nodes");
                tslList.add(task);
            } else {
                Trace.out((String)"Not adding Task shell Limit for Soft Limit - Maximum user processes as there is no default limit available for the login shell(s) on nodes.");
            }
        }
        if (stackHardLimits != null) {
            Trace.out((String)"Checking if Task shell Limit for Hard Limit - Stack is applicable for login shell on current set of nodes");
            task = new TaskShellLimits(this.m_xmlNodeList, ShellLimitType.HARD, ShellResourceType.MAX_STACK_SIZE, defaultExpectedStackHard, stackHardLimits);
            task.setNodeList(this.m_xmlNodeList);
            if (task.isLimitApplicable()) {
                Trace.out((String)"Adding the task as applicable login shell for Hard Limit - Stack was found on one or more nodes");
                tslList.add(task);
            } else {
                Trace.out((String)"Not adding Task shell Limit for Hard Limit - Stack as there is no default limit available for the login shell(s) on nodes.");
            }
        }
        if (stackSoftLimits != null) {
            Trace.out((String)"Checking if Task shell Limit for Soft Limit - Stack is applicable for login shell on current set of nodes");
            task = new TaskShellLimits(this.m_xmlNodeList, ShellLimitType.SOFT, ShellResourceType.MAX_STACK_SIZE, defaultExpectedStackSoft, stackSoftLimits);
            task.setNodeList(this.m_xmlNodeList);
            if (task.isLimitApplicable()) {
                Trace.out((String)"Adding the task as applicable login shell for Soft Limit - Stack was found on one or more nodes");
                tslList.add(task);
            } else {
                Trace.out((String)"Not adding Task shell Limit for Soft Limit - Stack as there is no default limit available for the login shell(s) on nodes.");
            }
        }
        return tslList.toArray(new TaskShellLimits[0]);
    }

    private TaskProcessAlive[] createTaskProcessAlive(CDMProcessChecks cdmProcessChecks) throws XmlParserException {
        Vector<HashMap> processChecks = cdmProcessChecks.getProcessChecks();
        TaskProcessAlive[] tpaList = new TaskProcessAlive[processChecks.size()];
        for (int i = 0; i < processChecks.size(); ++i) {
            HashMap pc = processChecks.elementAt(i);
            String processName = (String)pc.get(CDMConstraintTypes.NAME);
            SeverityType severity = this.getSeverityAttributeValue((String)pc.get(CDMConstraintTypes.SEVERITY));
            tpaList[i] = new TaskProcessAlive(processName);
            tpaList[i].setNodeList(this.m_xmlNodeList);
            tpaList[i].setSeverity(severity);
        }
        return tpaList;
    }

    private TaskArchitecture createTaskArchitecture(CDMOperatingSystem cdmOS) throws XmlParserException {
        HashMap<String, Object> kerAttrs = cdmOS.getArchitectureValues();
        List osArchs = (List)kerAttrs.get(CDMConstraintTypes.VALUE);
        SeverityType severity = this.getSeverityAttributeValue((String)kerAttrs.get(CDMConstraintTypes.SEVERITY));
        if (osArchs == null) {
            return null;
        }
        TaskArchitecture ta = new TaskArchitecture(osArchs);
        ta.setSeverity(severity);
        ta.setNodeList(this.m_xmlNodeList);
        return ta;
    }

    private TaskCheckEnvVariable[] createTaskCheckEnvVariable(CDMOperatingSystem cdmOS) throws XmlParserException {
        Vector<HashMap<String, String>> envAttrs = cdmOS.getEnvVariables();
        Vector<TaskCheckEnvVariable> tcenvVect = new Vector<TaskCheckEnvVariable>();
        String[] exceptionalVarList = new String[]{"ORA_CRS_HOME"};
        int s_maxLength = 0;
        boolean s_set = false;
        boolean isRestartServiceSet = false;
        boolean isTestEnv = VerificationUtil.isCVUTestEnv();
        for (int i = 0; i < envAttrs.size(); ++i) {
            s_maxLength = 0;
            s_set = false;
            HashMap<String, String> envData = envAttrs.elementAt(i);
            String name = envData.get(CDMConstraintTypes.ENV_VAR_NAME);
            if (Arrays.asList(exceptionalVarList).contains(name.toUpperCase()) && isTestEnv) continue;
            String maxLength = envData.get(CDMConstraintTypes.MAX_LENGTH);
            String set = envData.get(CDMConstraintTypes.SET);
            s_set = set != null && set.length() > 0 ? Boolean.parseBoolean(set) : true;
            if (maxLength != null && maxLength.length() > 0) {
                s_maxLength = Integer.parseInt(maxLength);
            }
            if (s_maxLength != 0 && !s_set) {
                String msg = s_msgBundle.getMessage("1109", false, (Object[])new String[]{CDMConstraintTypes.ENV_VAR});
                Trace.out((String)msg);
                throw new XmlParserException(msg);
            }
            TaskCheckEnvVariable tcenv = new TaskCheckEnvVariable();
            tcenv.setVariableName(name);
            tcenv.setMaxVariableLength(s_maxLength);
            tcenv.checkVariableSet(s_set);
            tcenv.setNodeList(this.m_xmlNodeList);
            if (!isRestartServiceSet) {
                isRestartServiceSet = true;
                tcenv.setRestartService(isRestartServiceSet);
            }
            tcenvVect.add(tcenv);
        }
        Object[] tcenvList = new TaskCheckEnvVariable[tcenvVect.size()];
        tcenvVect.copyInto(tcenvList);
        return tcenvList;
    }

    private TaskOSPatch[] createTaskOSPatches(CDMOperatingSystem cdmOS) throws XmlParserException {
        List<HashMap<String, String>> osPatchChecks = cdmOS.getOSPatches();
        TaskOSPatch[] tospList = new TaskOSPatch[osPatchChecks.size()];
        for (int i = 0; i < osPatchChecks.size(); ++i) {
            HashMap<String, String> pc = osPatchChecks.get(i);
            String osPatch = pc.get(CDMConstraintTypes.VALUE);
            SeverityType severity = this.getSeverityAttributeValue(pc.get(CDMConstraintTypes.SEVERITY));
            tospList[i] = new TaskOSPatch(osPatch);
            tospList[i].setSeverity(severity);
            tospList[i].setNodeList(this.m_xmlNodeList);
        }
        return tospList;
    }

    private TaskOraclePatch[] createHomeTaskOraclePatches(VerificationType vType, List<HashMap<String, String>> oraclePatchChecks) throws XmlParserException {
        SeverityType severity;
        String home;
        HashMap<String, String> oraclePatches = new HashMap<String, String>();
        HashMap<String, SeverityType> patchSeverity = new HashMap<String, SeverityType>();
        int j = 0;
        for (int i = 0; i < oraclePatchChecks.size(); ++i) {
            HashMap<String, String> pc = oraclePatchChecks.get(i);
            String oraclePatch = pc.get(CDMConstraintTypes.VALUE);
            home = pc.get(CDMConstraintTypes.HOME);
            severity = this.getSeverityAttributeValue(pc.get(CDMConstraintTypes.SEVERITY));
            if (oraclePatch == null) continue;
            oraclePatches.put(oraclePatch, home);
            patchSeverity.put(oraclePatch, severity);
        }
        TaskOraclePatch[] topList = new TaskOraclePatch[oraclePatches.size()];
        for (String oraclePatch : oraclePatches.keySet()) {
            home = (String)oraclePatches.get(oraclePatch);
            severity = (SeverityType)((Object)patchSeverity.get(oraclePatch));
            topList[j] = new TaskOraclePatch(vType, home, oraclePatch);
            if (VerificationUtil.isCVUTestEnv() || Utils.isDevelopmentEnv()) {
                topList[j].setSeverity(SeverityType.IGNORABLE);
            } else {
                topList[j].setSeverity(severity);
            }
            topList[j].setNodeList(this.m_xmlNodeList);
            ++j;
        }
        return topList;
    }

    private TaskOraclePatch[] createRACHomeTaskOraclePatches(VerificationType vType, List<HashMap<String, Object>> oraclePatchChecks) throws XmlParserException {
        String home;
        HashMap<String, String> oraclePatches = new HashMap<String, String>();
        HashMap<String, SeverityType> patchSeverity = new HashMap<String, SeverityType>();
        HashMap<String, Vector> patchNodes = new HashMap<String, Vector>();
        int k = 0;
        for (int i = 0; i < oraclePatchChecks.size(); ++i) {
            HashMap<String, Object> pc = oraclePatchChecks.get(i);
            String oraclePatch = (String)pc.get(CDMConstraintTypes.VALUE);
            home = (String)pc.get(CDMConstraintTypes.HOME);
            Vector nodes = (Vector)pc.get(CDMConstraintTypes.NODELIST);
            SeverityType severity = this.getSeverityAttributeValue((String)pc.get(CDMConstraintTypes.SEVERITY));
            if (oraclePatch == null) continue;
            oraclePatches.put(oraclePatch, home);
            patchSeverity.put(oraclePatch, severity);
            patchNodes.put(oraclePatch, nodes);
        }
        TaskOraclePatch[] topList = new TaskOraclePatch[oraclePatches.size()];
        for (String oraclePatch : oraclePatches.keySet()) {
            home = (String)oraclePatches.get(oraclePatch);
            SeverityType severity = (SeverityType)((Object)patchSeverity.get(oraclePatch));
            Vector nodeVector = (Vector)patchNodes.get(oraclePatch);
            String[] nodeList = nodeVector.toArray(new String[nodeVector.size()]);
            topList[k] = new TaskOraclePatch(vType, home, oraclePatch, true);
            topList[k].setNodeList(nodeList);
            topList[k].setSeverity(severity);
            ++k;
        }
        return topList;
    }

    private TaskKernelVersion createTaskKernelVersion(CDMOperatingSystem cdmOS) throws XmlParserException {
        HashMap kerAttrs = cdmOS.getKernelAttributes();
        String kver = (String)kerAttrs.get(CDMConstraintTypes.KERNEL_VER);
        String rim = (String)kerAttrs.get(CDMConstraintTypes.KERNEL_VER_RIM);
        if (kver == null) {
            return null;
        }
        TaskKernelVersion tkver = new TaskKernelVersion(kver);
        tkver.setNodeList(this.m_xmlNodeList);
        tkver.setRimValue(rim);
        return tkver;
    }

    private TaskContainerKernelParams createTaskContainerKernelParams(CDMOperatingSystem cdmOS) throws XmlParserException {
        HashMap<String, Object> propertiesHM = cdmOS.getKernelProperties();
        if (propertiesHM.size() == 0) {
            return null;
        }
        ArrayList<Task> tkpList = new ArrayList<Task>();
        SeverityType severity = null;
        for (String paramName : propertiesHM.keySet()) {
            Object paramCriteria = propertiesHM.get(paramName);
            List<String> applicableNodes = sTaskKernelParam.getApplicableNodes(paramName, this.m_xmlNodeList);
            if (applicableNodes.isEmpty()) {
                VerificationUtil.traceAndLog("Kernel parameter (" + paramName + ") is not applicable on any of the nodes in this environment. Skipping ....");
                continue;
            }
            Task taskObj = null;
            if (paramCriteria instanceof HashMap) {
                HashMap properties = (HashMap)paramCriteria;
                String name = (String)properties.get(CDMConstraintTypes.NAME);
                String value = (String)properties.get(CDMConstraintTypes.VALUE);
                String atleast = (String)properties.get(CDMConstraintTypes.ATLEAST);
                String atmost = (String)properties.get(CDMConstraintTypes.ATMOST);
                String gthan = (String)properties.get(CDMConstraintTypes.GREATER_THAN);
                String lthan = (String)properties.get(CDMConstraintTypes.LESS_THAN);
                String equalToValue = (String)properties.get(CDMConstraintTypes.EQUAL);
                severity = this.getSeverityAttributeValue((String)properties.get(CDMConstraintTypes.SEVERITY));
                if (value != null) {
                    taskObj = new TaskKernelParam(name, value);
                } else if (equalToValue != null) {
                    taskObj = new TaskKernelParam(name, equalToValue, true);
                } else {
                    RangeOfValue r = new RangeOfValue(RangeType.INTEGER);
                    try {
                        this.manipulateRange(r, value, atleast, atmost, gthan, lthan, false);
                    }
                    catch (InvalidRangeManipulationException e) {
                        throw new XmlParserException(e.getMessage(), e);
                    }
                    taskObj = new TaskKernelParam(name, r);
                }
                taskObj.setSeverity(severity);
            } else {
                List paramSteps = (List)paramCriteria;
                if (paramSteps == null) {
                    return null;
                }
                for (int i = 0; i < paramSteps.size(); ++i) {
                    HashMap kernelParamStepHM = (HashMap)paramSteps.get(i);
                    if (taskObj == null) {
                        taskObj = new TaskKernelParam(paramName);
                        severity = this.getSeverityAttributeValue((String)kernelParamStepHM.get(CDMConstraintTypes.SEVERITY));
                        taskObj.setSeverity(severity);
                    }
                    this.addTaskKernelPropertyStep(kernelParamStepHM, (TaskKernelParam)taskObj);
                }
                if (taskObj == null) {
                    Object[] msgParams = new String[]{CDMConstraintTypes.PROPERTY};
                    String msg = s_msgBundle.getMessage("1110", false, msgParams);
                    Trace.out((String)msg);
                    throw new XmlParserException(msg);
                }
            }
            taskObj.setNodeList(applicableNodes.toArray(new String[0]));
            tkpList.add(taskObj);
        }
        TaskContainerKernelParams tckp = new TaskContainerKernelParams(tkpList.toArray(new TaskKernelParam[0]));
        return tckp;
    }

    private void addTaskKernelPropertyStep(HashMap<String, String> kernelParamStepHM, TaskKernelParam tkp) throws XmlParserException {
        Float multipleF;
        String units = kernelParamStepHM.get(CDMConstraintTypes.UNIT);
        StorageUnit su = this.getStorageUnits(units);
        RangeOfValue r = new RangeOfValue(RangeType.STORAGE_SIZE);
        StorageSize valueSS = null;
        StorageSize atleastSS = null;
        StorageSize atmostSS = null;
        StorageSize gthanSS = null;
        StorageSize lthanSS = null;
        StorageSize minSS = null;
        StorageSize maxSS = null;
        String minValue = kernelParamStepHM.get(CDMConstraintTypes.MIN_VALUE);
        String minUnits = kernelParamStepHM.get(CDMConstraintTypes.MIN_UNIT);
        String maxValue = kernelParamStepHM.get(CDMConstraintTypes.MAX_VALUE);
        String maxUnits = kernelParamStepHM.get(CDMConstraintTypes.MAX_UNIT);
        String value = kernelParamStepHM.get(CDMConstraintTypes.VALUE);
        String atleast = kernelParamStepHM.get(CDMConstraintTypes.ATLEAST);
        String atmost = kernelParamStepHM.get(CDMConstraintTypes.ATMOST);
        String gthan = kernelParamStepHM.get(CDMConstraintTypes.GREATER_THAN);
        String lthan = kernelParamStepHM.get(CDMConstraintTypes.LESS_THAN);
        try {
            if (value != null) {
                valueSS = new StorageSize(Double.parseDouble(value), su);
            }
            if (atleast != null) {
                atleastSS = new StorageSize(Double.parseDouble(atleast), su);
            }
            if (atmost != null) {
                atmostSS = new StorageSize(Double.parseDouble(atmost), su);
            }
            if (gthan != null) {
                gthanSS = new StorageSize(Double.parseDouble(gthan), su);
            }
            if (lthan != null) {
                lthanSS = new StorageSize(Double.parseDouble(lthan), su);
            }
            if (minValue != null) {
                minSS = new StorageSize(Double.parseDouble(minValue), this.getStorageUnits(minUnits));
                tkp.setMinVal(minSS);
            }
            if (maxValue != null) {
                maxSS = new StorageSize(Double.parseDouble(maxValue), this.getStorageUnits(maxUnits));
                tkp.setMaxVal(maxSS);
            }
        }
        catch (NumberFormatException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        try {
            this.manipulateRange(r, valueSS, atleastSS, atmostSS, gthanSS, lthanSS, false);
        }
        catch (InvalidRangeManipulationException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        String multiple = kernelParamStepHM.get(CDMConstraintTypes.MULTIPLE);
        try {
            multipleF = Float.valueOf(Float.parseFloat(multiple));
        }
        catch (NumberFormatException nfe) {
            Object[] msgParams = new String[]{multiple, CDMConstraintTypes.MULTIPLE, CDMConstraintTypes.STEP};
            String msg = s_msgBundle.getMessage("1097", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg, nfe);
        }
        try {
            tkp.addStep(r, su, multipleF.floatValue());
        }
        catch (InvalidStepException ise) {
            throw new XmlParserException(ise.getMessage(), ise);
        }
    }

    private TaskContainerPackages createTaskContainerPackages(CDMOperatingSystem cdmOS) throws XmlParserException {
        List<HashMap<String, Object>> packageList = cdmOS.getPackages();
        if (packageList.size() == 0) {
            return null;
        }
        TaskPackage[] tpList = new TaskPackage[packageList.size()];
        int packageCounter = 0;
        for (HashMap<String, Object> pkgCriteria : packageList) {
            TaskPackage tp = null;
            String pkgName = (String)pkgCriteria.get(CDMConstraintTypes.NAME);
            String pkgArch = (String)pkgCriteria.get(CDMConstraintTypes.ARCHITECTURE);
            SeverityType severity = this.getSeverityAttributeValue((String)pkgCriteria.get(CDMConstraintTypes.SEVERITY));
            Object criteria = pkgCriteria.get(CDMConstraintTypes.VALUE);
            tp = criteria instanceof String ? new TaskPackage(pkgName, criteria.toString(), pkgArch) : new TaskPackage(pkgName, (RangeOfValue)criteria, pkgArch);
            tp.setSeverity(severity);
            tp.setNodeList(this.m_xmlNodeList);
            tpList[packageCounter++] = tp;
        }
        TaskContainerPackages tcPkgs = new TaskContainerPackages(tpList);
        return tcPkgs;
    }

    private StorageUnit getStorageUnits(String units) throws XmlParserException {
        if (units == null) {
            Object[] msgParams = new String[]{units};
            String msg = s_msgBundle.getMessage("1105", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (units.equals("B")) {
            return StorageUnit.BYTE;
        }
        if (units.equals("KB")) {
            return StorageUnit.KBYTE;
        }
        if (units.equals("MB")) {
            return StorageUnit.MBYTE;
        }
        if (units.equals("GB")) {
            return StorageUnit.GBYTE;
        }
        if (units.equals("TB")) {
            return StorageUnit.TBYTE;
        }
        Object[] msgParams = new String[]{units};
        String msg = s_msgBundle.getMessage("1105", false, msgParams);
        Trace.out((String)msg);
        throw new XmlParserException(msg);
    }

    private void manipulateRange(RangeOfValue r, Object value, Object atleast, Object atmost, Object gthan, Object lthan, boolean exclude) throws XmlParserException, InvalidRangeManipulationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("RangeOfValue = " + r + ", value = " + value + ", atleast = " + atleast + ", atmost = " + atmost + ", gthan = " + gthan + ", lthan = " + lthan + ", exclude = " + exclude));
        }
        if (value == null && atleast == null && atmost == null && gthan == null && lthan == null) {
            String msg = s_msgBundle.getMessage("1112", false);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (value != null && (atleast != null || atmost != null || gthan != null || lthan != null)) {
            String msg = s_msgBundle.getMessage("1113", false);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (value != null) {
            try {
                if (!exclude) {
                    r.include(RangeOperator.EQ, value);
                } else {
                    r.exclude(RangeOperator.EQ, value);
                }
                return;
            }
            catch (InvalidRangeManipulationException e) {
                new XmlParserException(e.getMessage(), e);
            }
        }
        if (atleast != null && gthan != null) {
            Object[] msgParams = new String[]{RangeOperator.GE.toString(), RangeOperator.GT.toString()};
            String msg = s_msgBundle.getMessage("1114", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (atmost != null && lthan != null) {
            Object[] msgParams = new String[]{RangeOperator.LE.toString(), RangeOperator.LT.toString()};
            String msg = s_msgBundle.getMessage("1114", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        RangeOperator firstRangeOp = null;
        Object firstRangeValue = null;
        RangeOperator secondRangeOp = null;
        Object secondRangeValue = null;
        if (atleast != null) {
            firstRangeOp = this.getRangeOperator(CDMConstraintTypes.ATLEAST);
            firstRangeValue = atleast;
        } else if (gthan != null) {
            firstRangeOp = this.getRangeOperator(CDMConstraintTypes.GREATER_THAN);
            firstRangeValue = gthan;
        }
        if (atmost != null) {
            if (firstRangeOp != null) {
                secondRangeOp = this.getRangeOperator(CDMConstraintTypes.ATMOST);
                secondRangeValue = atmost;
            } else {
                firstRangeOp = this.getRangeOperator(CDMConstraintTypes.ATMOST);
                firstRangeValue = atmost;
            }
        } else if (lthan != null) {
            if (firstRangeOp != null) {
                secondRangeOp = this.getRangeOperator(CDMConstraintTypes.LESS_THAN);
                secondRangeValue = lthan;
            } else {
                firstRangeOp = this.getRangeOperator(CDMConstraintTypes.LESS_THAN);
                firstRangeValue = lthan;
            }
        }
        if (!exclude) {
            if (secondRangeOp != null) {
                r.include(firstRangeOp, firstRangeValue, secondRangeOp, secondRangeValue);
            } else {
                r.include(firstRangeOp, firstRangeValue);
            }
        } else if (secondRangeOp != null) {
            r.exclude(firstRangeOp, firstRangeValue, secondRangeOp, secondRangeValue);
        } else {
            r.exclude(firstRangeOp, firstRangeValue);
        }
    }

    private void convertRangeValuesToBaseUnit(HashMap<String, String> rangeAttributes, long conversionFactor) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Enter convertRangeValuesToCanonical. rangeAttributes = " + rangeAttributes + ", conversionFactor = " + conversionFactor));
        }
        String value = rangeAttributes.get(CDMConstraintTypes.VALUE);
        String atleast = rangeAttributes.get(CDMConstraintTypes.ATLEAST);
        String atmost = rangeAttributes.get(CDMConstraintTypes.ATMOST);
        String gthan = rangeAttributes.get(CDMConstraintTypes.GREATER_THAN);
        String lthan = rangeAttributes.get(CDMConstraintTypes.LESS_THAN);
        if (value != null) {
            double convertedValue = Double.parseDouble(value) * (double)conversionFactor;
            rangeAttributes.put(CDMConstraintTypes.VALUE, Double.toString(convertedValue));
        }
        if (atleast != null) {
            double convertedAtleast = Double.parseDouble(atleast) * (double)conversionFactor;
            rangeAttributes.put(CDMConstraintTypes.ATLEAST, Double.toString(convertedAtleast));
        }
        if (atmost != null) {
            double convertedatmost = Double.parseDouble(atmost) * (double)conversionFactor;
            rangeAttributes.put(CDMConstraintTypes.ATMOST, Double.toString(convertedatmost));
        }
        if (gthan != null) {
            double convertedgthan = Double.parseDouble(gthan) * (double)conversionFactor;
            rangeAttributes.put(CDMConstraintTypes.GREATER_THAN, Double.toString(convertedgthan));
        }
        if (lthan != null) {
            double convertedlthan = Double.parseDouble(lthan) * (double)conversionFactor;
            rangeAttributes.put(CDMConstraintTypes.LESS_THAN, Double.toString(convertedlthan));
        }
    }

    private RangeOperator getRangeOperator(String op) throws XmlParserException {
        if (op == null) {
            Object[] msgParams = new String[]{"null"};
            String msg = s_msgBundle.getMessage("1107", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (op.equals(CDMConstraintTypes.VALUE)) {
            return RangeOperator.EQ;
        }
        if (op.equals(CDMConstraintTypes.ATLEAST)) {
            return RangeOperator.GE;
        }
        if (op.equals(CDMConstraintTypes.ATMOST)) {
            return RangeOperator.LE;
        }
        if (op.equals(CDMConstraintTypes.GREATER_THAN)) {
            return RangeOperator.GT;
        }
        if (op.equals(CDMConstraintTypes.LESS_THAN)) {
            return RangeOperator.LT;
        }
        Object[] msgParams = new String[]{op};
        String msg = s_msgBundle.getMessage("1107", false, msgParams);
        Trace.out((String)msg);
        throw new XmlParserException(msg);
    }

    private SeverityType getSeverityAttributeValue(String severityStr) throws XmlParserException {
        SeverityType severity = SeverityType.CRITICAL;
        if (SeverityType.FATAL.name().equalsIgnoreCase(severityStr)) {
            severity = SeverityType.FATAL;
        } else if (SeverityType.IGNORABLE.name().equalsIgnoreCase(severityStr)) {
            severity = SeverityType.IGNORABLE;
        }
        return severity;
    }
}

