/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TCPConCommand
extends VerificationCommand {
    private static MessageBundle m_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private CmdMode m_cmdMode;
    private String m_locIP = null;
    private int m_port = -1;
    private int m_pid = -1;
    List<String> m_tcpServers = new ArrayList<String>();
    private Map<String, Result> m_mapTCPConStatus = null;

    TCPConCommand(String node, String[] args, CmdMode cmdMode) {
        super(node, args, null);
        this.m_cmdMode = cmdMode;
        if (this.m_cmdMode == CmdMode.CLIENT) {
            this.m_mapTCPConStatus = new HashMap<String, Result>();
        }
    }

    public static TCPConCommand getTCPServerCommand(String node, String ip) {
        String[] args = new String[]{"-runTCPserverEx", ip};
        return new TCPConCommand(node, args, CmdMode.SERVER);
    }

    public static TCPConCommand getTCPClientCommand(String node, String ip, String[] tcpServs) {
        Trace.out((String)("Creating -chkTCPclientEx command with node " + node + ". client ip = " + ip));
        String[] args = new String[tcpServs.length + 2];
        args[0] = "-chkTCPclientEx";
        args[1] = ip;
        for (int i = 0; i < tcpServs.length; ++i) {
            Trace.out((String)("tcpServs[" + i + "]=" + tcpServs[i]));
            args[2 + i] = tcpServs[i];
        }
        return new TCPConCommand(node, args, CmdMode.CLIENT);
    }

    public void setTCPServersStatus(String node, String[] tcpServers) {
        for (String serverIp : tcpServers) {
            Result result = new Result(node);
            result.setStatus(1);
            this.setTCPConnectivityStatus(serverIp, result);
        }
    }

    @Override
    public boolean execute() {
        super.execute();
        if (this.m_cmdMode == CmdMode.SERVER) {
            this.parseTCPServerOutput();
        } else {
            this.parseTCPClientOutput();
        }
        return true;
    }

    private void parseTCPServerOutput() {
        String output = this.getOutput();
        if (output == null || output.length() == 0) {
            return;
        }
        String[] t1 = output.split(",");
        if (this.getVfyCode() == 0) {
            for (int i = 0; i < t1.length; ++i) {
                String[] t2 = t1[i].split("=");
                if (t2.length != 2) {
                    Trace.out((String)("could not parse " + t1[i]));
                    continue;
                }
                if (t2[0].trim().equalsIgnoreCase("PID")) {
                    this.m_pid = Integer.parseInt(t2[1].trim());
                    continue;
                }
                if (t2[0].trim().equalsIgnoreCase("PORT")) {
                    this.m_port = Integer.parseInt(t2[1].trim());
                    continue;
                }
                Trace.out((String)(t1[i] + " does not contain PORT or PID"));
            }
        } else {
            String errno = null;
            String syscal = null;
            String errmsg = null;
            for (int i = 0; i < t1.length; ++i) {
                String[] t2 = t1[i].split("=");
                if (t2.length != 2) {
                    Trace.out((String)("could not parse " + t1[i]));
                    continue;
                }
                if (t2[0].trim().equalsIgnoreCase("ERRNO")) {
                    errno = t2[1].trim();
                    continue;
                }
                if (t2[0].trim().equalsIgnoreCase("SYSCAL")) {
                    syscal = t2[1].trim();
                    continue;
                }
                if (t2[0].trim().equalsIgnoreCase("ERRMSG")) {
                    errmsg = t2[1].trim();
                    continue;
                }
                Trace.out((String)(t1[i] + " does not contain ERRNO, SYSCAL or ERRMSG"));
            }
            String nlsErrMsg = m_gMsgBundle.getMessage("11850", true, (Object[])new String[]{syscal, errno, this.getNodeName()});
            nlsErrMsg = nlsErrMsg + LSEP + errmsg;
            this.m_result.addErrorDescription(new ErrorDescription(nlsErrMsg));
            this.m_result.setStatus(2);
        }
    }

    private void parseTCPClientOutput() {
        String[] conStatus;
        for (String cs : conStatus = VerificationUtil.fetchTextByTagsRepeat(this.commandResult.getResultString()[0], "<CV_VAL>", "</CV_VAL>")) {
            Trace.out((String)("parsing \"" + cs + "\"..."));
            String srvIp = null;
            boolean bConnected = false;
            boolean bError = false;
            String errno = null;
            String syscal = null;
            String errmsg = null;
            String[] t1 = cs.split(",");
            for (int i = 0; i < t1.length; ++i) {
                String[] t2 = t1[i].split("=");
                if (t2.length != 2) {
                    Trace.out((String)("could not parse " + t1[i]));
                    continue;
                }
                String nm = t2[0].trim();
                String val = t2[1].trim();
                if (nm.equalsIgnoreCase("IP")) {
                    srvIp = val;
                    continue;
                }
                if (nm.equalsIgnoreCase("CS")) {
                    bConnected = Boolean.parseBoolean(val);
                    continue;
                }
                if (nm.equalsIgnoreCase("ERR")) {
                    bError = Boolean.parseBoolean(val);
                    continue;
                }
                if (nm.equalsIgnoreCase("ERRNO")) {
                    errno = val;
                    continue;
                }
                if (nm.equalsIgnoreCase("SYSCAL")) {
                    syscal = val;
                    continue;
                }
                if (nm.equalsIgnoreCase("ERRMSG")) {
                    errmsg = val;
                    continue;
                }
                Trace.out((String)("could not parse " + t1[i]));
            }
            if (srvIp == null) {
                Trace.out((String)("srvIp does not exists in " + cs));
                continue;
            }
            Result connectivityResult = new Result(this.getNodeName());
            if (bConnected) {
                connectivityResult.setStatus(1);
            } else {
                Trace.out((String)("connectivity to the server " + srvIp + " failed"));
                String nlsErrMsg = m_gMsgBundle.getMessage("11095", true, (Object[])new String[]{syscal, errno, this.getNodeName()});
                nlsErrMsg = nlsErrMsg + LSEP + errmsg;
                connectivityResult.addErrorDescription(new ErrorDescription(nlsErrMsg));
                connectivityResult.setStatus(3);
            }
            this.setTCPConnectivityStatus(srvIp, connectivityResult);
        }
    }

    public int getPid() {
        return this.m_pid;
    }

    public int getPort() {
        return this.m_port;
    }

    public Result getTCPServerResult() {
        return this.m_result;
    }

    public Result getTCPConnectStatus(String srvIp) {
        return this.m_mapTCPConStatus.get(srvIp);
    }

    private void setTCPConnectivityStatus(String serverIp, Result result) {
        this.m_mapTCPConStatus.put(serverIp, result);
    }

    public String getLocIp() {
        return this.m_locIP;
    }

    private static enum CmdMode {
        SERVER,
        CLIENT;

    }
}

