/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.asm;

public class ASMConnectInfo {
    private static ASMConnectInfo m_asmConnectInfo = null;
    private static final String protocolBEQ = "protocol=beq";
    private String m_connectDescriptor = null;
    private boolean m_isBeq;
    private String m_userName = null;
    private String m_userPassword = null;

    public ASMConnectInfo(String connectDescriptor) {
        this.m_connectDescriptor = connectDescriptor;
        this.m_isBeq = connectDescriptor.toLowerCase().contains(protocolBEQ);
    }

    public ASMConnectInfo(String connectDescriptor, String userName, String password) {
        this.m_connectDescriptor = connectDescriptor;
        this.m_isBeq = connectDescriptor.toLowerCase().contains(protocolBEQ);
        this.m_userName = userName;
        this.m_userPassword = password;
    }

    public String getConnectDescriptor() {
        return this.m_connectDescriptor;
    }

    public boolean isBEQProtocol() {
        return this.m_isBeq;
    }

    public final String getUserName() {
        return this.m_userName;
    }

    public final String getUserPassword() {
        return this.m_userPassword;
    }

    public static ASMConnectInfo getASMConnectInfo() {
        return m_asmConnectInfo;
    }

    public static void setASMConnectInfo(ASMConnectInfo asmConnectInfo) {
        m_asmConnectInfo = asmConnectInfo;
    }
}

