/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification;

import oracle.cluster.verification.ParamPreReq;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ParamPreReqDBInst
implements ParamPreReq {
    private GlobalVerificationContext m_globalVerificationCtx = GlobalVerificationContext.getInstance();

    public void setASMCheck(boolean asmCheck) {
        CVUVariables.setValue(CVUVariableConstants.ASM_DEVICE_CHECKS_FLAG, Boolean.toString(asmCheck));
    }

    public void setUSMCheck(boolean usmCheck) {
        CVUVariables.setValue(CVUVariableConstants.USM_DEVICE_CHECKS_FLAG, Boolean.toString(usmCheck));
    }

    public boolean getUSMCheck() {
        String usmChecks = CVUVariables.getValue(CVUVariableConstants.USM_DEVICE_CHECKS_FLAG);
        return VerificationUtil.isStringGood(usmChecks) && usmChecks.equalsIgnoreCase("true");
    }

    public boolean getASMCheck() {
        String asmDeviceChecks = CVUVariables.getValue(CVUVariableConstants.ASM_DEVICE_CHECKS_FLAG);
        return VerificationUtil.isStringGood(asmDeviceChecks) && asmDeviceChecks.equalsIgnoreCase("true");
    }

    public void setASMDGList(String[] asmdglist) {
        this.m_globalVerificationCtx.setASMDiskGroups(asmdglist);
    }

    public String[] getASMDGList() {
        return this.m_globalVerificationCtx.getASMDiskGroups();
    }

    public void setRelease(String release) {
        if (release != null && release.trim().length() > 0) {
            Trace.out((String)("setting release as : " + release));
            CVUVariables.setValue(CVUVariableConstants.RELEASE, release);
        }
    }

    public void setOSDBAgroup(String group) {
        CVUVariables.setValue(CVUVariableConstants.DBA_GROUP, group);
    }

    public void setOSOPERgroup(String group) {
        CVUVariables.setValue(CVUVariableConstants.OPER_GROUP, group);
    }

    public void setASMAdminGroup(String group) {
        CVUVariables.setValue(CVUVariableConstants.ASM_GROUP, group);
    }

    public void setOSDBAForASMGroup(String group) {
        CVUVariables.setValue(CVUVariableConstants.DBA_ASM_GROUP, group);
    }

    public void setOSBACKUPgroup(String group) {
        CVUVariables.setValue(CVUVariableConstants.BACKUPDBA_GROUP, group);
    }

    public void setOSDGgroup(String group) {
        CVUVariables.setValue(CVUVariableConstants.DGDBA_GROUP, group);
    }

    public void setOSKMgroup(String group) {
        CVUVariables.setValue(CVUVariableConstants.KMDBA_GROUP, group);
    }

    public void setOSRACDBAgroup(String group) {
        CVUVariables.setValue(CVUVariableConstants.RACDBA_GROUP, group);
    }

    public void setOrclHome(String orclHome) {
        CVUVariables.setValue(CVUVariableConstants.ORACLE_HOME, orclHome);
        CVUVariables.setValue(CVUVariableConstants.RAC_HOME, orclHome);
    }

    public void setOrclHomeOnOCFS(boolean orclHomeOnOCFS) {
        CVUVariables.setValue(CVUVariableConstants.ORACLE_HOME_ON_OCFS, Boolean.toString(orclHomeOnOCFS));
    }

    public String getRelease() {
        String release = CVUVariables.getValue(CVUVariableConstants.RELEASE);
        Trace.out((String)("Returning release as : " + release));
        return release;
    }

    public String getOSDBAgroup() {
        return CVUVariables.getValue(CVUVariableConstants.DBA_GROUP);
    }

    public String getOSOPERgroup() {
        return CVUVariables.getValue(CVUVariableConstants.OPER_GROUP);
    }

    public String getASMAdminGroup() {
        return CVUVariables.getValue(CVUVariableConstants.ASM_GROUP);
    }

    public String getOSDBAForASMGroup(String group) {
        return CVUVariables.getValue(CVUVariableConstants.DBA_ASM_GROUP);
    }

    public String getOSBACKUPgroup() {
        return CVUVariables.getValue(CVUVariableConstants.BACKUPDBA_GROUP);
    }

    public String getOSDGgroup() {
        return CVUVariables.getValue(CVUVariableConstants.DGDBA_GROUP);
    }

    public String getOSKMgroup() {
        return CVUVariables.getValue(CVUVariableConstants.KMDBA_GROUP);
    }

    public String getOSRACDBAgroup() {
        return CVUVariables.getValue(CVUVariableConstants.RACDBA_GROUP);
    }

    public String getOrclHome() {
        return CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
    }

    public boolean orclHomeOnOCFS() {
        String orclHomeOnOCFS = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME_ON_OCFS);
        return VerificationUtil.isStringGood(orclHomeOnOCFS) && orclHomeOnOCFS.equalsIgnoreCase("true");
    }

    public String getOraInv() {
        return CVUVariables.getValue(CVUVariableConstants.INSTALL_GROUP);
    }

    public void setOraInv(String oraInv) {
        CVUVariables.setValue(CVUVariableConstants.INSTALL_GROUP, oraInv);
    }

    public void setCRSHome(String crsHome) {
        CVUVariables.setValue(CVUVariableConstants.CRS_HOME, crsHome);
    }

    public String getCRSHome() {
        return CVUVariables.getValue(CVUVariableConstants.CRS_HOME);
    }

    public void setHAHome(String haHome) {
        CVUVariables.setValue(CVUVariableConstants.HA_HOME, haHome);
    }

    public String getHAHome() {
        return CVUVariables.getValue(CVUVariableConstants.HA_HOME);
    }

    public void setOracleBase(String oracleBase) {
        CVUVariables.setValue(CVUVariableConstants.ORACLE_BASE, oracleBase);
    }

    public String getOracleBase() {
        return CVUVariables.getValue(CVUVariableConstants.ORACLE_BASE);
    }
}

