/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification;

import java.util.List;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.ClusterwareUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ParamPreReqCRSInst
implements ParamPreReq {
    private GlobalVerificationContext m_globalVerificationCtx = GlobalVerificationContext.getInstance();

    public void setRelease(String release) {
        if (release != null && release.trim().length() > 0) {
            Trace.out((String)("setting release as : " + release));
            CVUVariables.setValue(CVUVariableConstants.RELEASE, release);
        }
    }

    public void setOCRLoc(String[] path) {
        if (path != null) {
            CVUVariables.setValue(CVUVariableConstants.OCR_LOCATIONS, VerificationUtil.strArr2List(path));
        }
    }

    public void setVotingLoc(String[] path) {
        if (path != null) {
            CVUVariables.setValue(CVUVariableConstants.VOTING_LOCATIONS, VerificationUtil.strArr2List(path));
        }
    }

    public void setORAINVgroup(String group) {
        CVUVariables.setValue(CVUVariableConstants.INSTALL_GROUP, group);
    }

    public void setASMADMINgroup(String group) {
        CVUVariables.setValue(CVUVariableConstants.ASM_GROUP, group);
    }

    public String getRelease() {
        String release = CVUVariables.getValue(CVUVariableConstants.RELEASE);
        Trace.out((String)("Returning release as : " + release));
        return release;
    }

    public List<String> getOCRLoc() {
        try {
            return ClusterwareUtil.getOCRLocations();
        }
        catch (VerificationException e) {
            Trace.out((String)"Failed to retrieve the ocr locations");
            Trace.out((Exception)e);
            return null;
        }
    }

    public List<String> getVotingLoc() {
        try {
            return ClusterwareUtil.getVoteDiskLocations();
        }
        catch (ClusterInfoException e) {
            Trace.out((String)"Failed to retrieve the vote disk locations");
            Trace.out((Exception)((Object)e));
            return null;
        }
    }

    public String getORAINVgroup() {
        return CVUVariables.getValue(CVUVariableConstants.INSTALL_GROUP);
    }

    public String getASMADMINgroup() {
        return CVUVariables.getValue(CVUVariableConstants.ASM_GROUP);
    }

    public void setOSDBAgroup(String group) {
        CVUVariables.setValue(CVUVariableConstants.DBA_GROUP, group);
    }

    public String getOSDBAgroup() {
        return CVUVariables.getValue(CVUVariableConstants.DBA_GROUP);
    }

    public void setASMOPERgroup(String group) {
        CVUVariables.setValue(CVUVariableConstants.ASM_OPER_GROUP, group);
    }

    public String getASMOPERgroup() {
        return CVUVariables.getValue(CVUVariableConstants.ASM_OPER_GROUP);
    }

    public void setCRSHome(String crsHome) {
        CVUVariables.setValue(CVUVariableConstants.CRS_HOME, crsHome);
    }

    public String getCRSHome() {
        return CVUVariables.getValue(CVUVariableConstants.CRS_HOME);
    }

    public void setASMDevice(String[] asmDev) {
        this.m_globalVerificationCtx.setASMDevices(asmDev);
    }

    public String[] getASMDevice() {
        return this.m_globalVerificationCtx.getASMdevices();
    }

    public void setASMCheck(boolean asmCheck) {
        CVUVariables.setValue(CVUVariableConstants.ASM_DEVICE_CHECKS_FLAG, Boolean.toString(asmCheck));
    }

    public boolean getASMCheck() {
        String asmDeviceChecks = CVUVariables.getValue(CVUVariableConstants.ASM_DEVICE_CHECKS_FLAG);
        return VerificationUtil.isStringGood(asmDeviceChecks) && asmDeviceChecks.equalsIgnoreCase("true");
    }

    public void setOracleBase(String oracleBase) {
        CVUVariables.setValue(CVUVariableConstants.ORACLE_BASE, oracleBase);
    }

    public String getOracleBase() {
        return CVUVariables.getValue(CVUVariableConstants.ORACLE_BASE);
    }
}

