/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.verification;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.verification.FixupResult;
import oracle.cluster.verification.FixupStatus;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;

public class FixupResultImpl
implements FixupResult {
    private String m_node = null;
    private FixupStatus m_status = FixupStatus.UNKNOWN;
    private List<VerificationError> m_errorList = null;

    public FixupResultImpl(String node) {
        this.m_node = node;
        this.m_errorList = new ArrayList<VerificationError>();
    }

    @Override
    public FixupStatus getStatus() {
        return this.m_status;
    }

    @Override
    public List<VerificationError> getErrors() {
        return this.m_errorList;
    }

    public void setStatus(FixupStatus status) {
        if (status == FixupStatus.UNKNOWN) {
            return;
        }
        if (this.m_status == FixupStatus.SUCCESSFUL || this.m_status == FixupStatus.WARNING || this.m_status == FixupStatus.UNKNOWN) {
            if (this.m_status == FixupStatus.WARNING && status == FixupStatus.SUCCESSFUL) {
                return;
            }
            this.m_status = status;
        }
    }

    @Override
    public String getNode() {
        return this.m_node;
    }

    public void addErrorDescription(ErrorDescription errorDesc) {
        this.m_errorList.add(errorDesc);
    }

    public void addErrorDescription(List<VerificationError> errorDescList) {
        this.m_errorList.addAll(errorDescList);
    }

    public void updateResult(FixupResult result) {
        Trace.out((int)1, (String)("<==Before Upload ==>" + this.traceFixupResultInfo()));
        if (!result.getNode().equals(this.m_node)) {
            return;
        }
        this.setStatus(result.getStatus());
        if (result.getErrors().size() > 0) {
            this.addErrorDescription(result.getErrors());
        }
        Trace.out((int)1, (String)("<==After Upload ==>" + this.traceFixupResultInfo()));
    }

    public void updateResult(Result result) {
        Trace.out((int)1, (String)("<==Before Upload ==>" + this.traceFixupResultInfo()));
        Trace.out((int)1, (String)("<==Source Result ==>" + result.traceResultInfo()));
        if (!result.getNode().equals(this.m_node)) {
            return;
        }
        FixupStatus toUpdateStatus = FixupStatus.UNKNOWN;
        toUpdateStatus = result.getStatus() == 5 || result.getStatus() == 6 ? FixupStatus.UNKNOWN : (result.getStatus() == 2 ? FixupStatus.ERROR : (result.getStatus() == 3 ? FixupStatus.FAILED : (result.getStatus() == 4 ? FixupStatus.WARNING : FixupStatus.SUCCESSFUL)));
        this.setStatus(toUpdateStatus);
        if (result.getErrors().size() > 0) {
            this.addErrorDescription(result.getErrors());
        }
        Trace.out((int)1, (String)("<==After Upload ==>" + this.traceFixupResultInfo()));
    }

    public String traceFixupResultInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\nDumping FixupResult data.\n");
        buffer.append("  Status     : " + this.m_status.toString() + "\n");
        buffer.append("  Node       : " + this.m_node + "\n");
        if (this.m_errorList.size() > 0) {
            buffer.append("Node Error :");
        }
        for (VerificationError error : this.m_errorList) {
            buffer.append(error.getErrorMessage() + "\n");
        }
        return buffer.toString();
    }
}

