/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.cluster;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.common.ManageableEntityImpl;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.PortException;
import oracle.eons.BridgeFilter;
import oracle.eons.LogicalAddress;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.supercluster.common.CommonFactory;
import oracle.supercluster.common.SCDiscoveryMethod;
import oracle.supercluster.common.SCDiscoveryServer;
import oracle.supercluster.common.SCRepresentative;
import oracle.supercluster.common.SCTier;
import oracle.supercluster.common.SCTierException;
import oracle.supercluster.impl.cluster.ClusterFactoryImpl;
import oracle.supercluster.impl.cluster.GossipServerResourceImpl;
import oracle.supercluster.resources.SclcMsgID;
import oracle.supercluster.resources.SclsMsgID;

public class SCTierImpl
extends ManageableEntityImpl
implements SCTier {
    private CRSResourceImpl m_crsResource;
    private boolean m_isClusterTier;

    SCTierImpl(CRSResourceImpl crsResource, boolean isClusterTier) throws SCTierException {
        this.m_crsResource = crsResource;
        this.m_isClusterTier = isClusterTier;
        try {
            this.m_name = this.m_crsResource.getName();
            this.m_displayName = this.m_isClusterTier ? (Cluster.isCluster() ? new ClusterUtil().getClusterName() : InetAddress.getLocalHost().getHostName()) : this.m_crsResource.getAttribute(ResourceType.SuperCluster.TIER_NAME.name()).getValue();
        }
        catch (ClusterUtilException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TIER_NAME_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName()}), (Throwable)e);
        }
        catch (CRSException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TIER_NAME_FAILED, (boolean)true, (Object[])new Object[]{ResourceType.SuperCluster.TIER_NAME.toString(), e}));
        }
        catch (UnknownHostException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_ADDR_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName()}), (Throwable)e);
        }
    }

    public String getTierName() throws SCTierException {
        try {
            if (this.m_isClusterTier) {
                if (Cluster.isCluster()) {
                    return new ClusterUtil().getClusterName();
                }
                return InetAddress.getLocalHost().getHostName();
            }
            return this.m_crsResource.getAttribute(ResourceType.SuperCluster.TIER_NAME.name()).getValue().trim();
        }
        catch (ClusterUtilException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TIER_NAME_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName()}), (Throwable)e);
        }
        catch (CRSException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TIER_NAME_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName()}), (Throwable)e);
        }
        catch (UnknownHostException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_ADDR_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName()}), (Throwable)e);
        }
    }

    public SCDiscoveryMethod discoveryMethod() throws SCTierException {
        String attrName = this.m_isClusterTier ? ResourceType.EONS.DISCOVERY_METHOD.name() : ResourceType.SuperCluster.DISCOVERY_METHOD.name();
        String attrValue = ResourceType.getAgentGenEnv((String)attrName);
        if (attrValue == null) {
            try {
                attrValue = this.m_crsResource.getAttribute(attrName).getValue().trim();
            }
            catch (CRSException e) {
                throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_DISC_METHOD_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName()}));
            }
        }
        return SCDiscoveryMethod.getEnumMember((String)attrValue);
    }

    public InetAddress getMulticastAddress() throws SCTierException {
        String mcastAddr = null;
        try {
            SCDiscoveryMethod discMethod = this.discoveryMethod();
            if (!discMethod.name().equals(SCDiscoveryMethod.MULTICAST.name())) {
                throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.NOT_MCAST_DISC_METHOD, (boolean)true, (Object[])new Object[]{this.getUserAssignedName(), discMethod.toString()}));
            }
            String attrName = this.m_isClusterTier ? ResourceType.EONS.MCAST_ADDRESS.name() : ResourceType.SuperCluster.MCAST_ADDRESS.name();
            mcastAddr = ResourceType.getAgentGenEnv((String)attrName);
            if (mcastAddr == null) {
                try {
                    mcastAddr = this.m_crsResource.getAttribute(attrName).getValue().trim();
                }
                catch (CRSException e) {
                    throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_MCAST_ADDR_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName(), mcastAddr}), (Throwable)e);
                }
            }
            Trace.out((String)("mcastAddr=" + mcastAddr));
            return ClusterFactoryImpl.getMulticastAddress(mcastAddr);
        }
        catch (UnknownHostException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_MCAST_ADDR_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName(), mcastAddr}), (Throwable)e);
        }
    }

    public int getMulticastPort() throws SCTierException {
        String mcastAddr = null;
        try {
            SCDiscoveryMethod discMethod = this.discoveryMethod();
            if (!discMethod.name().equals(SCDiscoveryMethod.MULTICAST.name())) {
                throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.NOT_MCAST_DISC_METHOD, (boolean)true, (Object[])new Object[]{this.getUserAssignedName(), discMethod.toString()}));
            }
            String attrName = this.m_isClusterTier ? ResourceType.EONS.MCAST_ADDRESS.name() : ResourceType.SuperCluster.MCAST_ADDRESS.name();
            mcastAddr = ResourceType.getAgentGenEnv((String)attrName);
            if (mcastAddr == null) {
                try {
                    mcastAddr = this.m_crsResource.getAttribute(attrName).getValue().trim();
                }
                catch (CRSException e) {
                    throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_MCAST_ADDR_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName(), mcastAddr}), (Throwable)e);
                }
            }
            return ClusterFactoryImpl.getMulticastPort(mcastAddr);
        }
        catch (PortException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_MCAST_ADDR_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName(), mcastAddr}), (Throwable)e);
        }
    }

    public List<SCDiscoveryServer> discoveryServers() throws SCTierException {
        try {
            SCDiscoveryMethod discMethod = this.discoveryMethod();
            if (!discMethod.name().equals(SCDiscoveryMethod.GOSSIP_SERVERS.name())) {
                throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.NOT_GOSSIPSERVER_DISC_METHOD, (boolean)true, (Object[])new Object[]{this.getUserAssignedName(), discMethod.toString()}));
            }
            ArrayList<SCDiscoveryServer> list = new ArrayList<SCDiscoveryServer>(1);
            list.add(ClusterFactoryImpl.getInstance().getGossipServerResource().discoveryServer());
            return list;
        }
        catch (SoftwareModuleException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (boolean)true, (Object[])new Object[]{GossipServerResourceImpl.getResourceName()}), (Throwable)e);
        }
        catch (NotExistsException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (boolean)true, (Object[])new Object[]{GossipServerResourceImpl.getResourceName()}), (Throwable)e);
        }
    }

    public Map<String, Integer> memberList() throws SCTierException {
        try {
            SCDiscoveryMethod discMethod = this.discoveryMethod();
            if (discMethod.name().equals(SCDiscoveryMethod.LIST.name())) {
                String attrName = this.m_isClusterTier ? ResourceType.EONS.MEMBER_LIST.name() : ResourceType.SuperCluster.MEMBER_LIST.name();
                String attrValue = ResourceType.getAgentGenEnv((String)attrName);
                if (attrValue == null) {
                    attrValue = this.m_crsResource.getAttribute(attrName).getValue().trim();
                }
                return ClusterFactoryImpl.getMemberList(attrValue);
            }
            if (discMethod.name().equals(SCDiscoveryMethod.MULTICAST.name())) {
                SCRepresentative scRep = CommonFactory.getInstance().getSCRepresentative();
                if (scRep != null) {
                    List mbrAddrList = scRep.memberList((SCTier)this);
                    HashMap<String, Integer> mbrList = new HashMap<String, Integer>(mbrAddrList.size());
                    Integer mcastPort = this.getMulticastPort();
                    for (LogicalAddress mbr : mbrAddrList) {
                        mbrList.put(mbr.getHostName(), mcastPort);
                    }
                    return mbrList;
                }
                throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_SCREP_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName(), scRep}));
            }
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_MBRS_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName(), "NOT IMPLEMENTED YET"}));
        }
        catch (CRSException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_MBRS_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName()}), (Throwable)e);
        }
        catch (SoftwareModuleException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_MBRS_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName()}), (Throwable)e);
        }
    }

    public boolean isClusterTier() throws SCTierException {
        return this.m_isClusterTier;
    }

    public List<BridgeFilter> getFilters(BridgeFilter.FILTERLOCATION location) throws SCTierException {
        throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_FILTERS_FAILED, (boolean)true, (Object[])new Object[]{location.toString(), this.getUserAssignedName(), "NOT IMPLEMENTED YET"}));
    }

    public void insertFilters(BridgeFilter.FILTERLOCATION location, List<BridgeFilter> filters) throws SCTierException {
        StringBuilder sb = new StringBuilder();
        for (BridgeFilter filter : filters) {
            if (sb.length() > 0) {
                sb.append("," + filter.toString());
                continue;
            }
            sb.append(filter.toString());
        }
        throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.SET_FILTERS_FAILED, (boolean)true, (Object[])new Object[]{sb.toString(), location.toString(), this.getUserAssignedName(), "NOT IMPLEMENTED"}));
    }

    public int port() throws SCTierException {
        try {
            String node;
            List attrList;
            String attrName = this.m_isClusterTier ? ResourceType.EONS.PORT.name() : ResourceType.SuperCluster.PORT.name();
            String port = ResourceType.getAgentGenEnv((String)attrName);
            Trace.out((String)("port=" + port));
            if (port != null) {
                return Integer.parseInt(port);
            }
            Trace.out((String)"port value not found in the environment");
            if (Cluster.isCluster() && (attrList = this.m_crsResource.getCurrentAttributes(node = Cluster.getLocalNode(), new String[]{attrName})).size() == 1) {
                return Integer.parseInt(((ResourceAttribute)attrList.get(0)).getValue());
            }
            return Integer.parseInt(this.m_crsResource.getAttribute(attrName).getValue());
        }
        catch (ClusterException e) {
            Trace.out((Exception)((Object)e));
            throw new SCTierException(MessageBundle.getMessage((MessageKey)PrCnMsgID.GET_PORT_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName()}), (Throwable)e);
        }
        catch (CRSException e) {
            Trace.out((Exception)((Object)e));
            throw new SCTierException(MessageBundle.getMessage((MessageKey)PrCnMsgID.GET_PORT_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName()}), (Throwable)e);
        }
        catch (NumberFormatException e) {
            Trace.out((Exception)e);
            throw new SCTierException(MessageBundle.getMessage((MessageKey)PrCnMsgID.GET_PORT_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName()}), (Throwable)e);
        }
    }

    public Map<String, String> properties() throws SCTierException {
        HashMap<String, String> envMap = new HashMap<String, String>();
        String attrName = this.m_isClusterTier ? ResourceType.EONS.PROPERTIES.name() : ResourceType.SuperCluster.PROPERTIES.name();
        String attrValue = ResourceType.getAgentGenEnv((String)attrName);
        if (attrValue == null) {
            try {
                attrValue = this.m_crsResource.getAttribute(attrName).getValue().trim();
            }
            catch (CRSException e) {
                throw new SCTierException(MessageBundle.getMessage((MessageKey)PrCnMsgID.GET_PROPS_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName()}), (Throwable)e);
            }
        }
        Matcher matcher = CRSFactoryImpl.getEnvPattern().matcher(attrValue);
        while (matcher.find()) {
            String[] nvPairs = matcher.group(0).split("=");
            if (nvPairs.length == 2) {
                envMap.put(nvPairs[0].trim(), nvPairs[1].trim());
                continue;
            }
            throw new SCTierException(MessageBundle.getMessage((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, (boolean)true, (Object[])new Object[]{attrName, attrValue, matcher.group(0)}));
        }
        return envMap;
    }

    public void setProperties(Map<String, String> props) throws SCTierException {
        StringBuilder sb = new StringBuilder();
        try {
            String attrName = this.m_isClusterTier ? ResourceType.EONS.PROPERTIES.name() : ResourceType.SuperCluster.PROPERTIES.name();
            for (String key : props.keySet()) {
                if (sb.length() > 0) {
                    sb.append(" " + key.trim() + "=" + props.get(key).trim());
                    continue;
                }
                sb.append(key.trim() + "=" + props.get(key).trim());
            }
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(attrName, sb.toString()));
        }
        catch (CRSException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)PrCnMsgID.SET_PROPS_FAILED, (boolean)true, (Object[])new Object[]{sb.toString(), this.getUserAssignedName()}), (Throwable)e);
        }
    }

    public void setMulticastAddress(InetAddress mcastAddress) throws SCTierException {
        if (mcastAddress == null) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.ILLEGAL_ARG, (boolean)true, (Object[])new Object[]{"mcastAddress", mcastAddress}));
        }
        if (!mcastAddress.isMulticastAddress()) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.NOT_MCAST_ADDRESS, (boolean)true, (Object[])new Object[]{mcastAddress.getHostAddress()}));
        }
        SCDiscoveryMethod discMethod = this.discoveryMethod();
        if (!discMethod.name().equals(SCDiscoveryMethod.MULTICAST.name())) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.NOT_MCAST_DISC_METHOD, (boolean)true, (Object[])new Object[]{this.getUserAssignedName(), discMethod.toString()}));
        }
        try {
            int mcastPort = this.getMulticastPort();
            String attrName = this.m_isClusterTier ? ResourceType.EONS.MCAST_ADDRESS.name() : ResourceType.SuperCluster.MCAST_ADDRESS.name();
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(attrName, ClusterFactoryImpl.getMulticastAddress(mcastAddress, String.valueOf(mcastPort))));
        }
        catch (CRSException ce) {
            throw new SCTierException(ce.getMessage());
        }
    }

    public void setMulticastPort(String mcastPort) throws SCTierException {
        SCDiscoveryMethod discMethod = this.discoveryMethod();
        if (!discMethod.name().equals(SCDiscoveryMethod.MULTICAST.name())) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.NOT_MCAST_DISC_METHOD, (boolean)true, (Object[])new Object[]{this.getUserAssignedName(), discMethod.toString()}));
        }
        try {
            InetAddress mcastAddress = this.getMulticastAddress();
            String attrName = this.m_isClusterTier ? ResourceType.EONS.MCAST_ADDRESS.name() : ResourceType.SuperCluster.MCAST_ADDRESS.name();
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(attrName, ClusterFactoryImpl.getMulticastAddress(mcastAddress, mcastPort)));
        }
        catch (CRSException ce) {
            throw new SCTierException(ce.getMessage());
        }
    }

    public void setListenPort(String localPort) throws SCTierException {
        if (localPort == null) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, (boolean)true, (Object[])new Object[]{"localPort", localPort}));
        }
        try {
            int portInt = Integer.parseInt(localPort);
            if (portInt < 1024 || portInt > 65535) {
                throw new SCTierException(MessageBundle.getMessage((MessageKey)SclsMsgID.INVALID_LOCALPORT_NUMBER, (boolean)true, (Object[])new Object[]{localPort}));
            }
        }
        catch (NumberFormatException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclsMsgID.INVALID_LOCALPORT_NUMBER, (boolean)true, (Object[])new Object[]{localPort}), (Throwable)e);
        }
        try {
            String attrName = this.m_isClusterTier ? ResourceType.EONS.PORT.name() : ResourceType.SuperCluster.PORT.name();
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(attrName, localPort));
        }
        catch (CRSException ce) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclsMsgID.EONS_SETLISTENPORT_FAILED, (boolean)true, (Object[])new Object[]{localPort, this.getUserAssignedName()}), (Throwable)ce);
        }
    }
}

