/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.cluster;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.util.NotExistsException;
import oracle.eons.ONS;
import oracle.eons.TierDiscoveryInfo;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.supercluster.cluster.SCFileHandler;
import oracle.supercluster.common.SCRException;
import oracle.supercluster.common.SCTierException;
import oracle.supercluster.common.Version;
import oracle.supercluster.impl.cluster.ClusterFactoryImpl;
import oracle.supercluster.impl.cluster.EONSControl;
import oracle.supercluster.impl.cluster.Sniper;
import oracle.supercluster.impl.cluster.SniperVictim;
import oracle.supercluster.impl.common.CommonFactoryImpl;
import oracle.supercluster.impl.common.SCRepresentativeImpl;
import oracle.supercluster.resources.SclcMsgID;

public class SCRServerImpl
extends UnicastRemoteObject
implements EONSControl,
SniperVictim {
    private static String s_registryURL;
    private static EONSControl s_instance;
    private Logger m_logger;
    private SCRepresentativeImpl m_scRepImpl;

    private SCRServerImpl(TierDiscoveryInfo htierInfo, TierDiscoveryInfo vtierInfo, ONS.TierName tierName, int port, int repCount, Version version, String scanName) throws RemoteException, SCRException {
        try {
            String logDir = ClusterFactoryImpl.getInstance().getLogDirectory();
            SCFileHandler handler = new SCFileHandler(logDir);
            this.m_logger = Logger.getLogger("oracle.supercluster");
            ArrayList<String> verfList = new ArrayList<String>(1);
            verfList.add(scanName);
            this.m_scRepImpl = (SCRepresentativeImpl)CommonFactoryImpl.getInstance().createSCRepresentative(htierInfo, vtierInfo, tierName, port, repCount, version, null, verfList, 60);
        }
        catch (IOException e) {
            SCRException scrExp = new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.LOGGER_CONFIG_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SCR.toString(), String.valueOf(port) + " " + htierInfo.toString() + " " + vtierInfo.toString()}), (Throwable)e);
            if (this.m_logger != null) {
                this.m_logger.severe(e.getMessage());
                this.m_logger.severe(scrExp.getMessage());
            } else {
                Trace.out((Exception)e);
            }
            throw scrExp;
        }
        catch (SoftwareModuleException e) {
            SCRException scrExp = new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_START_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SCR.toString(), String.valueOf(port) + " " + htierInfo.toString() + " " + vtierInfo.toString()}), (Throwable)e);
            this.m_logger.severe(e.getMessage());
            this.m_logger.severe(scrExp.getMessage());
            throw scrExp;
        }
        catch (SCTierException e) {
            SCRException scrExp = new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.LOGGER_CONFIG_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SCR.toString()}), (Throwable)e);
            throw scrExp;
        }
    }

    static synchronized EONSControl createInstance(TierDiscoveryInfo htierInfo, TierDiscoveryInfo vtierInfo, ONS.TierName tierName, int port, int repCount, Version version, String scanName) throws RemoteException, SCRException {
        if (null == s_instance) {
            try {
                s_instance = SCRServerImpl.getInstance(port);
            }
            catch (RemoteException e) {
                Trace.out((String)("IGNORED" + e.getMessage()));
            }
        }
        if (null == s_instance) {
            try {
                s_instance = new SCRServerImpl(htierInfo, vtierInfo, tierName, port, repCount, version, scanName);
                LocateRegistry.createRegistry(SCRServerImpl.getRegistryPort(port));
                if (null == s_registryURL) {
                    s_registryURL = SCRServerImpl.getRegistryURL(port);
                }
                Trace.out((String)("binding to registry=" + s_registryURL));
                Naming.rebind(s_registryURL, s_instance);
                s_instance = (EONSControl)Naming.lookup(s_registryURL);
                Trace.out((String)("s_instance found from registry =" + s_instance));
            }
            catch (NotBoundException e) {
                Trace.out((String)("IGNORED: " + e.getMessage()));
            }
            catch (MalformedURLException e) {
                Trace.out((String)("IGNORED: " + e.getMessage()));
            }
        }
        return s_instance;
    }

    static synchronized EONSControl getInstance(int port) throws RemoteException, SCRException {
        try {
            if (null == s_registryURL) {
                s_registryURL = SCRServerImpl.getRegistryURL(port);
            }
            return (EONSControl)Naming.lookup(s_registryURL);
        }
        catch (MalformedURLException e) {
            Trace.out((Exception)e);
            throw new SCRException((Throwable)e);
        }
        catch (NotBoundException e) {
            Trace.out((Exception)e);
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_NOT_RUNNING, (boolean)true, (Object[])new Object[]{ResourceLiterals.SCR.toString()}), (Throwable)e);
        }
        catch (AccessException e) {
            Trace.out((Exception)e);
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_NOT_RUNNING, (boolean)true, (Object[])new Object[]{ResourceLiterals.SCR.toString()}), (Throwable)e);
        }
    }

    @Override
    public void start() throws RemoteException {
        try {
            this.m_scRepImpl.start();
        }
        catch (SCRException e) {
            this.m_logger.severe(e.getMessage());
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public boolean status() throws RemoteException {
        return this.m_scRepImpl.status();
    }

    @Override
    public void stop() throws RemoteException {
        try {
            Naming.unbind(s_registryURL);
        }
        catch (NotBoundException e) {
            this.m_logger.info("IGNORED: " + e.getMessage());
        }
        catch (MalformedURLException e) {
            this.m_logger.info("IGNORED: " + e.getMessage());
        }
        this.m_scRepImpl.stop();
        this.m_logger.info("Stopped SCRepresentative Server");
        new Timer().schedule((TimerTask)new Sniper(this), 1000L);
    }

    @Override
    public void shoot() {
        this.m_scRepImpl = null;
        s_instance = null;
        System.exit(0);
    }

    private static int getRegistryPort(int port) {
        return port + 1;
    }

    private static String getRegistryURL(int port) {
        String serverName;
        try {
            serverName = Cluster.getHostName();
        }
        catch (ClusterException e) {
            try {
                serverName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                Trace.out((String)("IGNORED" + uhe.getMessage()));
                serverName = "localhost";
            }
        }
        String url = "//" + serverName + ':' + SCRServerImpl.getRegistryPort(port) + "/oracle.supercluster.impl.cluster.SCRServerImpl";
        Trace.out((String)("SCRServer url=" + url));
        return url;
    }

    public static void main(String[] args) {
        int status;
        Logger logger = Logger.getLogger("oracle.supercluster");
        try {
            EONSControl server = ClusterFactoryImpl.getInstance().createSCRServer();
            server.start();
            status = 0;
        }
        catch (SoftwareModuleException e) {
            logger.severe(e.toString());
            status = 1;
        }
        catch (NotExistsException e) {
            logger.severe(e.toString());
            status = 1;
        }
        catch (SCRException e) {
            logger.severe(e.toString());
            status = 1;
        }
        catch (RemoteException e) {
            logger.severe(e.toString());
            status = 1;
        }
        logger.info("SCRepresentative server status=" + status);
        if (status != 0) {
            System.exit(status);
        }
    }
}

