/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.cluster;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.CardinalityException;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ClusterResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.nodeapps.EONSImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.eons.BridgeFilter;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.supercluster.cluster.GossipServerResource;
import oracle.supercluster.cluster.SCRDResource;
import oracle.supercluster.cluster.SCRDResourceException;
import oracle.supercluster.common.CommonFactory;
import oracle.supercluster.common.SCDiscoveryMethod;
import oracle.supercluster.common.SCDiscoveryServer;
import oracle.supercluster.common.SCRException;
import oracle.supercluster.common.SCRepresentative;
import oracle.supercluster.common.SCTierException;
import oracle.supercluster.common.SuperCluster;
import oracle.supercluster.impl.cluster.ClusterFactoryImpl;
import oracle.supercluster.impl.cluster.GossipServerResourceImpl;
import oracle.supercluster.impl.cluster.SCTierImpl;
import oracle.supercluster.resources.SclcMsgID;

public class SCRDResourceImpl
extends SoftwareModuleImpl
implements SCRDResource,
SuperCluster {
    private ResourceAttribute m_nameAttr;
    private ClusterResourceImpl m_clusterResource;
    private SCTierImpl m_tierImpl;

    SCRDResourceImpl(ResourceAttribute nameAttr) throws SCRDResourceException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.SuperCluster.NAME.name())) {
                throw new SCRDResourceException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.SuperCluster.NAME.name());
            }
            String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            int numValues = values.length;
            if (numValues != 2 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.SUPERCLUSTER.toString().equalsIgnoreCase(values[numValues - 1])) {
                throw new SCRDResourceException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.SuperCluster.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            this.m_displayName = values[numValues - 1];
            Trace.out((String)("name=" + this.m_nameAttr.getName() + " value=" + this.m_name));
            this.m_clusterResource = (ClusterResourceImpl)CRSFactoryImpl.getInstance().getClusterResource(this.m_nameAttr);
            this.m_crsResource = this.m_clusterResource;
            this.m_tierImpl = ClusterFactoryImpl.getInstance().getSCTierImpl(this.m_crsResource, false);
        }
        catch (NotExistsException values) {
        }
        catch (CRSException e) {
            throw new SCRDResourceException(e);
        }
        catch (SoftwareModuleException e) {
            throw new SCRDResourceException(e);
        }
        catch (SCTierException e) {
            throw new SCRDResourceException(e);
        }
    }

    void create(String tierName, String port, SCDiscoveryMethod discoveryMethod, InetAddress mcastAddress, String mcastPort, Map<String, Integer> mbrMap, Map<String, String> map, Version version) throws AlreadyExistsException, SCRDResourceException {
        ResourceAttribute gossipserverTypeAttr = null;
        SCRDResourceException excep = null;
        if (SCDiscoveryMethod.MULTICAST.equals((Object)discoveryMethod)) {
            if (mcastAddress == null) {
                throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mcastAddress", mcastAddress);
            }
            if (mcastPort == null || mcastPort.trim().length() == 0) {
                throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mcastPort", mcastPort);
            }
            if (!mcastAddress.isMulticastAddress()) {
                throw new SCRDResourceException((MessageKey)SclcMsgID.NOT_MCAST_ADDRESS, mcastAddress.getHostAddress());
            }
        }
        if (SCDiscoveryMethod.LIST.equals((Object)discoveryMethod)) {
            if (mbrMap == null || mbrMap.size() == 0) {
                throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mbrMap", mbrMap);
            }
        } else if (SCDiscoveryMethod.GOSSIP_SERVERS.equals((Object)discoveryMethod)) {
            try {
                GossipServerResource gsr = ClusterFactoryImpl.getInstance().getGossipServerResource();
                gossipserverTypeAttr = CRSFactoryImpl.getInstance().create(ResourceType.GossipServer.NAME.name(), ResourceType.GossipServer.NAME.toString());
            }
            catch (SoftwareModuleException e) {
                throw new SCRDResourceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, e, this.m_nameAttr.getValue());
            }
            catch (NotExistsException e) {
                throw new SCRDResourceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, e, this.m_nameAttr.getValue(), MessageBundle.getMessage((MessageKey)PrCrMsgID.RES_NOT_EXISTS, (boolean)false, (Object[])new Object[]{GossipServerResourceImpl.getResourceName()}));
            }
            catch (CRSException e) {
                throw new SCRDResourceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, e, this.m_nameAttr.getValue());
            }
        }
        try {
            List attrList;
            ResourceAttribute scanLsnrTypeAttr;
            ResourceAttribute eonsAttr = null;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute scTypeAttr = crsFactory.create(ResourceType.SuperCluster.NAME.name(), ResourceType.SuperCluster.NAME.toString());
            if (!crsFactory.isRegistered(EONSImpl.getResourceName(), CRSEntity.Type.Resource)) {
                throw new SCRDResourceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, this.m_nameAttr.getValue(), MessageBundle.getMessage((MessageKey)PrCrMsgID.RES_NOT_EXISTS, (boolean)true, (Object[])new Object[]{EONSImpl.getResourceName()}));
            }
            eonsAttr = crsFactory.create(ResourceType.EONS.NAME.name(), EONSImpl.getResourceName());
            if (!crsFactory.isRegistered(ResourceType.ScanListener.NAME.toString(), CRSEntity.Type.ResourceType)) {
                if (Cluster.isCluster()) {
                    throw new SCRDResourceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, this.m_nameAttr.getValue(), MessageBundle.getMessage((MessageKey)PrCrMsgID.RES_TYPE_NOT_EXISTS, (boolean)true, (Object[])new Object[]{ResourceType.ScanListener.NAME.toString()}));
                }
                scanLsnrTypeAttr = null;
            } else {
                scanLsnrTypeAttr = crsFactory.create(ResourceType.ScanListener.NAME.name(), ResourceType.ScanListener.NAME.toString());
            }
            if (!crsFactory.isRegistered(scTypeAttr.getValue(), CRSEntity.Type.ResourceType)) {
                if (!crsFactory.isRegistered(ResourceType.ClusterResource.NAME.toString(), CRSEntity.Type.ResourceType)) {
                    crsFactory.create(CRSEntity.Type.ResourceType, ResourceType.getAttributes(ResourceType.ClusterResource.class));
                }
                attrList = ResourceType.getAttributes(ResourceType.SuperCluster.class);
                crsFactory.create(CRSEntity.Type.ResourceType, attrList);
            } else {
                attrList = crsFactory.getResourceTypeEntity(scTypeAttr).getAttributes(new String[0]);
            }
            attrList = ResourceType.getProfile((List)attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.SuperCluster.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.SuperCluster.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.SCREP_RES_DESC.toString());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.SuperCluster.TIER_NAME.name())) {
                    if (tierName != null) {
                        attr.setValue(tierName);
                        continue;
                    }
                    try {
                        String clusterName = new ClusterUtil().getClusterName();
                        attr.setValue(clusterName + '.' + ResourceLiterals.DATABASE.toString());
                    }
                    catch (ClusterUtilException e) {
                        Trace.out((String)("IGNORE: " + (Object)((Object)e)));
                    }
                    continue;
                }
                if (port != null && attr.getName().equalsIgnoreCase(ResourceType.SuperCluster.PORT.name())) {
                    attr.setValue(port);
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.SuperCluster.DISCOVERY_METHOD.name())) {
                    attr.setValue(discoveryMethod.toString());
                    continue;
                }
                if (SCDiscoveryMethod.MULTICAST.equals((Object)discoveryMethod) && attr.getName().equalsIgnoreCase(ResourceType.SuperCluster.MCAST_ADDRESS.name())) {
                    attr.setValue(ClusterFactoryImpl.getMulticastAddress(mcastAddress, mcastPort));
                    continue;
                }
                if (SCDiscoveryMethod.LIST.equals((Object)discoveryMethod) && attr.getName().equalsIgnoreCase(ResourceType.SuperCluster.MEMBER_LIST.name())) {
                    attr.setValue(ClusterFactoryImpl.getMemberList(mbrMap));
                    continue;
                }
                if (map == null || !attr.getName().equalsIgnoreCase(ResourceType.SuperCluster.PROPERTIES.name())) continue;
                StringBuilder sb = new StringBuilder();
                for (String key : map.keySet()) {
                    if (sb.length() > 0) {
                        sb.append(" " + key.trim() + "=" + map.get(key).trim());
                        continue;
                    }
                    sb.append(key.trim() + "=" + map.get(key).trim());
                }
                attr.setValue(sb.toString());
            }
            attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
            ArrayList<ResourceDependency> depList = new ArrayList<ResourceDependency>();
            if (scanLsnrTypeAttr != null) {
                depList.add(crsFactory.createResourceDependency(scanLsnrTypeAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.TYPE_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP}));
            }
            if (gossipserverTypeAttr != null) {
                depList.add(crsFactory.createResourceDependency(gossipserverTypeAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.TYPE_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP}));
            }
            ResourceDependency[] startDepList = new ResourceDependency[depList.size()];
            startDepList = depList.toArray(startDepList);
            attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])startDepList)));
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.CRS_USER);
            this.m_clusterResource = (ClusterResourceImpl)CRSFactoryImpl.getInstance().getClusterResource(this.m_nameAttr);
            this.m_tierImpl = ClusterFactoryImpl.getInstance().getSCTierImpl(this.m_crsResource, false);
        }
        catch (CRSException e) {
            excep = new SCRDResourceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            excep = new SCRDResourceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            excep = new SCRDResourceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (SCTierException e) {
            excep = new SCRDResourceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public SCRepresentative scRepresentative() throws SCRException {
        try {
            return CommonFactory.getInstance().getSCRepresentative();
        }
        catch (SoftwareModuleException e) {
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_SCREP_FAILED, (boolean)true, (Object[])new Object[]{e}));
        }
    }

    public String getTierName() throws SCTierException {
        return this.m_tierImpl.getTierName();
    }

    @Override
    public SuperCluster tier() throws SCTierException {
        return this;
    }

    public SCDiscoveryMethod discoveryMethod() throws SCTierException {
        return this.m_tierImpl.discoveryMethod();
    }

    public InetAddress getMulticastAddress() throws SCTierException {
        return this.m_tierImpl.getMulticastAddress();
    }

    public int getMulticastPort() throws SCTierException {
        return this.m_tierImpl.getMulticastPort();
    }

    public List<SCDiscoveryServer> discoveryServers() throws SCTierException {
        return this.m_tierImpl.discoveryServers();
    }

    public Map<String, Integer> memberList() throws SCTierException {
        return this.m_tierImpl.memberList();
    }

    public boolean isClusterTier() throws SCTierException {
        return this.m_tierImpl.isClusterTier();
    }

    public List<BridgeFilter> getFilters(BridgeFilter.FILTERLOCATION location) throws SCTierException {
        throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_FILTERS_FAILED, (boolean)true, (Object[])new Object[]{location.toString(), this.tier().getName()}));
    }

    public void insertFilters(BridgeFilter.FILTERLOCATION location, List<BridgeFilter> filters) throws SCTierException {
        StringBuilder sb = new StringBuilder();
        for (BridgeFilter filter : filters) {
            if (sb.length() > 0) {
                sb.append("," + filter.toString());
                continue;
            }
            sb.append(filter.toString());
        }
        throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.SET_FILTERS_FAILED, (boolean)true, (Object[])new Object[]{sb.toString(), location.toString(), this.tier().getName(), "NOT IMPLEMENTED"}));
    }

    public int port() throws SCTierException {
        return this.m_tierImpl.port();
    }

    @Override
    public Map<String, String> properties() throws SCRException {
        try {
            return this.m_tierImpl.properties();
        }
        catch (SCTierException e) {
            throw new SCRException((Throwable)e);
        }
    }

    @Override
    public void setProperties(Map<String, String> props) throws SCRException {
        try {
            this.m_tierImpl.setProperties(props);
        }
        catch (SCTierException e) {
            throw new SCRException((Throwable)e);
        }
    }

    public int getCardinality() throws CardinalityException {
        return this.m_clusterResource.getCardinality();
    }

    public int getMaxCardinality() throws CardinalityException {
        return this.m_clusterResource.getMaxCardinality();
    }

    public void setMaxCardinality(int cardinality) throws CardinalityException {
        this.m_clusterResource.setMaxCardinality(cardinality);
    }

    public void relocate() throws NotRunningException, RelocateException {
        this.m_clusterResource.relocate();
    }

    public void relocate(Node srcNode) throws NotRunningException, RelocateException {
        this.m_clusterResource.relocate(srcNode);
    }

    public void relocateTo(Node tgtNode) throws NotRunningException, RelocateException {
        this.m_clusterResource.relocateTo(tgtNode);
    }

    public void relocate(Node srcNode, Node dstNode) throws NotRunningException, RelocateException {
        this.m_clusterResource.relocate(srcNode, dstNode);
    }

    public List<InetAddress> address() throws SCRDResourceException {
        try {
            List nodeList = this.m_clusterResource.fetchRunningNodes();
            ArrayList<InetAddress> addrList = new ArrayList<InetAddress>(nodeList.size());
            for (Node node : nodeList) {
                addrList.add(InetAddress.getByName(node.getName()));
            }
            return addrList;
        }
        catch (CRSException e) {
            throw new SCRDResourceException((MessageKey)SclcMsgID.GET_ADDR_FAILED, e, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new SCRDResourceException((MessageKey)SclcMsgID.GET_ADDR_FAILED, e, this.getUserAssignedName());
        }
        catch (UnknownHostException e) {
            throw new SCRDResourceException((MessageKey)SclcMsgID.GET_ADDR_FAILED, e, this.getUserAssignedName());
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, SCRDResourceException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new SCRDResourceException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    public void start(int count) throws AlreadyRunningException, CompositeOperationException, CardinalityException {
        this.m_clusterResource.start(count);
    }

    public void stop(int count, boolean force) throws AlreadyStoppedException, CompositeOperationException, CardinalityException {
        this.m_clusterResource.stop(count, force);
    }

    public void remove(int count, boolean force) throws AlreadyRunningException, CompositeOperationException, CardinalityException {
        this.m_clusterResource.remove(count, force);
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, SCRDResourceException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            throw new SCRDResourceException(e);
        }
    }

    public static String getResourceName() {
        return "ora." + ResourceLiterals.SUPERCLUSTER.toString();
    }

    public void setMulticastAddress(InetAddress mcastAddress) throws SCTierException {
        this.m_tierImpl.setMulticastAddress(mcastAddress);
    }

    public void setMulticastPort(String mcastPort) throws SCTierException {
        this.m_tierImpl.setMulticastPort(mcastPort);
    }

    public void setListenPort(String localPort) throws SCTierException {
        this.m_tierImpl.setListenPort(localPort);
    }
}

