/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.cluster;

import java.rmi.RemoteException;
import java.util.Map;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.security.DaemonSecurityManager;
import oracle.ops.mgmt.security.NullSecurityManager;
import oracle.ops.mgmt.security.SecurityHelper;
import oracle.ops.mgmt.trace.Trace;
import oracle.supercluster.cluster.SCRDResource;
import oracle.supercluster.common.SCRException;
import oracle.supercluster.impl.cluster.ClusterFactoryImpl;
import oracle.supercluster.impl.cluster.CommandLineParser;
import oracle.supercluster.impl.cluster.EONSControl;
import oracle.supercluster.resources.SclcMsgID;

public class SCRCTL {
    static final String DAEMON = "daemon";
    static final int MAX_STATUS_ATTEMPTS = 10;
    static final int MSEC_WAIT_PER_ATTEMPT = 1000;
    private SCRDResource m_scrd;

    private SCRCTL() throws SCRException {
        try {
            this.m_scrd = ClusterFactoryImpl.getInstance().getSCRDResource();
        }
        catch (SoftwareModuleException e) {
            throw new SCRException((Throwable)e);
        }
        catch (NotExistsException e) {
            throw new SCRException((Throwable)e);
        }
    }

    void start() throws SCRException {
        try {
            if (this.status()) {
                Trace.out((String)"SCRepresentative is currently running");
                return;
            }
        }
        catch (SCRException sCRException) {
            // empty catch block
        }
        Util utl = null;
        try {
            int i = 0;
            Map<String, String> propsMap = this.m_scrd.properties();
            String[] inputList = propsMap.size() == 0 ? new String[3] : new String[3 + propsMap.size()];
            inputList[i++] = CommandLineParser.CommandOption.Start.toString();
            inputList[i++] = ResourceLiterals.SCR.toString();
            inputList[i++] = DAEMON;
            for (String key : propsMap.keySet()) {
                inputList[i++] = ResourceLiterals.JAVA_PROP_PREFIX.toString() + key.trim() + "=" + propsMap.get(key).trim();
            }
            utl = new Util();
            String crsHome = utl.getCRSHome();
            String scrctl = crsHome + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.SCRCTL_SCRIPT.toString();
            Trace.out((String)("scrctl script=" + scrctl));
            if (!Cluster.isCluster() || !new SystemFactory().CreateSystem().isUnixSystem()) {
                NullSecurityManager daemonSecurity = new NullSecurityManager();
                System.setSecurityManager((SecurityManager)daemonSecurity);
            } else {
                SecurityHelper securityHelper = new SecurityHelper(crsHome);
                DaemonSecurityManager daemonSecurity = new DaemonSecurityManager();
                daemonSecurity.setSecurityHelper(securityHelper);
                System.setSecurityManager((SecurityManager)daemonSecurity);
            }
            if (Trace.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder(scrctl);
                for (String input : inputList) {
                    sb.append(" " + input);
                }
                Trace.out((String)("makeDaemon=" + sb.toString()));
            }
            utl.makeDaemon(scrctl, inputList, null);
        }
        catch (UtilException e) {
            Trace.out((Exception)((Object)e));
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_START_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)e);
        }
        finally {
            if (utl != null) {
                try {
                    utl.destroy();
                }
                catch (UtilException e) {
                    Trace.out((Exception)((Object)e));
                }
            }
        }
    }

    void stop() throws SCRException {
        EONSControl server = null;
        try {
            server = ClusterFactoryImpl.getInstance().getSCRServer();
            Trace.out((String)"Stopping SCReps");
            server.stop();
        }
        catch (SoftwareModuleException e) {
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_STOP_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)e);
        }
        catch (NotExistsException e) {
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_STOP_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)e);
        }
        catch (RemoteException e) {
            Trace.out((Exception)e);
            if (server != null) {
                throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_STOP_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)e);
            }
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_NOT_RUNNING, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)e);
        }
    }

    boolean status() throws SCRException {
        EONSControl server = null;
        try {
            server = ClusterFactoryImpl.getInstance().getSCRServer();
            return server.status();
        }
        catch (SoftwareModuleException e) {
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_STAT_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)e);
        }
        catch (NotExistsException e) {
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_STAT_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)e);
        }
        catch (RemoteException e) {
            if (server != null) {
                throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_STAT_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)e);
            }
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_NOT_RUNNING, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)e);
        }
    }

    static final String usage() {
        return MessageBundle.getMessage((MessageKey)SclcMsgID.SCRIPT_USAGE, (boolean)false, (Object[])new Object[]{ResourceLiterals.SCRCTL_SCRIPT.toString(), CommandLineParser.CommandOption.getSyntaxOptions(), System.getProperty("PROGRAM", ResourceLiterals.GOSSIPSERVER.toString()) + "|" + System.getProperty("PROGRAM", ResourceLiterals.EONS.toString()) + "|" + System.getProperty("PROGRAM", ResourceLiterals.SCR.toString())});
    }

    public static void main(String[] args) {
        boolean stat;
        block13: {
            stat = false;
            try {
                CommandLineParser.CommandOption cmdOpt = new CommandLineParser(args).getCommandOption();
                if (CommandLineParser.CommandOption.Start.equals((Object)cmdOpt) || CommandLineParser.CommandOption.Stop.equals((Object)cmdOpt) || CommandLineParser.CommandOption.Status.equals((Object)cmdOpt)) {
                    SCRCTL ctl = new SCRCTL();
                    if (CommandLineParser.CommandOption.Start.equals((Object)cmdOpt)) {
                        ctl.start();
                        for (int i = 0; i < 10; ++i) {
                            Trace.out((String)("SCR start status attempt = " + (i + 1)));
                            try {
                                try {
                                    Thread.currentThread();
                                    Thread.sleep((i + 1) * 1000);
                                }
                                catch (InterruptedException e) {
                                    Trace.out((String)("IGNORE: " + e.getMessage()));
                                }
                                stat = ctl.status();
                                if (!stat) continue;
                                break block13;
                            }
                            catch (SCRException e) {
                                Trace.out((String)("IGNORE: " + e.getMessage()));
                            }
                        }
                        break block13;
                    }
                    if (CommandLineParser.CommandOption.Stop.equals((Object)cmdOpt)) {
                        ctl.stop();
                        stat = true;
                    } else if (CommandLineParser.CommandOption.Status.equals((Object)cmdOpt)) {
                        stat = ctl.status();
                    }
                    break block13;
                }
                System.out.println(SCRCTL.usage());
                System.exit(0);
            }
            catch (IllegalArgumentException e) {
                System.out.println(e.getMessage());
                System.out.println(SCRCTL.usage());
            }
            catch (SCRException e) {
                System.out.println(e.getMessage());
                Trace.out((String)("INFO:" + (Object)((Object)e)));
            }
        }
        Trace.out((String)("stat=" + stat));
        System.exit(stat ? 0 : 1);
    }
}

