/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.cluster;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.RelocatableImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.scan.ScanFactoryImpl;
import oracle.cluster.impl.scan.ScanVIPImpl;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.scan.ScanVIP;
import oracle.cluster.scan.ScanVIPException;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.supercluster.cluster.GossipServerResource;
import oracle.supercluster.cluster.GossipServerResourceException;
import oracle.supercluster.common.CommonFactory;
import oracle.supercluster.common.DiscoveryServerException;
import oracle.supercluster.common.SCDiscoveryServer;
import oracle.supercluster.resources.SclcMsgID;

public class GossipServerResourceImpl
extends SoftwareModuleImpl
implements GossipServerResource {
    private ResourceAttribute m_nameAttr;

    GossipServerResourceImpl(ResourceAttribute nameAttr) throws GossipServerResourceException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.GossipServer.NAME.name())) {
                throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.GossipServer.NAME.name());
            }
            String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            int numValues = values.length;
            if (numValues != 2 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.GOSSIPSERVER.toString().equalsIgnoreCase(values[numValues - 1])) {
                throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.GossipServer.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            this.m_displayName = values[numValues - 1];
            Trace.out((String)("name=" + this.m_nameAttr.getName() + " value=" + this.m_name));
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(this.m_nameAttr);
        }
        catch (NotExistsException values) {
        }
        catch (CRSException e) {
            throw new GossipServerResourceException(e);
        }
    }

    void create(ScanVIP sVIP, String port, Map<String, String> map, Version version) throws AlreadyExistsException, GossipServerResourceException {
        try {
            List attrList;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute scanVIPAttr = crsFactory.create(ResourceType.ScanVIP.NAME.name(), sVIP.crsResource().getName());
            ResourceAttribute dsTypeAttr = crsFactory.create(ResourceType.GossipServer.NAME.name(), ResourceType.GossipServer.NAME.toString());
            if (!crsFactory.isRegistered(dsTypeAttr.getValue(), CRSEntity.Type.ResourceType)) {
                if (!crsFactory.isRegistered(ResourceType.ClusterResource.NAME.toString(), CRSEntity.Type.ResourceType)) {
                    crsFactory.create(CRSEntity.Type.ResourceType, ResourceType.getAttributes(ResourceType.ClusterResource.class));
                }
                attrList = ResourceType.getAttributes(ResourceType.GossipServer.class);
                crsFactory.create(CRSEntity.Type.ResourceType, attrList);
            } else {
                attrList = crsFactory.getResourceTypeEntity(dsTypeAttr).getAttributes(new String[0]);
            }
            attrList = ResourceType.getProfile((List)attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.GossipServer.NAME.name())) {
                    attr.setValue(GossipServerResourceImpl.getResourceName());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.GossipServer.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.DOS_RES_DESC.toString());
                    continue;
                }
                if (port != null && attr.getName().equalsIgnoreCase(ResourceType.GossipServer.PORT.name())) {
                    attr.setValue(port);
                    continue;
                }
                if (map == null || !attr.getName().equalsIgnoreCase(ResourceType.GossipServer.PROPERTIES.name())) continue;
                StringBuilder sb = new StringBuilder();
                for (String key : map.keySet()) {
                    if (sb.length() > 0) {
                        sb.append(" " + key.trim() + "=" + map.get(key).trim());
                        continue;
                    }
                    sb.append(key.trim() + "=" + map.get(key).trim());
                }
                attr.setValue(sb.toString());
            }
            attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
            ResourceDependency hardDep = crsFactory.createResourceDependency(scanVIPAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
            ResourceDependency pullupDep = crsFactory.createResourceDependency(scanVIPAttr, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
            attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString((ResourceDependency[])new ResourceDependency[]{hardDep, pullupDep})));
            hardDep = crsFactory.createResourceDependency(scanVIPAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[]{ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP});
            attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), hardDep.toString()));
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.CRS_USER);
        }
        catch (CRSException e) {
            throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (ScanVIPException e) {
            throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    public void relocate() throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocate();
        }
        catch (NotExistsException e) {
            throw new RelocateException((Throwable)e);
        }
        catch (CRSException e) {
            throw new RelocateException((Throwable)e);
        }
    }

    public void relocate(Node node) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(node);
        }
        catch (NotExistsException e) {
            throw new RelocateException((Throwable)e);
        }
        catch (CRSException e) {
            throw new RelocateException((Throwable)e);
        }
    }

    public void relocateTo(Node tgtNode) throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocateTo(tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException((Throwable)e);
        }
        catch (CRSException e) {
            throw new RelocateException((Throwable)e);
        }
    }

    public void relocate(Node srcNode, Node dstNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode, dstNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException((Throwable)e);
        }
        catch (CRSException e) {
            throw new RelocateException((Throwable)e);
        }
    }

    @Override
    public SCDiscoveryServer discoveryServer() throws DiscoveryServerException {
        try {
            return CommonFactory.getInstance().getDiscoveryServer();
        }
        catch (SoftwareModuleException e) {
            throw new DiscoveryServerException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_GOSSIPSERVER_FAILED, (boolean)true, (Object[])new Object[]{e}));
        }
    }

    public InetAddress address() throws DiscoveryServerException {
        try {
            SCDiscoveryServer ds = CommonFactory.getInstance().getDiscoveryServer();
            if (ds != null) {
                return ds.address();
            }
            throw new DiscoveryServerException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_GOSSIPSERVER_FAILED, (boolean)true, (Object[])new Object[]{ds}));
        }
        catch (SoftwareModuleException e) {
            throw new DiscoveryServerException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_GOSSIPSERVER_FAILED, (boolean)true, (Object[])new Object[]{e}));
        }
    }

    @Override
    public ScanVIP scanVIP() throws GossipServerResourceException {
        StringBuilder sb = new StringBuilder();
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            String[] resNames = ResourceDependency.getResourceNames((ResourceAttribute)attr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP);
            if (resNames.length == 0) {
                attr = this.m_crsResource.getAttribute(ResourceType.LocalResource.STOP_DEPENDENCIES.name());
                resNames = ResourceDependency.getResourceNames((ResourceAttribute)attr, (ResourceDependency.DepType)ResourceDependency.DepType.HARD_DEP);
            }
            Trace.out((String)("resNames.length = " + resNames.length));
            for (String res : resNames) {
                if (sb.length() > 0) {
                    sb.append("," + res);
                } else {
                    sb.append(res);
                }
                if (!res.endsWith(".vip".toString())) continue;
                return ScanFactoryImpl.getInstance().getScanVIP(res);
            }
            Trace.out((String)("sb= " + sb));
            throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_GET_DEP_RES_FAILED, ScanVIPImpl.getResourceName((int)1, (int)1), this.getUserAssignedName(), sb.toString());
        }
        catch (SoftwareModuleException e) {
            throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_GET_DEP_RES_FAILED, e, ScanVIPImpl.getResourceName((int)1, (int)1), this.getUserAssignedName(), sb.toString());
        }
        catch (CRSException e) {
            throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_GET_DEP_RES_FAILED, e, ScanVIPImpl.getResourceName((int)1, (int)1), this.getUserAssignedName(), sb.toString());
        }
        catch (NotExistsException e) {
            throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_GET_DEP_RES_FAILED, e, ScanVIPImpl.getResourceName((int)1, (int)1), this.getUserAssignedName(), sb.toString());
        }
    }

    @Override
    public void setScanVIP(ScanVIP sVIP) throws GossipServerResourceException {
        String curResName = "";
        String newResName = "";
        try {
            ScanVIP curScanVIP = this.scanVIP();
            curResName = curScanVIP.crsResource().getName();
            newResName = sVIP.crsResource().getName();
            ResourceAttribute[] raList = new ResourceAttribute[]{this.m_crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name()), this.m_crsResource.getAttribute(ResourceType.LocalResource.STOP_DEPENDENCIES.name())};
            raList[0].setValue(raList[0].getValue().replaceAll(curResName, newResName));
            raList[1].setValue(raList[1].getValue().replaceAll(curResName, newResName));
            this.m_crsResource.update(raList);
        }
        catch (ScanVIPException e) {
            throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_SET_DEP_RES_FAILED, e, curResName, this.getUserAssignedName(), newResName);
        }
        catch (NotExistsException e) {
            throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_SET_DEP_RES_FAILED, e, curResName, this.getUserAssignedName(), newResName);
        }
        catch (CRSException e) {
            throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_SET_DEP_RES_FAILED, e, curResName, this.getUserAssignedName(), newResName);
        }
    }

    public int port() throws DiscoveryServerException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.GossipServer.PORT.name());
            return Integer.parseInt(attr.getValue().trim());
        }
        catch (CRSException e) {
            throw new DiscoveryServerException(MessageBundle.getMessage((MessageKey)PrCnMsgID.GET_PORT_FAILED, (boolean)true, (Object[])new Object[]{this.getUserAssignedName()}), (Throwable)e);
        }
    }

    @Override
    public Map<String, String> properties() throws GossipServerResourceException {
        try {
            HashMap<String, String> envMap = new HashMap<String, String>();
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.GossipServer.PROPERTIES.name());
            String value = attr.getValue();
            Trace.out((String)("PROPERTIES value=" + value));
            if (value.length() > 0) {
                String[] propList;
                for (String prop : propList = value.split(" ")) {
                    String[] nvPairs = prop.split("=");
                    if (nvPairs.length != 2) {
                        throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, attr.getName(), value, prop);
                    }
                    envMap.put(nvPairs[0].trim(), nvPairs[1].trim());
                }
            }
            return envMap;
        }
        catch (CRSException e) {
            throw new GossipServerResourceException((MessageKey)PrCnMsgID.GET_PROPS_FAILED, e, this.getUserAssignedName());
        }
    }

    @Override
    public void setProperties(Map<String, String> props) throws GossipServerResourceException {
        StringBuilder sb = new StringBuilder();
        try {
            for (String key : props.keySet()) {
                if (sb.length() > 0) {
                    sb.append(" " + key.trim() + "=" + props.get(key).trim());
                    continue;
                }
                sb.append(key.trim() + "=" + props.get(key).trim());
            }
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.GossipServer.PROPERTIES.name(), sb.toString()));
        }
        catch (CRSException e) {
            throw new GossipServerResourceException((MessageKey)PrCnMsgID.SET_PROPS_FAILED, e, sb.toString(), this.getUserAssignedName());
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, GossipServerResourceException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, GossipServerResourceException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            throw new GossipServerResourceException(e);
        }
    }

    public static String getResourceName() {
        return "ora." + ResourceLiterals.GOSSIPSERVER.toString();
    }
}

