/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.cluster;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.supercluster.cluster.SCFileHandler;
import oracle.supercluster.common.DiscoveryServerException;
import oracle.supercluster.common.SCDiscoveryServer;
import oracle.supercluster.common.SCTierException;
import oracle.supercluster.impl.cluster.ClusterFactoryImpl;
import oracle.supercluster.impl.cluster.EONSControl;
import oracle.supercluster.impl.cluster.Sniper;
import oracle.supercluster.impl.cluster.SniperVictim;
import oracle.supercluster.impl.common.CommonFactoryImpl;
import oracle.supercluster.resources.SclcMsgID;

public class GOSServerImpl
extends UnicastRemoteObject
implements EONSControl,
SniperVictim {
    private static String s_registryURL;
    private static EONSControl s_instance;
    private Logger m_logger;
    private SCDiscoveryServer m_dserver;

    private GOSServerImpl(InetAddress bindAddr, int port) throws RemoteException, DiscoveryServerException {
        try {
            String logDir = ClusterFactoryImpl.getInstance().getLogDirectory();
            SCFileHandler handler = new SCFileHandler(logDir);
            this.m_logger = Logger.getLogger("oracle.supercluster");
            this.m_dserver = CommonFactoryImpl.getInstance().createDiscoveryServer(bindAddr, port);
        }
        catch (IOException e) {
            DiscoveryServerException disExp = new DiscoveryServerException(MessageBundle.getMessage((MessageKey)SclcMsgID.LOGGER_CONFIG_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.GOSSIPSERVER.toString(), bindAddr.getHostAddress() + " " + String.valueOf(port)}), (Throwable)e);
            if (this.m_logger != null) {
                this.m_logger.severe(e.getMessage());
                this.m_logger.severe(disExp.getMessage());
            } else {
                Trace.out((Exception)e);
            }
            throw disExp;
        }
        catch (SoftwareModuleException e) {
            DiscoveryServerException disExp = new DiscoveryServerException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_START_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.GOSSIPSERVER.toString(), bindAddr.getHostAddress() + " " + String.valueOf(port)}), (Throwable)e);
            this.m_logger.severe(e.getMessage());
            this.m_logger.severe(disExp.getMessage());
            throw disExp;
        }
        catch (SCTierException e) {
            DiscoveryServerException disExp = new DiscoveryServerException(MessageBundle.getMessage((MessageKey)SclcMsgID.LOGGER_CONFIG_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.GOSSIPSERVER.toString()}), (Throwable)e);
            throw disExp;
        }
    }

    static synchronized EONSControl createInstance(InetAddress bindAddr, int port) throws RemoteException, DiscoveryServerException {
        if (null == s_instance) {
            try {
                s_instance = GOSServerImpl.getInstance(port);
            }
            catch (RemoteException e) {
                Trace.out((String)("IGNORED:" + e.getMessage()));
            }
        }
        if (null == s_instance) {
            try {
                s_instance = new GOSServerImpl(bindAddr, port);
                LocateRegistry.createRegistry(GOSServerImpl.getRegistryPort(port));
                if (null == s_registryURL) {
                    s_registryURL = GOSServerImpl.getRegistryURL(port);
                }
                Trace.out((String)("binding to registry=" + s_registryURL));
                Naming.rebind(s_registryURL, s_instance);
                s_instance = (EONSControl)Naming.lookup(s_registryURL);
                Trace.out((String)("s_instance found from registry =" + s_instance));
            }
            catch (NotBoundException e) {
                Trace.out((String)("IGNORED:" + e.getMessage()));
            }
            catch (MalformedURLException e) {
                Trace.out((String)("IGNORED" + e.getMessage()));
            }
        }
        return s_instance;
    }

    static synchronized EONSControl getInstance(int port) throws RemoteException, DiscoveryServerException {
        try {
            if (null == s_registryURL) {
                s_registryURL = GOSServerImpl.getRegistryURL(port);
            }
            return (EONSControl)Naming.lookup(s_registryURL);
        }
        catch (MalformedURLException e) {
            Trace.out((String)e.getMessage());
            throw new DiscoveryServerException((Throwable)e);
        }
        catch (NotBoundException e) {
            Trace.out((String)e.getMessage());
            throw new RemoteException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_NOT_RUNNING, (boolean)true, (Object[])new Object[]{ResourceLiterals.GOSSIPSERVER.toString()}), e);
        }
        catch (AccessException e) {
            Trace.out((String)e.getMessage());
            throw new DiscoveryServerException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_NOT_RUNNING, (boolean)true, (Object[])new Object[]{ResourceLiterals.GOSSIPSERVER.toString()}), (Throwable)e);
        }
    }

    @Override
    public void start() throws RemoteException {
        try {
            this.m_dserver.start();
        }
        catch (DiscoveryServerException e) {
            this.m_logger.severe(e.getMessage());
            throw new RemoteException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_START_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.GOSSIPSERVER.toString()}), e);
        }
    }

    @Override
    public boolean status() throws RemoteException {
        try {
            return this.m_dserver.status();
        }
        catch (DiscoveryServerException e) {
            this.m_logger.severe(e.getMessage());
            throw new RemoteException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_STAT_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.GOSSIPSERVER.toString()}), e);
        }
    }

    @Override
    public void stop() throws RemoteException {
        try {
            Naming.unbind(s_registryURL);
        }
        catch (NotBoundException e) {
            this.m_logger.info("IGNORE:" + e.getMessage());
        }
        catch (MalformedURLException e) {
            this.m_logger.info("IGNORE:" + e.getMessage());
        }
        try {
            this.m_dserver.stop();
        }
        catch (DiscoveryServerException e) {
            this.m_logger.severe(e.getMessage());
            throw new RemoteException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_STOP_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.GOSSIPSERVER.toString()}), e);
        }
        this.m_logger.info("Stopped DiscoveryServer");
        new Timer().schedule((TimerTask)new Sniper(this), 1000L);
    }

    @Override
    public void shoot() {
        this.m_dserver = null;
        s_instance = null;
        System.exit(0);
    }

    private static int getRegistryPort(int port) {
        return port + 1;
    }

    private static String getRegistryURL(int port) {
        String serverName;
        try {
            serverName = Cluster.getHostName();
        }
        catch (ClusterException e) {
            try {
                serverName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                Trace.out((String)("IGNORED:" + uhe.getMessage()));
                serverName = "localhost";
            }
        }
        String url = "//" + serverName + ':' + GOSServerImpl.getRegistryPort(port) + "/oracle.supercluster.impl.cluster.GOSServerImpl";
        Trace.out((String)("DiscoveryServer url=" + url));
        return url;
    }

    public static void main(String[] args) {
        int status;
        Logger logger = Logger.getLogger("oracle.supercluster");
        try {
            EONSControl server = ClusterFactoryImpl.getInstance().createGossipServer();
            server.start();
            status = 0;
        }
        catch (SoftwareModuleException e) {
            logger.severe(e.toString());
            status = 1;
        }
        catch (NotExistsException e) {
            logger.severe(e.toString());
            status = 1;
        }
        catch (DiscoveryServerException e) {
            logger.severe(e.toString());
            status = 1;
        }
        catch (RemoteException e) {
            logger.severe(e.toString());
            status = 1;
        }
        logger.info("Discovery Server status=" + status);
        if (status != 0) {
            System.exit(status);
        }
    }
}

