/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.cluster;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.nodeapps.EONSException;
import oracle.cluster.util.NotExistsException;
import oracle.eons.ONS;
import oracle.eons.ONSFactory;
import oracle.eons.ProxyListener;
import oracle.eons.TierDiscoveryInfo;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.rawdevice.OCR;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.trace.Trace;
import oracle.supercluster.cluster.SCFileHandler;
import oracle.supercluster.common.SCTierException;
import oracle.supercluster.impl.cluster.ClusterFactoryImpl;
import oracle.supercluster.impl.cluster.EONSControl;
import oracle.supercluster.impl.cluster.Sniper;
import oracle.supercluster.impl.cluster.SniperVictim;
import oracle.supercluster.resources.SclcMsgID;

class EONSServerImpl
extends UnicastRemoteObject
implements EONSControl,
SniperVictim {
    private static EONSControl s_instance;
    private static String s_registryURL;
    private static Logger s_logger;
    private Logger m_logger;
    private ProxyListener m_proxyListener;
    private StatusListener m_statusListener;
    private static String STATUS_EONS_MSG;
    private static String UP_EONS_MSG;
    private static String DOWN_EONS_MSG;
    private static String INVALID_EONS_MSG;
    private static int MSG_LEN;

    private EONSServerImpl(TierDiscoveryInfo tdiInfo, ONS.TierName tierName, int proxyPort) throws RemoteException, EONSException, SoftwareModuleException {
        try {
            String logDir = ClusterFactoryImpl.getInstance().getLogDirectory();
            SCFileHandler handler = new SCFileHandler(logDir);
            this.m_logger = Logger.getLogger("oracle.supercluster");
            this.m_logger.info("Tier Properties: " + tdiInfo.getTierProperties());
            if (TierDiscoveryInfo.DiscoveryType.MULTICAST == tdiInfo.getDiscoveryType()) {
                this.m_logger.info("Bind address: " + tdiInfo.getBindAddr());
                this.m_logger.info("Multicast address: " + tdiInfo.getMulticastAddr());
            }
            this.m_proxyListener = ONSFactory.createLazyProxy((TierDiscoveryInfo)tdiInfo, (ONS.TierName)tierName, (int)proxyPort);
            this.m_proxyListener.start();
        }
        catch (IOException ioe) {
            this.throwEonsException((MessageKey)SclcMsgID.SERVER_START_FAILED, ioe, proxyPort, tdiInfo.toString());
        }
        catch (SCTierException e) {
            this.throwEonsException((MessageKey)SclcMsgID.LOGGER_CONFIG_FAILED, (Exception)((Object)e), proxyPort, tdiInfo.toString());
        }
        try {
            this.m_logger.log(Level.INFO, "starting the status listener");
            this.m_statusListener = new StatusListener();
            if (!this.m_statusListener.createPortFile()) {
                this.throwEonsException((MessageKey)SclcMsgID.PORT_FILE_FAILED, null, proxyPort, tdiInfo.toString());
            }
            this.m_statusListener.start();
        }
        catch (IOException ioe) {
            this.m_proxyListener.shutdown();
            this.throwEonsException((MessageKey)SclcMsgID.STATUS_LISTENER_FAILED, ioe, proxyPort, tdiInfo.toString());
        }
        catch (UtilException ue) {
            this.m_proxyListener.shutdown();
            this.throwEonsException((MessageKey)SclcMsgID.STATUS_LISTENER_FAILED, (Exception)((Object)ue), proxyPort, tdiInfo.toString());
        }
        catch (ClusterUtilException cue) {
            this.m_proxyListener.shutdown();
            this.throwEonsException((MessageKey)SclcMsgID.STATUS_LISTENER_FAILED, (Exception)((Object)cue), proxyPort, tdiInfo.toString());
        }
        catch (OCRException oe) {
            this.m_proxyListener.shutdown();
            this.throwEonsException((MessageKey)SclcMsgID.STATUS_LISTENER_FAILED, (Exception)((Object)oe), proxyPort, tdiInfo.toString());
        }
    }

    private void throwEonsException(MessageKey key, Exception e, int proxyPort, String tdiInfo) throws EONSException {
        EONSException eonsExp = new EONSException(key, (Throwable)e, new Object[]{ResourceLiterals.EONS.toString(), String.valueOf(proxyPort) + " " + tdiInfo});
        if (this.m_logger != null) {
            if (e != null) {
                this.m_logger.severe(e.getMessage());
            }
            this.m_logger.severe(eonsExp.getMessage());
        } else {
            Trace.out((Exception)e);
        }
        throw eonsExp;
    }

    static synchronized EONSControl createInstance(TierDiscoveryInfo tierInfo, ONS.TierName tierName, int port) throws RemoteException, EONSException {
        if (null == s_instance) {
            try {
                s_instance = EONSServerImpl.getInstance(port);
            }
            catch (RemoteException e) {
                s_logger.severe("IGNORED:" + e.getMessage());
            }
            catch (NotExistsException e) {
                s_logger.severe("IGNORED:" + e.getMessage());
            }
        }
        if (null == s_instance) {
            try {
                s_instance = new EONSServerImpl(tierInfo, tierName, port);
                LocateRegistry.createRegistry(ClusterFactoryImpl.getInstance().getEONSRegistryPort(port));
                s_logger.info("binding to registry=" + s_registryURL);
                Naming.rebind(s_registryURL, s_instance);
                s_instance = (EONSControl)Naming.lookup(s_registryURL);
                s_logger.info("s_instance found from registry =" + s_instance);
            }
            catch (SoftwareModuleException e) {
                s_logger.severe(e.getMessage());
                throw new EONSException((Throwable)e);
            }
            catch (NotBoundException e) {
                s_logger.severe("IGNORED:" + e.getMessage());
            }
            catch (MalformedURLException e) {
                s_logger.severe("IGNORED" + e.getMessage());
            }
        }
        return s_instance;
    }

    static synchronized EONSControl getInstance(int port) throws NotExistsException, RemoteException, EONSException {
        try {
            if (null == s_registryURL) {
                s_registryURL = ClusterFactoryImpl.getInstance().getEONSRegistryURL(port);
            }
            return (EONSControl)Naming.lookup(s_registryURL);
        }
        catch (SoftwareModuleException e) {
            s_logger.severe(e.toString());
            throw new EONSException((Throwable)e);
        }
        catch (MalformedURLException e) {
            s_logger.severe(e.toString());
            throw new EONSException((Throwable)e);
        }
        catch (NotBoundException e) {
            s_logger.severe(e.toString());
            throw new RemoteException(MessageBundle.getMessage((MessageKey)SclcMsgID.SERVER_NOT_RUNNING, (boolean)true, (Object[])new Object[]{ResourceLiterals.EONS.toString()}), e);
        }
    }

    @Override
    public void start() throws RemoteException {
        try {
            if (!this.status()) {
                this.m_proxyListener.start();
            }
        }
        catch (IOException e) {
            this.m_logger.severe(e.getMessage());
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public boolean status() throws RemoteException {
        return this.m_proxyListener.isRunning();
    }

    @Override
    public void stop() throws RemoteException {
        try {
            Naming.unbind(s_registryURL);
        }
        catch (NotBoundException e) {
            this.m_logger.info("IGNORED" + e.getMessage());
        }
        catch (MalformedURLException e) {
            this.m_logger.info("IGNORED" + e.getMessage());
        }
        this.m_proxyListener.shutdown();
        this.m_logger.info("Stopped EONSServer");
        new Timer().schedule((TimerTask)new Sniper(this), 1000L);
    }

    @Override
    public void shoot() {
        s_instance = null;
        System.exit(0);
    }

    public static void main(String[] args) {
        int status;
        try {
            EONSControl server = ClusterFactoryImpl.getInstance().createEONSServer();
            server.start();
            status = 0;
        }
        catch (SoftwareModuleException e) {
            s_logger.severe(e.toString());
            status = 1;
        }
        catch (RemoteException e) {
            s_logger.severe(e.toString());
            status = 1;
        }
        s_logger.info("eONS server status=" + status);
        if (status != 0) {
            System.exit(status);
        }
    }

    static {
        STATUS_EONS_MSG = "check_eons";
        UP_EONS_MSG = "up_eons";
        DOWN_EONS_MSG = "down_eons";
        INVALID_EONS_MSG = "invalid";
        MSG_LEN = 64;
        s_logger = Logger.getLogger("oracle.supercluster");
    }

    class StatusListener
    extends Thread {
        int m_port;
        ServerSocket m_serverSocket = new ServerSocket(0);

        StatusListener() throws IOException {
            this.m_port = this.m_serverSocket.getLocalPort();
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean createPortFile() throws IOException, UtilException, ClusterUtilException, OCRException {
            String nodename;
            Util utl = new Util();
            String dirName = utl.getCRSHome() + File.separator + "eons" + File.separator + "init";
            File portDir = new File(dirName);
            if (!portDir.exists()) {
                EONSServerImpl.this.m_logger.info(dirName + " does not exist");
                if (!portDir.mkdirs() && !portDir.exists()) {
                    EONSServerImpl.this.m_logger.warning("Failed to create directory " + dirName);
                    return false;
                }
                EONSServerImpl.this.m_logger.info("created directory " + dirName);
            } else {
                EONSServerImpl.this.m_logger.info(dirName + " exists");
            }
            if (OCR.isCluster()) {
                ClusterUtil clusterUtil = new ClusterUtil();
                nodename = clusterUtil.getLocalNodeName();
            } else {
                nodename = utl.getLocalHostName();
            }
            String fileName = utl.getCRSHome() + File.separator + "eons" + File.separator + "init" + File.separator + "eons_" + nodename;
            File portFile = new File(fileName);
            if (!portFile.exists()) {
                EONSServerImpl.this.m_logger.log(Level.INFO, fileName + " does not exist");
                if (!portFile.createNewFile()) {
                    EONSServerImpl.this.m_logger.warning("Failed to create file " + fileName);
                    return false;
                }
                EONSServerImpl.this.m_logger.info("created file " + fileName);
            } else {
                EONSServerImpl.this.m_logger.info(fileName + " exists");
            }
            FileWriter fw = new FileWriter(portFile);
            fw.write(new Integer(this.m_port).toString());
            fw.flush();
            return true;
        }

        @Override
        public void run() {
            Socket s = null;
            OutputStream os = null;
            InputStream is = null;
            if (EONSServerImpl.this.m_logger != null) {
                EONSServerImpl.this.m_logger.info("starting the status listener at " + this.m_port);
            } else {
                Trace.out((String)("starting the status listener at " + this.m_port));
            }
            while (true) {
                try {
                    while (true) {
                        int nb;
                        s = this.m_serverSocket.accept();
                        os = s.getOutputStream();
                        is = s.getInputStream();
                        byte[] buf = new byte[MSG_LEN];
                        String request = new String(buf, 0, nb = is.read(buf));
                        String status = request.equals(STATUS_EONS_MSG) ? (EONSServerImpl.this.m_proxyListener.isRunning() ? UP_EONS_MSG : DOWN_EONS_MSG) : INVALID_EONS_MSG;
                        os.write(status.getBytes());
                        s.close();
                    }
                }
                catch (IOException e) {
                    if (EONSServerImpl.this.m_logger != null) {
                        EONSServerImpl.this.m_logger.severe(e.getMessage());
                    } else {
                        Trace.out((Exception)e);
                    }
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

