/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.cluster;

import java.rmi.RemoteException;
import java.util.Map;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.nodeapps.EONS;
import oracle.cluster.nodeapps.EONSException;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.security.NullSecurityManager;
import oracle.ops.mgmt.trace.Trace;
import oracle.supercluster.impl.cluster.ClusterFactoryImpl;
import oracle.supercluster.impl.cluster.CommandLineParser;
import oracle.supercluster.impl.cluster.EONSControl;
import oracle.supercluster.impl.cluster.SCRCTL;
import oracle.supercluster.resources.SclcMsgID;

public class EONSCTL {
    private EONS m_eons;

    private EONSCTL() throws EONSException {
        Trace.out((String)"get EONS resource from CRS");
        try {
            this.m_eons = NodeAppsFactory.getInstance().getEONS();
        }
        catch (SoftwareModuleException e) {
            throw new EONSException((Throwable)e);
        }
        catch (NotExistsException e) {
            throw new EONSException((Throwable)e);
        }
    }

    void start() throws EONSException {
        try {
            if (this.status()) {
                Trace.out((String)"EONSServer is currently running");
                return;
            }
        }
        catch (EONSException eONSException) {
            // empty catch block
        }
        Trace.out((String)"starting the EONSServer");
        Util utl = null;
        try {
            int i = 0;
            Trace.out((String)"Get properties from eons resource");
            Map propsMap = this.m_eons.properties();
            utl = new Util();
            String crsHome = utl.getCRSHome();
            String[] inputList = propsMap.size() == 0 ? new String[3] : new String[3 + propsMap.size()];
            inputList[i++] = CommandLineParser.CommandOption.Start.toString();
            inputList[i++] = ResourceLiterals.EONS.toString();
            inputList[i++] = "daemon";
            for (String key : propsMap.keySet()) {
                inputList[i++] = ResourceLiterals.JAVA_PROP_PREFIX.toString() + key.trim() + "=" + ((String)propsMap.get(key)).trim();
            }
            String scrctl = crsHome + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.SCRCTL_SCRIPT.toString();
            NullSecurityManager daemonSecurity = new NullSecurityManager();
            System.setSecurityManager((SecurityManager)daemonSecurity);
            if (Trace.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder(scrctl);
                for (String input : inputList) {
                    sb.append(" " + input);
                }
                Trace.out((String)("makeDaemon=" + sb.toString()));
            }
            utl.makeDaemon(scrctl, inputList, null);
        }
        catch (SoftwareModuleException e) {
            Trace.out((Exception)((Object)e));
            throw new EONSException((MessageKey)SclcMsgID.SERVER_START_FAILED, (Throwable)e, new Object[]{ResourceLiterals.EONS.toString()});
        }
        catch (UtilException e) {
            Trace.out((Exception)((Object)e));
            throw new EONSException((MessageKey)SclcMsgID.SERVER_START_FAILED, (Throwable)e, new Object[]{ResourceLiterals.EONS.toString()});
        }
        finally {
            if (utl != null) {
                try {
                    utl.destroy();
                }
                catch (UtilException e) {
                    Trace.out((Exception)((Object)e));
                }
            }
        }
    }

    void stop() throws EONSException {
        EONSControl server = null;
        try {
            server = ClusterFactoryImpl.getInstance().getEONSServer(this.m_eons);
            Trace.out((String)"Stopping EONSServer");
            server.stop();
        }
        catch (SoftwareModuleException e) {
            throw new EONSException((MessageKey)SclcMsgID.SERVER_STOP_FAILED, (Throwable)e, new Object[]{ResourceLiterals.EONS.toString()});
        }
        catch (NotExistsException e) {
            throw new EONSException((MessageKey)SclcMsgID.SERVER_STOP_FAILED, (Throwable)e, new Object[]{ResourceLiterals.EONS.toString()});
        }
        catch (RemoteException e) {
            Trace.out((Exception)e);
            if (server != null) {
                throw new EONSException((MessageKey)SclcMsgID.SERVER_STOP_FAILED, (Throwable)e, new Object[]{ResourceLiterals.EONS.toString()});
            }
            throw new EONSException((MessageKey)SclcMsgID.SERVER_NOT_RUNNING, (Throwable)e, new Object[]{ResourceLiterals.EONS.toString()});
        }
    }

    boolean status() throws EONSException {
        EONSControl server = null;
        Trace.out((String)"Getting the status of the EONSServer");
        try {
            server = ClusterFactoryImpl.getInstance().getEONSServer(this.m_eons);
            return server.status();
        }
        catch (SoftwareModuleException e) {
            throw new EONSException((MessageKey)SclcMsgID.SERVER_STAT_FAILED, (Throwable)e, new Object[]{ResourceLiterals.EONS.toString()});
        }
        catch (NotExistsException e) {
            throw new EONSException((MessageKey)SclcMsgID.SERVER_STAT_FAILED, (Throwable)e, new Object[]{ResourceLiterals.EONS.toString()});
        }
        catch (RemoteException e) {
            if (server != null) {
                throw new EONSException((MessageKey)SclcMsgID.SERVER_STAT_FAILED, (Throwable)e, new Object[]{ResourceLiterals.EONS.toString()});
            }
            throw new EONSException((MessageKey)SclcMsgID.SERVER_NOT_RUNNING, (Throwable)e, new Object[]{ResourceLiterals.EONS.toString()});
        }
    }

    public static void main(String[] args) {
        boolean stat;
        block13: {
            stat = false;
            try {
                CommandLineParser.CommandOption cmdOpt = new CommandLineParser(args).getCommandOption();
                if (CommandLineParser.CommandOption.Start.equals((Object)cmdOpt) || CommandLineParser.CommandOption.Stop.equals((Object)cmdOpt) || CommandLineParser.CommandOption.Status.equals((Object)cmdOpt)) {
                    EONSCTL ctl = new EONSCTL();
                    if (CommandLineParser.CommandOption.Start.equals((Object)cmdOpt)) {
                        ctl.start();
                        for (int i = 0; i < 10; ++i) {
                            Trace.out((String)("EONS start status attempt = " + (i + 1)));
                            try {
                                try {
                                    Thread.currentThread();
                                    Thread.sleep((i + 1) * 1000);
                                }
                                catch (InterruptedException e) {
                                    Trace.out((String)("IGNORE: " + e.getMessage()));
                                }
                                stat = ctl.status();
                                if (!stat) continue;
                                break block13;
                            }
                            catch (EONSException e) {
                                Trace.out((String)("IGNORE: " + e.getMessage()));
                            }
                        }
                        break block13;
                    }
                    if (CommandLineParser.CommandOption.Stop.equals((Object)cmdOpt)) {
                        ctl.stop();
                        stat = true;
                    } else if (CommandLineParser.CommandOption.Status.equals((Object)cmdOpt)) {
                        stat = ctl.status();
                    }
                    break block13;
                }
                System.out.println(SCRCTL.usage());
                System.exit(0);
            }
            catch (IllegalArgumentException e) {
                System.out.println(e.getMessage());
                System.out.println(SCRCTL.usage());
            }
            catch (EONSException e) {
                System.out.println(e.getMessage());
                Trace.out((String)("INFO: " + (Object)((Object)e)));
            }
        }
        Trace.out((String)("EONS command status =" + stat));
        System.exit(stat ? 0 : 1);
    }
}

