/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.cluster;

import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.util.Utils;
import oracle.supercluster.resources.SclcMsgID;

public class CommandLineParser {
    private CommandOption m_cmdOpt;

    public CommandLineParser(String[] args) throws IllegalArgumentException {
        if (args.length == 0) {
            throw new IllegalArgumentException(MessageBundle.getMessage((MessageKey)SclcMsgID.NO_ARGS, (boolean)false, (Object[])new Object[]{ResourceLiterals.SCRCTL_SCRIPT.toString()}));
        }
        if (args.length > 1) {
            throw new IllegalArgumentException(Utils.getString((String[])args, (String)","));
        }
        this.m_cmdOpt = CommandOption.getOption(args[0]);
    }

    public CommandOption getCommandOption() {
        return this.m_cmdOpt;
    }

    public static enum CommandOption {
        Start("start"),
        Stop("stop"),
        Status("status"),
        Help0("help"),
        Help1("-h"),
        Help2("?");

        private String m_value;

        private CommandOption(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }

        public static CommandOption getOption(String value) throws IllegalArgumentException {
            for (CommandOption cmdOpt : CommandOption.values()) {
                if (!cmdOpt.toString().equalsIgnoreCase(value)) continue;
                return cmdOpt;
            }
            throw new IllegalArgumentException(MessageBundle.getMessage((MessageKey)SclcMsgID.ILLEGAL_ARG, (boolean)false, (Object[])new Object[]{value}));
        }

        public static String getSyntaxOptions() {
            return Start.toString() + "|" + Stop.toString() + "|" + Status.toString();
        }
    }
}

