/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.impl.cluster;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import oracle.cluster.common.ClusterException;
import oracle.cluster.common.CommonFactory;
import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.CardinalityException;
import oracle.cluster.crs.NoVersionAvailableException;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.impl.scan.ScanVIPImpl;
import oracle.cluster.nodeapps.EONS;
import oracle.cluster.nodeapps.EONSException;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.scan.ScanFactory;
import oracle.cluster.scan.ScanVIP;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.PortException;
import oracle.eons.ONS;
import oracle.eons.ONSFactory;
import oracle.eons.TierDiscoveryInfo;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.supercluster.cluster.GossipServerResource;
import oracle.supercluster.cluster.GossipServerResourceException;
import oracle.supercluster.cluster.SCRDResource;
import oracle.supercluster.cluster.SCRDResourceException;
import oracle.supercluster.common.ClusterTier;
import oracle.supercluster.common.DiscoveryServerException;
import oracle.supercluster.common.SCDiscoveryMethod;
import oracle.supercluster.common.SCDiscoveryServer;
import oracle.supercluster.common.SCRException;
import oracle.supercluster.common.SCTier;
import oracle.supercluster.common.SCTierException;
import oracle.supercluster.common.SuperCluster;
import oracle.supercluster.impl.cluster.EONSControl;
import oracle.supercluster.impl.cluster.EONSServerImpl;
import oracle.supercluster.impl.cluster.GOSServerImpl;
import oracle.supercluster.impl.cluster.GossipServerResourceImpl;
import oracle.supercluster.impl.cluster.SCRDResourceImpl;
import oracle.supercluster.impl.cluster.SCRServerImpl;
import oracle.supercluster.impl.cluster.SCTierImpl;
import oracle.supercluster.resources.SclcMsgID;

public class ClusterFactoryImpl {
    private static ClusterFactoryImpl s_instance;
    private static InetAddress s_mcAddress;
    private static String s_mcPort;
    private static String CRS_DEVELOPER_ENV;

    private ClusterFactoryImpl() throws SoftwareModuleException {
    }

    public static synchronized ClusterFactoryImpl getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new ClusterFactoryImpl();
        }
        return s_instance;
    }

    public GossipServerResource createGossipServerResource(String port, Map<String, String> map, Version version) throws AlreadyExistsException, GossipServerResourceException {
        try {
            List sVIPList = ScanFactory.getInstance().getScanVIPs();
            if (sVIPList.size() > 0) {
                return this.createGossipServerResource((ScanVIP)sVIPList.get(0), String.valueOf(port), map, version);
            }
            throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, GossipServerResourceImpl.getResourceName(), ResourceLiterals.GOSSIPSERVER.toString(), MessageBundle.getMessage((MessageKey)PrCrMsgID.RES_NOT_EXISTS, (boolean)false, (Object[])new Object[]{ScanVIPImpl.getResourceName((int)1, (int)1)}));
        }
        catch (SoftwareModuleException e) {
            throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, e, GossipServerResourceImpl.getResourceName(), ResourceLiterals.GOSSIPSERVER.toString());
        }
        catch (NotExistsException e) {
            throw new GossipServerResourceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, e, GossipServerResourceImpl.getResourceName(), ResourceLiterals.GOSSIPSERVER.toString());
        }
    }

    public GossipServerResource createGossipServerResource(ScanVIP sVIP, String port, Map<String, String> map, Version version) throws AlreadyExistsException, GossipServerResourceException {
        try {
            GossipServerResourceImpl gsrImpl = new GossipServerResourceImpl(CRSFactoryImpl.getInstance().create(ResourceType.GossipServer.NAME.name(), GossipServerResourceImpl.getResourceName()));
            gsrImpl.create(sVIP, port, map, version);
            return gsrImpl;
        }
        catch (SoftwareModuleException e) {
            throw new GossipServerResourceException(e);
        }
        catch (CRSException e) {
            throw new GossipServerResourceException(e);
        }
    }

    public GossipServerResource getGossipServerResource() throws NotExistsException, GossipServerResourceException {
        try {
            GossipServerResourceImpl gsrImpl = new GossipServerResourceImpl(CRSFactoryImpl.getInstance().create(ResourceType.GossipServer.NAME.name(), GossipServerResourceImpl.getResourceName()));
            CRSResource crsRes = gsrImpl.crsResource();
            return gsrImpl;
        }
        catch (CRSException e) {
            throw new GossipServerResourceException(e);
        }
        catch (SoftwareModuleException e) {
            throw new GossipServerResourceException(e);
        }
    }

    public SCRDResource createSCRDResource(String tierName, String port, SCDiscoveryMethod discoveryMethod, InetAddress mcastAddress, String mcastPort, Map<String, Integer> mbrList, Map<String, String> map, Version version) throws AlreadyExistsException, SCRDResourceException {
        try {
            SCRDResourceImpl scrdImpl = new SCRDResourceImpl(CRSFactoryImpl.getInstance().create(ResourceType.SuperCluster.NAME.name(), SCRDResourceImpl.getResourceName()));
            scrdImpl.create(tierName, port, discoveryMethod, mcastAddress, mcastPort, mbrList, map, version);
            return scrdImpl;
        }
        catch (SoftwareModuleException e) {
            throw new SCRDResourceException(e);
        }
        catch (CRSException e) {
            throw new SCRDResourceException(e);
        }
    }

    public SCRDResource getSCRDResource() throws NotExistsException, SCRDResourceException {
        try {
            SCRDResourceImpl scrdImpl = new SCRDResourceImpl(CRSFactoryImpl.getInstance().create(ResourceType.SuperCluster.NAME.name(), SCRDResourceImpl.getResourceName()));
            CRSResource crsRes = scrdImpl.crsResource();
            return scrdImpl;
        }
        catch (CRSException e) {
            throw new SCRDResourceException(e);
        }
        catch (SoftwareModuleException e) {
            throw new SCRDResourceException(e);
        }
    }

    EONSControl createEONSServer() throws EONSException {
        try {
            TierDiscoveryInfo tierInfo = this.getTierDiscoveryInfo(true);
            ONS.TierName tierName = this.getTierName(true);
            int port = Integer.parseInt(ResourceType.getAgentGenEnv((String)ResourceType.EONS.PORT.name()));
            Trace.out((String)("eONS port=" + port));
            return EONSServerImpl.createInstance(tierInfo, tierName, port);
        }
        catch (NumberFormatException e) {
            throw new EONSException((MessageKey)SclcMsgID.GET_CLUSTER_TIER_FAILED, (Throwable)e, new Object[]{e});
        }
        catch (SCTierException e) {
            throw new EONSException((MessageKey)SclcMsgID.GET_CLUSTER_TIER_FAILED, (Throwable)e, new Object[]{e});
        }
        catch (RemoteException e) {
            throw new EONSException((MessageKey)SclcMsgID.GET_CLUSTER_TIER_FAILED, (Throwable)e, new Object[]{e});
        }
    }

    EONSControl getEONSServer(EONS eonsRes) throws NotExistsException, RemoteException, EONSException {
        int port;
        try {
            port = eonsRes.tier().port();
        }
        catch (SCTierException e) {
            throw new EONSException((Throwable)e);
        }
        return EONSServerImpl.getInstance(port);
    }

    EONSControl createSCRServer() throws NotExistsException, SCRException {
        try {
            EONS eons = NodeAppsFactory.getInstance().getEONS();
            ClusterTier htier = eons.tier();
            TierDiscoveryInfo htierInfo = this.getTierDiscoveryInfo((SCTier)htier);
            SCRDResource scr = this.getSCRDResource();
            Version version = scr.version();
            SuperCluster vtier = scr.tier();
            TierDiscoveryInfo vtierInfo = this.getTierDiscoveryInfo((SCTier)vtier);
            ONS.TierName tierName = this.getTierName((SCTier)vtier);
            return SCRServerImpl.createInstance(htierInfo, vtierInfo, tierName, vtier.port(), scr.getMaxCardinality(), oracle.supercluster.common.Version.getVersion(), ((ScanVIP)ScanFactory.getInstance().getScanVIPs().get(0)).getScanName());
        }
        catch (SoftwareModuleException e) {
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_CLUSTER_TIER_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)e);
        }
        catch (NoVersionAvailableException e) {
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_CLUSTER_TIER_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)e);
        }
        catch (CardinalityException e) {
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_CLUSTER_TIER_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)e);
        }
        catch (SCTierException e) {
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_CLUSTER_TIER_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)e);
        }
        catch (RemoteException e) {
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_CLUSTER_TIER_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)e);
        }
    }

    EONSControl getSCRServer() throws NotExistsException, RemoteException, SCRException {
        try {
            return SCRServerImpl.getInstance(this.getSCRDResource().tier().port());
        }
        catch (SCRDResourceException e) {
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_CLUSTER_TIER_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)((Object)e));
        }
        catch (SCTierException e) {
            throw new SCRException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_CLUSTER_TIER_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.SUPERCLUSTER.toString()}), (Throwable)e);
        }
    }

    EONSControl createGossipServer() throws NotExistsException, DiscoveryServerException {
        try {
            GossipServerResourceImpl gsrImpl = (GossipServerResourceImpl)this.getGossipServerResource();
            return GOSServerImpl.createInstance(gsrImpl.scanVIP().address(), gsrImpl.port());
        }
        catch (SoftwareModuleException e) {
            throw new DiscoveryServerException(MessageBundle.getMessage((MessageKey)SclcMsgID.CREATE_GOSSIPSERVER_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.GOSSIPSERVER.toString()}), (Throwable)e);
        }
        catch (RemoteException e) {
            throw new DiscoveryServerException(MessageBundle.getMessage((MessageKey)SclcMsgID.CREATE_GOSSIPSERVER_FAILED, (boolean)true, (Object[])new Object[]{ResourceLiterals.GOSSIPSERVER.toString()}), (Throwable)e);
        }
    }

    EONSControl getGossipServer() throws NotExistsException, RemoteException, DiscoveryServerException {
        try {
            GossipServerResourceImpl gsrImpl = (GossipServerResourceImpl)this.getGossipServerResource();
            return GOSServerImpl.getInstance(gsrImpl.port());
        }
        catch (GossipServerResourceException e) {
            throw new DiscoveryServerException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_GOSSIPSERVER_FAILED, (boolean)true, (Object[])new Object[]{e}));
        }
    }

    public SCTierImpl getSCTierImpl(CRSResourceImpl crsResource, boolean isClusterTier) throws SCTierException {
        return new SCTierImpl(crsResource, isClusterTier);
    }

    public String getLogDirectory() throws SCTierException {
        String hostName;
        String crsHome;
        String fsep = File.separator;
        try {
            crsHome = new Util().getCRSHome();
        }
        catch (UtilException e) {
            throw new SCTierException((Throwable)e);
        }
        try {
            hostName = Cluster.getLocalNode();
        }
        catch (oracle.ops.mgmt.cluster.ClusterException e) {
            throw new SCTierException((Throwable)e);
        }
        return crsHome + fsep + "log" + fsep + hostName + fsep + "srvm";
    }

    TierDiscoveryInfo getTierDiscoveryInfo(SCTier tier) throws SCTierException {
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            SCDiscoveryMethod discMethod = tier.discoveryMethod();
            if (discMethod.name().equals(SCDiscoveryMethod.MULTICAST.name())) {
                InetAddress addr = tier.getMulticastAddress();
                int port = tier.getMulticastPort();
                TierDiscoveryInfo result = ONSFactory.createMulticastTierDiscoveryInfo((String)tier.getTierName(), (String)addr.getHostAddress(), (int)port, null, null);
                if (!(!Cluster.isCluster() || osName.equals("aix") || osName.equals("sunos") && Cluster.isVendorCluster())) {
                    String privateIpAddress = (String)CommonFactory.getInstance().getCluster().getPrivateAddresses().get(0);
                    result.setBindAddr(privateIpAddress);
                }
                return result;
            }
            if (discMethod.name().equals(SCDiscoveryMethod.LIST.name())) {
                int port;
                boolean isMbr = false;
                Map mbrMap = tier.memberList();
                ArrayList<String> mbrList = new ArrayList<String>(mbrMap.size());
                String myHost = Cluster.getHostName();
                int myPort = port = tier.port();
                for (String key : mbrMap.keySet()) {
                    if (myHost.equalsIgnoreCase(key)) {
                        myPort = (Integer)mbrMap.get(key);
                        isMbr = true;
                    }
                    mbrList.add(key.trim() + "[" + ((Integer)mbrMap.get(key)).toString() + "]");
                }
                if (!isMbr) {
                    Trace.out((String)(myHost + " is not in " + mbrList.toString() + " picking next port after my listen port =" + port));
                    myPort = port + 1;
                }
                Trace.out((String)("createListTDI args: " + myHost + " " + myPort + " " + mbrList.toString()));
                return ONSFactory.createListTierDiscoveryInfo((String)tier.getTierName(), (String)myHost, (int)myPort, mbrList, null, null);
            }
            if (discMethod.name().equals(SCDiscoveryMethod.GOSSIP_SERVERS.name())) {
                int port;
                List dsList = tier.discoveryServers();
                ArrayList<String> dsAddrList = new ArrayList<String>(dsList.size());
                for (SCDiscoveryServer ds : dsList) {
                    InetAddress addr = ds.address();
                    port = ds.port();
                    dsAddrList.add(addr.getHostAddress() + "[" + port + "]");
                }
                String myHost = Cluster.getHostName();
                port = tier.port();
                return ONSFactory.createGossipTierDiscoveryInfo((String)tier.getTierName(), (String)myHost, (int)port, dsAddrList, null, null);
            }
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TDI_FAILED, (boolean)true, (Object[])new Object[]{tier.getName(), "NOT IMPLEMENTED YET"}));
        }
        catch (ClusterException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TDI_FAILED, (boolean)true, (Object[])new Object[]{tier.getName(), e}), (Throwable)e);
        }
        catch (oracle.ops.mgmt.cluster.ClusterException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TDI_FAILED, (boolean)true, (Object[])new Object[]{tier.getName(), e}), (Throwable)e);
        }
        catch (ManageableEntityException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TDI_FAILED, (boolean)true, (Object[])new Object[]{tier.getName(), e}), (Throwable)e);
        }
        catch (UnknownHostException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TDI_FAILED, (boolean)true, (Object[])new Object[]{tier.getName(), e}), (Throwable)e);
        }
    }

    TierDiscoveryInfo getTierDiscoveryInfo(boolean isClusterTier) throws SCTierException {
        String tierName = this.getTierName(isClusterTier).toString();
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            String discMtd = ResourceType.getAgentGenEnv((String)(isClusterTier ? ResourceType.EONS.DISCOVERY_METHOD.name() : ResourceType.SuperCluster.DISCOVERY_METHOD.name()));
            Trace.out((String)("discMethod=" + discMtd));
            SCDiscoveryMethod discMethod = SCDiscoveryMethod.getEnumMember((String)discMtd);
            String clusterTierName = Cluster.isCluster() ? new ClusterUtil().getClusterName() : InetAddress.getLocalHost().getHostName();
            tierName = isClusterTier ? clusterTierName : ResourceType.getAgentGenEnv((String)ResourceType.SuperCluster.TIER_NAME.name());
            Trace.out((String)("tierName=" + tierName));
            if (discMethod.name().equals(SCDiscoveryMethod.MULTICAST.name())) {
                String mcastAttrVal = ResourceType.getAgentGenEnv((String)(isClusterTier ? ResourceType.EONS.MCAST_ADDRESS.name() : ResourceType.SuperCluster.MCAST_ADDRESS.name()));
                Trace.out((String)("mcastAttrVal=" + mcastAttrVal));
                String addr = ClusterFactoryImpl.getMulticastAddressString(mcastAttrVal);
                int port = ClusterFactoryImpl.getMulticastPort(mcastAttrVal);
                TierDiscoveryInfo result = ONSFactory.createMulticastTierDiscoveryInfo((String)tierName, (String)addr, (int)port, null, null);
                if (!(!Cluster.isCluster() || osName.equals("aix") || osName.equals("sunos") && Cluster.isVendorCluster())) {
                    String privateIpAddress = (String)CommonFactory.getInstance().getCluster().getPrivateAddresses().get(0);
                    result.setBindAddr(privateIpAddress);
                }
                return result;
            }
            if (discMethod.name().equals(SCDiscoveryMethod.LIST.name())) {
                int port;
                boolean isMbr = false;
                String mbrListAttrVal = ResourceType.getAgentGenEnv((String)(isClusterTier ? ResourceType.EONS.MEMBER_LIST.name() : ResourceType.SuperCluster.MEMBER_LIST.name()));
                Map<String, Integer> mbrMap = ClusterFactoryImpl.getMemberList(mbrListAttrVal);
                ArrayList<String> mbrList = new ArrayList<String>(mbrMap.size());
                String myHost = Cluster.getHostName();
                int myPort = port = Integer.parseInt(ResourceType.getAgentGenEnv((String)(isClusterTier ? ResourceType.EONS.PORT.name() : ResourceType.SuperCluster.PORT.name())));
                for (String key : mbrMap.keySet()) {
                    if (myHost.equalsIgnoreCase(key)) {
                        myPort = mbrMap.get(key);
                        isMbr = true;
                    }
                    mbrList.add(key.trim() + "[" + mbrMap.get(key).toString() + "]");
                }
                if (!isMbr) {
                    Trace.out((String)(myHost + " is not in " + mbrList.toString() + " picking next port after my listen port =" + port));
                    myPort = port + 1;
                }
                Trace.out((String)("createListTDI args: " + myHost + " " + myPort + " " + mbrList.toString()));
                return ONSFactory.createListTierDiscoveryInfo((String)tierName, (String)myHost, (int)myPort, mbrList, null, null);
            }
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TDI_FAILED, (boolean)true, (Object[])new Object[]{tierName, "NOT SUPPORTED DISCOVERY METHOD"}));
        }
        catch (NumberFormatException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TDI_FAILED, (boolean)true, (Object[])new Object[]{tierName, e}), (Throwable)e);
        }
        catch (ClusterUtilException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TDI_FAILED, (boolean)true, (Object[])new Object[]{tierName, e}), (Throwable)e);
        }
        catch (oracle.ops.mgmt.cluster.ClusterException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TDI_FAILED, (boolean)true, (Object[])new Object[]{tierName, e}), (Throwable)e);
        }
        catch (PortException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TDI_FAILED, (boolean)true, (Object[])new Object[]{tierName, e}), (Throwable)e);
        }
        catch (UnknownHostException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TDI_FAILED, (boolean)true, (Object[])new Object[]{tierName, e}), (Throwable)e);
        }
        catch (ClusterException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TDI_FAILED, (boolean)true, (Object[])new Object[]{tierName, e}), (Throwable)e);
        }
        catch (ManageableEntityException e) {
            throw new SCTierException(MessageBundle.getMessage((MessageKey)SclcMsgID.GET_TDI_FAILED, (boolean)true, (Object[])new Object[]{tierName, e}), (Throwable)e);
        }
    }

    ONS.TierName getTierName(boolean isClusterTier) {
        return isClusterTier ? ONS.TierName.DB : ONS.TierName.BRIDGE;
    }

    ONS.TierName getTierName(SCTier tier) throws SCTierException {
        return this.getTierName(tier.isClusterTier());
    }

    int getEONSRegistryPort(int port) throws EONSException {
        return port + 1;
    }

    String getEONSRegistryURL(int port) throws NotExistsException, EONSException {
        try {
            int registryPort = this.getEONSRegistryPort(port);
            String hostname = Cluster.getHostName();
            String os = System.getProperty("os.name").toLowerCase();
            String developerEnv = System.getenv(CRS_DEVELOPER_ENV);
            String url = os.indexOf("win") >= 0 && developerEnv == null ? "//" + hostname + "/oracle.supercluster.impl.cluster.EONSServerImpl" : "//" + hostname + ':' + String.valueOf(registryPort) + "/oracle.supercluster.impl.cluster.EONSServerImpl";
            Trace.out((String)("eonsRegistryURL:" + url));
            return url;
        }
        catch (oracle.ops.mgmt.cluster.ClusterException e) {
            throw new EONSException((Throwable)e);
        }
    }

    protected String getRandomIPMulticastAddr() {
        String MULTI_IP_PREFIX = "234";
        StringBuilder result = new StringBuilder();
        result.append(MULTI_IP_PREFIX);
        Random rd = new Random();
        for (int i = 0; i < 3; ++i) {
            result.append("." + (rd.nextInt(1000) % 254 + 2));
        }
        Trace.out((String)("getRandomIPMulticastAddr:" + result.toString()));
        return result.toString();
    }

    protected int getValidPort() {
        NodeAppsFactoryImpl nodeAppInst;
        int MAX_NUM_OF_TRIALS = 10;
        int runs = 0;
        int port = Integer.parseInt(ResourceLiterals.EONS_MCAST_PORT.toString());
        boolean isValid = false;
        Random rd = new Random();
        try {
            nodeAppInst = NodeAppsFactoryImpl.getInstance();
        }
        catch (SoftwareModuleException ex) {
            Trace.out((String)("Unable to get instance of NodeAppsFactoryImpl to verify multicast port for eONS, with exception:" + ex.toString()));
            return -1;
        }
        while (!isValid && runs <= 10) {
            try {
                ++runs;
                String[] nodeList = Cluster.getNodes();
                nodeAppInst.checkPorts(nodeList, new int[]{port});
            }
            catch (CompositeOperationException ex1) {
                Trace.out((String)("multicast port= " + port + " is not available. Try getting new one"));
                port = rd.nextInt(100000) % 9973 + 15000;
                continue;
            }
            catch (oracle.ops.mgmt.cluster.ClusterException ex2) {
                Trace.out((String)("Unable to verify multicast port for eONS, with exception:" + ex2.toString()));
                break;
            }
            isValid = true;
            break;
        }
        if (!isValid) {
            Trace.out((String)"Exceeded 10 times in getting a valid multicast port for eONS.");
            return -1;
        }
        Trace.out((String)("Use port:" + port + " for eONS multicast."));
        return port;
    }

    public final synchronized InetAddress getMulticastAddress() throws UnknownHostException {
        if (s_mcAddress != null) {
            return s_mcAddress;
        }
        String guid = ONSFactory.createNewGuid();
        Trace.out((String)("guid =" + guid));
        System.setProperty("oracle.farm.guid", guid);
        String mcastAddrStr = null;
        mcastAddrStr = System.getProperty("oracle.ons.multicastaddr");
        if (mcastAddrStr == null) {
            String ipAddr = this.getRandomIPMulticastAddr();
            int defaultPort = this.getValidPort();
            if (defaultPort == -1) {
                return null;
            }
            System.setProperty("oracle.ons.multicastaddr", ipAddr + ":" + defaultPort);
            s_mcAddress = InetAddress.getByName(ipAddr);
            s_mcPort = String.valueOf(defaultPort);
        } else {
            int idx = mcastAddrStr.lastIndexOf(35);
            if (idx == -1) {
                idx = mcastAddrStr.lastIndexOf(58);
            }
            String mcAddr = mcastAddrStr.substring(0, idx);
            s_mcAddress = InetAddress.getByName(mcAddr);
            s_mcPort = mcastAddrStr.substring(idx + 1);
        }
        return s_mcAddress;
    }

    public synchronized int getMulticastPort() throws PortException {
        try {
            if (s_mcPort != null) {
                return Integer.parseInt(s_mcPort);
            }
            Trace.out((String)("MC address =" + this.getMulticastAddress()));
            return Integer.parseInt(s_mcPort);
        }
        catch (UnknownHostException e) {
            throw new PortException((MessageKey)PrCnMsgID.GET_PORT_FAILED, (Throwable)e, new Object[]{s_mcPort});
        }
        catch (NumberFormatException e) {
            throw new PortException((MessageKey)PrCnMsgID.GET_PORT_FAILED, (Throwable)e, new Object[]{s_mcPort});
        }
    }

    public static String getMemberList(Map<String, Integer> mbrList) {
        StringBuilder sb = new StringBuilder();
        for (String key : mbrList.keySet()) {
            if (sb.length() > 0) {
                sb.append(" " + key.trim() + ':' + mbrList.get(key).toString());
                continue;
            }
            sb.append(key.trim() + ':' + mbrList.get(key).toString());
        }
        return sb.toString();
    }

    public static Map<String, Integer> getMemberList(String mbrListAttrValue) throws SCTierException {
        String[] elements = mbrListAttrValue.split("\\s");
        HashMap<String, Integer> mbrMap = new HashMap<String, Integer>(elements.length);
        for (String elem : elements) {
            if (elem.trim().length() == 0) continue;
            String[] nvPairs = elem.split(String.valueOf(':'));
            if (nvPairs.length == 2) {
                mbrMap.put(nvPairs[0].trim(), Integer.valueOf(nvPairs[1].trim()));
                continue;
            }
            throw new SCTierException(MessageBundle.getMessage((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, (boolean)true, (Object[])new Object[]{ResourceType.SuperCluster.MEMBER_LIST.name(), mbrListAttrValue, elem}));
        }
        return mbrMap;
    }

    public static String getMulticastAddress(InetAddress mcAddr, String mcPort) {
        return mcAddr.getHostAddress() + ClusterFactoryImpl.getSeparator() + mcPort;
    }

    public static InetAddress getMulticastAddress(String mcastAttrValue) throws UnknownHostException {
        return InetAddress.getByName(ClusterFactoryImpl.getMulticastAddressString(mcastAttrValue));
    }

    private static String getMulticastAddressString(String mcastAttrValue) {
        String mcAddr = mcastAttrValue;
        int index = mcAddr.lastIndexOf(ClusterFactoryImpl.getSeparator());
        if (index > 0) {
            mcAddr = mcAddr.substring(0, index);
        }
        Trace.out((String)("mcAddr=" + mcAddr));
        return mcAddr;
    }

    public static int getMulticastPort(String mcastAttrValue) throws PortException {
        try {
            String port = mcastAttrValue;
            int index = port.lastIndexOf(ClusterFactoryImpl.getSeparator());
            if (index > 0) {
                port = port.substring(index + 1);
            }
            Trace.out((String)("port=" + port));
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new PortException((MessageKey)PrCnMsgID.GET_PORT_FAILED, (Throwable)e, new Object[]{mcastAttrValue});
        }
    }

    public static final String getSeparator() {
        return String.valueOf(':');
    }

    static {
        s_mcAddress = null;
        s_mcPort = null;
        CRS_DEVELOPER_ENV = "OCR_DEVELOPER_ENV";
    }
}

