/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.cluster;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import oracle.ops.mgmt.trace.Trace;
import oracle.supercluster.cluster.SCMessageFormatter;
import oracle.supercluster.impl.cluster.ClusterFactoryImpl;

public class SCFileHandler
extends Handler {
    public static final int DEFAULT_LOG_FILE_SIZE = 0xA00000;
    public static final int DEFAULT_NUM_LOG_FILES = 3;
    private static final String BASENAME_PROPNAME = "basename";
    private static final String LIMIT_PROPNAME = "limit";
    private static final String COUNT_PROPNAME = "count";
    private static final String APPEND_PROPNAME = "append";
    private static final String SERVER_PROPNAME = "oracle.supercluster.cluster.server";
    private static final String THIS_CLASSPATH = "oracle.supercluster.cluster.SCFileHandler";
    private static final String TRACING_PROPNAME = "tracing";
    private static final String TRACING_LEVEL_PROPNAME = "tracing.level";
    private static final String LOG_FORMATTER = "oracle.suplercluster.cluster.SCFileHandler.formatter";
    private FileHandler m_fileHandler;
    private String m_logDir;

    private Formatter getFormatter(String fmname) {
        String formatterClass = System.getProperty(fmname);
        try {
            if (formatterClass != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(formatterClass);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception ex) {
            Trace.out((String)("error in loading logging formatter class: " + ex.toString()));
        }
        return null;
    }

    public SCFileHandler() throws IOException, SecurityException {
        String logDir = "";
        try {
            logDir = ClusterFactoryImpl.getInstance().getLogDirectory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_logDir = logDir;
        this.setup();
    }

    public SCFileHandler(String logDir) throws IOException, SecurityException {
        this.m_logDir = logDir;
        this.setup();
    }

    private void setup() throws IOException, SecurityException {
        int tracingLvl;
        String name = System.getProperty(SERVER_PROPNAME);
        if (name == null) {
            name = "eonsd";
        } else {
            int index = name.lastIndexOf(46);
            if (index > 0) {
                name = name.substring(index + 1);
            }
        }
        LogManager lmgr = LogManager.getLogManager();
        String pattern = lmgr.getProperty("oracle.supercluster.cluster.SCFileHandler." + name + '.' + BASENAME_PROPNAME);
        if (pattern == null) {
            pattern = lmgr.getProperty("oracle.supercluster.cluster.SCFileHandler.basename");
        }
        if (pattern == null) {
            pattern = name + "_%g.log";
        }
        pattern = this.getPattern(pattern);
        int limit = this.getInt(lmgr, name, LIMIT_PROPNAME, 0xA00000);
        int count = this.getInt(lmgr, name, COUNT_PROPNAME, 3);
        boolean append = this.getBool(lmgr, name, APPEND_PROPNAME);
        boolean tracingOn = Boolean.getBoolean("TRACING.ENABLED");
        if (!tracingOn) {
            tracingOn = this.getBool(lmgr, name, TRACING_PROPNAME);
        }
        if ((tracingLvl = Integer.parseInt(System.getProperty("TRACING.LEVEL", "-1"))) == -1) {
            tracingLvl = this.getInt(lmgr, name, TRACING_LEVEL_PROPNAME, 1);
        }
        if (tracingOn) {
            String traceFile = pattern;
            int index = traceFile.lastIndexOf(File.separator);
            if (index > 0) {
                traceFile = pattern.substring(0, index) + File.separator + name + ".trc";
            }
            Trace.out((String)("trace file is " + traceFile));
            Trace.setMaxLogOutputSize((int)(limit / 1024 * 1024));
            Trace.setMaxLogOutputFiles((int)count);
            Trace.traceEnabled((boolean)tracingOn);
            Trace.setTraceLevel((int)tracingLvl);
            boolean succ = Trace.configure((boolean)true, (boolean)true, (boolean)true, (boolean)true, (String)traceFile, (boolean)true);
            Trace.out((String)("trace configure status=" + succ));
        }
        this.m_fileHandler = new FileHandler(pattern, limit, count, append);
        Formatter formatter = null;
        String formatterName = System.getProperty(LOG_FORMATTER);
        if (formatterName != null) {
            formatter = this.getFormatter(formatterName);
        }
        if (formatter == null) {
            formatter = new SCMessageFormatter();
        }
        this.m_fileHandler.setFormatter(formatter);
    }

    @Override
    public void close() throws SecurityException {
        this.m_fileHandler.close();
    }

    @Override
    public void flush() {
        this.m_fileHandler.flush();
    }

    @Override
    public void publish(LogRecord record) {
        this.m_fileHandler.publish(record);
    }

    private int getInt(LogManager lmgr, String compName, String prop, int defaultValue) {
        String intStr = lmgr.getProperty("oracle.supercluster.cluster.SCFileHandler." + compName + '.' + prop);
        if (intStr == null) {
            intStr = lmgr.getProperty("oracle.supercluster.cluster.SCFileHandler." + prop);
        }
        Trace.out((String)("intStr=" + intStr));
        if (intStr == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(intStr.trim());
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    private boolean getBool(LogManager lmgr, String compName, String prop) {
        String boolStr = lmgr.getProperty("oracle.supercluster.cluster.SCFileHandler." + compName + '.' + prop);
        if (boolStr == null) {
            boolStr = lmgr.getProperty("oracle.supercluster.cluster.SCFileHandler." + prop);
        }
        Trace.out((String)("boolStr=" + boolStr));
        return Boolean.parseBoolean(boolStr);
    }

    private String getPattern(String patternSuffix) {
        String fsep = File.separator;
        File logDir = new File(this.m_logDir);
        if (!logDir.exists()) {
            boolean status = logDir.mkdirs();
            Trace.out((String)("Create log directory status:" + status));
        }
        String pattern = logDir.getAbsolutePath() + fsep + patternSuffix;
        Trace.out((String)("pattern string=" + pattern));
        return pattern;
    }
}

