/*
 * Decompiled with CFR 0.152.
 */
package oracle.supercluster.cluster;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.scan.ScanVIP;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.PortException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.supercluster.cluster.GossipServerResource;
import oracle.supercluster.cluster.GossipServerResourceException;
import oracle.supercluster.cluster.SCRDResource;
import oracle.supercluster.cluster.SCRDResourceException;
import oracle.supercluster.common.SCDiscoveryMethod;
import oracle.supercluster.impl.cluster.ClusterFactoryImpl;

public class ClusterFactory {
    private static ClusterFactory s_instance;
    private ClusterFactoryImpl s_factoryImpl = ClusterFactoryImpl.getInstance();

    private ClusterFactory() throws SoftwareModuleException {
    }

    public static synchronized ClusterFactory getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new ClusterFactory();
        }
        return s_instance;
    }

    public GossipServerResource createGossipServer(Version version) throws AlreadyExistsException, GossipServerResourceException {
        return this.createGossipServer(Integer.parseInt(ResourceLiterals.GOSSIPSERVER_PORT.toString()), new HashMap<String, String>(0), version);
    }

    public GossipServerResource createGossipServer(int port, Map<String, String> propMap, Version version) throws AlreadyExistsException, GossipServerResourceException {
        if (port < 1) {
            throw new GossipServerResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "port", port);
        }
        if (null == propMap) {
            throw new GossipServerResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "propMap", propMap);
        }
        if (null == version) {
            throw new GossipServerResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createGossipServerResource(String.valueOf(port), propMap, version);
    }

    public GossipServerResource createGossipServer(ScanVIP sVIP, int port, Map<String, String> propMap, Version version) throws AlreadyExistsException, GossipServerResourceException {
        if (port < 1) {
            throw new GossipServerResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "port", port);
        }
        if (null == propMap) {
            throw new GossipServerResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "propMap", propMap);
        }
        if (null == version) {
            throw new GossipServerResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        if (null == sVIP) {
            throw new GossipServerResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sVIP", sVIP);
        }
        return this.s_factoryImpl.createGossipServerResource(sVIP, String.valueOf(port), propMap, version);
    }

    public GossipServerResource getGossipServer() throws NotExistsException, GossipServerResourceException {
        return this.s_factoryImpl.getGossipServerResource();
    }

    public SCRDResource createSCRDResource(Version version) throws AlreadyExistsException, SCRDResourceException {
        try {
            return this.createSCRDResource(this.s_factoryImpl.getMulticastAddress(), this.s_factoryImpl.getMulticastPort(), version);
        }
        catch (UnknownHostException e) {
            throw new SCRDResourceException(e);
        }
        catch (PortException e) {
            throw new SCRDResourceException(e);
        }
    }

    public SCRDResource createSCRDResource(InetAddress mcastAddress, Version version) throws AlreadyExistsException, SCRDResourceException {
        return this.createSCRDResource(mcastAddress, Integer.parseInt(ResourceLiterals.SUPERCLUSTER_MCAST_PORT.toString()), version);
    }

    public SCRDResource createSCRDResource(InetAddress mcastAddress, int mcastPort, Version version) throws AlreadyExistsException, SCRDResourceException {
        return this.createSCRDResource(mcastAddress, mcastPort, new HashMap<String, String>(0), version);
    }

    public SCRDResource createSCRDResource(InetAddress mcastAddress, int mcastPort, Map<String, String> propMap, Version version) throws AlreadyExistsException, SCRDResourceException {
        if (null == version) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        if (null == mcastAddress) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mcastAddress", mcastAddress);
        }
        if (mcastPort < 1) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mcastPort", mcastPort);
        }
        if (null == propMap) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "propMap", propMap);
        }
        return this.s_factoryImpl.createSCRDResource(null, null, SCDiscoveryMethod.MULTICAST, mcastAddress, String.valueOf(mcastPort), null, propMap, version);
    }

    public SCRDResource createSCRDResource(String tierName, int port, InetAddress mcastAddress, int mcastPort, Map<String, String> propMap, Version version) throws AlreadyExistsException, SCRDResourceException {
        if (null == tierName || tierName.trim().length() == 0) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "tierName", tierName);
        }
        if (port < 1) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "port", port);
        }
        if (null == mcastAddress) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mcastAddress", mcastAddress);
        }
        if (mcastPort < 1) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mcastPort", mcastPort);
        }
        if (null == propMap) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "propMap", propMap);
        }
        if (null == version) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createSCRDResource(tierName, String.valueOf(port), SCDiscoveryMethod.MULTICAST, mcastAddress, String.valueOf(mcastPort), null, propMap, version);
    }

    public SCRDResource createSCRDResource(String tierName, int port, Map<String, String> propMap, Version version) throws AlreadyExistsException, SCRDResourceException {
        if (null == tierName || tierName.trim().length() == 0) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "tierName", tierName);
        }
        if (port < 1) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "port", port);
        }
        if (null == propMap) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "propMap", propMap);
        }
        if (null == version) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createSCRDResource(tierName, String.valueOf(port), SCDiscoveryMethod.GOSSIP_SERVERS, null, null, null, propMap, version);
    }

    public SCRDResource createSCRDResource(String tierName, int port, Map<String, Integer> mbrList, Map<String, String> propMap, Version version) throws AlreadyExistsException, SCRDResourceException {
        if (null == tierName || tierName.trim().length() == 0) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "tierName", tierName);
        }
        if (port < 1) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "port", port);
        }
        if (null == mbrList || 0 == mbrList.size()) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mbrList", mbrList);
        }
        if (null == propMap) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "propMap", propMap);
        }
        if (null == version) {
            throw new SCRDResourceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        return this.s_factoryImpl.createSCRDResource(tierName, String.valueOf(port), SCDiscoveryMethod.LIST, null, null, mbrList, propMap, version);
    }

    public SCRDResource getSCRDResource() throws NotExistsException, SCRDResourceException {
        return this.s_factoryImpl.getSCRDResource();
    }
}

