/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteutil;

import java.util.StringTokenizer;

public final class ListUtil {
    private static String DELIMITER = ",";

    public static String chooseFromList(String clientList, String serverList) {
        String[] cliL = ListUtil.arrayFromList(clientList);
        String[] srvL = ListUtil.arrayFromList(serverList);
        for (int i = 0; i < cliL.length; ++i) {
            for (int j = 0; j < srvL.length; ++j) {
                if (!cliL[i].equals(srvL[j])) continue;
                return cliL[i];
            }
        }
        return null;
    }

    public static String removeAllFromList(String list, String element) {
        StringBuffer buf = new StringBuffer();
        String[] arr = ListUtil.arrayFromList(list);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].equals(element)) continue;
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    public static String removeAllPrefixFromList(String list, String prefix) {
        StringBuffer buf = new StringBuffer();
        String[] arr = ListUtil.arrayFromList(list);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].startsWith(prefix)) continue;
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    public static String removeFirstFromList(String list, String element) {
        StringBuffer buf = new StringBuffer();
        String[] arr = ListUtil.arrayFromList(list);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].equals(element)) {
                element = "";
                continue;
            }
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    public static String getFirstInList(String list) {
        String[] arr = ListUtil.arrayFromList(list);
        if (arr.length == 0) {
            return null;
        }
        return arr[0];
    }

    public static boolean isInList(String list, String element) {
        String[] arr = ListUtil.arrayFromList(list);
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrefixInList(String list, String prefix) {
        String[] arr = ListUtil.arrayFromList(list);
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static String sortList(String list) {
        String[] arr = ListUtil.arrayFromList(list);
        for (int i = 0; i < arr.length; ++i) {
            for (int j = i; j < arr.length; ++j) {
                if (arr[i].compareTo(arr[j]) < 0) continue;
                String tmp = arr[j];
                arr[j] = arr[i];
                arr[i] = tmp;
            }
        }
        return ListUtil.listFromArray(arr);
    }

    public static String[] arrayFromList(String list) {
        if (list == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(list, DELIMITER);
        int cnt = 0;
        String[] sa = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            sa[cnt++] = st.nextToken().trim();
        }
        return sa;
    }

    public static String[] arrayFromList(String list, String delimiter) {
        if (list == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(list, delimiter);
        int cnt = 0;
        String[] sa = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            sa[cnt++] = st.nextToken().trim();
        }
        return sa;
    }

    public static String listFromArray(String[] arr) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == null || arr[i].equals("")) continue;
            if (buf.length() > 0) {
                buf.append(DELIMITER);
            }
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    public static String listFromArray(String[] arr, String delimiter) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == null || arr[i].equals("")) continue;
            if (buf.length() > 0) {
                buf.append(delimiter);
            }
            buf.append(arr[i]);
        }
        return buf.toString();
    }
}

