/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.result;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.result.ClusterResult;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;

public class GenericResult
implements ClusterResult {
    private int m_status;
    private Map m_results;
    private List m_failedNodes;

    public GenericResult(Map commandResults) {
        this.m_results = commandResults;
        this.setStatusValue();
    }

    public GenericResult(CommandResult commandResult) {
        this.m_status = 2;
        if (commandResult != null) {
            this.m_results = new Hashtable();
            String node = commandResult.getNodeName();
            this.m_results.put(node, commandResult);
            if (commandResult.getStatus()) {
                this.m_status = 0;
            } else {
                this.m_failedNodes = new ArrayList(1);
                this.m_failedNodes.add(node);
            }
        }
        ClusterLogger.log("GenericResult:Constructor() Status set to " + this.m_status, ClusterLogger.LOG_FINER);
    }

    private void setStatusValue() {
        this.m_status = 2;
        if (this.m_results != null) {
            int size = this.m_results.size();
            this.m_failedNodes = new ArrayList(size);
            Iterator iter = this.m_results.values().iterator();
            int succ = 0;
            for (int i = 0; i < size; ++i) {
                CommandResult res = (CommandResult)iter.next();
                if (res != null && res.getStatus()) {
                    ++succ;
                    continue;
                }
                this.m_failedNodes.add(res.getNodeName());
            }
            this.m_status = succ == size ? 0 : (succ == 0 ? 2 : 1);
        }
        ClusterLogger.log("GenericResult:Constructor() Status set to " + this.m_status, ClusterLogger.LOG_FINER);
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public CommandResult getResultOnNode(String nodename) {
        if (this.m_results != null && nodename != null) {
            return (CommandResult)this.m_results.get(nodename);
        }
        return null;
    }

    @Override
    public Iterator getResults() {
        if (this.m_results != null) {
            return this.m_results.values().iterator();
        }
        return new ArrayList().iterator();
    }

    @Override
    public List getFailedNodes() {
        int num = 0;
        if (this.m_failedNodes != null && (num = this.m_failedNodes.size()) > 0) {
            return this.m_failedNodes;
        }
        return null;
    }
}

