/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.plugins;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Constants;
import oracle.sysman.prov.remoteinterfaces.plugins.StreamReader;
import oracle.sysman.prov.remoteutil.ListUtil;

class RuntimeExec {
    private static final int FAILURE = 1;
    private static final int SUCCESS = 0;
    private String[] m_cmd = null;
    private String[] m_input = null;
    private String[] m_env = null;
    private String[] m_output = null;
    private String[] m_error = null;
    private int m_exitValue = 0;

    RuntimeExec(String[] cmd, String[] input, String[] env) {
        this.m_cmd = cmd;
        this.m_input = input;
        this.m_env = env;
    }

    int runCommand() {
        ClusterLogger.log("entering RuntimeExec.runCommand()", ClusterLogger.LOG_FINER);
        Process proc = null;
        int ret = 0;
        if (this.m_cmd == null) {
            ClusterLogger.log("runCommand: null command passed", ClusterLogger.LOG_SEVERE);
            ret = 1;
            return ret;
        }
        Runtime rt = Runtime.getRuntime();
        try {
            proc = this.m_env != null ? rt.exec(this.m_cmd, this.m_env) : rt.exec(this.m_cmd);
        }
        catch (IOException e) {
            ClusterLogger.log("runCommand: exec exception: " + e.getMessage(), ClusterLogger.LOG_SEVERE);
            ClusterLogger.log(e);
            ret = 1;
            return ret;
        }
        if (this.m_input != null) {
            OutputStream os = proc.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os);
            BufferedWriter bw = new BufferedWriter(osw);
            try {
                for (int line = 0; line < this.m_input.length; ++line) {
                    bw.write(this.m_input[line]);
                    bw.flush();
                }
                os.close();
            }
            catch (IOException ioe) {
                ClusterLogger.log(ioe);
            }
        }
        StreamReader outputReader = new StreamReader(proc.getInputStream(), "OUTPUT");
        StreamReader errorReader = new StreamReader(proc.getErrorStream(), "ERROR");
        errorReader.start();
        outputReader.start();
        try {
            this.m_exitValue = proc.waitFor();
            ClusterLogger.log("runCommand: process.waitFor returns " + this.m_exitValue, ClusterLogger.LOG_FINEST);
        }
        catch (InterruptedException ie) {
            ClusterLogger.log("runCommand: interrupted awaiting process: " + ie, ClusterLogger.LOG_SEVERE);
        }
        try {
            errorReader.join();
            outputReader.join();
        }
        catch (InterruptedException ie) {
            ClusterLogger.log("runCommand: interrupted the reader threads: " + ie, ClusterLogger.LOG_SEVERE);
        }
        this.m_output = outputReader.getBuffer();
        this.m_error = errorReader.getBuffer();
        try {
            this.m_exitValue = proc.exitValue();
        }
        catch (IllegalThreadStateException ie) {
            ClusterLogger.log(ie);
            this.m_exitValue = 1;
        }
        ClusterLogger.log("runCommand: process exitValue " + this.m_exitValue, ClusterLogger.LOG_FINEST);
        proc.destroy();
        return ret;
    }

    String[] getOutput() {
        if (this.m_output != null) {
            return this.m_output;
        }
        return new String[0];
    }

    String getOutputString() {
        if (this.m_output != null) {
            return ListUtil.listFromArray(this.m_output, Constants.LINE_SEPARATOR);
        }
        return "";
    }

    String[] getError() {
        if (this.m_error != null) {
            return this.m_error;
        }
        return new String[0];
    }

    String getErrorString() {
        if (this.m_error != null) {
            return ListUtil.listFromArray(this.m_error, Constants.LINE_SEPARATOR);
        }
        return "";
    }

    int getExitValue() {
        return this.m_exitValue;
    }

    int runCmdWithoutWait() throws IllegalThreadStateException {
        if (null == this.m_cmd) {
            return 1;
        }
        Runtime rt = Runtime.getRuntime();
        try {
            Process proc = rt.exec(this.m_cmd);
            Thread.sleep(1000L);
            proc.exitValue();
            return 0;
        }
        catch (InterruptedException e) {
            ClusterLogger.log(e);
            return 1;
        }
        catch (IOException e) {
            ClusterLogger.log(e);
            return 1;
        }
    }
}

