/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.plugins;

import java.text.MessageFormat;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiio.oiiol.OiiolLoggerUtil;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.prov.remoteinterfaces.cluster.NodeInfo;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Constants;
import oracle.sysman.prov.remoteinterfaces.nativesystem.NativeSystem;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Session;
import oracle.sysman.prov.remoteinterfaces.plugins.RemoteCommand;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;

public class RemoteCommandWMI
implements RemoteCommand,
Constants {
    private static final String DELIM2 = ":";
    private static final String EXITCODE_STR = "EXITCODE";
    private static final String FILE_SEPARATOR = "\\";
    private static final String ESCAPED_FILE_SEPARATOR = "\\\\";

    public native void copyFile(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws CommandException;

    public native void deleteFile(String var1, String var2, String var3, String var4, String var5) throws CommandException;

    public native void createService(String var1, String var2, String var3, String var4, String var5, String var6) throws CommandException;

    public native CommandResult createCmdService(String var1, String var2, String var3, String var4, String var5, String var6) throws CommandException;

    public native void deleteService(String var1, String var2, String var3, String var4, String var5, String var6) throws CommandException;

    public native void createDir(String var1, String var2, String var3, String var4, String var5) throws CommandException;

    public native void deleteDir(String var1, String var2, String var3, String var4, String var5) throws CommandException;

    String convertToStr(String[] arr) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            buffer.append(arr[i]);
            buffer.append(" ");
        }
        return buffer.toString();
    }

    @Override
    public CommandResult runcmd(NodeInfo nodeinfo, String[] cmdarr, String[] input, String[] env, boolean bSsh) {
        String node = nodeinfo.getNodeName();
        String SPACE = " ";
        boolean del_scratch = true;
        CommandResult result = new CommandResult(node);
        nodeinfo.getNativeSystem();
        Map s_sessions = NativeSystem.getSessions();
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Object l_execLog = null;
        String username = sess.getUsername();
        String cmd_type = cmdarr[0];
        String r_cmd = cmdarr[1];
        ClusterLogger.log("RemoteCommandWMI: runcmd : userName = " + username, ClusterLogger.LOG_INFO);
        String password = sess.getPassword();
        if (cmd_type.equals("win_runcmd")) {
            String l_servicePath = System.getProperty("oracle.sysman.prov.win_win_service_path");
            String tStamp = OiiolLoggerUtil.getTimeStamp();
            String shareName = "ADMIN$";
            String r_service = "RemoteExec";
            if (!r_service.toLowerCase().endsWith(".exe")) {
                r_service = r_service + ".exe";
            }
            try {
                this.copyFile("localhost", l_servicePath, node, r_service, shareName, username, password, "copyFileToNode");
            }
            catch (CommandException ce) {
                ClusterLogger.log("RemoteCommandWMI: runcmd : copyFile = " + l_servicePath + "  File is already present", ClusterLogger.LOG_INFO);
            }
            try {
                String r_servicePath = "%SystemRoot%\\" + r_service + " " + "\"" + r_cmd + "\"";
                ClusterLogger.log("RemoteCommandWMI: runcmd : createCmdService = " + r_servicePath, ClusterLogger.LOG_INFO);
                result = this.createCmdService(node, "RemoteExec" + tStamp, r_servicePath, shareName, username, password);
                String sPath = ESCAPED_FILE_SEPARATOR + node + FILE_SEPARATOR + shareName + FILE_SEPARATOR + r_service;
                ClusterLogger.log("RemoteCommandWMI: runcmd : deleteService = " + sPath, ClusterLogger.LOG_INFO);
                this.deleteService(node, "RemoteExec" + tStamp, sPath, shareName, username, password);
                this.deleteFile(node, r_service, shareName, username, password);
            }
            catch (CommandException ce) {
                result.setException(ce);
                result.setExitCode(-1);
                result.setErrStr(ce.getFullMessage());
                result.setStatus(false);
                result.setResult(new Boolean(false));
                ClusterLogger.log((Throwable)((Object)ce));
                ClusterLogger.log("RemoteCommandWMI : runcmd : " + ce.getNodeName() + " " + ce.getFullMessage(), ClusterLogger.LOG_INFO);
            }
            return result;
        }
        if (cmd_type.equals("win_cdir") || cmd_type.equals("win_ddir") || cmd_type.equals("win_dfile")) {
            String r_loc = cmdarr[1];
            String shareName = this.getShareName(r_loc);
            String r_loc1 = this.getfNameWithoutParentDir(r_loc);
            r_loc1 = OiixPathOps.getNativeForm((String)r_loc1);
            try {
                if (cmd_type.equals("win_cdir")) {
                    ClusterLogger.log("RemoteCommandWMI: runcmd : CreateDir = " + r_loc1, ClusterLogger.LOG_INFO);
                    this.createDir(node, r_loc1, shareName, username, password);
                } else if (cmd_type.equals("win_ddir")) {
                    ClusterLogger.log("RemoteCommandWMI: runcmd : DeleteDir = " + r_loc1, ClusterLogger.LOG_INFO);
                    this.deleteDir(node, r_loc1, shareName, username, password);
                } else if (cmd_type.equals("win_dfile")) {
                    ClusterLogger.log("RemoteCommandWMI: runcmd : DeleteFile = " + r_loc1, ClusterLogger.LOG_INFO);
                    this.deleteFile(node, r_loc1, shareName, username, password);
                }
            }
            catch (CommandException ce) {
                result.setException(ce);
                result.setExitCode(-1);
                result.setErrStr(ce.getFullMessage());
                result.setStatus(false);
                result.setResult(new Boolean(false));
                ClusterLogger.log((Throwable)((Object)ce));
                ClusterLogger.log("RemoteCommandWMI : runcmd : " + ce.getNodeName() + " " + ce.getFullMessage(), ClusterLogger.LOG_INFO);
                return result;
            }
            result.setExitCode(0);
            result.setStatus(true);
            result.setResult(new Boolean(true));
            return result;
        }
        if (cmd_type.equals("win_cservice") || cmd_type.equals("win_rservice")) {
            String r_service = cmdarr[1];
            String r_serviceName = cmdarr[2];
            r_service = OiixPathOps.getNativeForm((String)r_service);
            String shareName = this.getShareName(r_service);
            r_service = this.getfNameWithoutParentDir(r_service);
            try {
                if (cmd_type.equals("win_cservice")) {
                    String r_service_args = cmdarr[3];
                    String r_servicePath = ESCAPED_FILE_SEPARATOR + node + FILE_SEPARATOR + shareName + FILE_SEPARATOR + r_service + " " + "\"" + r_service_args + "\"";
                    ClusterLogger.log("RemoteCommandWMI: runcmd : createService = " + r_servicePath, ClusterLogger.LOG_INFO);
                    this.createService(node, r_serviceName, r_servicePath, shareName, username, password);
                } else {
                    String r_servicePath = ESCAPED_FILE_SEPARATOR + node + FILE_SEPARATOR + shareName + FILE_SEPARATOR + r_service;
                    ClusterLogger.log("RemoteCommandWMI: runcmd : deleteService = " + r_servicePath, ClusterLogger.LOG_INFO);
                    this.deleteService(node, r_serviceName, r_servicePath, shareName, username, password);
                }
            }
            catch (CommandException ce) {
                result.setException(ce);
                result.setExitCode(-1);
                result.setErrStr(ce.getFullMessage());
                result.setStatus(false);
                result.setResult(new Boolean(false));
                ClusterLogger.log((Throwable)((Object)ce));
                ClusterLogger.log("RemoteCommandWMI : createService : " + ce.getNodeName() + " " + ce.getFullMessage(), ClusterLogger.LOG_INFO);
                return result;
            }
            result.setExitCode(0);
            result.setStatus(true);
            result.setResult(new Boolean(true));
            return result;
        }
        return null;
    }

    @Override
    public CommandResult copyFile(NodeInfo nodeinfo1, String file1, NodeInfo nodeinfo2, String file2) {
        String node1 = nodeinfo1.getNodeName();
        String node2 = nodeinfo2.getNodeName();
        CommandResult result = new CommandResult(node2);
        nodeinfo1.getNativeSystem();
        Map s_sessions = NativeSystem.getSessions();
        Session sess = (Session)s_sessions.get(nodeinfo1.getSessionId());
        String username = sess.getUsername();
        ClusterLogger.log("RemoteCommandWMI: copyFile : userName = " + username, ClusterLogger.LOG_INFO);
        String password = sess.getPassword();
        String tmpfile = new String(file2);
        String shareName = this.getShareName(tmpfile);
        file1 = OiixPathOps.getNativeForm((String)file1);
        file2 = OiixPathOps.getNativeForm((String)file2);
        ClusterLogger.log("RemoteCommandWMI: copyFile : file1 = " + file1 + " file2 = " + file2, ClusterLogger.LOG_INFO);
        file2 = this.getfNameWithoutParentDir(file2);
        try {
            if (node1.trim().equals("localhost")) {
                this.copyFile(node1, file1, node2, file2, shareName, username, password, "copyFileToNode");
            } else {
                this.copyFile(node2, file1, node1, file2, shareName, username, password, "copyFileFromNode");
            }
        }
        catch (CommandException ce) {
            result.setException(ce);
            result.setExitCode(-1);
            result.setErrStr(ce.getFullMessage());
            result.setStatus(false);
            result.setResult(new Boolean(false));
            ClusterLogger.log((Throwable)((Object)ce));
            ClusterLogger.log("RemoteCommandWMi : copyFile : " + ce.getNodeName() + " " + ce.getFullMessage(), ClusterLogger.LOG_INFO);
            return result;
        }
        result.setExitCode(0);
        result.setStatus(true);
        result.setResult(new Boolean(true));
        return result;
    }

    private String getShareName(String filename) {
        String[] shareArray = filename.split(DELIM2);
        String shareName = shareArray[0].toUpperCase() + "$";
        ClusterLogger.log("RemoteCommandWMI: copyFile : shareName = " + shareName, ClusterLogger.LOG_INFO);
        return shareName;
    }

    private String getfNameWithoutParentDir(String filename) {
        ClusterLogger.log("RemoteCommandWMI: getfNameWithoutParentDir : fileName = " + filename, ClusterLogger.LOG_INFO);
        filename = OiixPathOps.getNativeForm((String)filename);
        String[] fname = filename.split(ESCAPED_FILE_SEPARATOR);
        String result = null;
        for (int i = 1; i < fname.length; ++i) {
            result = result == null ? fname[i] : result + FILE_SEPARATOR + fname[i];
        }
        return result;
    }

    private String escapeString(String str) {
        String line_sep = FILE_SEPARATOR;
        String escape_line_sep = ESCAPED_FILE_SEPARATOR;
        return str.replace(line_sep, escape_line_sep);
    }

    @Override
    public String[] formulateCmd(boolean bsSh, Session sess, String node, Paths paths, String cmd, String cmdArgs, String nodePrefix) {
        return null;
    }

    @Override
    public String[] formulateCmd(String key, boolean bsSh, Session sess, String node, Paths paths, String cmd, String cmdArgs) {
        return null;
    }

    @Override
    public String[] formulateCmd(String key, Session sess, String node, Paths paths, String cmd, String cmdArgs, String sudoPath, String sudoArgs) {
        return null;
    }

    @Override
    public String[] formulateCmd(boolean bSsh, String node, Paths paths, String remoteShellPath, String remoteShellArgs, String cmd, String cmdArgs, String nodePrefix) {
        return null;
    }

    @Override
    public String[] formulateCmd(boolean bSsh, String node, Paths paths, String remoteShellPath, String remoteShellArgs, String cmd, String cmdArgs, String nodePrefix, String username) {
        return null;
    }

    @Override
    public String formulateCmd(Paths paths, String key, String dirpath, String flag) {
        return MessageFormat.format(paths.getValue(key), "", "'" + dirpath + "'", "", "", flag);
    }

    @Override
    public String[] formulateCmd(String key, boolean bsSh, Session sess, String node, Paths paths, String cmd, String cmdArgs, String username) {
        return null;
    }

    private String[] createCmdArr(String formatStr, String remoteShellPath, String remoteShellArgs, String node, String loginShellPath, String loginShellArgs, String cmdPath, String cmdArgs) {
        StringTokenizer st = new StringTokenizer(remoteShellArgs);
        StringBuffer tmpBuf = new StringBuffer();
        int n = st.countTokens();
        if (st.hasMoreTokens()) {
            tmpBuf.append(st.nextToken());
        }
        for (int i = 1; i < n; ++i) {
            tmpBuf.append("#");
            tmpBuf.append(st.nextToken());
        }
        remoteShellArgs = tmpBuf.toString();
        String unixcmd = MessageFormat.format(formatStr, remoteShellPath, remoteShellArgs, node, loginShellPath, loginShellArgs, cmdPath + " " + cmdArgs);
        ClusterLogger.log(unixcmd, ClusterLogger.LOG_INFO);
        st = new StringTokenizer(unixcmd, "#");
        String[] cmdArr = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArr[i] = st.nextToken();
            ++i;
        }
        return cmdArr;
    }

    @Override
    public String[] formulateLocalCmd(String key, String node, String cmd, String cmdArgs) {
        return this.createCmdArr(key, node, cmd, cmdArgs);
    }

    @Override
    public String[] formulateLocalCmd(Paths paths, String cmd, String cmdArgs) {
        return null;
    }

    private String[] createCmdArr(String formatStr, String node, String cmdPath, String cmdArgs) {
        StringTokenizer st = new StringTokenizer(cmdArgs);
        StringBuffer tmpBuf = new StringBuffer();
        int n = st.countTokens();
        if (st.hasMoreTokens()) {
            tmpBuf.append(st.nextToken());
        }
        for (int i = 1; i < n; ++i) {
            tmpBuf.append("#");
            tmpBuf.append(st.nextToken());
        }
        String args = tmpBuf.toString();
        String unixcmd = MessageFormat.format(formatStr, "", "", node, "", "", "", cmdPath, args);
        ClusterLogger.log(unixcmd, ClusterLogger.LOG_INFO);
        st = new StringTokenizer(unixcmd, "#");
        String[] cmdArr = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArr[i] = st.nextToken();
            ++i;
        }
        return cmdArr;
    }

    @Override
    public CommandResult runCmdWithoutWait(NodeInfo nodeinfo, String[] cmdArr, boolean bSsh) {
        ClusterLogger.log("API not supported in this plugin");
        CommandResult result = new CommandResult(nodeinfo.getNodeName());
        result.setStatus(false);
        result.setResult(new Boolean(false));
        return result;
    }

    static {
        String wmidllPath = null;
        String oui_libPath = System.getProperty("oracle.installer.library_loc");
        if (oui_libPath == null) {
            String libPath = System.getProperty("java.library.path");
            wmidllPath = System.getProperty("oracle.sysman.prov.PathsPropertiesLoc");
            wmidllPath = wmidllPath + FILE_SEPARATOR + "RemoteCommandWMI" + ".dll";
        } else {
            wmidllPath = oui_libPath + FILE_SEPARATOR + "RemoteCommandWMI" + ".dll";
        }
        ClusterLogger.log("RemoteCommandWMI: RemoteCommandWMIDLL Path = " + wmidllPath, ClusterLogger.LOG_INFO);
        System.load(wmidllPath);
    }
}

