/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.plugins;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.cluster.NodeInfo;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Constants;
import oracle.sysman.prov.remoteinterfaces.nativesystem.NativeSystem;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.plugins.MyUserInfo;
import oracle.sysman.prov.remoteinterfaces.plugins.RemoteCommand;
import oracle.sysman.prov.remoteinterfaces.plugins.RuntimeExec;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;

public class RemoteCommandJSCH
implements RemoteCommand,
Constants {
    private int m_exitVal = 0;
    private String m_out = null;
    private String r_error = null;
    private String PROPERTY_USER_HOME = "user.home";

    private static String convertToStr(String[] arr) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            buffer.append(arr[i]);
            buffer.append(" ");
        }
        return buffer.toString().trim();
    }

    private void cleanup(Channel ch, Session sess) {
        if (ch != null) {
            ch.disconnect();
        }
        if (sess != null) {
            sess.disconnect();
        }
    }

    private String getIdentityLoc() {
        return OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)this.getsshDir(), (String)"id_rsa"));
    }

    private String getIdentityLoc2() {
        return OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)this.getsshDir(), (String)"identity"));
    }

    private String getIdDsaLoc() {
        return OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)this.getsshDir(), (String)"id_dsa"));
    }

    private String getsshDir() {
        return OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)this.getHomeDir(), (String)".ssh"));
    }

    private String getHomeDir() {
        String home = System.getProperty(this.PROPERTY_USER_HOME).trim();
        return home;
    }

    public String getOutput() {
        return this.m_out;
    }

    public int getExitCode() {
        return this.m_exitVal;
    }

    public String getError() {
        return this.r_error;
    }

    @Override
    public CommandResult runcmd(NodeInfo nodeinfo, String[] cmdarr, String[] input, String[] env, boolean bSsh) {
        Map s_sessions = NativeSystem.getSessions();
        oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess = (oracle.sysman.prov.remoteinterfaces.nativesystem.Session)s_sessions.get(nodeinfo.getSessionId());
        String node = nodeinfo.getNodeName();
        CommandResult result = new CommandResult(node);
        String cmdStr = RemoteCommandJSCH.convertToStr(cmdarr);
        ClusterLogger.log(cmdStr, ClusterLogger.LOG_INFO, false);
        CommandException ex = null;
        ClusterLogger.log("nodename, cmd: " + node + ", " + cmdStr);
        try {
            if (node.equals("localhost")) {
                this.runLocalCommand(node, cmdarr, input, env);
            } else {
                this.runJschCommand(sess, node, cmdStr, input, nodeinfo.getPaths());
            }
        }
        catch (FatalException e) {
            ex = new CommandException(node, e.getMessage(), e.getCause());
            result.setException(ex);
            result.setStatus(false);
            result.setResult(new Boolean(false));
            return result;
        }
        int retVal = this.getExitCode();
        int exitVal = 1;
        if (retVal != 0) {
            ClusterLogger.log(cmdStr, ClusterLogger.LOG_INFO, false);
            ClusterLogger.log("Error: Not able to run the command on node " + node + ". Retval of runcmd: " + retVal, ClusterLogger.LOG_INFO, false);
            ex = new CommandException(node, "PROV-16003", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16003", (Object[])new String[]{cmdStr}));
            ex.setErrLevel(4);
        } else {
            exitVal = this.getExitCode();
            if (bSsh) {
                ClusterLogger.log("Exitcode of the remote command [rnode " + node + "]: " + exitVal, ClusterLogger.LOG_INFO, false);
                result.setExitCode(exitVal);
            } else {
                ClusterLogger.log("Exitcode of the rsh command [rnode " + node + "]: " + exitVal, ClusterLogger.LOG_INFO, false);
            }
            if (exitVal != 0) {
                if (bSsh) {
                    ex = new CommandException(node, "PROV-16004", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16004", (Object[])new String[]{cmdStr, String.valueOf(exitVal)}));
                    ex.setErrLevel(1);
                } else {
                    ex = new CommandException(node, "PROV-16010", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16010", (Object[])new String[]{cmdStr, String.valueOf(exitVal)}));
                    ex.setErrLevel(3);
                }
            }
        }
        String cmdOut = this.getOutput();
        result.setOutStr(cmdOut);
        ClusterLogger.log("Outstream [rnode " + node + "]: " + cmdOut, ClusterLogger.LOG_FINEST, false);
        String[] errors = null;
        if (null != this.getError()) {
            errors = OiixFunctionOps.explodeString((String)this.getError(), (String)"\n");
            ClusterLogger.log("Errstream [rnode " + node + "]: " + this.getError(), ClusterLogger.LOG_INFO, false);
        }
        if (null != errors) {
            StringBuffer buffer = new StringBuffer();
            String lineSep = LINE_SEPARATOR;
            Paths paths = nodeinfo.getPaths();
            if (null == paths) {
                paths = sess.getLocalPaths();
            }
            for (int i = 0; i < errors.length; ++i) {
                if (paths.ignoreErrString(errors[i])) continue;
                buffer.append(errors[i]);
                buffer.append(lineSep);
            }
            String cmdError = buffer.toString();
            if (cmdError.length() != 0) {
                result.setErrStr(cmdError);
                if (ex == null) {
                    ex = new CommandException(node, cmdError);
                    ex.setErrLevel(2);
                }
            }
        }
        if (ex != null) {
            result.setException(ex);
            result.setStatus(false);
            result.setResult(new Boolean(false));
            ClusterLogger.log("CommandResult status [rnode " + node + "]: false", ClusterLogger.LOG_INFO, false);
        } else {
            result.setStatus(true);
            result.setResult(new Boolean(true));
            ClusterLogger.log("CommandResult status [rnode " + node + "]: true", ClusterLogger.LOG_INFO, false);
        }
        return result;
    }

    private void addJschKeys(JSch jsch) {
        String[] keyListArr;
        String keyListFromProperty;
        ArrayList<String> keyFileList = new ArrayList<String>();
        String id_rsa = this.getIdentityLoc();
        String identity = this.getIdentityLoc2();
        String id_dsa = this.getIdDsaLoc();
        if (id_rsa != null && !id_rsa.trim().equals("") && new File(id_rsa).exists()) {
            keyFileList.add(id_rsa);
        }
        if (identity != null && !identity.trim().equals("") && new File(identity).exists()) {
            keyFileList.add(identity);
        }
        if (id_dsa != null && !id_dsa.trim().equals("") && new File(id_dsa).exists()) {
            keyFileList.add(id_dsa);
        }
        if ((keyListFromProperty = System.getProperty("oracle.sysman.prov.remoteinterfaces.identitylist")) != null && !keyListFromProperty.trim().equals("") && (keyListArr = keyListFromProperty.trim().split(",")) != null) {
            for (int i = 0; i < keyListArr.length; ++i) {
                if (keyListArr[i] == null || keyListArr[i].trim().equals("") || !new File(keyListArr[i].trim()).exists()) continue;
                keyFileList.add(keyListArr[i].trim());
            }
        }
        for (int i = 0; i < keyFileList.size(); ++i) {
            try {
                jsch.addIdentity((String)keyFileList.get(i));
                ClusterLogger.log("Adding Identity " + keyFileList.get(i));
                continue;
            }
            catch (Exception e) {
                ClusterLogger.log(e, ClusterLogger.LOG_INFO);
            }
        }
    }

    private String replacePassWithAsterix(String msg, String[] passwd) {
        if (msg == null || msg.trim().equals("")) {
            return msg;
        }
        if (passwd == null || passwd.length == 0) {
            return msg;
        }
        try {
            for (int i = 0; i < passwd.length; ++i) {
                if (passwd[i] == null || passwd[i].trim().length() <= 0 || msg.indexOf(passwd[i].trim()) < 0) continue;
                msg = msg.replaceAll(passwd[i].trim(), "*****");
            }
        }
        catch (PatternSyntaxException e) {
            ClusterLogger.log("PatternSyntaxException: Unable to replace *****. Returning empty string ");
            msg = "";
        }
        catch (Exception e) {
            ClusterLogger.log("Exception: Unable to replace *****. Returning empty string ");
            msg = "";
        }
        return msg;
    }

    private void runJschCommand(oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess, String node, String cmdStr, String[] input, Paths paths) throws FatalException {
        Channel channel = null;
        Session session = null;
        try {
            boolean isPtyRequired;
            JSch jsch = new JSch();
            this.addJschKeys(jsch);
            String m_user = sess.getUsername();
            session = jsch.getSession(m_user, node, RemoteCommandJSCH.getPortNo(paths));
            MyUserInfo ui = new MyUserInfo(sess.getPassword());
            session.setUserInfo((UserInfo)ui);
            Properties configProps = new Properties();
            configProps.put("StrictHostKeyChecking", "no");
            configProps.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
            session.setConfig(configProps);
            session.connect();
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(cmdStr);
            String str = sess.getPreference("oracle.sysman.prov.remoteinterfaces.sudo_pbrun_pty");
            boolean bl = isPtyRequired = str != null && "true".equalsIgnoreCase(str.trim());
            if (isPtyRequired) {
                ((ChannelExec)channel).setPty(true);
            }
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ((ChannelExec)channel).setErrStream((OutputStream)bo);
            InputStream in = channel.getInputStream();
            OutputStream out = channel.getOutputStream();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));
            channel.connect();
            ClusterLogger.log("[" + node + "]: ", ClusterLogger.LOG_INFO);
            ClusterLogger.log(cmdStr, ClusterLogger.LOG_INFO);
            StringBuffer buf = new StringBuffer();
            byte[] tmp = new byte[1024];
            while (true) {
                String inputStr;
                int i;
                if (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                    buf.append(new String(tmp, 0, i - 1));
                    continue;
                }
                if (null != input && (inputStr = RemoteCommandJSCH.convertToStr(input)).length() > 0) {
                    bw.write(inputStr);
                    bw.newLine();
                    bw.flush();
                }
                if (channel.isClosed()) {
                    this.m_exitVal = channel.getExitStatus();
                    ClusterLogger.log("Exit-status: " + channel.getExitStatus(), ClusterLogger.LOG_INFO);
                    this.r_error = bo.toString();
                    this.r_error = this.replacePassWithAsterix(this.r_error, input);
                    if (this.r_error == null) break;
                    ClusterLogger.log("Error: " + this.r_error, ClusterLogger.LOG_INFO);
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ee) {
                    ClusterLogger.log(this.r_error, ClusterLogger.LOG_INFO);
                    ClusterLogger.log(ee, ClusterLogger.LOG_INFO);
                }
            }
            this.cleanup(channel, session);
            this.m_out = buf.toString();
            this.m_out = this.replacePassWithAsterix(this.m_out, input);
        }
        catch (Exception e) {
            ClusterLogger.log(this.r_error, ClusterLogger.LOG_INFO);
            ClusterLogger.log(e, ClusterLogger.LOG_INFO);
            ClusterLogger.log(this.m_out, ClusterLogger.LOG_INFO);
            this.cleanup(channel, session);
            throw new FatalException(e);
        }
        ClusterLogger.log(this.m_out, ClusterLogger.LOG_FINEST);
        this.cleanup(channel, session);
    }

    private void runLocalCommand(String node, String[] cmdarr, String[] input, String[] env) throws FatalException {
        String cmdStr = RemoteCommandJSCH.convertToStr(cmdarr);
        ClusterLogger.log(cmdStr, ClusterLogger.LOG_INFO, false);
        RuntimeExec runtime = new RuntimeExec(cmdarr, input, env);
        if (runtime.runCommand() != 0) {
            throw new FatalException("PROV-16003", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16003"));
        }
        this.m_exitVal = runtime.getExitValue();
        this.m_out = runtime.getOutputString();
        this.r_error = runtime.getErrorString();
    }

    @Override
    public CommandResult copyFile(NodeInfo nodeinfo1, String file1, NodeInfo nodeinfo2, String file2) {
        String node2;
        String node1 = nodeinfo1.getNodeName();
        String node = node2 = nodeinfo2.getNodeName();
        NodeInfo nodeinfo = nodeinfo2;
        boolean sourceIsLocal = true;
        if (node2.equals("localhost")) {
            node = node1;
            nodeinfo = nodeinfo1;
            sourceIsLocal = false;
        }
        Map s_sessions = NativeSystem.getSessions();
        oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess = (oracle.sysman.prov.remoteinterfaces.nativesystem.Session)s_sessions.get(nodeinfo.getSessionId());
        CommandResult result = new CommandResult(node);
        if (nodeinfo.isSshSet()) {
            try {
                if (sourceIsLocal) {
                    this.scpTo(sess, node, file1, file2, nodeinfo.getPaths());
                } else {
                    this.scpFrom(sess, node, file2, file1, nodeinfo.getPaths());
                }
                result.setStatus(true);
                result.setResult(new Boolean(true));
            }
            catch (CommandException ce) {
                result.setException(ce);
                result.setStatus(false);
                result.setResult(new Boolean(false));
                ClusterLogger.log("CommandResult status [rnode " + node + "]: false", ClusterLogger.LOG_INFO, false);
            }
        }
        return result;
    }

    private void scpTo(oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess, String node, String localFile, String remoteFile, Paths paths) throws CommandException {
        ClusterLogger.log("Copy localfile: " + localFile + " to remotefile: " + remoteFile + "remote node: " + node + "\n", ClusterLogger.LOG_INFO);
        Channel channel = null;
        Session session = null;
        try {
            int len;
            JSch jsch = new JSch();
            this.addJschKeys(jsch);
            String m_user = sess.getUsername();
            session = jsch.getSession(m_user, node, RemoteCommandJSCH.getPortNo(paths));
            MyUserInfo ui = new MyUserInfo(sess.getPassword());
            session.setUserInfo((UserInfo)ui);
            Properties configProps = new Properties();
            configProps.put("StrictHostKeyChecking", "no");
            configProps.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
            session.setConfig(configProps);
            session.connect();
            String scpcmd = this.getScpCmd(paths, sess);
            String command = scpcmd + " -p -t " + remoteFile;
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            if (this.checkAck(in) != 0) {
                this.cleanup(channel, session);
                return;
            }
            long filesize = new File(localFile).length();
            command = "C0644 " + filesize + " ";
            command = localFile.lastIndexOf(47) > 0 ? command + localFile.substring(localFile.lastIndexOf(47) + 1) : command + localFile;
            command = command + "\n";
            out.write(command.getBytes());
            out.flush();
            if (this.checkAck(in) != 0) {
                this.cleanup(channel, session);
                return;
            }
            FileInputStream fis = new FileInputStream(localFile);
            byte[] buf = new byte[1024];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
                out.flush();
            }
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (this.checkAck(in) != 0) {
                this.cleanup(channel, session);
                return;
            }
        }
        catch (Exception ex) {
            this.cleanup(channel, session);
            throw new CommandException(node, "PROV-16011", ex.getMessage(), ex);
        }
        this.cleanup(channel, session);
    }

    protected String getScpCmd(Paths paths, oracle.sysman.prov.remoteinterfaces.nativesystem.Session session) {
        String vendor = session.getPreference("SSH_VENDOR");
        if ("Tectia".equalsIgnoreCase(vendor)) {
            return "scp";
        }
        String scpcmd = paths.getValue("SCP_PATH");
        if (null == scpcmd || scpcmd.trim().length() == 0) {
            scpcmd = "scp";
        }
        return scpcmd;
    }

    private void scpFrom(oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess, String node, String localFile, String remoteFile, Paths paths) throws CommandException {
        Channel channel = null;
        Session session = null;
        ClusterLogger.log("Copy remotefile: " + remoteFile + " to localfile: " + localFile + "\n", ClusterLogger.LOG_INFO);
        try {
            int c;
            String prefix = null;
            if (new File(localFile).isDirectory()) {
                prefix = localFile + File.separator;
            }
            JSch jsch = new JSch();
            this.addJschKeys(jsch);
            String m_user = sess.getUsername();
            session = jsch.getSession(m_user, node, RemoteCommandJSCH.getPortNo(paths));
            MyUserInfo ui = new MyUserInfo(sess.getPassword());
            session.setUserInfo((UserInfo)ui);
            Properties configProps = new Properties();
            configProps.put("StrictHostKeyChecking", "no");
            configProps.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
            session.setConfig(configProps);
            session.connect();
            String scpcmd = this.getScpCmd(paths, sess);
            String command = scpcmd + " -f " + remoteFile;
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            while ((c = this.checkAck(in)) == 67) {
                int foo;
                in.read(buf, 0, 5);
                long filesize = 0L;
                while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                    filesize = filesize * 10L + (long)(buf[0] - 48);
                }
                String file = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                file = new String(buf, 0, i);
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                FileOutputStream fos = new FileOutputStream(prefix == null ? localFile : prefix + file);
                do {
                    foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                    if ((foo = in.read(buf, 0, foo)) < 0) break;
                    fos.write(buf, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                fos.close();
                if (this.checkAck(in) != 0) {
                    this.cleanup(channel, session);
                    return;
                }
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
            }
        }
        catch (Exception ex) {
            this.cleanup(channel, session);
            throw new CommandException(node, "PROV-16011", ex.getMessage(), ex);
        }
        this.cleanup(channel, session);
    }

    private int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                ClusterLogger.log(sb.toString(), ClusterLogger.LOG_INFO);
            }
            if (b == 2) {
                ClusterLogger.log(sb.toString(), ClusterLogger.LOG_INFO, true);
            }
        }
        return b;
    }

    @Override
    public String[] formulateCmd(boolean bsSh, oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess, String node, Paths paths, String cmd, String cmdArgs, String nodePrefix) {
        String[] cmdarr = null;
        cmdarr = nodePrefix != null ? (bsSh ? this.createCmdArr(paths.getValue("KEY11"), "", "", "", paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs) : this.createCmdArr(paths.getValue("KEY10"), sess.getRshPath(), sess.getRshArgs() + " " + nodePrefix + " ", node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs)) : (bsSh ? this.createCmdArr(paths.getValue("KEY11"), "", "", "", paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs) : this.createCmdArr(paths.getValue("KEY10"), sess.getRshPath(), sess.getRshArgs(), node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs));
        return cmdarr;
    }

    @Override
    public String[] formulateCmd(String key, boolean bsSh, oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess, String node, Paths paths, String cmd, String cmdArgs) {
        String[] cmdarr = null;
        cmdarr = bsSh ? this.createCmdArr(paths.getValue(key), "", "", "", paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs) : this.createCmdArr(paths.getValue(key), sess.getRshPath(), sess.getRshArgs() + " -n ", node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs);
        return cmdarr;
    }

    @Override
    public String[] formulateCmd(String key, oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess, String node, Paths paths, String cmd, String cmdArgs, String sudoPath, String sudoArgs) {
        String[] cmdarr = null;
        boolean bsSh = sess.getNodeInfo(node).isSshSet();
        cmdarr = bsSh ? (sess.getPreference("oracle.sysman.prov.remoteinterfaces.sudo_pbrun_shellout") != null && sess.getPreference("oracle.sysman.prov.remoteinterfaces.sudo_pbrun_shellout").trim().toLowerCase().equals("false") ? this.createCmdArr(paths.getValue(key), "", "", "", "", "", cmd + " " + cmdArgs, "", sudoPath, sudoArgs) : this.createCmdArr(paths.getValue(key), "", "", "", paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), "'" + cmd + " " + cmdArgs + "'", "", sudoPath, sudoArgs)) : this.createCmdArr(paths.getValue(key), sess.getRshPath(), sess.getRshArgs(), node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs);
        return cmdarr;
    }

    @Override
    public String[] formulateCmd(boolean bSsh, String node, Paths paths, String remoteShellPath, String remoteShellArgs, String cmd, String cmdArgs, String nodePrefix) {
        String[] cmdarr = null;
        cmdarr = this.createCmdArr(paths.getValue("KEY11"), "", "", "", "", "", cmd, cmdArgs);
        return cmdarr;
    }

    @Override
    public String[] formulateCmd(boolean bSsh, String node, Paths paths, String remoteShellPath, String remoteShellArgs, String cmd, String cmdArgs, String nodePrefix, String username) {
        String[] cmdarr = null;
        if (nodePrefix == null && username == null) {
            cmdarr = this.createCmdArr(paths.getValue("KEY11"), "", "", "", "", "", cmd, cmdArgs);
        }
        return cmdarr;
    }

    @Override
    public String formulateCmd(Paths paths, String key, String dirpath, String flag) {
        return MessageFormat.format(paths.getValue(key), "", "'" + dirpath + "'", "", "", flag);
    }

    @Override
    public String[] formulateCmd(String key, boolean bsSh, oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess, String node, Paths paths, String cmd, String cmdArgs, String username) {
        String[] cmdarr = null;
        cmdarr = bsSh ? this.createCmdArr(paths.getValue(key), "", "", "", paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs) : this.createCmdArr(paths.getValue(key), sess.getRshPath(), sess.getRshArgs() + " -l " + username + " -n ", node, paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), cmd, cmdArgs);
        return cmdarr;
    }

    private String[] createCmdArr(String formatStr, String remoteShellPath, String remoteShellArgs, String node, String loginShellPath, String loginShellArgs, String cmdPath, String cmdArgs) {
        StringTokenizer st = new StringTokenizer(remoteShellArgs);
        StringBuffer tmpBuf = new StringBuffer();
        int n = st.countTokens();
        if (st.hasMoreTokens()) {
            tmpBuf.append(st.nextToken());
        }
        for (int i = 1; i < n; ++i) {
            tmpBuf.append("#");
            tmpBuf.append(st.nextToken());
        }
        remoteShellArgs = tmpBuf.toString();
        String unixcmd = MessageFormat.format(formatStr, remoteShellPath, remoteShellArgs, node, loginShellPath, loginShellArgs, cmdPath + " " + cmdArgs);
        ClusterLogger.log(unixcmd, ClusterLogger.LOG_FINEST, false);
        st = new StringTokenizer(unixcmd, "#");
        String[] cmdArr = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArr[i] = st.nextToken();
            ++i;
        }
        return cmdArr;
    }

    private String[] createCmdArr(String formatStr, String remoteShellPath, String remoteShellArgs, String node, String loginShellPath, String loginShellArgs, String cmdPath, String cmdArgs, String sudoPath, String sudoArgs) {
        StringTokenizer st = new StringTokenizer(remoteShellArgs);
        StringBuffer tmpBuf = new StringBuffer();
        int n = st.countTokens();
        if (st.hasMoreTokens()) {
            tmpBuf.append(st.nextToken());
        }
        for (int i = 1; i < n; ++i) {
            tmpBuf.append("#");
            tmpBuf.append(st.nextToken());
        }
        remoteShellArgs = tmpBuf.toString();
        String unixcmd = MessageFormat.format(formatStr, remoteShellPath, remoteShellArgs, node, loginShellPath, loginShellArgs, cmdPath + " " + cmdArgs, sudoPath, sudoArgs);
        ClusterLogger.log(unixcmd, ClusterLogger.LOG_INFO);
        st = new StringTokenizer(unixcmd, "#");
        String[] cmdArr = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArr[i] = st.nextToken();
            ++i;
        }
        return cmdArr;
    }

    @Override
    public String[] formulateLocalCmd(String key, String node, String cmd, String cmdArgs) {
        return this.createCmdArr(key, node, cmd, cmdArgs);
    }

    @Override
    public String[] formulateLocalCmd(Paths paths, String cmd, String cmdArgs) {
        if (cmdArgs != null) {
            cmd = cmd + " " + cmdArgs;
        }
        String[] unixcmd = new String[]{paths.getValue("SH_PATH"), paths.getValue("SH_ARGS"), "'" + cmd + "'"};
        return unixcmd;
    }

    private String[] createCmdArr(String formatStr, String node, String cmdPath, String cmdArgs) {
        StringTokenizer st = new StringTokenizer(cmdArgs);
        StringBuffer tmpBuf = new StringBuffer();
        int n = st.countTokens();
        if (st.hasMoreTokens()) {
            tmpBuf.append(st.nextToken());
        }
        for (int i = 1; i < n; ++i) {
            tmpBuf.append("#");
            tmpBuf.append(st.nextToken());
        }
        String args = tmpBuf.toString();
        String unixcmd = MessageFormat.format(formatStr, "", "", node, "", "", "", cmdPath, args);
        ClusterLogger.log(unixcmd, ClusterLogger.LOG_INFO);
        st = new StringTokenizer(unixcmd, "#");
        String[] cmdArr = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArr[i] = st.nextToken();
            ++i;
        }
        return cmdArr;
    }

    @Override
    public CommandResult runCmdWithoutWait(NodeInfo nodeinfo, String[] cmdArr, boolean bSsh) {
        Map s_sessions = NativeSystem.getSessions();
        oracle.sysman.prov.remoteinterfaces.nativesystem.Session sess = (oracle.sysman.prov.remoteinterfaces.nativesystem.Session)s_sessions.get(nodeinfo.getSessionId());
        String node = nodeinfo.getNodeName();
        String cmdStr = RemoteCommandJSCH.convertToStr(cmdArr);
        CommandResult result = new CommandResult(node);
        Channel channel = null;
        Session session = null;
        try {
            int i;
            JSch jsch = new JSch();
            String m_user = sess.getUsername();
            session = jsch.getSession(m_user, node, RemoteCommandJSCH.getPortNo(nodeinfo.getPaths()));
            MyUserInfo ui = new MyUserInfo(sess.getPassword());
            session.setUserInfo((UserInfo)ui);
            Properties configProps = new Properties();
            configProps.put("StrictHostKeyChecking", "no");
            session.setConfig(configProps);
            session.connect();
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(cmdStr);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ((ChannelExec)channel).setErrStream((OutputStream)bo);
            InputStream in = channel.getInputStream();
            channel.connect();
            ClusterLogger.log("[" + node + "]: ", ClusterLogger.LOG_INFO);
            ClusterLogger.log(cmdStr, ClusterLogger.LOG_INFO);
            StringBuffer buf = new StringBuffer();
            byte[] tmp = new byte[1024];
            while (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                buf.append(new String(tmp, 0, i - 1));
            }
            if (channel.isEOF()) {
                this.m_exitVal = channel.getExitStatus();
                ClusterLogger.log("Exit-status: " + channel.getExitStatus(), ClusterLogger.LOG_INFO);
                this.r_error = bo.toString();
                if (this.r_error != null) {
                    ClusterLogger.log("Error: " + this.r_error, ClusterLogger.LOG_INFO);
                }
                result.setStatus(true);
            } else {
                result.setStatus(false);
            }
            this.cleanup(channel, session);
            this.m_out = buf.toString();
        }
        catch (Exception e) {
            ClusterLogger.log(this.r_error, ClusterLogger.LOG_INFO);
            ClusterLogger.log(e, ClusterLogger.LOG_INFO);
            ClusterLogger.log(this.m_out, ClusterLogger.LOG_INFO);
            this.cleanup(channel, session);
        }
        ClusterLogger.log(this.m_out, ClusterLogger.LOG_INFO);
        this.cleanup(channel, session);
        return result;
    }

    private static int getPortNo(Paths paths) {
        int port = 22;
        try {
            String portNo = paths.getValue("SSH_PORT");
            port = Integer.parseInt(portNo);
        }
        catch (Exception e) {
            port = 22;
        }
        return port;
    }
}

