/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.nativesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.cluster.NodeInfo;
import oracle.sysman.prov.remoteinterfaces.command.Command;
import oracle.sysman.prov.remoteinterfaces.command.SharedPathCommand;
import oracle.sysman.prov.remoteinterfaces.core.ClusterManager;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteFileOperationException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteShellException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteShellFatalException;
import oracle.sysman.prov.remoteinterfaces.exception.SharedDeviceException;
import oracle.sysman.prov.remoteinterfaces.exception.UserEquivalenceException;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Assertions;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Constants;
import oracle.sysman.prov.remoteinterfaces.nativesystem.NativeSystem;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.RemoteExecutionEngine;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Session;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SessionId;
import oracle.sysman.prov.remoteinterfaces.result.ClusterResult;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;
import oracle.sysman.prov.remoteinterfaces.result.GenericResult;

public class WindowsSystem
extends NativeSystem
implements Constants {
    private static final String TMP = "c:\\tmp";
    private static final String FILE_SEPARATOR = "\\";
    private static final char FILE_SEPARATOR_CHAR = '\\';

    @Override
    public String getFileSeparator() {
        return FILE_SEPARATOR;
    }

    @Override
    public char getFileSeparatorChar() {
        return '\\';
    }

    @Override
    protected int findIndexOf(String substr, String str) {
        substr = substr.toLowerCase();
        str = str.toLowerCase();
        return str.indexOf(substr);
    }

    WindowsSystem(SessionId sessId) throws FatalException {
        super(sessId);
    }

    WindowsSystem(SessionId sessId, int platId) throws FatalException {
        super(sessId, platId);
    }

    @Override
    protected String getScratchPath() {
        return TMP;
    }

    @Override
    String[] getPingCommand(Session sess, String node, int timeout, Paths paths) {
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        return r_eng.formulateLocalCmd(sess, paths.getValue("PING_KEY"), node, paths.getValue("PING_PATH"), paths.getValue("PING_ARGS") + " " + String.valueOf(timeout * 1000));
    }

    @Override
    public CommandResult checkSSHSetup(NodeInfo nodeinfo) {
        return this.checkSSHSetup(nodeinfo, null);
    }

    @Override
    public CommandResult checkSSHSetup(NodeInfo nodeinfo, String user) {
        CommandResult result = this.isNodeAlive(nodeinfo, 5);
        if (result.getStatus()) {
            Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
            String path = null;
            String args = sess.getLocalPaths().getValue("SSH_ARGS");
            if (user == null) {
                user = sess.getUsername();
            }
            if (user != null) {
                args = args + " -l " + user;
            }
            path = sess != null ? sess.getSshPath() : sess.getLocalPaths().getValue("SSH_PATH");
            try {
                result = this.investigateShellEquivalence(nodeinfo, path, args);
            }
            catch (RemoteShellException rse) {
                result.setException(rse);
                result.setStatus(false);
                result.setResult(new Boolean(false));
            }
        }
        return result;
    }

    @Override
    public ClusterResult validateRSHEquivalence(SessionId sessId, String[] nodeNames, String username) throws FatalException, UserEquivalenceException {
        ClusterLogger.log("entering WindowsSystem.validateRSHEquivalence()", ClusterLogger.LOG_FINER);
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    @Override
    public CommandResult checkRSHSetup(NodeInfo nodeinfo) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    @Override
    public CommandResult checkRSHSetup(NodeInfo nodeinfo, String user) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    @Override
    CommandResult checkRemoteExecutionSetup(NodeInfo nodeinfo, boolean update) throws RemoteShellException {
        String node = nodeinfo.getNodeName();
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        CommandResult result = this.isNodeAlive(nodeinfo, 5);
        if (!result.getStatus()) {
            String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16002", (Object[])new String[]{node, String.valueOf(5)});
            errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16008") + "\n" + errorMessage;
            throw new RemoteShellException(node, "PROV-16008", errorMessage, (Throwable)((Object)result.getException()));
        }
        result = this.investigateShellEquivalence(nodeinfo, sess.getSshPath(), sess.getSshArgs());
        if (update) {
            nodeinfo.setSsh(sess.isUserShellSsh());
        }
        return result;
    }

    private CommandResult investigateShellEquivalence(NodeInfo nodeinfo, String path, String args) throws RemoteShellException {
        ClusterLogger.log("Checking user equivalence");
        String node = nodeinfo.getNodeName();
        Paths paths = nodeinfo.getPaths();
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String cmd = "'" + paths.getValue("FALSE") + "'";
        String[] unixcmd = r_eng.formulateCmd(sess, true, node, paths, path, args, cmd, "", null);
        CommandResult result = this.runcmd(nodeinfo, unixcmd, true);
        if (result.getExitCode() == 1) {
            result.setException(null);
            result.setResult(new Boolean(true));
            result.setStatus(true);
            return result;
        }
        throw new RemoteShellException(node, "PROV-16018", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16018", (Object[])new String[]{this.convertToStr(unixcmd)}), (Throwable)((Object)result.getException()));
    }

    @Override
    public CommandResult getTimeOnNode(NodeInfo nodeinfo) {
        ClusterLogger.log("entering WindowsSystem.getTimeOnNode()", ClusterLogger.LOG_FINER);
        String node = nodeinfo.getNodeName();
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String cmd = paths.getValue("DATE_PATH") + " " + paths.getValue("DATE_ARGS");
        String[] cmdarr = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), cmd, "", "-n");
        CommandResult result = this.runcmd(nodeinfo, cmdarr, true);
        result.setResult(null);
        int minute = 0;
        int hour = 0;
        int date = 0;
        int month = 0;
        int year = 0;
        if (result.getStatus()) {
            String outStr = result.getOutStr();
            try {
                StringTokenizer st = new StringTokenizer(outStr, " /");
                if (st.countTokens() == 4) {
                    st.nextToken();
                    month = Integer.valueOf(st.nextToken());
                    date = Integer.valueOf(st.nextToken());
                    year = Integer.valueOf(st.nextToken());
                } else {
                    result.setStatus(false);
                }
            }
            catch (NumberFormatException e) {
                result.setException(new CommandException(node, e));
                result.setStatus(false);
            }
            if (result.getStatus()) {
                String time_cmd = paths.getValue("TIME_PATH") + " " + paths.getValue("TIME_ARGS");
                cmdarr = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), time_cmd, "", "-n");
                result = this.runcmd(nodeinfo, cmdarr, true);
                outStr = result.getOutStr();
                result.setResult(null);
                try {
                    StringTokenizer st = new StringTokenizer(outStr, " :");
                    if (st.countTokens() == 3) {
                        hour = Integer.valueOf(st.nextToken());
                        minute = Integer.valueOf(st.nextToken());
                        if (st.nextToken().equals("PM")) {
                            hour += 12;
                        }
                        int val = (int)new GregorianCalendar(year, month, date, hour, minute).getTimeInMillis();
                        result.setResult(new Integer(val));
                    } else {
                        result.setStatus(false);
                    }
                }
                catch (NumberFormatException e) {
                    result.setException(new CommandException(node, e));
                    result.setStatus(false);
                }
            }
        }
        return result;
    }

    @Override
    public ClusterResult isSharedPath(SessionId sessId, String pathName, String[] nodeNames) throws FatalException, RemoteFileOperationException, SharedDeviceException {
        ClusterLogger.log("entering NativeSystem.isSharedPath()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        int stime = 0;
        String sleep_time = System.getProperty("oracle.sysman.prov.sleep_time");
        if (sleep_time.trim() != null) {
            stime = Integer.getInteger("oracle.sysman.prov.sleep_time");
        }
        if (nodeNames.length < 2) {
            StringBuffer sb = new StringBuffer();
            if (nodeNames.length > 0) {
                sb.append(nodeNames[0]);
            }
            Object[] args = new String[]{sb.toString(), String.valueOf(nodeNames.length), String.valueOf(2)};
            ClusterLogger.log("nodeNames length is less than 2");
            throw new FatalException("PROV-16024", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16024", (Object[])args));
        }
        boolean isLocalNode = this.isLocalNode(nodeNames[0]);
        String localnode = null;
        if (isLocalNode) {
            localnode = nodeNames[0];
            String[] newNodeNames = new String[nodeNames.length - 1];
            System.arraycopy(nodeNames, 1, newNodeNames, 0, nodeNames.length - 1);
            nodeNames = newNodeNames;
        }
        try {
            this.startup(sessId, nodeNames);
        }
        catch (ClusterException e) {
            throw new SharedDeviceException(e);
        }
        Assertions.assertName(pathName);
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo = sess.getNodeInfo(nodeNames[0]);
        NativeSystem ns = nodeinfo.getNativeSystem();
        pathName = ns.getStandardForm(pathName);
        String tempFile = "CFSFileName" + String.valueOf(System.currentTimeMillis());
        ClusterLogger.log("pathName = " + pathName + "  tempFile = " + tempFile);
        File dirPath = new File(pathName);
        CommandResult res = null;
        if (isLocalNode) {
            while (!dirPath.isDirectory()) {
                if (dirPath.getParentFile() != null) {
                    dirPath = dirPath.getParentFile();
                    continue;
                }
                ClusterLogger.log("None of the parent directories of the path " + pathName + " exist on node " + nodeNames[0]);
                throw new SharedDeviceException("PROV-16000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16000", (Object[])new String[]{pathName}), null);
            }
            pathName = dirPath.getAbsolutePath();
        } else {
            String testpath = pathName;
            while (!(res = ns.pathExists(nodeinfo, testpath, 8)).getStatus()) {
                if ((testpath = OiixPathOps.getParentDir((String)testpath)) != null) continue;
                ClusterLogger.log("None of the parent directories of the path " + pathName + " exist on node " + nodeNames[0]);
                throw new SharedDeviceException("PROV-16000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16000", (Object[])new String[]{pathName}), null);
            }
            pathName = testpath;
        }
        String localTempFile = null;
        String remoteTempFile = null;
        if (isLocalNode) {
            remoteTempFile = localTempFile = OiixPathOps.concatPath((String)pathName, (String)tempFile);
        } else {
            String scratchPath = sess.getLocalPaths().getValue("SCRATCHPATH");
            localTempFile = OiixPathOps.concatPath((String)scratchPath, (String)tempFile);
            remoteTempFile = OiixPathOps.concatPath((String)pathName, (String)tempFile);
        }
        File newTempFile = new File(localTempFile);
        newTempFile.delete();
        this.removeFileFromNodes(sessId, nodeNames, remoteTempFile);
        ClusterLogger.log("creating file " + localTempFile);
        FileOutputStream fos = null;
        res = new CommandResult(localnode);
        try {
            fos = new FileOutputStream(newTempFile);
            fos.write("This is CFS test file content".getBytes());
            fos.flush();
        }
        catch (FileNotFoundException e) {
            ClusterLogger.log("Failed to create the test CFS file at " + localTempFile);
            if (newTempFile.exists()) {
                newTempFile.delete();
            }
            throw new SharedDeviceException("PROV-16025", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16025", (Object[])new String[]{localTempFile, localnode}), null);
        }
        catch (IOException e) {
            ClusterLogger.log("Failed to write to the test CFS file " + localTempFile);
            if (newTempFile.exists()) {
                newTempFile.delete();
            }
            throw new SharedDeviceException("PROV-16025", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16025", (Object[])new String[]{localTempFile, localnode}), null);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (!isLocalNode) {
            this.copyFile(sess.getLocalNodeInfo(), localTempFile, sess.getNodeInfo(nodeNames[0]), remoteTempFile);
        }
        try {
            if (sleep_time == null) {
                ClusterLogger.log("isSharedPath: Sleeping for: 8 seconds ", ClusterLogger.LOG_INFO, true);
                Thread.sleep(8000L);
            } else {
                ClusterLogger.log("isSharedPath: Sleeping for: " + sleep_time + " milliseconds", ClusterLogger.LOG_INFO, true);
                Thread.sleep(stime);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Command[] sharedPathCmds = new SharedPathCommand[nodeNames.length];
        nodeinfo = null;
        ns = null;
        for (int i = 0; i < nodeNames.length; ++i) {
            nodeinfo = sess.getNodeInfo(nodeNames[i]);
            sharedPathCmds[i] = new SharedPathCommand(nodeinfo, remoteTempFile);
        }
        ClusterManager clusterManager = new ClusterManager();
        ClusterResult clusterResult = clusterManager.submit(sharedPathCmds);
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (isLocalNode) {
            Hashtable<String, CommandResult> t = new Hashtable<String, CommandResult>();
            CommandResult resultOnNode = CommandResult.SUCCESS(localnode);
            resultOnNode.setResult(new Boolean(true));
            t.put(localnode, resultOnNode);
            while (results.hasNext()) {
                resultOnNode = (CommandResult)results.next();
                t.put(resultOnNode.getNodeName(), resultOnNode);
            }
            clusterResult = new GenericResult(t);
            results = clusterResult.getResults();
        }
        newTempFile.delete();
        nodeinfo = sess.getNodeInfo(nodeNames[0]);
        ns = nodeinfo.getNativeSystem();
        ns.removeFile(nodeinfo, remoteTempFile);
        if (status == 0) {
            return clusterResult;
        }
        String failedNodeList = WindowsSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16031", (Object[])new String[]{pathName, failedNodeList});
        throw new SharedDeviceException("PROV-16031", errorMessage, results);
    }

    @Override
    public CommandResult createCFSFile(NodeInfo nodeinfo, String filePath) {
        ClusterLogger.log("entering WindowsSystem.createCFSFile()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        CommandResult result = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String cmd = "'" + paths.getValue("TOUCH_PATH") + "'" + " '" + filePath + "'";
        String[] unixcmd = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), cmd, "", null);
        result = this.runcmd(nodeinfo, unixcmd, true);
        if (!result.getStatus()) {
            return result;
        }
        cmd = " echo This is CFS test file content > '" + filePath + "'";
        unixcmd = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), cmd, "", null);
        return this.runcmd(nodeinfo, unixcmd, true);
    }

    @Override
    public CommandResult testCFSFile(NodeInfo nodeinfo, String path) {
        ClusterLogger.log("entering WindowsSystem.testCFSFile()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        ClusterLogger.log("node " + node + " path " + path, ClusterLogger.LOG_FINER);
        File filePath = new File(path);
        CommandResult result = null;
        String cmd = paths.getValue("MORE_PATH") + " '" + WindowsSystem.getNativeForm(path) + "'";
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String[] unixcmd = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), cmd, "", "-n");
        result = this.runcmd(nodeinfo, unixcmd, true);
        String outStr = result.getOutStr();
        if (outStr.indexOf("This is CFS test file content") == -1) {
            ClusterLogger.log(node + " Command output is empty");
            result.setException(new CommandException(node, "PROV-16031", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"ERROR_SHARED_DEVICE0", (Object[])new Object[]{path, node})));
            result.setStatus(false);
            result.setResult(new Boolean(false));
        }
        return result;
    }

    @Override
    public CommandResult getFreeSpace(NodeInfo nodeinfo, String path) {
        ClusterLogger.log("entering WindowsSystem.getFreeSpace()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        String[] unixcmd = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String cmd = paths.getValue("DF_PATH");
        String cmdArgs = paths.getValue("DF_ARGS") + " " + path;
        unixcmd = r_eng.formulateCmd(bSsh, sess, node, paths, cmd, cmdArgs, "-n");
        CommandResult res = this.runcmd(nodeinfo, unixcmd, bSsh);
        Integer space = null;
        if (res.getStatus()) {
            String outStr = res.getOutStr();
            StringTokenizer st = new StringTokenizer(outStr, LINE_SEPARATOR);
            if (st.countTokens() >= 2) {
                int col = 5;
                StringTokenizer st1 = new StringTokenizer(st.nextToken());
                int numCols = st1.countTokens();
                String colName = paths.getValue("DF_COL_NAME");
                int idx = -1;
                for (int i = 0; i < numCols; ++i) {
                    idx = st1.nextToken().indexOf(colName);
                    if (idx == -1) continue;
                    col = i + 1;
                }
                st1 = new StringTokenizer(st.nextToken());
                int k = 0;
                while (true) {
                    if (st1.hasMoreTokens()) {
                        String token = st1.nextToken();
                        if (++k != col) continue;
                        try {
                            space = new Integer(token);
                            res.setResult(space);
                        }
                        catch (NumberFormatException nfe) {
                            res.setException(new CommandException(node, nfe));
                        }
                        break;
                    }
                    if (!st.hasMoreTokens()) break;
                    st1 = new StringTokenizer(st.nextToken());
                }
                if (space == null) {
                    res.setException(new CommandException(node, "PROV-16023", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"ERROR_FREE_SPACE0")));
                }
            } else {
                res.setException(new CommandException(node, "PROV-16023", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"ERROR_FREE_SPACE1")));
            }
        }
        if (space == null) {
            res.setStatus(false);
            res.setResult(new Integer(0));
        }
        return res;
    }

    @Override
    public String createFileName(NodeInfo nodeinfo, String fileName) {
        String nodeName = nodeinfo.getNodeName();
        String username = ((Session)s_sessions.get(nodeinfo.getSessionId())).getUsername();
        fileName = this.getStandardForm(fileName);
        StringBuffer file = new StringBuffer();
        boolean localfile = false;
        if (nodeName.equals("localhost")) {
            localfile = true;
            file.append("\"");
        } else {
            if (username != null) {
                file.append(username);
                file.append("@");
            }
            file.append(nodeName);
            file.append(":'");
        }
        if (fileName.indexOf(":") == 1) {
            file.append("/cygdrive/");
            file.append(fileName.charAt(0));
            file.append(fileName.substring(2));
        } else {
            file.append(fileName);
        }
        if (localfile) {
            file.append("\"");
        } else {
            file.append("'");
        }
        return file.toString();
    }

    @Override
    public CommandResult extractArchive(String filename, NodeInfo nodeinfo, String destdir, int cmd, boolean extractModificationTime, String unzipCmd) {
        ClusterLogger.log("entering WindowsSystem.extractArchive()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String nodename = nodeinfo.getNodeName();
        String archiveCmd = null;
        archiveCmd = unzipCmd != null && unzipCmd.trim().length() > 0 ? unzipCmd : "'" + paths.getValue("UNZIP_PATH") + "' " + paths.getValue("UNZIP_ARGS");
        String cmdstr = "cd '" + destdir + "' && " + archiveCmd + " '" + filename + "'";
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String[] wincmd = r_eng.formulateCmd(sess, true, nodename, paths, sess.getSshPath(), sess.getSshArgs(), cmdstr, "", "-n");
        return this.runcmd(nodeinfo, wincmd, true);
    }

    @Override
    public ClusterResult copyListedPathsToNodes(SessionId sessId, String[] nodeNames, String dirName, String copyListFile, String excludeListFile, String tmpDir, boolean create) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering WindowsSystem.copyListedPathsToNodes()", ClusterLogger.LOG_FINER);
        if (dirName == null || dirName.trim().length() == 0) {
            throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
        }
        return super.copyListedPathsToNodes(sessId, nodeNames, dirName, copyListFile, excludeListFile, tmpDir, create);
    }

    @Override
    public CommandResult copyAndExtractArchive(String archive, NodeInfo nodeinfo, String destdir, boolean create, int cmd, boolean extractModificationTime) {
        return this.copyAndExtractArchive(archive, nodeinfo, destdir, create, cmd, extractModificationTime, null);
    }

    @Override
    public CommandResult copyAndExtractArchive(String archive, NodeInfo nodeinfo, String destdir, boolean create, int cmd, boolean extractModificationTime, String tempLoc) {
        ClusterLogger.log("entering WindowsSystem.copyAndExtractArchive()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String nodename = nodeinfo.getNodeName();
        CommandResult res = null;
        if (destdir != null && create && !(res = this.createDir(nodeinfo, destdir)).getStatus()) {
            return res;
        }
        if (tempLoc == null) {
            tempLoc = nodeinfo.getScratchPath();
        } else {
            res = this.createDir(nodeinfo, tempLoc);
            if (!res.getStatus()) {
                return res;
            }
        }
        archive = OiixPathOps.getStandardForm((String)archive);
        String remoteArchive = OiixPathOps.concatPath((String)tempLoc, (String)("remote" + OiixPathOps.getFileName((String)archive)));
        res = this.copyFile(sess.getLocalNodeInfo(), archive, nodeinfo, remoteArchive);
        if (!res.getStatus()) {
            return res;
        }
        this.extractArchive(remoteArchive, nodeinfo, destdir, 6, true, null);
        this.removeFile(nodeinfo, remoteArchive);
        return res;
    }

    @Override
    public CommandResult copyDirFromNode(NodeInfo nodeinfo, String sourcedir, String destdir, boolean extractModificationTime, String tempLoc) {
        ClusterLogger.log("entering WindowsSystem.copyDirFromNode()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String nodename = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        CommandResult res = null;
        String timestamp = this.getTimeStamp();
        String rArchive = "remoteArchive" + nodename + timestamp + ".zip";
        String lArchive = "localArchive" + nodename + timestamp + ".zip";
        String sourceTar = null;
        String destTar = null;
        int stime = 0;
        String sleep_time = System.getProperty("oracle.sysman.prov.sleep_time");
        if (sleep_time != null) {
            stime = Integer.getInteger("oracle.sysman.prov.sleep_time");
        }
        if (tempLoc == null) {
            sourceTar = nodeinfo.getScratchPath() + FILE_SEPARATOR + rArchive;
            destTar = sess.getLocalNodeInfo().getScratchPath() + "/" + lArchive;
        } else {
            res = this.createDir(nodeinfo, tempLoc);
            if (!res.getStatus()) {
                return res;
            }
            sourceTar = tempLoc + FILE_SEPARATOR + rArchive;
            destTar = tempLoc + "/" + lArchive;
        }
        String cmd = this.getZipCommand(sourceTar, sourcedir, null, null, paths);
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String[] unixcmd1 = r_eng.formulateCmd(sess, true, nodename, paths, sess.getSshPath(), sess.getSshArgs(), cmd, "", "-n");
        res = this.runcmd(nodeinfo, unixcmd1, bSsh);
        try {
            if (sleep_time == null) {
                ClusterLogger.log("Sleeping for: 8 seconds ", ClusterLogger.LOG_INFO, true);
                Thread.sleep(8000L);
            } else {
                ClusterLogger.log("Sleeping for: " + sleep_time + " seconds", ClusterLogger.LOG_INFO, true);
                Thread.sleep(stime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        res = this.copyFile(nodeinfo, sourceTar, sess.getLocalNodeInfo(), destTar);
        if (!res.getStatus()) {
            return res;
        }
        try {
            if (sleep_time == null) {
                ClusterLogger.log("Sleeping for: 8 seconds ", ClusterLogger.LOG_INFO, true);
                Thread.sleep(8000L);
            } else {
                ClusterLogger.log("Sleeping for: " + sleep_time + " seconds", ClusterLogger.LOG_INFO, true);
                Thread.sleep(stime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        destdir = destdir + "/" + nodename;
        new File(destdir).mkdirs();
        sess.getLocalNodeInfo().getNativeSystem().extractArchiveOnLocalNode(sess.getLocalNodeInfo(), this.getStandardForm(destTar), this.getStandardForm(destdir), 6, true);
        this.removeFile(nodeinfo, sourceTar);
        new File(destTar).delete();
        return res;
    }

    @Override
    protected CommandResult extractArchiveOnLocalNode(NodeInfo nodeinfo, String archiveFile, String destdir, int cmd, boolean extractModificationTime) {
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths localPaths = sess.getLocalPaths();
        String unixcmd = "cd '" + destdir + "' && '" + localPaths.getValue("UNZIP_PATH") + "' " + localPaths.getValue("UNZIP_ARGS") + " '" + archiveFile + "'";
        String[] cmdArray = new String[]{localPaths.getValue("SHELL_PATH"), localPaths.getValue("SHELL_ARGS"), unixcmd};
        ClusterLogger.log("command to be run: " + this.convertToStr(cmdArray), ClusterLogger.LOG_INFO, true);
        return this.runcmd(sess.getLocalNodeInfo(), cmdArray, true);
    }

    @Override
    public ClusterResult createListedDirsOnNodes(SessionId sessId, String[] nodeNames, String createListFile, String parentDir, String tmpDir) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering WindowsSystem.createListedDirsOnNodes()", ClusterLogger.LOG_FINER);
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    @Override
    public CommandResult createListedDirs(NodeInfo nodeinfo, String createListFile) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    @Override
    public CommandResult createListedDirs(NodeInfo nodeinfo, String createListFile, String tempLoc) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    @Override
    public CommandResult removeFile(NodeInfo nodeinfo, String file) {
        ClusterLogger.log("entering UnixSystem.removeFile()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        file = this.getStandardForm(file);
        file = WindowsSystem.getNativeForm(file);
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String cmd = paths.getValue("RM_PATH") + " " + paths.getValue("RM_F_ARGS") + " '" + file + "'";
        String[] cmdarr = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), cmd, "", "-n");
        CommandResult result = this.runcmd(nodeinfo, cmdarr, true);
        String errors = result.getErrStr();
        if (errors != null && (errors = errors.toLowerCase()).indexOf(paths.getValue("RM_ERR1")) != -1) {
            result.setStatus(true);
            result.setResult(new Boolean(true));
            result.setException(null);
        }
        return result;
    }

    @Override
    public CommandResult removeDir(NodeInfo nodeinfo, String dir, boolean recurse, boolean deleteEmptyParent) {
        ClusterLogger.log("entering WindowsSystem.removeDir()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        String unixcmd = null;
        dir = this.getStandardForm(dir);
        dir = WindowsSystem.getNativeForm(dir);
        if (recurse) {
            unixcmd = paths.getValue("RMDIR_PATH") + " " + paths.getValue("RM_RF_ARGS");
            unixcmd = unixcmd + " '" + dir + "'";
        } else {
            unixcmd = paths.getValue("RMDIR_PATH");
            unixcmd = unixcmd + " '" + WindowsSystem.getNativeForm(dir) + "'";
        }
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String[] cmdarr = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), unixcmd, "", "-n");
        CommandResult result = this.runcmd(nodeinfo, cmdarr, true);
        String errors = result.getErrStr();
        if (errors != null && errors.indexOf(paths.getValue("RM_ERR1")) != -1) {
            result.setStatus(true);
            result.setResult(new Boolean(true));
            result.setException(null);
        }
        if (result.getStatus() && deleteEmptyParent) {
            String parent = this.getStandardForm(dir);
            CommandResult res2 = result;
            while (parent != null && res2.getStatus()) {
                parent = this.getParentDir(parent);
                String cmd = paths.getValue("RMDIR_PATH") + " '" + WindowsSystem.getNativeForm(parent) + "'";
                cmdarr = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), cmd, "", "-n");
                res2 = this.runcmd(nodeinfo, cmdarr, true);
            }
        }
        return result;
    }

    @Override
    public ClusterResult removeListedPathsFromNodes(SessionId sessId, String[] nodeNames, String removeListFile, int pathType) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering WindowsSystem.removeListedFilesFromNode()", ClusterLogger.LOG_FINER);
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    @Override
    public CommandResult removeListedPaths(NodeInfo nodeinfo, String removeListFile, int pathType) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    @Override
    public CommandResult runRootCmd(String cmd, String[] args, String[] env, String password, NodeInfo nodeinfo) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    @Override
    protected CommandResult linkFile(NodeInfo nodeinfo, String sourceFile, String destFile) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    @Override
    public CommandResult pathExists(NodeInfo nodeinfo, String path, int pathType) {
        ClusterLogger.log("entering WindowsSystem.pathExists()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        CommandResult result = null;
        String unixcmd = null;
        String[] unixcmd1 = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        if (pathType == 11) {
            unixcmd = r_eng.formulateCmd(sess, nodeinfo, "CMD2", path, paths.getValue("DIR_EXISTS_FLAG"), paths);
            unixcmd1 = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), unixcmd, "", "-n");
            result = this.runcmd(nodeinfo, unixcmd1, true);
            if (result.getStatus()) {
                unixcmd = r_eng.formulateCmd(sess, nodeinfo, "CMD2", path, paths.getValue("DIR_WRITABLE_FLAG"), paths);
                unixcmd1 = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), unixcmd, "", "-n");
                result = this.runcmd(nodeinfo, unixcmd1, true);
            }
        } else {
            String flags = "";
            switch (pathType) {
                case 8: {
                    flags = paths.getValue("DIR_EXISTS_FLAG");
                    break;
                }
                case 9: {
                    flags = paths.getValue("FILE_EXISTS_FLAG");
                    break;
                }
                default: {
                    flags = paths.getValue("PATH_EXISTS_FLAG");
                }
            }
            unixcmd = r_eng.formulateCmd(sess, nodeinfo, "CMD2", path, flags, paths);
            unixcmd1 = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), unixcmd, "", "-n");
            result = this.runcmd(nodeinfo, unixcmd1, true);
        }
        return result;
    }

    @Override
    public CommandResult moveFile(NodeInfo nodeinfo, String sourceFile, String destFile) {
        ClusterLogger.log("entering WindowsSystem.moveFile()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        sourceFile = WindowsSystem.getNativeForm(sourceFile);
        destFile = WindowsSystem.getNativeForm(destFile);
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String unixcmd = paths.getValue("MV_PATH") + " " + paths.getValue("MV_ARGS") + " '" + sourceFile + "' '" + destFile + "'";
        String[] cmdarr = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), unixcmd, "", "-n");
        return this.runcmd(nodeinfo, cmdarr, true);
    }

    @Override
    public CommandResult listDirectory(NodeInfo nodeinfo, String dirPath) {
        ClusterLogger.log("entering WindowsSystem.listDirectory()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String unixcmd = "'" + paths.getValue("LS_PATH") + "' " + paths.getValue("LS_ARGS") + " '" + dirPath + "'";
        String[] cmdarr = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), unixcmd, "", "-n");
        CommandResult result = this.runcmd(nodeinfo, cmdarr, true);
        if (result.getStatus()) {
            String outStr = result.getOutStr();
            StringTokenizer st = new StringTokenizer(outStr);
            int num = st.countTokens();
            String[] filelist = new String[num];
            for (int i = 0; i < num; ++i) {
                filelist[i] = st.nextToken();
            }
            result.setResult(filelist);
        }
        return result;
    }

    @Override
    public CommandResult getHostName(NodeInfo nodeinfo) {
        String outStr;
        StringTokenizer st;
        ClusterLogger.log("entering WindowsSystem.getHostName()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        if (this.isLocalNode(node)) {
            CommandResult result = CommandResult.SUCCESS(node);
            result.setResult(s_sHostnameLocal);
            return result;
        }
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String unixcmd = "'" + paths.getValue("HOSTNAME_PATH") + "'";
        String[] cmdarr = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), unixcmd, "", null);
        CommandResult result = this.runcmd(nodeinfo, cmdarr, true);
        result.setResult(null);
        if (result.getStatus() && (st = new StringTokenizer(outStr = result.getOutStr())).countTokens() > 0) {
            result.setResult(st.nextToken());
        }
        return result;
    }

    @Override
    public CommandResult getHostName(NodeInfo nodeinfo, boolean fullname) {
        return null;
    }

    @Override
    public String getExeName(String cmd) {
        return cmd + ".exe";
    }

    @Override
    protected String getPingPath() {
        return this.getWindowsCommandPath("ping.exe");
    }

    protected String getWindowsCommandPath(String cmdName) {
        String winCmd = null;
        String result = null;
        if (result != null) {
            File file = new File(result + FILE_SEPARATOR + cmdName);
            if (file.exists()) {
                winCmd = file.getAbsolutePath();
            } else {
                file = new File(result + FILE_SEPARATOR + "system32" + FILE_SEPARATOR + cmdName);
                if (file.exists()) {
                    winCmd = file.getAbsolutePath();
                }
            }
        }
        ClusterLogger.log("winCmd = " + winCmd);
        return winCmd;
    }

    @Override
    public CommandResult runCmd(String cmd, String[] args, String[] env, NodeInfo nodeinfo) {
        int i;
        ClusterLogger.log("entering WindowsSystem.runCmd()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        String cmd1 = "";
        if (env != null) {
            for (i = 0; i < env.length; ++i) {
                cmd1 = cmd1 + env[i] + " ";
            }
            cmd1 = cmd1 + ";";
        }
        cmd1 = cmd1 + "'" + cmd + "'";
        if (args != null) {
            for (i = 0; i < args.length; ++i) {
                cmd1 = cmd1 + " " + args[i] + " ";
            }
        }
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String[] cmdArr = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), cmd1, "", "-n");
        return this.runcmd(nodeinfo, cmdArr, true);
    }

    @Override
    public CommandResult runRemoteSSHCmd(String[] args, String[] env, NodeInfo nodeinfo, String remoteNode, String username) {
        int i;
        Paths paths = nodeinfo.getPaths();
        String cmd = paths.getValue("SSH_PATH") + " " + paths.getValue("SSH_ARGS") + " -l " + username + " -n " + remoteNode + " '" + paths.getValue("SH_PATH") + " " + paths.getValue("SH_ARGS") + " '" + paths.getValue("DATE_PATH") + " " + paths.getValue("DATE_ARGS") + "''";
        ClusterLogger.log("entering WindowsSystem.runRemoteSSHCmd()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        String node = nodeinfo.getNodeName();
        String cmd1 = "";
        if (env != null) {
            for (i = 0; i < env.length; ++i) {
                cmd1 = cmd1 + env[i] + " ";
            }
            cmd1 = cmd1 + ";";
        }
        cmd1 = cmd1 + "'" + cmd + "'";
        if (args != null) {
            for (i = 0; i < args.length; ++i) {
                cmd1 = cmd1 + " " + args[i] + " ";
            }
        }
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        String[] cmdArr = r_eng.formulateCmd(sess, true, node, paths, sess.getSshPath(), sess.getSshArgs(), cmd1, "", "-n", username);
        return this.runcmd(nodeinfo, cmdArr, true);
    }

    @Override
    protected String getDefaultDestDirToExtractFiles() throws FatalException {
        return "C:/";
    }

    protected String getArchiveCommand(String archive, String parentDir, String copyListFile, String exclListFile, Paths paths) throws FatalException {
        paths.isValidated("ZIP_PATH");
        return this.getZipCommand(archive, parentDir, copyListFile, exclListFile, paths);
    }

    @Override
    protected int getArchiveCommandToBeUsed(int remotePlatId) {
        return 6;
    }

    @Override
    protected String getTmpArchivePath(String tmpDir) {
        String filename = tmpDir + FILE_SEPARATOR + "tempArchive" + this.getTimeStamp() + ".zip";
        return filename;
    }

    @Override
    protected void createArchive(String archive, String srcDir, String copyListFile, String excludeListFile, Session sess) throws FatalException {
        Paths paths = sess.getLocalPaths();
        String[] cmdArray = new String[]{paths.getValue("SHELL_PATH"), paths.getValue("SHELL_ARGS"), this.getArchiveCommand(archive, srcDir, copyListFile, excludeListFile, paths)};
        ClusterLogger.log("command to be run: " + this.convertToStr(cmdArray), ClusterLogger.LOG_INFO, true);
        CommandResult result = this.runcmd(sess.getLocalNodeInfo(), cmdArray, true);
        if (!result.getStatus()) {
            throw new FatalException("PROV-16036", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16036"), (Throwable)((Object)result.getException()));
        }
    }

    @Override
    protected void checkRemoteShell(Session sess) throws RemoteShellFatalException {
        String remoteshell = sess.getPreference("REMOTE_SHELL");
        if (remoteshell != null) {
            if (!remoteshell.equalsIgnoreCase("ssh")) {
                Object[] args = new Object[]{remoteshell};
                throw new RemoteShellFatalException("PROV-16006", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16006", (Object[])args));
            }
            ClusterLogger.log("Client requested for a valid remote shell: " + remoteshell);
            sess.setUserShellSpecified(true);
            sess.setIsUserShellSsh(true);
            ClusterLogger.log("Is remote shell specified by user? [Session Id = " + sess.getSessionId() + "]: " + true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void checkUserEquivPrereqs(Session sess) throws RemoteShellFatalException {
        if (sess.isUserShellSpecified()) {
            try {
                if (!sess.isUserShellSsh() || !s_bUseExistingSSH) return;
                Assertions.validatePath(sess.getSshPath());
                Assertions.validatePath(sess.getScpPath());
                sess.setSsh(true);
                return;
            }
            catch (FatalException fe) {
                ClusterLogger.log((Throwable)((Object)fe));
                Object[] args = new Object[]{sess.getSshPath() + " " + sess.getScpPath()};
                throw new RemoteShellFatalException("PROV-16006", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"INVALID_REMOTE_SHELL0", (Object[])args));
            }
        }
        boolean error = false;
        try {
            if (s_bUseExistingSSH) {
                Assertions.validatePath(sess.getSshPath());
                Assertions.validatePath(sess.getScpPath());
            }
            sess.setSsh(true);
        }
        catch (FatalException fe) {
            error = true;
            ClusterLogger.log(fe.getErrorMessage());
        }
        if (!error) return;
        throw new RemoteShellFatalException("PROV-16021", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16021"));
    }

    @Override
    protected void checkCreateListedDirPrereqs(Paths paths) throws FatalException {
    }

    @Override
    protected void checkRemoveListedPathsPrereqs(Paths paths) throws FatalException {
    }

    public static String getNativeForm(String stdPath) {
        String retPath = stdPath.replace('/', '\\');
        return retPath;
    }

    @Override
    protected CommandResult convertFile(NodeInfo nodeinfo, int platform, String file) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }
}

