/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.nativesystem;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Assertions;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Constants;

public class ValidatePaths
implements Constants {
    private static boolean DEBUG = false;
    private static String[] VARS = new String[]{"PING_PATH", "TRUE", "RSH_PATH", "RCP_PATH", "SSH_PATH", "SCP_PATH", "SH_PATH", "TAR_PATH", "UNZIP_PATH", "ZIP_PATH", "CAT_PATH", "MKDIR_PATH", "RM_PATH", "RMDIR_PATH", "CHMOD_PATH", "CHOWN_PATH", "XARGS_PATH", "DF_PATH", "MV_PATH", "SUDO_PATH", "LN_PATH", "LS_PATH", "TOUCH_PATH", "HOSTNAME_PATH", "DATE_PATH", "CP_PATH", "SCRATCHPATH"};
    private static final String PLATFORM_INFO_PROPERTIES = "platformInfo.properties";
    private static final String RESOURCE_LOC = "oracle/sysman/prov/remoteinterfaces/nativesystem/";
    private static String s_sPropertiesDir = null;
    private static Map s_platInfo = null;
    private static Map m_props = null;

    private static boolean loadFile(String path) {
        Properties temp = ValidatePaths.loadPropertiesFile(path);
        if (temp == null) {
            return false;
        }
        Enumeration<?> propNames = temp.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propVal = (String)temp.get(propName);
            m_props.put(propName, propVal);
        }
        return true;
    }

    private static void loadResource(String path) {
        path = OiixPathOps.getNativeForm((String)path);
        InputStream in = ClassLoader.getSystemResourceAsStream(path);
        Properties temp = null;
        if (in != null) {
            try {
                temp = new Properties();
                temp.load(in);
                in.close();
            }
            catch (IOException e) {
                System.out.println(e);
            }
            Enumeration<?> propNames = temp.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propVal = (String)temp.get(propName);
                m_props.put(propName, propVal);
            }
        }
    }

    private static Properties loadPropertiesFile(String path) {
        path = OiixPathOps.getNativeForm((String)path);
        Properties temp = null;
        try {
            FileInputStream fs = new FileInputStream(path);
            temp = new Properties();
            temp.load(fs);
            fs.close();
        }
        catch (IOException e2) {
            System.out.println(e2.getMessage());
        }
        return temp;
    }

    private static void validatePaths() {
        System.out.print("\nVerify paths ..");
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < VARS.length; ++i) {
            String propName = VARS[i];
            String val = (String)m_props.get(propName);
            System.out.print(".");
            if (val != null) {
                try {
                    Assertions.validatePath(val);
                }
                catch (FatalException e) {
                    buf.append(propName);
                    buf.append("=");
                    buf.append(val);
                    buf.append("\n");
                }
                continue;
            }
            buf.append(propName);
            buf.append("=");
            buf.append("\n");
        }
        if (buf.length() > 0) {
            System.out.println("\n###############################################################\n");
            System.out.println("The following executables were not found at their default locations. Please provide the locations in userPaths.properties.\n");
            System.out.println(buf.toString());
            System.out.println("\nSteps to specify the command locations:");
            System.out.println("  Set system property oracle.sysman.prov.PathsPropertiesLoc to a directory d.\n  Create a file userPaths.properties in the directory d.\n  Specify the correct locations of the commands in the properties file.");
        } else {
            System.out.println("\nVerification completed successfully.");
        }
    }

    private static void loadPaths() {
        int platId = OiixPlatform.getCurrentPlatform();
        System.out.println("current platform id: " + platId);
        String[] files = (String[])s_platInfo.get(new Integer(platId));
        if (files == null || files.length == 0) {
            if (OiixPlatform.isPlatInGroup((int)-1, (int)platId)) {
                files = (String[])s_platInfo.get(new Integer(-1));
            }
            if (files == null || files.length == 0) {
                System.out.println("ERROR: Unable to find properties for the current platform.");
                System.exit(1);
            }
        }
        m_props = new HashMap();
        String absPath = null;
        boolean loadResource = true;
        for (int i = 0; i < files.length; ++i) {
            loadResource = true;
            if (s_sPropertiesDir != null) {
                absPath = OiixPathOps.concatPath((String)s_sPropertiesDir, (String)files[i]);
                System.out.println("Loading properties: " + absPath);
                boolean bl = loadResource = !ValidatePaths.loadFile(absPath);
            }
            if (!loadResource) continue;
            absPath = OiixPathOps.concatPath((String)RESOURCE_LOC, (String)files[i]);
            System.out.println("Loading properties from jar: " + absPath);
            ValidatePaths.loadResource(absPath);
        }
        if (DEBUG) {
            for (String propName : m_props.keySet()) {
                String val = (String)m_props.get(propName);
                System.out.println("Set " + propName + " to " + val);
            }
            System.out.println();
        }
    }

    public static void main(String[] args) {
        String absPath;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-dirloc") && i < args.length - 1 && args[i + 1].trim().length() != 0) {
                s_sPropertiesDir = OiixPathOps.getAbsolutePath((String)args[i + 1]);
                ++i;
                continue;
            }
            System.out.println("Optional arguments:\n -dirloc <location where the properties files are present>\n    If the properties file is not present in the specified location, it will search for the file in the classpath.\n");
            System.exit(1);
        }
        boolean loadResource = true;
        Properties temp = null;
        if (s_sPropertiesDir != null) {
            absPath = OiixPathOps.concatPath((String)s_sPropertiesDir, (String)PLATFORM_INFO_PROPERTIES);
            System.out.println("Loading platformInfo.properties: " + absPath);
            temp = ValidatePaths.loadPropertiesFile(absPath);
            boolean bl = loadResource = temp == null;
        }
        if (loadResource) {
            absPath = OiixPathOps.concatPath((String)RESOURCE_LOC, (String)PLATFORM_INFO_PROPERTIES);
            System.out.println("Loading platformInfo.properties from jar: " + absPath);
            InputStream in = ClassLoader.getSystemResourceAsStream(absPath);
            if (in != null) {
                try {
                    temp = new Properties();
                    temp.load(in);
                    in.close();
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
        }
        if (temp == null) {
            System.out.println("platformInfo.properties was not found.");
            System.exit(1);
        }
        s_platInfo = new HashMap();
        Enumeration<?> propNames = temp.propertyNames();
        if (DEBUG) {
            System.out.print("Supported platforms: ");
        }
        while (propNames.hasMoreElements()) {
            Integer propName = null;
            String tempName = null;
            try {
                tempName = (String)propNames.nextElement();
                propName = new Integer(tempName);
            }
            catch (NumberFormatException nfe) {
                System.out.println(nfe);
            }
            String propVal = (String)temp.get(tempName);
            StringTokenizer st = new StringTokenizer(propVal, ",");
            int numFiles = st.countTokens();
            String[] files = new String[numFiles];
            for (int i = 0; i < numFiles; ++i) {
                files[i] = st.nextToken();
            }
            if (DEBUG) {
                System.out.print(tempName + " ");
            }
            s_platInfo.put(propName, files);
        }
        if (DEBUG) {
            System.out.println();
        }
        ValidatePaths.loadPaths();
        ValidatePaths.validatePaths();
    }
}

