/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.nativesystem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.sysman.prov.remoteinterfaces.nativesystem.RemoteExecutionEngine;

public class UserPreferences {
    public static final String FALLBACK_TO_RSH = "FALLBACK_TO_RSH";
    public static final String RSH_PATH = "RSH_PATH";
    public static final String RCP_PATH = "RCP_PATH";
    public static final String SSH_PATH = "SSH_PATH";
    public static final String SCP_PATH = "SCP_PATH";
    public static final String REMOTE_SHELL = "REMOTE_SHELL";
    public static final String LOGIN_SHELL = "LOGIN_SHELL";
    public static final String TEMP_LOCATION = "TEMP_LOCATION";
    public static final String LOCAL_TEMP_LOCATION = "LOCAL_TEMP_LOCATION";
    public static final String REMOTE_TEMP_LOCATION = "REMOTE_TEMP_LOCATION";
    public static final String REMOTENODES_PLATFORM = "REMOTENODES_PLATFORM";
    public static final String REMOTE_PATH_PROPERTIES_LOC = "REMOTE_PATH_PROPERTIES_LOC";
    public static final String REMOTE_COMMAND_PLUGIN_NAME = "REMOTE_COMMAND_PLUGIN_NAME";
    public static final String DEOBFUSCATE_PASSWORD = "DEOBFUSCATE_PASSWORD";
    public static final String SUDO_PBRUN_PATH = "SUDO_PBRUN_PATH";
    public static final String SUDO_PBRUN_ARGS = "SUDO_PBRUN_ARGS";
    public static final String SUDO_PBRUN_PASSWORD = "SUDO_PBRUN_PASSWORD";
    public static final String SSH_VENDOR = "SSH_VENDOR";
    private Map m_preferences = new HashMap();
    private static final List s_prefNames = new ArrayList();

    public static List getPreferenceNames() {
        return s_prefNames;
    }

    public UserPreferences() {
        this.m_preferences.put(FALLBACK_TO_RSH, System.getProperty("oracle.sysman.prov.fallbackToRsh"));
        this.m_preferences.put(RSH_PATH, System.getProperty("oracle.sysman.prov.rshPath"));
        this.m_preferences.put(RCP_PATH, System.getProperty("oracle.sysman.prov.rcpPath"));
        this.m_preferences.put(SSH_PATH, System.getProperty("oracle.sysman.prov.sshPath"));
        this.m_preferences.put(SCP_PATH, System.getProperty("oracle.sysman.prov.scpPath"));
        this.m_preferences.put(REMOTE_SHELL, System.getProperty("oracle.sysman.prov.remoteShell"));
        this.m_preferences.put(LOGIN_SHELL, System.getProperty("oracle.sysman.prov.loginShell"));
        this.m_preferences.put(TEMP_LOCATION, System.getProperty("oracle.sysman.prov.tempLocation"));
        this.m_preferences.put(LOCAL_TEMP_LOCATION, System.getProperty("oracle.sysman.prov.localTempLocation"));
        this.m_preferences.put(REMOTE_TEMP_LOCATION, System.getProperty("oracle.sysman.prov.remoteTempLocation"));
        this.m_preferences.put(REMOTENODES_PLATFORM, System.getProperty("oracle.sysman.prov.remotenodes_platform"));
        this.m_preferences.put(REMOTE_PATH_PROPERTIES_LOC, System.getProperty("oracle.sysman.prov.RemotePathsPropertiesLoc"));
        this.m_preferences.put(REMOTE_COMMAND_PLUGIN_NAME, RemoteExecutionEngine.getDefaultPlugin());
        this.m_preferences.put(DEOBFUSCATE_PASSWORD, "false");
        this.m_preferences.put(SUDO_PBRUN_PATH, System.getProperty("oracle.sysman.prov.remoteinterfaces.sudo_pbrun_path"));
        this.m_preferences.put(SUDO_PBRUN_ARGS, System.getProperty("oracle.sysman.prov.remoteinterfaces.sudo_pbrun_args"));
        this.m_preferences.put(SUDO_PBRUN_PASSWORD, System.getProperty("oracle.sysman.prov.remoteinterfaces.sudo_pbrun_password"));
        this.m_preferences.put(SSH_VENDOR, "OpenSSH");
    }

    public UserPreferences(Map props) {
        this();
        Iterator names = props.keySet().iterator();
        String name = null;
        String value = null;
        while (names.hasNext()) {
            name = (String)names.next();
            if (this.m_preferences.get(name) != null) continue;
            value = (String)props.get(name);
            this.m_preferences.put(name, value);
        }
    }

    public void setPreference(String key, String value) {
        this.m_preferences.put(key, value);
    }

    public String getPreference(String key) {
        return (String)this.m_preferences.get(key);
    }

    static {
        s_prefNames.add(FALLBACK_TO_RSH);
        s_prefNames.add(RSH_PATH);
        s_prefNames.add(RCP_PATH);
        s_prefNames.add(SSH_PATH);
        s_prefNames.add(SCP_PATH);
        s_prefNames.add(REMOTE_SHELL);
        s_prefNames.add(LOGIN_SHELL);
        s_prefNames.add(TEMP_LOCATION);
        s_prefNames.add(LOCAL_TEMP_LOCATION);
        s_prefNames.add(REMOTE_TEMP_LOCATION);
        s_prefNames.add(REMOTENODES_PLATFORM);
        s_prefNames.add(REMOTE_PATH_PROPERTIES_LOC);
        s_prefNames.add(DEOBFUSCATE_PASSWORD);
        s_prefNames.add(REMOTE_COMMAND_PLUGIN_NAME);
        s_prefNames.add(SUDO_PBRUN_PATH);
        s_prefNames.add(SUDO_PBRUN_ARGS);
        s_prefNames.add(SUDO_PBRUN_PASSWORD);
        s_prefNames.add(SSH_VENDOR);
    }
}

