/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.nativesystem;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Commands;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Constants;
import oracle.sysman.prov.remoteinterfaces.nativesystem.NativeSystem;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Session;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SessionId;
import oracle.sysman.prov.remoteinterfaces.nativesystem.UnixSystem;
import oracle.sysman.prov.remoteinterfaces.nativesystem.WindowsSystem;
import oracle.sysman.prov.remoteinterfaces.nativesystem.WindowsSystemWMI;

public class SystemFactory
implements Constants {
    public static int s_localPlatId = OiixPlatform.getCurrentPlatform();
    private static Map s_platTable = new Hashtable();
    private static Map wmi_platTable = new Hashtable();
    private static Map config = new Hashtable();
    private static Map s_platInfo = new Hashtable();

    private static void loadConfig(Properties temp) {
        Enumeration<?> propNames = temp.propertyNames();
        while (propNames.hasMoreElements()) {
            Integer propName = null;
            String tempName = null;
            try {
                tempName = (String)propNames.nextElement();
                propName = new Integer(tempName);
            }
            catch (NumberFormatException nfe) {
                ClusterLogger.log(nfe);
            }
            String propVal = (String)temp.get(tempName);
            StringTokenizer st = new StringTokenizer(propVal, ",");
            int numFiles = st.countTokens();
            String[] rfiles = new String[numFiles];
            for (int i = 0; i < numFiles; ++i) {
                rfiles[i] = st.nextToken();
            }
            ClusterLogger.log("entering config property " + tempName);
            config.put(propName, rfiles);
        }
    }

    public static boolean useWMI() throws FatalException {
        String m_sPropertiesDir = System.getProperty("oracle.sysman.prov.PathsPropertiesLoc");
        if (m_sPropertiesDir != null) {
            m_sPropertiesDir = OiixPathOps.getAbsolutePath((String)m_sPropertiesDir);
            m_sPropertiesDir = OiixPathOps.concatPath((String)m_sPropertiesDir, (String)"remoteinterfaces_config.properties");
            ClusterLogger.log("remoteinterfaces_config.txt : " + m_sPropertiesDir, ClusterLogger.LOG_FINEST);
            Properties prop = Commands.loadPropertiesFile(m_sPropertiesDir);
            if (prop != null) {
                SystemFactory.loadConfig(prop);
                String useWMI = (String)config.get("useWMI");
                if (useWMI.trim().equals("TRUE")) {
                    ClusterLogger.log("useWMI returning true", ClusterLogger.LOG_FINEST);
                    return true;
                }
            }
        }
        ClusterLogger.log("useWMI returning false", ClusterLogger.LOG_FINEST);
        return false;
    }

    private static int getRemotePlatform(SessionId sessId) {
        String remotePlatId;
        Session sess;
        int remotePlatId_int = -1;
        if (NativeSystem.s_sessions != null && (sess = (Session)NativeSystem.s_sessions.get(sessId)) != null) {
            remotePlatId_int = sess.getRemoteNodesPlatform();
        }
        if (remotePlatId_int == -1 && (remotePlatId = System.getProperty("oracle.sysman.prov.remotenodes_platform")) != null) {
            try {
                Integer obj = new Integer(remotePlatId);
                remotePlatId_int = obj;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return remotePlatId_int;
    }

    public static NativeSystem CreateNativeSystemWMI(SessionId sessId) throws FatalException {
        ClusterLogger.log("entering SystemFactory.CreateNativeSystemWMI()", ClusterLogger.LOG_FINEST);
        NativeSystem nativesystem = (NativeSystem)wmi_platTable.get(new Integer(s_localPlatId));
        if (nativesystem != null) {
            return nativesystem;
        }
        nativesystem = new WindowsSystemWMI(sessId);
        wmi_platTable.put(new Integer(s_localPlatId), nativesystem);
        return nativesystem;
    }

    public static NativeSystem CreateNativeSystem(SessionId sessId) throws FatalException {
        ClusterLogger.log("entering SystemFactory.CreateNativeSystem()", ClusterLogger.LOG_FINEST);
        NativeSystem nativeSystem = (NativeSystem)s_platTable.get(new Integer(s_localPlatId));
        if (nativeSystem != null) {
            return nativeSystem;
        }
        if (OiixPlatform.isPlatInGroup((int)-1, (int)s_localPlatId)) {
            ClusterLogger.log("creating a NativeSystem object: platformGrp is UNIX", ClusterLogger.LOG_INFO);
            nativeSystem = new UnixSystem(sessId);
        } else if (OiixPlatform.isPlatInGroup((int)-3, (int)s_localPlatId)) {
            ClusterLogger.log("creating a NativeSystem object: platformGrp is Windows", ClusterLogger.LOG_INFO);
            nativeSystem = new WindowsSystem(sessId);
        } else {
            ClusterLogger.log("creating a NativeSystem object: Default platform is UNIX", ClusterLogger.LOG_INFO);
            nativeSystem = new UnixSystem(sessId);
        }
        s_platTable.put(new Integer(s_localPlatId), nativeSystem);
        try {
            String localhost = InetAddress.getLocalHost().getHostName();
            s_platInfo.put(localhost, new Integer(s_localPlatId));
        }
        catch (UnknownHostException e) {
            ClusterLogger.log(e);
        }
        return nativeSystem;
    }

    public static NativeSystem CreateNativeSystem(SessionId sessId, int platId) throws FatalException {
        ClusterLogger.log("entering SystemFactory.CreateNativeSystem()", ClusterLogger.LOG_FINEST);
        NativeSystem nativeSystem = (NativeSystem)s_platTable.get(new Integer(platId));
        if (nativeSystem == null || OiixPlatform.isPlatInGroup((int)-3, (int)platId) && OiixPlatform.isPlatInGroup((int)-3, (int)s_localPlatId)) {
            if (OiixPlatform.isPlatInGroup((int)-1, (int)platId)) {
                ClusterLogger.log("creating a NativeSystem object: platformGrp is UNIX", ClusterLogger.LOG_INFO, true);
                nativeSystem = new UnixSystem(sessId, platId);
            } else if (OiixPlatform.isPlatInGroup((int)-3, (int)platId)) {
                if (SystemFactory.useWMI()) {
                    if (platId == s_localPlatId) {
                        nativeSystem = new WindowsSystemWMI(sessId, platId);
                        ClusterLogger.log("creating a NativeSystem object: platformGrp is Windows : Using WMI", ClusterLogger.LOG_INFO, true);
                    } else {
                        ClusterLogger.log("creating a NativeSystem object: platformGrp is Windows : Using CYGWIN", ClusterLogger.LOG_INFO, true);
                        nativeSystem = new WindowsSystem(sessId, platId);
                    }
                } else {
                    ClusterLogger.log("creating a NativeSystem object: platformGrp is Windows : Using CYGWIN", ClusterLogger.LOG_INFO, true);
                    nativeSystem = new WindowsSystem(sessId, platId);
                }
            } else {
                ClusterLogger.log("creating a NativeSystem object: Default Platform is UNIX", ClusterLogger.LOG_INFO);
                nativeSystem = new UnixSystem(sessId, platId);
            }
            s_platTable.put(new Integer(platId), nativeSystem);
        }
        return nativeSystem;
    }

    public static NativeSystem CreateNativeSystem(SessionId sessId, String nodename) throws FatalException {
        ClusterLogger.log("entering SystemFactory.CreateNativeSystem(nodename)", ClusterLogger.LOG_FINEST);
        int platId = SystemFactory.getPlatform(sessId, nodename);
        return SystemFactory.CreateNativeSystem(sessId, platId);
    }

    public static void dispose() {
        ClusterLogger.log("entering SystemFactory.dispose()", ClusterLogger.LOG_FINEST);
        s_platTable.clear();
        s_platInfo.clear();
    }

    public static void setPlatformInfo(Map platInfo) {
        ClusterLogger.log("entering SystemFactory.setPlatformInfo()", ClusterLogger.LOG_FINEST);
        Iterator names = platInfo.keySet().iterator();
        String name = null;
        String value = null;
        while (names.hasNext()) {
            name = SystemFactory.getHostName((String)names.next());
            if (name == null || (value = (String)s_platInfo.get(name)) != null || (value = (String)platInfo.get(name)) == null) continue;
            s_platInfo.put(name, value);
        }
    }

    private static int getPlatform(SessionId sessId, String node) {
        Integer platId;
        int remoteplatId;
        ClusterLogger.log("entering SystemFactory.getPlatform()", ClusterLogger.LOG_FINEST);
        int platformId = s_localPlatId;
        boolean found = false;
        String hostname = SystemFactory.getHostName(node);
        if (hostname == null) {
            node = hostname;
        }
        if (node.equals(NativeSystem.s_sHostnameLocal) || node.equals(NativeSystem.s_sFullHostnameLocal)) {
            found = true;
        }
        if (!found && (remoteplatId = SystemFactory.getRemotePlatform(sessId)) != -1) {
            platformId = remoteplatId;
            found = true;
        }
        if (!found && (platId = (Integer)s_platInfo.get(node)) != null) {
            platformId = platId;
            found = true;
        }
        s_platInfo.put(node, new Integer(platformId));
        return platformId;
    }

    private static String getHostName(String name) {
        ClusterLogger.log("entering SystemFactory.getHostName()", ClusterLogger.LOG_FINEST);
        if (name != null) {
            try {
                name = InetAddress.getByName(name).getHostName();
            }
            catch (UnknownHostException e) {
                ClusterLogger.log(e);
            }
        }
        return name;
    }
}

