/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.nativesystem;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Assertions;

public class Paths {
    Map m_props = null;
    private Vector m_ignoreStrings = new Vector();
    private static int m_numStrings = 0;

    Paths() {
        this.m_props = new Hashtable();
    }

    public String getValue(String var) {
        String[] ret;
        if (var != null && (ret = (String[])this.m_props.get(var)) != null && ret[0] != null) {
            return ret[0];
        }
        return "";
    }

    public void setValue(String var, String value) {
        if (var != null && value != null) {
            this.m_props.put(var, new String[]{value, "0"});
        }
    }

    void setValue(String var, String value, String validated) {
        if (var != null && value != null) {
            if (validated.equals("1")) {
                this.m_props.put(var, new String[]{value, "1"});
            } else {
                this.m_props.put(var, new String[]{value, "0"});
            }
        }
    }

    boolean isValidated(String var) throws FatalException {
        String[] ret;
        if (var != null && (ret = (String[])this.m_props.get(var)) != null) {
            if (ret[1] != null && ret[1].equals("1")) {
                return true;
            }
            Assertions.validatePath(ret[0]);
            this.setValue(var, ret[0], "1");
            return true;
        }
        throw new FatalException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001"));
    }

    void readIgnoreMessages(BufferedReader bReader) {
        try {
            m_numStrings = 0;
            String txt = bReader.readLine();
            ClusterLogger.log("Ignore error strings:", ClusterLogger.LOG_FINEST);
            while (txt != null) {
                if (!(txt = txt.trim()).equals("")) {
                    ClusterLogger.log(txt, ClusterLogger.LOG_FINEST);
                    this.m_ignoreStrings.add(txt);
                }
                txt = bReader.readLine();
            }
            bReader.close();
        }
        catch (IOException e2) {
            ClusterLogger.log("Exception while reading the file ignoreMessages.txt. The strings specified might not get ignored.");
        }
        m_numStrings = this.m_ignoreStrings.size();
    }

    public synchronized boolean ignoreErrString(String str) {
        if ((str = str.trim()).equals("")) {
            return true;
        }
        for (int i = 0; i < m_numStrings; ++i) {
            String temp = (String)this.m_ignoreStrings.get(i);
            if (str.indexOf(temp) == -1) continue;
            return true;
        }
        return false;
    }
}

