/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.nativesystem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.sysman.emCfg.support.Formatter;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.cluster.NodeInfo;
import oracle.sysman.prov.remoteinterfaces.command.AdvancedUserEquivCommand;
import oracle.sysman.prov.remoteinterfaces.command.Command;
import oracle.sysman.prov.remoteinterfaces.command.CopyAndExtractCommand;
import oracle.sysman.prov.remoteinterfaces.command.CopyCommand;
import oracle.sysman.prov.remoteinterfaces.command.CopyDirFromNodeCommand;
import oracle.sysman.prov.remoteinterfaces.command.CreateDirCommand;
import oracle.sysman.prov.remoteinterfaces.command.CreateListedDirsCommand;
import oracle.sysman.prov.remoteinterfaces.command.DateCommand;
import oracle.sysman.prov.remoteinterfaces.command.NodeAliveCommand;
import oracle.sysman.prov.remoteinterfaces.command.RemoveDirCommand;
import oracle.sysman.prov.remoteinterfaces.command.RemoveFileCommand;
import oracle.sysman.prov.remoteinterfaces.command.RemoveListedPathsCommand;
import oracle.sysman.prov.remoteinterfaces.command.RunCommand;
import oracle.sysman.prov.remoteinterfaces.command.RunRootCommand;
import oracle.sysman.prov.remoteinterfaces.command.SharedPathCommand;
import oracle.sysman.prov.remoteinterfaces.command.UserEquivCommand;
import oracle.sysman.prov.remoteinterfaces.core.ClusterManager;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.exception.NodesAliveException;
import oracle.sysman.prov.remoteinterfaces.exception.PluginException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteFileOperationException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteShellException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteShellFatalException;
import oracle.sysman.prov.remoteinterfaces.exception.SharedDeviceException;
import oracle.sysman.prov.remoteinterfaces.exception.UserEquivalenceException;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Assertions;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Commands;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Constants;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.RemoteExecutionEngine;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Session;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SessionId;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SystemFactory;
import oracle.sysman.prov.remoteinterfaces.nativesystem.UserPreferences;
import oracle.sysman.prov.remoteinterfaces.result.ClusterResult;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;
import oracle.sysman.prov.remoteinterfaces.result.GenericResult;

public abstract class NativeSystem
implements Constants {
    protected static int startupCount;
    protected static final String COMMA = ", ";
    protected static final String PIPE = " | ";
    protected static final String DELIM = "::";
    protected static final String DELIM2 = ":";
    protected static final String EXITCODE_STR = "EXITCODE";
    protected static final String PING_RETRY_COUNT = "oracle.sysman.prov.ping_retry_count";
    protected static String TMPPATH;
    private static final String SOCKET_READ_TIMEOUT = "oracle.sysman.prov.ssh.socketReadTimeout";
    protected boolean no_delete = false;
    private static final int RELATIVE_PATHS = 0;
    private static final int ABSOLUTE_PATHS = 1;
    protected static String s_sHostnameLocal;
    protected static String s_sFullHostnameLocal;
    protected static boolean s_bUseExistingSSH;
    private int PORT = 22;
    private static final int RSH_PORT = 514;
    protected static Hashtable s_tmpLocs;
    protected int m_platId;
    protected static NativeSystem s_nativesystem;
    private static final String SYSTEM_PROPERTIES = "system.properties";
    protected static Map s_sessions;

    public static Paths getLocalCommands() {
        return ((Session)s_sessions.get(NativeSystem.getDefaultSessionId())).getLocalPaths();
    }

    public static SessionId getDefaultSessionId() {
        return SessionId.getId();
    }

    public static Map getSessions() {
        return s_sessions;
    }

    public int getPlatformId() {
        return this.m_platId;
    }

    NativeSystem(SessionId sessId) throws FatalException {
        new ClusterManager(true).init();
        this.getHostnameForLocalNode();
        this.initSession(sessId, SystemFactory.s_localPlatId);
    }

    NativeSystem(SessionId sessId, int platId) throws FatalException {
        this.initSession(sessId, platId);
    }

    public void initSession(SessionId sessId, int platId) throws FatalException {
        this.m_platId = platId;
        Session sess = (Session)s_sessions.get(sessId);
        if (sess == null) {
            sess = new Session(sessId);
            ClusterLogger.log("Creating new session with id " + sessId.getName());
            s_sessions.put(sessId, sess);
            ClusterLogger.log("No.of. active sessions: " + s_sessions.size());
            Commands commands = new Commands();
            sess.setCommands(commands);
            Paths localPaths = commands.createInstance(SystemFactory.s_localPlatId);
            sess.setLocalPaths(localPaths);
            NodeInfo localNodeInfo = new NodeInfo("localhost");
            if (platId == SystemFactory.s_localPlatId) {
                localNodeInfo.setNativeSystem(this);
            } else {
                localNodeInfo.setNativeSystem(SystemFactory.CreateNativeSystem(sessId));
            }
            localNodeInfo.setPaths(localPaths);
            localNodeInfo.setSessionId(sessId);
            sess.setLocalNodeInfo(localNodeInfo);
            RemoteExecutionEngine r_eng = new RemoteExecutionEngine();
            sess.setRemoteExecutionEngine(r_eng);
        }
    }

    protected void startup(SessionId sessId, String[] remoteNodes) throws FatalException, ClusterException {
        this.startup(sessId, remoteNodes, null, null, null);
    }

    public void startup(SessionId sessId, String[] remoteNodes, String username, String password, UserPreferences pref) throws FatalException, ClusterException {
        ClusterLogger.log("entering NativeSystem.startup()", ClusterLogger.LOG_INFO);
        Session sess = (Session)s_sessions.get(sessId);
        if (sess == null) {
            this.initSession(sessId, SystemFactory.s_localPlatId);
            sess = (Session)s_sessions.get(sessId);
        }
        if (!sess.isStartupDone()) {
            ClusterLogger.log(" sess.isStartupDone() is false", ClusterLogger.LOG_INFO, false);
            ClusterLogger.log("username: " + username, ClusterLogger.LOG_FINEST, false);
            if (pref != null) {
                sess.setUserPrefs(pref);
            }
            if (username != null) {
                sess.setUsername(username);
                ClusterLogger.log("Setting username to " + username, ClusterLogger.LOG_INFO);
            }
            if (password != null) {
                String obfuscatedPass;
                String string = obfuscatedPass = pref != null ? pref.getPreference("DEOBFUSCATE_PASSWORD") : null;
                if (obfuscatedPass != null && obfuscatedPass.equalsIgnoreCase("true")) {
                    password = this.decryptObfuscatedPassword(password);
                }
                sess.setPassword(password);
                ClusterLogger.log("Setting password to ********", ClusterLogger.LOG_INFO);
            }
            this.setSessionPreferences(sess);
            sess.getLocalNodeInfo().setNativeSystem(SystemFactory.CreateNativeSystem(sessId));
            this.checkUserEquivPrereqs(sess);
            String tmp = sess.getPreference("LOCAL_TEMP_LOCATION");
            boolean validated = false;
            if (!this.validateLocalTemp(sess, tmp)) {
                tmp = sess.getPreference("TEMP_LOCATION");
            } else {
                validated = true;
            }
            if (!validated) {
                if (!this.validateLocalTemp(sess, tmp)) {
                    tmp = sess.getLocalPaths().getValue("SCRATCHPATH");
                } else {
                    validated = true;
                }
            }
            if (!validated) {
                if (!this.validateLocalTemp(sess, tmp)) {
                    tmp = this.getScratchPath();
                } else {
                    validated = true;
                }
            }
            if (!validated && !this.validateLocalTemp(sess, tmp)) {
                sess.getLocalNodeInfo().setScratchPath(tmp);
                String tmpStd = OiixPathOps.getStandardForm((String)tmp);
                Integer obj = (Integer)s_tmpLocs.get(tmpStd);
                if (obj != null) {
                    obj = new Integer(obj + 1);
                    s_tmpLocs.put(tmpStd, obj);
                }
            }
            sess.setStartupDone(true);
        }
        String failedNodes = null;
        Hashtable<String, CommandResult> t = new Hashtable<String, CommandResult>();
        CommandResult resultOnNode = null;
        int nRemoteNodes = remoteNodes != null ? remoteNodes.length : 0;
        String failedNodes0 = null;
        for (int i = 0; i < nRemoteNodes; ++i) {
            NodeInfo nodeinfo = sess.getNodeInfo(remoteNodes[i]);
            if (nodeinfo != null && (!this.isLocalNode(remoteNodes[i]) || sess.isLocalNodeSetupDone())) continue;
            ClusterLogger.log("Doing startup tasks on node " + remoteNodes[i], ClusterLogger.LOG_INFO, true);
            if (nodeinfo == null) {
                nodeinfo = new NodeInfo(remoteNodes[i]);
                nodeinfo.setSessionId(sessId);
            }
            NativeSystem ns = null;
            try {
                ns = SystemFactory.CreateNativeSystem(sessId, remoteNodes[i]);
                nodeinfo.setNativeSystem(ns);
                nodeinfo.setPaths(sess.getCommands().createInstance(ns.m_platId, sess.getRemotePathsLoc()));
            }
            catch (FatalException e) {
                ClusterLogger.log((Throwable)((Object)e));
                if (failedNodes0 == null) {
                    failedNodes0 = remoteNodes[i];
                    continue;
                }
                failedNodes0 = failedNodes0 + COMMA + remoteNodes[i];
                continue;
            }
            String prefVal = sess.getPreference("LOGIN_SHELL");
            if (prefVal != null) {
                nodeinfo.getPaths().setValue("SH_PATH", prefVal);
            }
            try {
                sess.setNodeInfo(nodeinfo);
                resultOnNode = ns.checkRemoteExecutionSetup(nodeinfo, true);
                t.put(remoteNodes[i], resultOnNode);
            }
            catch (RemoteShellException rse) {
                ClusterLogger.log((Throwable)((Object)rse));
                resultOnNode = new CommandResult(remoteNodes[i]);
                resultOnNode.setStatus(false);
                resultOnNode.setResult(new Boolean(false));
                resultOnNode.setException(rse);
                t.put(remoteNodes[i], resultOnNode);
                if (failedNodes == null) {
                    failedNodes = remoteNodes[i];
                    continue;
                }
                failedNodes = failedNodes + COMMA + remoteNodes[i];
                continue;
            }
            String tempLoc = sess.getPreference("REMOTE_TEMP_LOCATION");
            boolean validated = false;
            if (!this.validateRemoteTemp(nodeinfo, ns, tempLoc)) {
                tempLoc = sess.getPreference("TEMP_LOCATION");
            } else {
                validated = true;
            }
            if (!validated) {
                if (!this.validateRemoteTemp(nodeinfo, ns, tempLoc)) {
                    tempLoc = nodeinfo.getPaths().getValue("SCRATCHPATH");
                } else {
                    validated = true;
                }
            }
            if (!validated) {
                if (!this.validateRemoteTemp(nodeinfo, ns, tempLoc)) {
                    tempLoc = ns.getScratchPath();
                } else {
                    validated = true;
                }
            }
            if (!validated && !this.validateRemoteTemp(nodeinfo, ns, tempLoc)) {
                tempLoc = ns.getScratchPath();
                nodeinfo.getPaths().setValue("SCRATCHPATH", tempLoc);
                nodeinfo.setScratchPath(tempLoc);
            }
            sess.setNodeInfo(nodeinfo);
            sess.localNodeSetupDone(true);
        }
        if (failedNodes0 != null) {
            throw new FatalException("PROV-16039", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PLATFORM_NOT_FOUND1", (Object[])new String[]{failedNodes0}));
        }
        if (failedNodes != null) {
            throw new ClusterException(OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"REMOTE_SETUP_CHK_FAIL0", (Object[])new String[]{failedNodes}), new GenericResult(t).getResults());
        }
    }

    protected boolean validateLocalTemp(Session sess, String tmp) {
        if (tmp == null) {
            return false;
        }
        boolean bTmpCreated = false;
        String tmpStd = OiixPathOps.getStandardForm((String)tmp);
        Integer obj = (Integer)s_tmpLocs.get(tmpStd);
        sess.getLocalNodeInfo().setTempCreated(false);
        File dir = new File(tmp);
        if (!dir.exists()) {
            ClusterLogger.log(tmp + " does not exist on local node. Creating dir...");
            bTmpCreated = dir.mkdirs();
            if (!bTmpCreated) {
                ClusterLogger.log("Unable to create temp directory on local node", ClusterLogger.LOG_WARNING);
                return false;
            }
            if (obj != null) {
                ClusterLogger.log("There are existing sessions that point to this newly created temp location", ClusterLogger.LOG_WARNING, true);
            }
            sess.getLocalNodeInfo().setTempCreated(true);
            sess.getLocalNodeInfo().setScratchPath(tmp);
            s_tmpLocs.put(tmpStd, new Integer(1));
            return true;
        }
        if (!dir.canWrite()) {
            ClusterLogger.log("Temp directory on local node does not have write permissions.", ClusterLogger.LOG_WARNING);
            return false;
        }
        sess.getLocalNodeInfo().setScratchPath(tmp);
        if (obj != null) {
            obj = new Integer(obj + 1);
            s_tmpLocs.put(tmpStd, obj);
        }
        return true;
    }

    private boolean validateRemoteTemp(NodeInfo nodeinfo, NativeSystem ns, String tempLoc) {
        if (tempLoc == null) {
            return false;
        }
        nodeinfo.setTempCreated(false);
        CommandResult res = ns.pathExists(nodeinfo, tempLoc, 11);
        if (!((Boolean)res.getResult()).booleanValue()) {
            ClusterLogger.log("creating temp loc " + tempLoc + " on node " + nodeinfo.getNodeName());
            res = ns.createDir(nodeinfo, tempLoc);
            if (!((Boolean)res.getResult()).booleanValue()) {
                ClusterLogger.log((Throwable)((Object)res.getException()));
                return false;
            }
            nodeinfo.setTempCreated(true);
        }
        nodeinfo.setScratchPath(tempLoc);
        nodeinfo.getPaths().setValue("SCRATCHPATH", tempLoc);
        return true;
    }

    protected RemoteExecutionEngine getRemoteExecutionEngine(Session sess) {
        RemoteExecutionEngine r_eng = null;
        if (sess != null) {
            r_eng = sess.getRemoteExecutionEngine();
        }
        if (r_eng == null) {
            r_eng = new RemoteExecutionEngine();
        }
        return r_eng;
    }

    public Paths getLocalPaths(SessionId sessId) throws FatalException {
        Session sess = (Session)s_sessions.get(sessId);
        if (sess == null) {
            throw new FatalException("PROV-16042", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16042"));
        }
        return sess.getLocalPaths();
    }

    public Paths getRemotePaths(SessionId sessId, String node) throws FatalException {
        Session sess = (Session)s_sessions.get(sessId);
        if (sess == null) {
            throw new FatalException("PROV-16042", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16042"));
        }
        NodeInfo nodeinfo = sess.getNodeInfo(node);
        if (nodeinfo != null) {
            return nodeinfo.getPaths();
        }
        throw new FatalException("PROV-16042", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16042"));
    }

    public static Paths getLocalPathsWithoutStartup(String propsDir) throws FatalException {
        Commands commands = new Commands(propsDir);
        Paths m_localPaths = commands.createInstance(SystemFactory.s_localPlatId, propsDir, false);
        return m_localPaths;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Paths getRemotePathsWithoutStartup(int remotePlatformID, String propsDir) throws FatalException {
        String m_PropertiesDir = null;
        m_PropertiesDir = System.getProperty("oracle.sysman.prov.PathsPropertiesLoc");
        String r_PropertiesDir = System.getProperty("oracle.sysman.prov.RemotePathsPropertiesLoc");
        Commands commands = new Commands();
        if (null != propsDir) {
            return commands.createInstance(remotePlatformID, propsDir, false);
        }
        if (r_PropertiesDir != null) return commands.createInstance(remotePlatformID, r_PropertiesDir);
        if (m_PropertiesDir == null) throw new FatalException("PROV-16049", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16049"));
        return commands.createInstance(remotePlatformID, m_PropertiesDir);
    }

    public String[] getRemotePathFiles(SessionId sessId) throws FatalException {
        Session sess = (Session)s_sessions.get(sessId);
        if (sess == null) {
            throw new FatalException("PROV-16042", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16042"));
        }
        String remotePathsDir = sess.getRemotePathsLoc();
        if (null == remotePathsDir) {
            throw new FatalException("PROV-16055", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16055"));
        }
        sess.getCommands();
        return Commands.getPathFiles(sess.getRemoteNodesPlatform(), remotePathsDir);
    }

    protected String getTimeStamp() {
        Date d = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss-a", Locale.ENGLISH);
        return df.format(d);
    }

    public abstract String getFileSeparator();

    public abstract char getFileSeparatorChar();

    public void shutdown(SessionId sessId, boolean no_Delete) {
        this.no_delete = no_Delete;
        this.shutdown(sessId);
    }

    public synchronized void shutdown(SessionId sessId) {
        ClusterLogger.log("entering NativeSystem.shutdown()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(sessId);
        if (sess != null) {
            String tmpStd;
            Integer obj;
            NodeInfo nodeinfo = null;
            Iterator iter = sess.getNodeInfoObjs();
            while (iter.hasNext()) {
                nodeinfo = (NodeInfo)iter.next();
                NativeSystem ns = nodeinfo.getNativeSystem();
                if (!nodeinfo.isTmpCreated()) continue;
                String tmp = nodeinfo.getScratchPath();
                ns.removeDir(nodeinfo, tmp, true, false);
                ClusterLogger.log("Deleting " + tmp + " from " + nodeinfo.getNodeName());
            }
            String localTmp = sess.getLocalNodeInfo().getScratchPath();
            if (localTmp != null && (obj = (Integer)s_tmpLocs.get(tmpStd = OiixPathOps.getStandardForm((String)localTmp))) != null) {
                int tmpCount = obj;
                ClusterLogger.log("local temp dir reference count: " + tmpCount);
                if (tmpCount == 1) {
                    OiixFileOps.cleanupdelete((File)new File(localTmp));
                    ClusterLogger.log("Deleting " + localTmp + " from local node");
                    if (!this.no_delete) {
                        s_tmpLocs.remove(tmpStd);
                    }
                } else {
                    s_tmpLocs.put(tmpStd, new Integer(--tmpCount));
                }
            }
        }
        s_sessions.remove(sessId);
        ClusterLogger.log("Disposing session: " + sessId.getName());
        ClusterLogger.log("No.of. sessions remaining: " + s_sessions.size());
        if (s_sessions.size() == 0) {
            ClusterLogger.log("NativeSystem:s_sessions is empty", ClusterLogger.LOG_FINEST);
            new ClusterManager(true).dispose();
            s_sHostnameLocal = null;
            s_sFullHostnameLocal = null;
            s_bUseExistingSSH = true;
        }
    }

    protected void getHostnameForLocalNode() {
        try {
            InetAddress inetAddr = InetAddress.getLocalHost();
            s_sHostnameLocal = inetAddr.getHostName();
            int idx = s_sHostnameLocal.indexOf(46);
            if (idx != -1) {
                s_sFullHostnameLocal = s_sHostnameLocal;
                s_sHostnameLocal = s_sHostnameLocal.substring(0, idx);
            } else {
                s_sFullHostnameLocal = inetAddr.getCanonicalHostName();
            }
            ClusterLogger.log("localhost hostname: " + s_sHostnameLocal + " localhost full hostname: " + s_sFullHostnameLocal, ClusterLogger.LOG_FINER);
        }
        catch (UnknownHostException uhe) {
            ClusterLogger.log(uhe.toString(), ClusterLogger.LOG_SEVERE);
        }
    }

    protected boolean isLocalNode(String node) {
        return node.equalsIgnoreCase("localhost") || node.equals(s_sHostnameLocal) || node.equals(s_sFullHostnameLocal);
    }

    protected static final String[] getCmdArr(String cmdStr) {
        StringTokenizer st = new StringTokenizer(cmdStr);
        String[] cmdArr = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArr[i] = st.nextToken();
            ++i;
        }
        return cmdArr;
    }

    protected static final String[] getStringArr(String cmdStr) {
        StringTokenizer st = new StringTokenizer(cmdStr, COMMA);
        String[] stringArr = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            stringArr[i] = st.nextToken();
            ++i;
        }
        return stringArr;
    }

    protected static String getNodesListStr(List nodes) {
        StringBuffer sb = new StringBuffer();
        int size = nodes == null ? 0 : nodes.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                sb.append((String)nodes.get(0));
                continue;
            }
            sb.append(COMMA);
            sb.append((String)nodes.get(i));
        }
        return sb.toString();
    }

    protected String extractCmdName(String usercmd) {
        if (usercmd != null) {
            StringTokenizer st;
            usercmd = usercmd.trim();
            if (!(usercmd = OiixPathOps.getStandardForm((String)usercmd)).equals("") && (st = new StringTokenizer(usercmd)).countTokens() == 1) {
                int inx = usercmd.lastIndexOf(47);
                if (inx == -1) {
                    return usercmd;
                }
                return usercmd.substring(inx + 1);
            }
        }
        return null;
    }

    protected abstract String getScratchPath();

    protected void setSessionPreferences(Session sess) throws RemoteShellFatalException, FatalException {
        String scpportArgs;
        String sshportArgs;
        String scpArgs;
        String sshArgs;
        String scp;
        String prefVal = sess.getPreference("FALLBACK_TO_RSH");
        Paths localPaths = sess.getLocalPaths();
        if (prefVal != null) {
            sess.setFallbackToRSH(new Boolean(prefVal));
            ClusterLogger.log("Setting FallbackToRSH to " + sess.isFallbackToRSH(), ClusterLogger.LOG_FINEST);
        }
        if ((prefVal = sess.getPreference("LOGIN_SHELL")) != null) {
            sess.setLoginShell(prefVal);
            ClusterLogger.log("Setting loginShell to " + prefVal, ClusterLogger.LOG_FINEST, true);
        }
        if ((prefVal = sess.getPreference("REMOTE_PATH_PROPERTIES_LOC")) != null) {
            sess.setRemotePathsLoc(prefVal);
            ClusterLogger.log("Setting REMOTE_PATH_PROPERTIES_LOC to " + prefVal, ClusterLogger.LOG_FINEST);
        }
        if ((prefVal = sess.getPreference("REMOTE_COMMAND_PLUGIN_NAME")) != null) {
            try {
                RemoteExecutionEngine.registerPlugin(prefVal);
            }
            catch (PluginException pe) {
                throw new FatalException("plugin " + prefVal + " is invalid or incompatible", (Throwable)((Object)pe));
            }
            ClusterLogger.log("Setting REMOTE_COMMAND_PLUGIN_NAME to " + prefVal, ClusterLogger.LOG_FINEST, true);
            sess.setRemotePlugin(prefVal);
        }
        if ((prefVal = sess.getPreference("REMOTENODES_PLATFORM")) != null) {
            try {
                Integer obj = new Integer(prefVal);
                sess.setRemoteNodesPlatform(obj);
            }
            catch (NumberFormatException obj) {
                // empty catch block
            }
        }
        String rsh = (prefVal = sess.getPreference("RSH_PATH")) != null ? prefVal : localPaths.getValue("RSH_PATH");
        prefVal = sess.getPreference("RCP_PATH");
        String rcp = prefVal != null ? prefVal : localPaths.getValue("RCP_PATH");
        prefVal = sess.getPreference("SSH_PATH");
        String ssh = prefVal != null ? prefVal : localPaths.getValue("SSH_PATH");
        try {
            if (this.isClientSSH2(sess.getSessionId())) {
                scp = prefVal != null ? prefVal : localPaths.getValue("SCP2_PATH");
                sshArgs = localPaths.getValue("SSH2_ARGS");
                scpArgs = localPaths.getValue("SCP2_ARGS");
                String home = System.getProperty("user.home");
                if (null != home && home.length() > 0) {
                    sshArgs = sshArgs + " " + localPaths.getValue("SSH2_IDENTIFICATION_ARGS") + " " + OiixPathOps.concatPath((String)OiixPathOps.concatPath((String)home, (String)".ssh2"), (String)"identification");
                    scpArgs = scpArgs + " " + localPaths.getValue("SSH2_IDENTIFICATION_ARGS") + " " + OiixPathOps.concatPath((String)OiixPathOps.concatPath((String)home, (String)".ssh2"), (String)"identification");
                }
                sshportArgs = localPaths.getValue("SSH2_PORT_ARGS");
                scpportArgs = localPaths.getValue("SCP2_PORT_ARGS");
            } else {
                scp = prefVal != null ? prefVal : localPaths.getValue("SCP_PATH");
                sshArgs = localPaths.getValue("SSH_ARGS");
                scpArgs = localPaths.getValue("SCP_ARGS");
                sshportArgs = localPaths.getValue("SSH_PORT_ARGS");
                scpportArgs = localPaths.getValue("SCP_PORT_ARGS");
            }
            sess.setSshPath(ssh);
            sess.setScpPath(scp);
        }
        catch (OiixException e) {
            throw new RemoteShellFatalException(e.getErrorID(), e.getErrorMessage());
        }
        String sshport = null;
        try {
            Paths remotePaths = sess.getCommands().createInstance(sess.getRemoteNodesPlatform(), sess.getRemotePathsLoc());
            sshport = remotePaths.getValue("SSH_PORT");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == sshport || sshport.trim().length() == 0) {
            sess.setSshArgs(sshArgs);
            sess.setScpArgs(scpArgs);
        } else {
            try {
                this.PORT = Integer.parseInt(sshport);
                sess.setSshArgs(sshArgs + " " + sshportArgs + " " + sshport);
                sess.setScpArgs(scpArgs + " " + scpportArgs + " " + sshport);
            }
            catch (NumberFormatException nfe) {
                ClusterLogger.log("Invalid ssh port number defined, reverting to default port", ClusterLogger.LOG_WARNING);
                sess.setSshArgs(sshArgs);
                sess.setScpArgs(scpArgs);
            }
        }
        sess.setRshPath(rsh);
        sess.setRshArgs(localPaths.getValue("RSH_ARGS"));
        sess.setRcpPath(rcp);
        sess.setRcpArgs(localPaths.getValue("RCP_ARGS"));
        ClusterLogger.log("[Session Id = " + sess.getSessionId() + "]: sshpath, rshpath, scppath, rcppath: " + ssh + " " + rsh + " " + scp + " " + rcp);
        this.checkRemoteShell(sess);
    }

    protected abstract void checkRemoteShell(Session var1) throws RemoteShellFatalException;

    public ClusterResult runCmdOnNodes(SessionId sessId, String cmd, String[] args, String[] env, String[] nodeNames, boolean asNormalUser) throws FatalException, ClusterException {
        ClusterLogger.log("entering NativeSystem.runCmdOnNodes()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        this.startup(sessId, nodeNames);
        Assertions.assertName(cmd);
        ClusterResult clusterResult = null;
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo = null;
        NativeSystem ns = null;
        if (nodeNames.length == 1) {
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            ns = nodeinfo.getNativeSystem();
            CommandResult res = ns.runCmd(cmd, args, env, nodeinfo, asNormalUser);
            clusterResult = new GenericResult(res);
        } else {
            Command[] runCmds = new RunCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                runCmds[i] = new RunCommand(cmd, args, env, nodeinfo, asNormalUser);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(runCmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            return clusterResult;
        }
        String failedNodes = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16011", (Object[])new Object[]{cmd, failedNodes});
        throw new ClusterException("PROV-16011", errorMessage, results);
    }

    public ClusterResult areNodesAlive(SessionId sessId, String[] nodeNames, int timeout) throws FatalException, NodesAliveException {
        ClusterLogger.log("entering NativeSystem.areNodesAlive()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        Session sess = (Session)s_sessions.get(sessId);
        Paths localPaths = sess.getLocalPaths();
        String path = localPaths.getValue("PING_PATH");
        try {
            localPaths.isValidated("PING_PATH");
        }
        catch (FatalException fe) {
            path = this.getPingPath();
            if (path != null) {
                localPaths.setValue("PING_PATH", path, "1");
            }
            throw new FatalException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001"));
        }
        Command[] nodeAliveCmds = new NodeAliveCommand[nodeNames.length];
        NodeInfo nodeinfo = null;
        for (int i = 0; i < nodeNames.length; ++i) {
            nodeinfo = sess.getNodeInfo(nodeNames[i]);
            if (nodeinfo == null) {
                nodeinfo = new NodeInfo(nodeNames[i]);
                nodeinfo.setSessionId(sessId);
                nodeinfo.setNativeSystem(sess.getLocalNodeInfo().getNativeSystem());
            }
            nodeAliveCmds[i] = new NodeAliveCommand(nodeinfo, timeout);
        }
        ClusterManager clusterManager = new ClusterManager();
        ClusterResult clusterResult = clusterManager.submit(nodeAliveCmds);
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            return clusterResult;
        }
        String downNodeList = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        Object[] args = new Object[]{downNodeList, String.valueOf(timeout)};
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16002", (Object[])args);
        throw new NodesAliveException("PROV-16002", errorMessage, results);
    }

    public ClusterResult areNodesAliveEx(SessionId sessId, String[] nodeNames, int timeout, boolean usePing, boolean useSSH, boolean useRSH) throws FatalException, NodesAliveException {
        ClusterResult sshClusterResult;
        int[] pingExitCodes = null;
        ClusterLogger.log("entering NativeSystem.areNodesAlive()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        if (usePing) {
            int status;
            ClusterResult pingClusterResult = null;
            try {
                pingClusterResult = this.areNodesAlive(sessId, nodeNames, timeout);
            }
            catch (FatalException fe) {
                throw fe;
            }
            catch (NodesAliveException nae) {
                if (!useSSH && !useRSH) {
                    throw nae;
                }
                Iterator result = nae.getCommandResults();
                int i = 0;
                pingExitCodes = new int[nae.getCollectionLength()];
                while (result.hasNext()) {
                    int exitVal;
                    CommandResult res = (CommandResult)result.next();
                    pingExitCodes[i] = exitVal = res.getExitCode();
                    ClusterLogger.log("Ping Exit Code " + pingExitCodes[i], ClusterLogger.LOG_FINER, false);
                    ++i;
                }
            }
            if (pingClusterResult != null && (status = pingClusterResult.getStatus()) == 0) {
                return pingClusterResult;
            }
        }
        if (useSSH && useRSH) {
            sshClusterResult = null;
            String[] sshNodes = nodeNames;
            try {
                sshClusterResult = this.checkSSHServer(sshNodes);
            }
            catch (ClusterException ce) {
                ClusterResult rshClusterResult = null;
                String[] rshNodes = nodeNames;
                try {
                    rshClusterResult = this.checkRSHServer(rshNodes);
                }
                catch (ClusterException re) {
                    if (null != pingExitCodes) {
                        this.setExitCodes(re.getCommandResults(), pingExitCodes);
                    }
                    throw new NodesAliveException("PROV-16002", re.getMessage(), re.getCommandResults());
                }
                ClusterLogger.log("All nodes found up from RSH", ClusterLogger.LOG_FINER);
                return rshClusterResult;
            }
            ClusterLogger.log("All nodes found up from SSH", ClusterLogger.LOG_FINER);
            return sshClusterResult;
        }
        if (useSSH) {
            sshClusterResult = null;
            String[] sshNodes = nodeNames;
            try {
                ClusterLogger.log("Checking Nodes liveliness using SSH", ClusterLogger.LOG_FINER);
                sshClusterResult = this.checkSSHServer(sshNodes);
            }
            catch (ClusterException sshe) {
                if (null != pingExitCodes) {
                    this.setExitCodes(sshe.getCommandResults(), pingExitCodes);
                }
                throw new NodesAliveException("PROV-16040", sshe.getMessage(), sshe.getCommandResults());
            }
            return sshClusterResult;
        }
        if (useRSH) {
            ClusterResult rshClusterResult = null;
            String[] rshNodes = nodeNames;
            try {
                rshClusterResult = this.checkRSHServer(rshNodes);
            }
            catch (ClusterException re) {
                if (null != pingExitCodes) {
                    this.setExitCodes(re.getCommandResults(), pingExitCodes);
                }
                throw new NodesAliveException("PROV-16041", re.getMessage(), re.getCommandResults());
            }
            return rshClusterResult;
        }
        return null;
    }

    private void setExitCodes(Iterator results, int[] pingExitCodes) {
        int i = 0;
        while (results.hasNext()) {
            CommandResult res = (CommandResult)results.next();
            if (pingExitCodes != null) {
                res.setExitCode(pingExitCodes[i++]);
                continue;
            }
            res.setExitCode(1);
        }
    }

    protected String getPingPath() {
        return null;
    }

    public ClusterResult getFreeSpaceOnNode(SessionId sessId, String node, String path) throws FatalException, ClusterException {
        ClusterLogger.log("entering NativeSystem.getFreeSpaceOnNode()", ClusterLogger.LOG_FINER);
        Assertions.assertName(node);
        this.startup(sessId, new String[]{node});
        Assertions.assertName(path);
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo = sess.getNodeInfo(node);
        NativeSystem ns = nodeinfo.getNativeSystem();
        path = ns.getStandardForm(path);
        CommandResult res = ns.getFreeSpace(nodeinfo, path);
        GenericResult clusterResult = new GenericResult(res);
        if (res.getStatus()) {
            return clusterResult;
        }
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16023", (Object[])new Object[]{node, path});
        throw new ClusterException("PROV-16023", errorMessage, clusterResult.getResults());
    }

    public ClusterResult isSharedPath(SessionId sessId, String pathName, String[] nodeNames) throws FatalException, RemoteFileOperationException, SharedDeviceException {
        ClusterLogger.log("entering NativeSystem.isSharedPath()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        int stime = 0;
        String sleep_time = System.getProperty("oracle.sysman.prov.sleep_time");
        if (sleep_time != null && sleep_time.trim().length() > 0) {
            stime = Integer.getInteger("oracle.sysman.prov.sleep_time");
        }
        if (nodeNames.length < 2) {
            StringBuffer sb = new StringBuffer();
            if (nodeNames.length > 0) {
                sb.append(nodeNames[0]);
            }
            Object[] args = new String[]{sb.toString(), String.valueOf(nodeNames.length), String.valueOf(2)};
            ClusterLogger.log("nodeNames length is less than 2");
            throw new FatalException("PROV-16024", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16024", (Object[])args));
        }
        boolean isLocalNode = this.isLocalNode(nodeNames[0]);
        String localnode = null;
        if (isLocalNode) {
            localnode = nodeNames[0];
            String[] newNodeNames = new String[nodeNames.length - 1];
            System.arraycopy(nodeNames, 1, newNodeNames, 0, nodeNames.length - 1);
            nodeNames = newNodeNames;
        }
        try {
            this.startup(sessId, nodeNames);
        }
        catch (ClusterException e) {
            throw new SharedDeviceException(e);
        }
        Assertions.assertName(pathName);
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo = sess.getNodeInfo(nodeNames[0]);
        NativeSystem ns = nodeinfo.getNativeSystem();
        pathName = ns.getStandardForm(pathName);
        String tempFile = "CFSFileName" + String.valueOf(System.currentTimeMillis());
        ClusterLogger.log("pathName = " + pathName + "  tempFile = " + tempFile);
        File dirPath = new File(pathName);
        CommandResult res = null;
        if (isLocalNode) {
            pathName = OiixPathOps.getAbsolutePath((String)pathName);
            while (!dirPath.isDirectory()) {
                if (dirPath.getParentFile() != null) {
                    dirPath = dirPath.getParentFile();
                    continue;
                }
                ClusterLogger.log("None of the parent directories of the path " + pathName + " exist on node " + nodeNames[0]);
                throw new SharedDeviceException("PROV-16000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16000", (Object[])new String[]{pathName}), null);
            }
            pathName = dirPath.getAbsolutePath();
        } else {
            String testpath = pathName;
            while (!(res = ns.pathExists(nodeinfo, testpath, 8, false)).getStatus()) {
                if ((testpath = OiixPathOps.getParentDir((String)testpath)) != null) continue;
                ClusterLogger.log("None of the parent directories of the path " + pathName + " exist on node " + nodeNames[0]);
                throw new SharedDeviceException("PROV-16000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16000", (Object[])new String[]{pathName}), null);
            }
            pathName = testpath;
        }
        String dirPathName = pathName + "/" + tempFile;
        File newTempFile = new File(dirPathName);
        if (isLocalNode) {
            newTempFile.delete();
        }
        this.removeFileFromNodes(sessId, nodeNames, dirPathName, false);
        if (isLocalNode) {
            ClusterLogger.log("creating file " + dirPathName, ClusterLogger.LOG_FINEST);
            FileOutputStream fos = null;
            res = new CommandResult(localnode);
            try {
                fos = new FileOutputStream(newTempFile);
                fos.write("This is CFS test file content".getBytes());
                fos.flush();
            }
            catch (FileNotFoundException e) {
                ClusterLogger.log("Failed to create the test CFS file at " + dirPathName);
                if (newTempFile.exists()) {
                    newTempFile.delete();
                }
                throw new SharedDeviceException("PROV-16025", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16025", (Object[])new String[]{dirPathName, localnode}), null);
            }
            catch (IOException e) {
                ClusterLogger.log("Failed to write to the test CFS file " + dirPathName);
                if (newTempFile.exists()) {
                    newTempFile.delete();
                }
                throw new SharedDeviceException("PROV-16025", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16025", (Object[])new String[]{dirPathName, localnode}), null);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (new File(dirPathName).exists()) {
                ClusterLogger.log("file exists " + dirPathName, ClusterLogger.LOG_FINEST);
            } else {
                ClusterLogger.log("file does not exist " + dirPathName, ClusterLogger.LOG_FINEST);
            }
        } else {
            res = ns.createCFSFile(nodeinfo, dirPathName);
            if (!res.getStatus()) {
                ClusterLogger.log("Failed to create the test CFS file " + dirPathName + " on node " + nodeNames[0]);
                this.removeFile(nodeinfo, dirPathName, false);
                throw new SharedDeviceException("PROV-16025", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16025", (Object[])new String[]{dirPathName, nodeNames[0]}), null);
            }
        }
        try {
            if (sleep_time == null) {
                ClusterLogger.log("isSharedPath: Sleeping for: 8 seconds ", ClusterLogger.LOG_INFO, true);
                Thread.sleep(8000L);
            } else {
                ClusterLogger.log("isSharedPath: Sleeping for: " + sleep_time + " milliseconds", ClusterLogger.LOG_INFO, true);
                Thread.sleep(stime);
            }
        }
        catch (Exception fos) {
            // empty catch block
        }
        Command[] sharedPathCmds = new SharedPathCommand[nodeNames.length];
        nodeinfo = null;
        ns = null;
        for (int i = 0; i < nodeNames.length; ++i) {
            nodeinfo = sess.getNodeInfo(nodeNames[i]);
            sharedPathCmds[i] = new SharedPathCommand(nodeinfo, dirPathName);
        }
        ClusterManager clusterManager = new ClusterManager();
        ClusterResult clusterResult = clusterManager.submit(sharedPathCmds);
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (isLocalNode) {
            Hashtable<String, CommandResult> t = new Hashtable<String, CommandResult>();
            CommandResult resultOnNode = CommandResult.SUCCESS(localnode);
            resultOnNode.setResult(new Boolean(true));
            t.put(localnode, resultOnNode);
            while (results.hasNext()) {
                resultOnNode = (CommandResult)results.next();
                t.put(resultOnNode.getNodeName(), resultOnNode);
            }
            clusterResult = new GenericResult(t);
            results = clusterResult.getResults();
            newTempFile.delete();
        }
        nodeinfo = sess.getNodeInfo(nodeNames[0]);
        ns = nodeinfo.getNativeSystem();
        ns.removeFile(nodeinfo, dirPathName, false);
        if (status == 0) {
            return clusterResult;
        }
        String failedNodeList = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16031", (Object[])new String[]{pathName, failedNodeList});
        throw new SharedDeviceException("PROV-16031", errorMessage, results);
    }

    public ClusterResult validateUserEquivalence(SessionId sessId, String[] nodeNames) throws FatalException, UserEquivalenceException {
        ClusterLogger.log("entering NativeSystem.validateUserEquivalence()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        Session sess = (Session)s_sessions.get(sessId);
        if (!sess.isStartupDone()) {
            this.setSessionPreferences(sess);
            this.checkUserEquivPrereqs(sess);
        }
        ClusterResult clusterResult = null;
        NativeSystem ns = null;
        NodeInfo nodeinfo = null;
        if (nodeNames.length == 1) {
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            if (nodeinfo != null) {
                ns = nodeinfo.getNativeSystem();
            } else {
                nodeinfo = new NodeInfo(nodeNames[0]);
                nodeinfo.setSessionId(sessId);
                ns = SystemFactory.CreateNativeSystem(sessId, nodeNames[0]);
                nodeinfo.setPaths(sess.getCommands().createInstance(ns.m_platId, sess.getRemotePathsLoc()));
            }
            CommandResult res = ns.isNodeAccessible(nodeinfo);
            clusterResult = new GenericResult(res);
        } else {
            Command[] usrEquivCmds = new UserEquivCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                if (nodeinfo != null) {
                    ns = nodeinfo.getNativeSystem();
                } else {
                    nodeinfo = new NodeInfo(nodeNames[i]);
                    nodeinfo.setSessionId(sessId);
                    ns = SystemFactory.CreateNativeSystem(sessId, nodeNames[i]);
                    nodeinfo.setNativeSystem(ns);
                    nodeinfo.setPaths(sess.getCommands().createInstance(ns.m_platId, sess.getRemotePathsLoc()));
                }
                usrEquivCmds[i] = new UserEquivCommand(nodeinfo);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(usrEquivCmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            return clusterResult;
        }
        String failedNodeList = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16027", (Object[])new String[]{failedNodeList});
        throw new UserEquivalenceException("PROV-16027", errorMessage, results);
    }

    public ClusterResult validateAdvancedSSHEquivalence(SessionId sessId, String username, String[] nodeNames) throws FatalException, UserEquivalenceException, ClusterException {
        ClusterLogger.log("entering NativeSystem.validateAdvancedSSHEquivalence()", ClusterLogger.LOG_FINER, false);
        Assertions.assertList(nodeNames);
        Session sess = (Session)s_sessions.get(sessId);
        ClusterLogger.log("First checking from local to all remote nodes", ClusterLogger.LOG_FINER, false);
        ClusterResult clusterResult = null;
        clusterResult = this.validateSSHEquivalence(sessId, nodeNames);
        ClusterLogger.log(" validateSSHEquivalence sucessful from validateAdvancedSSHEquivalence", ClusterLogger.LOG_FINER, false);
        NodeInfo nodeinfo = null;
        int cnt = 0;
        Command[] advUsrEquivCmds = new AdvancedUserEquivCommand[nodeNames.length * nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            nodeinfo = this.initNode(sess, sessId, nodeNames[i]);
            for (int j = 0; j < nodeNames.length; ++j) {
                advUsrEquivCmds[cnt++] = new AdvancedUserEquivCommand(nodeinfo, username, UserEquivCommand.SSH, nodeNames[j]);
            }
        }
        ClusterManager clusterManager = new ClusterManager();
        clusterResult = clusterManager.submit(advUsrEquivCmds);
        int status = clusterResult.getStatus();
        if (status == 0) {
            return clusterResult;
        }
        String failedNodeList = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        Iterator results = clusterResult.getResults();
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16027", (Object[])new String[]{failedNodeList});
        throw new UserEquivalenceException("PROV-16027", errorMessage, results);
    }

    protected NodeInfo initNode(Session sess, SessionId sessId, String node) throws FatalException {
        NativeSystem ns = null;
        NodeInfo nodeinfo = sess.getNodeInfo(node);
        if (nodeinfo == null) {
            nodeinfo = new NodeInfo(node);
            nodeinfo.setSessionId(sessId);
            ns = SystemFactory.CreateNativeSystem(sessId, node);
            nodeinfo.setNativeSystem(ns);
            nodeinfo.setPaths(sess.getCommands().createInstance(ns.m_platId, sess.getRemotePathsLoc()));
        }
        return nodeinfo;
    }

    public ClusterResult validateSSHEquivalence(SessionId sessId, String[] nodeNames) throws FatalException, UserEquivalenceException {
        ClusterLogger.log("entering NativeSystem.validateSSHEquivalence()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        Session sess = (Session)s_sessions.get(sessId);
        if (!sess.isStartupDone()) {
            try {
                this.setSessionPreferences(sess);
            }
            catch (RemoteShellFatalException remoteShellFatalException) {
                // empty catch block
            }
            Assertions.validatePath(sess.getSshPath());
            Assertions.validatePath(sess.getScpPath());
            sess.setSsh(true);
        }
        ClusterResult clusterResult = null;
        NativeSystem ns = null;
        NodeInfo nodeinfo = null;
        if (nodeNames.length == 1) {
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            if (nodeinfo != null) {
                ns = nodeinfo.getNativeSystem();
            } else {
                nodeinfo = new NodeInfo(nodeNames[0]);
                nodeinfo.setSessionId(sessId);
                ns = SystemFactory.CreateNativeSystem(sessId, nodeNames[0]);
                nodeinfo.setNativeSystem(ns);
                nodeinfo.setPaths(sess.getCommands().createInstance(ns.m_platId, sess.getRemotePathsLoc()));
            }
            CommandResult res = ns.checkSSHSetup(nodeinfo);
            clusterResult = new GenericResult(res);
        } else {
            Command[] usrEquivCmds = new UserEquivCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                if (nodeinfo != null) {
                    ns = nodeinfo.getNativeSystem();
                } else {
                    nodeinfo = new NodeInfo(nodeNames[i]);
                    nodeinfo.setSessionId(sessId);
                    ns = SystemFactory.CreateNativeSystem(sessId, nodeNames[i]);
                    nodeinfo.setNativeSystem(ns);
                    nodeinfo.setPaths(sess.getCommands().createInstance(ns.m_platId, sess.getRemotePathsLoc()));
                }
                usrEquivCmds[i] = new UserEquivCommand(nodeinfo, UserEquivCommand.SSH);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(usrEquivCmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            return clusterResult;
        }
        String failedNodeList = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16027", (Object[])new String[]{failedNodeList});
        throw new UserEquivalenceException("PROV-16027", errorMessage, results);
    }

    public ClusterResult validateSSHEquivalence(SessionId sessId, String[] nodeNames, String username) throws FatalException, UserEquivalenceException {
        return this.validateSSHEquivalence(sessId, nodeNames, username, -1);
    }

    public ClusterResult validateSSHEquivalence(SessionId sessId, String[] nodeNames, String username, int port) throws FatalException, UserEquivalenceException {
        ClusterLogger.log("entering NativeSystem.validateSSHEquivalence()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        Session sess = (Session)s_sessions.get(sessId);
        if (!sess.isStartupDone()) {
            if (username != null) {
                sess.setUsername(username);
                ClusterLogger.log("Setting username to " + username, ClusterLogger.LOG_INFO);
            }
            try {
                this.setSessionPreferences(sess);
            }
            catch (RemoteShellFatalException remoteShellFatalException) {
                // empty catch block
            }
            if (port != -1) {
                String sshArgs = sess.getSshArgs();
                String sshPortArgs = sess.getLocalPaths().getValue("SSH_PORT_ARGS");
                if (null == sshPortArgs) {
                    sshPortArgs = "-p";
                }
                if (sshArgs.indexOf(sshPortArgs = " " + sshPortArgs + " ") == -1) {
                    sess.setSshArgs(sshArgs + sshPortArgs + String.valueOf(port));
                }
            }
            Assertions.validatePath(sess.getSshPath());
            Assertions.validatePath(sess.getScpPath());
            sess.setSsh(true);
        }
        ClusterResult clusterResult = null;
        NativeSystem ns = null;
        NodeInfo nodeinfo = null;
        if (nodeNames.length == 1) {
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            if (nodeinfo != null) {
                ns = nodeinfo.getNativeSystem();
            } else {
                nodeinfo = new NodeInfo(nodeNames[0]);
                nodeinfo.setSessionId(sessId);
                ns = SystemFactory.CreateNativeSystem(sessId, nodeNames[0]);
                nodeinfo.setPaths(sess.getCommands().createInstance(ns.m_platId, sess.getRemotePathsLoc()));
            }
            CommandResult res = ns.checkSSHSetup(nodeinfo, username);
            clusterResult = new GenericResult(res);
        } else {
            Command[] usrEquivCmds = new UserEquivCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                if (nodeinfo != null) {
                    ns = nodeinfo.getNativeSystem();
                } else {
                    nodeinfo = new NodeInfo(nodeNames[i]);
                    nodeinfo.setSessionId(sessId);
                    ns = SystemFactory.CreateNativeSystem(sessId, nodeNames[i]);
                    nodeinfo.setNativeSystem(ns);
                    nodeinfo.setPaths(sess.getCommands().createInstance(ns.m_platId, sess.getRemotePathsLoc()));
                }
                usrEquivCmds[i] = new UserEquivCommand(nodeinfo, username, UserEquivCommand.SSH);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(usrEquivCmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            return clusterResult;
        }
        String failedNodeList = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16027", (Object[])new String[]{failedNodeList});
        throw new UserEquivalenceException("PROV-16027", errorMessage, results);
    }

    public ClusterResult validateRSHEquivalence(SessionId sessId, String[] nodeNames, String username) throws FatalException, UserEquivalenceException {
        ClusterLogger.log("entering NativeSystem.validateRSHEquivalence()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        Session sess = (Session)s_sessions.get(sessId);
        if (!sess.isStartupDone()) {
            if (username != null) {
                sess.setUsername(username);
                ClusterLogger.log("Setting username to " + username, ClusterLogger.LOG_INFO);
            }
            try {
                this.setSessionPreferences(sess);
            }
            catch (RemoteShellFatalException remoteShellFatalException) {
                // empty catch block
            }
            Assertions.validatePath(sess.getRshPath());
            Assertions.validatePath(sess.getRcpPath());
            sess.setRsh(true);
        }
        ClusterResult clusterResult = null;
        NativeSystem ns = null;
        NodeInfo nodeinfo = null;
        if (nodeNames.length == 1) {
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            if (nodeinfo != null) {
                ns = nodeinfo.getNativeSystem();
            } else {
                nodeinfo = new NodeInfo(nodeNames[0]);
                nodeinfo.setSessionId(sessId);
                ns = SystemFactory.CreateNativeSystem(sessId, nodeNames[0]);
                nodeinfo.setPaths(sess.getCommands().createInstance(ns.m_platId, sess.getRemotePathsLoc()));
            }
            CommandResult res = ns.checkRSHSetup(nodeinfo, username);
            clusterResult = new GenericResult(res);
        } else {
            Command[] usrEquivCmds = new UserEquivCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                if (nodeinfo != null) {
                    ns = nodeinfo.getNativeSystem();
                } else {
                    nodeinfo = new NodeInfo(nodeNames[i]);
                    nodeinfo.setSessionId(sessId);
                    ns = SystemFactory.CreateNativeSystem(sessId, nodeNames[i]);
                    nodeinfo.setNativeSystem(ns);
                    nodeinfo.setPaths(sess.getCommands().createInstance(ns.m_platId, sess.getRemotePathsLoc()));
                }
                usrEquivCmds[i] = new UserEquivCommand(nodeinfo, username, UserEquivCommand.RSH);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(usrEquivCmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            return clusterResult;
        }
        String failedNodeList = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16027", (Object[])new String[]{failedNodeList});
        throw new UserEquivalenceException("PROV-16027", errorMessage, results);
    }

    public ClusterResult validateRSHEquivalence(SessionId sessId, String[] nodeNames) throws FatalException, UserEquivalenceException {
        ClusterLogger.log("entering NativeSystem.validateRSHEquivalence()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        Session sess = (Session)s_sessions.get(sessId);
        if (!sess.isStartupDone()) {
            try {
                this.setSessionPreferences(sess);
            }
            catch (RemoteShellFatalException remoteShellFatalException) {
                // empty catch block
            }
            Assertions.validatePath(sess.getRshPath());
            Assertions.validatePath(sess.getRcpPath());
            sess.setRsh(true);
        }
        ClusterResult clusterResult = null;
        NativeSystem ns = null;
        NodeInfo nodeinfo = null;
        if (nodeNames.length == 1) {
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            if (nodeinfo != null) {
                ns = nodeinfo.getNativeSystem();
            } else {
                nodeinfo = new NodeInfo(nodeNames[0]);
                nodeinfo.setSessionId(sessId);
                ns = SystemFactory.CreateNativeSystem(sessId, nodeNames[0]);
                nodeinfo.setPaths(sess.getCommands().createInstance(ns.m_platId, sess.getRemotePathsLoc()));
            }
            CommandResult res = ns.checkRSHSetup(nodeinfo);
            clusterResult = new GenericResult(res);
        } else {
            Command[] usrEquivCmds = new UserEquivCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                if (nodeinfo != null) {
                    ns = nodeinfo.getNativeSystem();
                } else {
                    nodeinfo = new NodeInfo(nodeNames[i]);
                    nodeinfo.setSessionId(sessId);
                    ns = SystemFactory.CreateNativeSystem(sessId, nodeNames[i]);
                    nodeinfo.setNativeSystem(ns);
                    nodeinfo.setPaths(sess.getCommands().createInstance(ns.m_platId, sess.getRemotePathsLoc()));
                }
                usrEquivCmds[i] = new UserEquivCommand(nodeinfo, UserEquivCommand.RSH);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(usrEquivCmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            return clusterResult;
        }
        String failedNodeList = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16027", (Object[])new String[]{failedNodeList});
        throw new UserEquivalenceException("PROV-16027", errorMessage, results);
    }

    public ClusterResult checkRSHServer(String[] nodeNames) throws FatalException, ClusterException {
        ClusterLogger.log("entering NativeSystem.checkRSHServer()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        GenericResult clusterResult = null;
        Hashtable<String, CommandResult> t = new Hashtable<String, CommandResult>();
        CommandResult result = null;
        Socket serverSocket = null;
        boolean status = true;
        for (int i = 0; i < nodeNames.length; ++i) {
            try {
                serverSocket = new Socket(nodeNames[i], 514);
                result = CommandResult.SUCCESS(nodeNames[i]);
                result.setResult(new Boolean(true));
            }
            catch (IOException ioe) {
                result = new CommandResult(nodeNames[i]);
                result.setException(new CommandException(nodeNames[i], ioe));
                result.setResult(new Boolean(false));
                status = false;
            }
            t.put(nodeNames[i], result);
            if (serverSocket == null) continue;
            try {
                serverSocket.close();
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        clusterResult = new GenericResult(t);
        if (status) {
            return clusterResult;
        }
        String failedNodeList = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16041", (Object[])new String[]{failedNodeList, String.valueOf(514)});
        throw new ClusterException("PROV-16041", errorMessage, clusterResult.getResults());
    }

    public ClusterResult checkSSHServer(String[] nodeNames) throws FatalException, ClusterException {
        return this.checkSSHServer(nodeNames, -1);
    }

    public ClusterResult checkSSHServer(String[] nodeNames, int port) throws FatalException, ClusterException {
        ClusterLogger.log("entering NativeSystem.checkSSHServer()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        GenericResult clusterResult = null;
        Hashtable<String, CommandResult> t = new Hashtable<String, CommandResult>();
        CommandResult result = null;
        Socket serverSocket = null;
        boolean status = true;
        if (-1 == port) {
            port = this.PORT;
        }
        for (int i = 0; i < nodeNames.length; ++i) {
            try {
                serverSocket = new Socket(nodeNames[i], port);
                result = CommandResult.SUCCESS(nodeNames[i]);
                result.setResult(new Boolean(true));
            }
            catch (IOException ioe) {
                result = new CommandResult(nodeNames[i]);
                result.setException(new CommandException(nodeNames[i], ioe));
                result.setResult(new Boolean(false));
                status = false;
            }
            t.put(nodeNames[i], result);
            if (serverSocket == null) continue;
            try {
                serverSocket.close();
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        clusterResult = new GenericResult(t);
        if (status) {
            return clusterResult;
        }
        String failedNodeList = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16040", (Object[])new String[]{failedNodeList, String.valueOf(port)});
        throw new ClusterException("PROV-16040", errorMessage, clusterResult.getResults());
    }

    public ClusterResult getNodesSyncInterval(SessionId sessId, String[] nodeNames) throws FatalException, ClusterException {
        ClusterLogger.log("entering NativeSystem.getNodesSyncInterval()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        this.startup(sessId, nodeNames);
        ClusterResult clusterResult = null;
        Session sess = (Session)s_sessions.get(sessId);
        boolean isLocalNode = this.isLocalNode(nodeNames[0]);
        if (isLocalNode) {
            String[] newNodeNames = new String[nodeNames.length - 1];
            System.arraycopy(nodeNames, 1, newNodeNames, 0, nodeNames.length - 1);
            nodeNames = newNodeNames;
        }
        NativeSystem ns = null;
        NodeInfo nodeinfo = null;
        if (nodeNames.length == 1) {
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            ns = nodeinfo.getNativeSystem();
            CommandResult res = ns.getTimeOnNode(nodeinfo);
            clusterResult = new GenericResult(res);
        } else {
            Command[] dateCmds = new DateCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                dateCmds[i] = new DateCommand(nodeinfo);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(dateCmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            int basetime = 0;
            int i = 0;
            if (isLocalNode) {
                basetime = (int)(System.currentTimeMillis() / 1000L);
            } else {
                basetime = (Integer)clusterResult.getResultOnNode(nodeNames[0]).getResult();
                i = 1;
            }
            int error = 0;
            for (i = 0; i < nodeNames.length; ++i) {
                int value = (Integer)clusterResult.getResultOnNode(nodeNames[i]).getResult();
                int temp = basetime - value;
                if (temp <= 0 || temp <= error) continue;
                error = temp;
            }
            Hashtable<String, CommandResult> t = new Hashtable<String, CommandResult>();
            CommandResult resultOnNode = CommandResult.SUCCESS("localhost");
            resultOnNode.setResult(new Integer(error));
            t.put("localhost", resultOnNode);
            while (results.hasNext()) {
                resultOnNode = (CommandResult)results.next();
                t.put(resultOnNode.getNodeName(), resultOnNode);
            }
            clusterResult = new GenericResult(t);
            return clusterResult;
        }
        String failedNodeList = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16038", (Object[])new String[]{failedNodeList});
        throw new ClusterException("PROV-16038", errorMessage, results);
    }

    public ClusterResult copyFileToNodes(SessionId sessId, String fileName1, String[] nodeNames, String fileName2) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering NativeSystem.copyFileToNodes()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        try {
            this.startup(sessId, nodeNames);
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Assertions.validatePath(fileName1);
        Assertions.assertName(fileName2);
        fileName1 = this.getStandardForm(fileName1);
        fileName2 = this.getStandardForm(fileName2);
        Session sess = (Session)s_sessions.get(sessId);
        ClusterResult clusterResult = null;
        if (nodeNames.length == 1) {
            CommandResult res = this.copyFile(sess.getLocalNodeInfo(), fileName1, sess.getNodeInfo(nodeNames[0]), fileName2);
            clusterResult = new GenericResult(res);
        } else {
            Command[] copyCmds = new CopyCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                copyCmds[i] = new CopyCommand(sess.getLocalNodeInfo(), fileName1, sess.getNodeInfo(nodeNames[i]), fileName2);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(copyCmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            return clusterResult;
        }
        String failedNodes = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        Object[] args = new Object[]{fileName1, OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"LOCALHOST"), fileName2, failedNodes};
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16009", (Object[])args);
        throw new RemoteFileOperationException("PROV-16009", errorMessage, results);
    }

    public ClusterResult copyFileBetweenNodes(SessionId sessId, String nodeName1, String fileName1, String nodeName2, String fileName2) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering NativeSystem.copyFileBetweenNodes()", ClusterLogger.LOG_FINER);
        Assertions.assertName(nodeName1);
        Assertions.assertName(nodeName2);
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo1 = null;
        NodeInfo nodeinfo2 = null;
        ArrayList<String> nodes = new ArrayList<String>();
        if (!nodeName1.equals("localhost")) {
            nodes.add(nodeName1);
            nodeinfo1 = sess.getNodeInfo(nodeName1);
        } else {
            nodeinfo1 = sess.getLocalNodeInfo();
        }
        if (!nodeName2.equals("localhost")) {
            nodes.add(nodeName2);
            nodeinfo2 = sess.getNodeInfo(nodeName2);
        } else {
            nodeinfo2 = sess.getLocalNodeInfo();
        }
        int size = nodes.size();
        String[] nodesArr = new String[size];
        for (int i = 0; i < size; ++i) {
            nodesArr[i] = (String)nodes.get(i);
        }
        try {
            this.startup(sessId, nodesArr);
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Assertions.assertName(fileName1);
        Assertions.assertName(fileName2);
        fileName1 = this.getStandardForm(fileName1);
        fileName2 = this.getStandardForm(fileName2);
        CommandResult res = this.copyFile(nodeinfo1, fileName1, nodeinfo2, fileName2);
        GenericResult clusterResult = new GenericResult(res);
        if (res.getStatus()) {
            return clusterResult;
        }
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16009", (Object[])new Object[]{fileName1, nodeName1, fileName2, nodeName2});
        throw new RemoteFileOperationException("PROV-16009", errorMessage, clusterResult.getResults());
    }

    protected abstract String getDefaultDestDirToExtractFiles() throws FatalException;

    public ClusterResult extractArchiveOnNode(SessionId sessId, String filename, String nodename, String destdir, int cmd, boolean extractModificationTime, String unzipCmd) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering NativeSystem.extractArchiveOnNode()", ClusterLogger.LOG_FINER);
        Assertions.assertName(nodename);
        try {
            this.startup(sessId, new String[]{nodename});
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Assertions.assertName(filename);
        Session sess = (Session)s_sessions.get(sessId);
        if (destdir == null || destdir.trim().length() == 0) {
            destdir = this.getDefaultDestDirToExtractFiles();
        }
        NodeInfo nodeinfo = sess.getNodeInfo(nodename);
        NativeSystem ns = nodeinfo.getNativeSystem();
        filename = ns.getStandardForm(filename);
        CommandResult res = ns.extractArchive(filename, nodeinfo, destdir, cmd, extractModificationTime, unzipCmd);
        GenericResult clusterResult = new GenericResult(res);
        if (res.getStatus()) {
            return clusterResult;
        }
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16012", (Object[])new Object[]{filename, destdir, nodename, String.valueOf(cmd)});
        throw new RemoteFileOperationException("PROV-16012", errorMessage, clusterResult.getResults());
    }

    protected abstract void createArchive(String var1, String var2, String var3, String var4, Session var5) throws FatalException;

    protected abstract String getTmpArchivePath(String var1);

    protected abstract int findIndexOf(String var1, String var2);

    protected String getListFileWithRelPaths(String pathName, String listFile, String tmpDir) throws FatalException {
        ClusterLogger.log("constructing a listFile with files relative to: " + pathName);
        pathName = OiixPathOps.getStandardForm((String)pathName);
        listFile = OiixPathOps.getStandardForm((String)listFile);
        tmpDir = OiixPathOps.getStandardForm((String)tmpDir);
        String scratchFileName = null;
        BufferedReader bufRead = null;
        PrintWriter out = null;
        String filePath = null;
        int nEntries = 0;
        try {
            bufRead = new BufferedReader(new FileReader(listFile));
            filePath = bufRead.readLine();
            if (filePath != null) {
                String line;
                filePath = OiixPathOps.getStandardForm((String)filePath.trim());
                File copyListFile = new File(listFile);
                copyListFile = File.createTempFile(copyListFile.getName() + "Rel" + this.getTimeStamp(), null, new File(tmpDir));
                scratchFileName = copyListFile.getAbsolutePath();
                ClusterLogger.log("Creating a temporary listFile " + scratchFileName, ClusterLogger.LOG_FINEST);
                out = new PrintWriter(new FileOutputStream(scratchFileName, false), true);
                if (this.findIndexOf(pathName, filePath) < 0) {
                    ClusterLogger.log("List file has the relative paths.", ClusterLogger.LOG_FINER);
                    pathName = "./";
                } else {
                    ClusterLogger.log("List file has the absolute paths.", ClusterLogger.LOG_FINER);
                }
                int replaceLen = pathName.length();
                int index = this.findIndexOf(pathName, filePath);
                String string = line = index == -1 ? filePath : filePath.substring(replaceLen);
                if (!line.equals("")) {
                    ClusterLogger.log(line, ClusterLogger.LOG_FINEST);
                    out.println(line);
                    ++nEntries;
                }
                while ((filePath = bufRead.readLine()) != null) {
                    index = this.findIndexOf(pathName, filePath = OiixPathOps.getStandardForm((String)filePath.trim()));
                    line = index == -1 ? filePath : filePath.substring(replaceLen);
                    if (line.equals("")) continue;
                    ClusterLogger.log(line, ClusterLogger.LOG_FINEST);
                    out.println(line);
                    ++nEntries;
                }
            }
        }
        catch (IOException ie) {
            ClusterLogger.log(ie.getMessage(), ClusterLogger.LOG_SEVERE);
            throw new FatalException(ie.getMessage());
        }
        finally {
            if (bufRead != null) {
                try {
                    bufRead.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                out.close();
            }
        }
        if (nEntries == 0) {
            return null;
        }
        return scratchFileName;
    }

    protected String getListFileWithAbsolutePaths(String pathName, String listFile, String tmpDir, int pathtype) throws FatalException {
        ClusterLogger.log("entering NativeSystem.getListFileWithAbsolutePaths()", ClusterLogger.LOG_FINER);
        if (pathtype == 1) {
            return listFile;
        }
        pathName = OiixPathOps.getStandardForm((String)pathName);
        listFile = OiixPathOps.getStandardForm((String)listFile);
        tmpDir = OiixPathOps.getStandardForm((String)tmpDir);
        String scratchFileName = null;
        BufferedReader bufRead = null;
        PrintWriter out = null;
        String filePath = null;
        try {
            bufRead = new BufferedReader(new FileReader(listFile));
            filePath = bufRead.readLine();
            if (filePath != null) {
                filePath = OiixPathOps.getStandardForm((String)filePath.trim());
                scratchFileName = listFile;
                if (this.findIndexOf(pathName, filePath) < 0) {
                    ClusterLogger.log("List file has relative paths.", ClusterLogger.LOG_FINER);
                    File copyListFile = new File(listFile);
                    copyListFile = File.createTempFile(copyListFile.getName() + "Abs" + this.getTimeStamp(), null, new File(tmpDir));
                    scratchFileName = copyListFile.getAbsolutePath();
                    ClusterLogger.log("Creating a temporary listFile " + scratchFileName, ClusterLogger.LOG_FINEST);
                    out = new PrintWriter(new FileOutputStream(scratchFileName, false), true);
                    String line = pathName + filePath;
                    ClusterLogger.log(line, ClusterLogger.LOG_FINEST);
                    out.println(line);
                    while ((filePath = bufRead.readLine()) != null) {
                        filePath = OiixPathOps.getStandardForm((String)filePath.trim());
                        line = pathName + filePath;
                        ClusterLogger.log(line, ClusterLogger.LOG_FINEST);
                        out.println(line);
                    }
                } else {
                    ClusterLogger.log("List file has the absolute paths.", ClusterLogger.LOG_FINER);
                }
            }
        }
        catch (IOException ie) {
            ClusterLogger.log(ie.getMessage(), ClusterLogger.LOG_SEVERE);
            throw new FatalException(ie.getMessage());
        }
        finally {
            if (bufRead != null) {
                try {
                    bufRead.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                out.close();
            }
        }
        return scratchFileName;
    }

    private int validateListFile(String parentDir, String listFile) throws FatalException {
        ClusterLogger.log("entering NativeSystem.validateListFile()", ClusterLogger.LOG_FINER);
        BufferedReader bufRead = null;
        int nRelative = 0;
        int nAbsolute = 0;
        String filePath = null;
        try {
            bufRead = new BufferedReader(new FileReader(listFile));
            while ((filePath = bufRead.readLine()) != null) {
                if (this.findIndexOf(parentDir, filePath) == -1) {
                    ++nRelative;
                    continue;
                }
                ++nAbsolute;
            }
        }
        catch (IOException ie) {
            ClusterLogger.log(ie.getMessage(), ClusterLogger.LOG_SEVERE);
            throw new FatalException(ie.getMessage());
        }
        finally {
            if (bufRead != null) {
                try {
                    bufRead.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (nRelative > 0 && nAbsolute > 0) {
            String errMsg = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16033", (Object[])new String[]{listFile, String.valueOf(nRelative), String.valueOf(nAbsolute)});
            ClusterLogger.log(errMsg, ClusterLogger.LOG_SEVERE);
            throw new FatalException(errMsg);
        }
        if (nRelative > 0) {
            return 0;
        }
        if (nAbsolute > 0) {
            return 1;
        }
        return -1;
    }

    protected String getZipCommand(String archive, String parentDir, String copyListFile, String exclListFile, Paths paths) {
        String cmd = "";
        cmd = parentDir != null ? "(cd '" + parentDir + "' && " : "(";
        String excllist = this.getList(exclListFile);
        String incllist = this.getList(copyListFile);
        cmd = cmd + "'" + paths.getValue("ZIP_PATH") + "' " + paths.getValue("ZIP_ARGS") + " '" + archive + "' " + " " + (incllist != null ? "* " + paths.getValue("ZIP_INCLUDE_ARGS") + " " + incllist : "*") + " " + (excllist != null ? paths.getValue("ZIP_EXCLUDE_ARGS") + " " + excllist : "") + " )";
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getList(String listFile) {
        if (listFile == null) {
            return null;
        }
        BufferedReader bufRead = null;
        String filePath = null;
        StringBuffer buff = new StringBuffer();
        try {
            bufRead = new BufferedReader(new FileReader(listFile));
            while ((filePath = bufRead.readLine()) != null) {
                buff.append(OiixPathOps.getStandardForm((String)filePath));
                buff.append(" ");
            }
        }
        catch (IOException ie) {
            ClusterLogger.log(ie.getMessage(), ClusterLogger.LOG_SEVERE);
        }
        finally {
            if (bufRead != null) {
                try {
                    bufRead.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (buff.length() > 0) {
            return buff.toString();
        }
        return null;
    }

    public ClusterResult copyListedPathsToNodes(SessionId sessId, String[] nodeNames, String dirName, String copyListFile, String excludeListFile, String tmpDir, boolean create) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering NativeSystem.copyListedPathsToNodes()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        try {
            this.startup(sessId, nodeNames);
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Session sess = (Session)s_sessions.get(sessId);
        boolean bCreate = false;
        if (tmpDir == null) {
            tmpDir = sess.getLocalNodeInfo().getScratchPath();
        } else if (tmpDir.trim().length() == 0) {
            tmpDir = sess.getLocalNodeInfo().getScratchPath();
        } else {
            File dir = new File(tmpDir);
            dir.mkdirs();
            bCreate = true;
        }
        Assertions.isDirWritable(tmpDir);
        if (dirName == null || dirName.trim().length() == 0) {
            dirName = this.getDefaultDestDirToExtractFiles();
        } else if (!dirName.endsWith(this.getFileSeparator())) {
            dirName = dirName + this.getFileSeparator();
            Assertions.validatePath(dirName);
        }
        dirName = this.getStandardForm(dirName);
        String newExclListFile = null;
        if (excludeListFile != null) {
            Assertions.canRead(excludeListFile);
            excludeListFile = newExclListFile = this.getListFileWithRelPaths(dirName, excludeListFile, tmpDir);
        }
        String newCopyListFile = null;
        Assertions.canRead(copyListFile);
        newCopyListFile = this.getListFileWithRelPaths(dirName, copyListFile, tmpDir);
        if (newCopyListFile == null) {
            throw new FatalException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001"));
        }
        copyListFile = newCopyListFile;
        String scratchPath = this.getTmpArchivePath(tmpDir);
        try {
            this.createArchive(scratchPath, dirName, copyListFile, excludeListFile, sess);
        }
        catch (FatalException fe) {
            new File(scratchPath).delete();
            if (newExclListFile != null) {
                new File(newExclListFile).delete();
            }
            if (newCopyListFile != null) {
                new File(newCopyListFile).delete();
            }
            throw fe;
        }
        ClusterResult clusterResult = null;
        NativeSystem ns = null;
        NodeInfo nodeinfo = null;
        int cmd = this.getArchiveCommandToBeUsed(sess.getRemoteNodesPlatform());
        if (nodeNames.length == 1) {
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            ns = nodeinfo.getNativeSystem();
            CommandResult res = null;
            res = bCreate ? ns.copyAndExtractArchive(scratchPath, nodeinfo, dirName, create, cmd, true, tmpDir) : ns.copyAndExtractArchive(scratchPath, nodeinfo, dirName, create, cmd, true);
            clusterResult = new GenericResult(res);
        } else {
            Command[] cmds = new CopyAndExtractCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                cmds[i] = bCreate ? new CopyAndExtractCommand(scratchPath, nodeinfo, dirName, create, cmd, true, tmpDir) : new CopyAndExtractCommand(scratchPath, nodeinfo, dirName, create, cmd, true);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(cmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        new File(scratchPath).delete();
        if (newExclListFile != null) {
            new File(newExclListFile).delete();
        }
        if (newCopyListFile != null) {
            new File(newCopyListFile).delete();
        }
        if (status == 0) {
            return clusterResult;
        }
        String failedNodes = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16013", (Object[])new Object[]{dirName, failedNodes});
        throw new RemoteFileOperationException("PROV-16013", errorMessage, results);
    }

    protected abstract int getArchiveCommandToBeUsed(int var1);

    public ClusterResult copyDirToNodes(SessionId sessId, String[] nodeNames, String srcDir, String destDir, String excludeListFile, String tmpDir, boolean create) throws FatalException, RemoteFileOperationException {
        return this.copyDirToNodes(sessId, nodeNames, srcDir, destDir, excludeListFile, tmpDir, create, true);
    }

    public ClusterResult copyDirToNodes(SessionId sessId, String[] nodeNames, String srcDir, String destDir, String excludeListFile, String tmpDir, boolean create, boolean extractModificationTime) throws FatalException, RemoteFileOperationException {
        int nFiles;
        ClusterLogger.log("entering NativeSystem.copyDirToNodes()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        try {
            this.startup(sessId, nodeNames);
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Session sess = (Session)s_sessions.get(sessId);
        boolean bCreate = false;
        if (tmpDir == null) {
            tmpDir = sess.getLocalNodeInfo().getScratchPath();
        } else if (tmpDir.trim().length() == 0) {
            tmpDir = sess.getLocalNodeInfo().getScratchPath();
        } else {
            File dir = new File(tmpDir);
            dir.mkdirs();
            bCreate = true;
        }
        Assertions.isDirWritable(tmpDir);
        Assertions.assertHome(srcDir);
        if (destDir == null) {
            destDir = srcDir;
        }
        if (!srcDir.endsWith(this.getFileSeparator()) && (nFiles = new File(srcDir = srcDir + this.getFileSeparator()).listFiles().length) == 0) {
            return this.createDirInNodes(sessId, nodeNames, destDir);
        }
        String newExclListFile = null;
        if (excludeListFile != null) {
            Assertions.canRead(excludeListFile);
            excludeListFile = newExclListFile = this.getListFileWithRelPaths(srcDir, excludeListFile, tmpDir);
        }
        String scratchPath = this.getTmpArchivePath(tmpDir);
        try {
            this.createArchive(scratchPath, srcDir, null, excludeListFile, sess);
        }
        catch (FatalException fe) {
            new File(scratchPath).delete();
            if (newExclListFile != null) {
                new File(newExclListFile).delete();
            }
            throw fe;
        }
        int cmd = this.getArchiveCommandToBeUsed(sess.getRemoteNodesPlatform());
        ClusterResult clusterResult = null;
        NativeSystem ns = null;
        NodeInfo nodeinfo = null;
        if (nodeNames.length == 1) {
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            ns = nodeinfo.getNativeSystem();
            CommandResult res = null;
            res = bCreate ? ns.copyAndExtractArchive(scratchPath, nodeinfo, destDir, create, cmd, extractModificationTime, tmpDir) : ns.copyAndExtractArchive(scratchPath, nodeinfo, destDir, create, cmd, extractModificationTime);
            clusterResult = new GenericResult(res);
        } else {
            Command[] cmds = new CopyAndExtractCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                cmds[i] = bCreate ? new CopyAndExtractCommand(scratchPath, nodeinfo, destDir, create, cmd, extractModificationTime, tmpDir) : new CopyAndExtractCommand(scratchPath, nodeinfo, destDir, create, cmd, extractModificationTime);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(cmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        new File(scratchPath).delete();
        if (newExclListFile != null) {
            new File(newExclListFile).delete();
        }
        if (status == 0) {
            return clusterResult;
        }
        String failedNodes = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16013", (Object[])new Object[]{srcDir, failedNodes});
        throw new RemoteFileOperationException("PROV-16013", errorMessage, results);
    }

    public ClusterResult copyDirFromNodes(SessionId sessId, String[] nodeNames, String srcDir, String destDir, String tmpDir, boolean extractModificationTime) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering NativeSystem.copyDirFromNodes()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        try {
            this.startup(sessId, nodeNames);
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        if (tmpDir != null) {
            if (tmpDir.trim().length() == 0) {
                tmpDir = null;
            } else {
                File dir = new File(tmpDir);
                dir.mkdirs();
            }
        }
        Assertions.assertName(srcDir);
        if (destDir == null) {
            destDir = srcDir;
        }
        Session sess = (Session)s_sessions.get(sessId);
        ClusterResult clusterResult = null;
        NativeSystem ns = null;
        NodeInfo nodeinfo = null;
        if (nodeNames.length == 1) {
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            ns = nodeinfo.getNativeSystem();
            CommandResult res = ns.copyDirFromNode(nodeinfo, srcDir, destDir, extractModificationTime, tmpDir);
            clusterResult = new GenericResult(res);
        } else {
            Command[] cmds = new CopyDirFromNodeCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                cmds[i] = new CopyDirFromNodeCommand(nodeinfo, srcDir, destDir, extractModificationTime, tmpDir);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(cmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            return clusterResult;
        }
        throw new RemoteFileOperationException("PROV-16013", "", results);
    }

    public ClusterResult createDirInNodes(SessionId sessId, String[] nodeNames, String dirName) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering NativeSystem.createDirInNodes()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        try {
            this.startup(sessId, nodeNames);
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Assertions.assertName(dirName);
        dirName = this.getStandardForm(dirName);
        Session sess = (Session)s_sessions.get(sessId);
        ClusterResult clusterResult = null;
        NativeSystem ns = null;
        NodeInfo nodeinfo = null;
        if (nodeNames.length == 1) {
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            ns = nodeinfo.getNativeSystem();
            CommandResult res = ns.createDir(nodeinfo, dirName);
            clusterResult = new GenericResult(res);
        } else {
            Command[] cmds = new CreateDirCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                cmds[i] = new CreateDirCommand(nodeinfo, dirName);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(cmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            return clusterResult;
        }
        String failedNodes = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16014", (Object[])new String[]{dirName, failedNodes});
        throw new RemoteFileOperationException("PROV-16014", errorMessage, results);
    }

    public ClusterResult createListedDirsOnNodes(SessionId sessId, String[] nodeNames, String createListFile, String parentDir, String tmpDir) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering NativeSystem.createListedDirsOnNodes()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        try {
            this.startup(sessId, nodeNames);
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Session sess = (Session)s_sessions.get(sessId);
        this.checkCreateListedDirPrereqs(sess.getLocalPaths());
        Assertions.canRead(createListFile);
        boolean bCreate = false;
        if (tmpDir == null) {
            tmpDir = sess.getLocalNodeInfo().getScratchPath();
        } else if (tmpDir.trim().length() == 0) {
            tmpDir = sess.getLocalNodeInfo().getScratchPath();
        } else {
            File dir = new File(tmpDir);
            dir.mkdirs();
            bCreate = true;
        }
        Assertions.isDirWritable(tmpDir);
        String newCreateListFile = null;
        if (parentDir != null) {
            if (!parentDir.endsWith(this.getFileSeparator())) {
                parentDir = parentDir + this.getFileSeparator();
            }
            int pathtype = this.validateListFile(parentDir, createListFile);
            createListFile = newCreateListFile = this.getListFileWithAbsolutePaths(parentDir, createListFile, tmpDir, pathtype);
        }
        ClusterResult clusterResult = null;
        NativeSystem ns = null;
        NodeInfo nodeinfo = null;
        if (nodeNames.length == 1) {
            CommandResult res = null;
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            ns = nodeinfo.getNativeSystem();
            res = bCreate ? ns.createListedDirs(nodeinfo, createListFile, tmpDir) : ns.createListedDirs(nodeinfo, createListFile);
            clusterResult = new GenericResult(res);
        } else {
            Command[] cmds = new CreateListedDirsCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                cmds[i] = bCreate ? new CreateListedDirsCommand(nodeinfo, createListFile, tmpDir) : new CreateListedDirsCommand(nodeinfo, createListFile);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(cmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (newCreateListFile != null) {
            new File(newCreateListFile).delete();
        }
        if (status == 0) {
            return clusterResult;
        }
        String failedNodes = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16028", (Object[])new String[]{failedNodes, createListFile});
        throw new RemoteFileOperationException("PROV-16028", errorMessage, results);
    }

    public ClusterResult isDirWritable(SessionId sessId, String node, String dir) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering NativeSystem.isDirWritable()", ClusterLogger.LOG_FINER);
        Assertions.assertName(node);
        try {
            this.startup(sessId, new String[]{node});
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Assertions.assertName(dir);
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo = sess.getNodeInfo(node);
        NativeSystem ns = nodeinfo.getNativeSystem();
        dir = ns.getStandardForm(dir);
        CommandResult res = ns.pathExists(nodeinfo, dir, 7);
        if (((Boolean)res.getResult()).booleanValue()) {
            res = ns.pathExists(nodeinfo, dir, 11);
        } else {
            res = ns.createDir(nodeinfo, dir);
            ns.removeDir(nodeinfo, dir, false, false);
        }
        GenericResult clusterResult = new GenericResult(res);
        if (res.getStatus()) {
            return clusterResult;
        }
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16019", (Object[])new String[]{dir, node});
        throw new RemoteFileOperationException("PROV-16019", errorMessage, clusterResult.getResults());
    }

    public ClusterResult pathExistsOnNode(SessionId sessId, String node, String path, int pathType) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering NativeSystem.pathExistsOnNode()", ClusterLogger.LOG_FINER);
        Assertions.assertName(node);
        try {
            this.startup(sessId, new String[]{node});
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Assertions.assertName(path);
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo = sess.getNodeInfo(node);
        NativeSystem ns = nodeinfo.getNativeSystem();
        path = ns.getStandardForm(path);
        CommandResult res = ns.pathExists(nodeinfo, path, pathType);
        GenericResult clusterResult = new GenericResult(res);
        if (res.getException() == null) {
            return clusterResult;
        }
        String errorMessage = "";
        if (pathType == 11) {
            errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16019", (Object[])new String[]{path, node});
            throw new RemoteFileOperationException("PROV-16019", errorMessage, clusterResult.getResults());
        }
        errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16016", (Object[])new String[]{path, node});
        throw new RemoteFileOperationException("PROV-16016", errorMessage, clusterResult.getResults());
    }

    public ClusterResult removeDirFromNodes(SessionId sessId, String[] nodeNames, String dirName, boolean recurse, boolean deleteEmptyParent) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering NativeSystem.removeDirRecurseFromNodes()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        try {
            this.startup(sessId, nodeNames);
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Assertions.assertName(dirName);
        dirName = this.getStandardForm(dirName);
        Session sess = (Session)s_sessions.get(sessId);
        NativeSystem ns = null;
        ClusterResult clusterResult = null;
        NodeInfo nodeinfo = null;
        if (nodeNames.length == 1) {
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            ns = nodeinfo.getNativeSystem();
            CommandResult res = ns.removeDir(nodeinfo, dirName, recurse, deleteEmptyParent);
            clusterResult = new GenericResult(res);
        } else {
            Command[] cmds = new RemoveDirCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                cmds[i] = new RemoveDirCommand(nodeinfo, dirName, recurse, deleteEmptyParent);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(cmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            return clusterResult;
        }
        String failedNodes = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16015", (Object[])new String[]{dirName, failedNodes});
        throw new RemoteFileOperationException("PROV-16015", errorMessage, results);
    }

    public ClusterResult removeFileFromNodes(SessionId sessId, String[] nodeNames, String filename) throws FatalException, RemoteFileOperationException {
        return this.removeFileFromNodes(sessId, nodeNames, filename, true);
    }

    public ClusterResult removeFileFromNodes(SessionId sessId, String[] nodeNames, String filename, boolean asNormalUser) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering NativeSystem.removeFileFromNodes()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        try {
            this.startup(sessId, nodeNames);
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Assertions.assertName(filename);
        filename = this.getStandardForm(filename);
        Session sess = (Session)s_sessions.get(sessId);
        ClusterResult clusterResult = null;
        NativeSystem ns = null;
        NodeInfo nodeinfo = null;
        if (nodeNames.length == 1) {
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            ns = nodeinfo.getNativeSystem();
            CommandResult res = ns.removeFile(nodeinfo, filename, asNormalUser);
            clusterResult = new GenericResult(res);
        } else {
            Command[] cmds = new RemoveFileCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                cmds[i] = new RemoveFileCommand(nodeinfo, filename, asNormalUser);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(cmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            return clusterResult;
        }
        String failedNodes = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16022", (Object[])new String[]{filename, failedNodes});
        throw new RemoteFileOperationException("PROV-16022", errorMessage, results);
    }

    public ClusterResult removeListedPathsFromNodes(SessionId sessId, String[] nodeNames, String removeListFile, int pathType) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering NativeSystem.removeListedFilesFromNode()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        try {
            this.startup(sessId, nodeNames);
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Session sess = (Session)s_sessions.get(sessId);
        this.checkRemoveListedPathsPrereqs(sess.getLocalPaths());
        Assertions.canRead(removeListFile);
        ClusterResult clusterResult = null;
        NativeSystem ns = null;
        NodeInfo nodeinfo = null;
        if (nodeNames.length == 1) {
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            ns = nodeinfo.getNativeSystem();
            CommandResult res = ns.removeListedPaths(nodeinfo, removeListFile, pathType);
            clusterResult = new GenericResult(res);
        } else {
            Command[] cmds = new RemoveListedPathsCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                cmds[i] = new RemoveListedPathsCommand(nodeinfo, removeListFile, pathType);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(cmds);
        }
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            return clusterResult;
        }
        String failedNodes = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16029", (Object[])new String[]{removeListFile, failedNodes});
        throw new RemoteFileOperationException("PROV-16029", errorMessage, results);
    }

    public ClusterResult moveFileOnNode(SessionId sessId, String node, String sourceFile, String destFile) throws FatalException, RemoteFileOperationException {
        Assertions.assertName(node);
        try {
            this.startup(sessId, new String[]{node});
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Assertions.assertName(sourceFile);
        Assertions.assertName(destFile);
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo = sess.getNodeInfo(node);
        NativeSystem ns = nodeinfo.getNativeSystem();
        sourceFile = this.getStandardForm(sourceFile);
        destFile = this.getStandardForm(destFile);
        sourceFile = ns.getStandardForm(sourceFile);
        destFile = ns.getStandardForm(destFile);
        CommandResult res = ns.moveFile(nodeinfo, sourceFile, destFile);
        GenericResult clusterResult = new GenericResult(res);
        if (res.getStatus()) {
            return clusterResult;
        }
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16030", (Object[])new Object[]{node, sourceFile, destFile});
        throw new RemoteFileOperationException("PROV-16030", errorMessage, clusterResult.getResults());
    }

    public ClusterResult listDirectoryOnNode(SessionId sessId, String nodeName, String dirPath) throws FatalException, RemoteFileOperationException {
        ClusterLogger.log("entering NativeSystem.listDirectoryOnNode()", ClusterLogger.LOG_FINER);
        Assertions.assertName(nodeName);
        try {
            this.startup(sessId, new String[]{nodeName});
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Assertions.assertName(dirPath);
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo = sess.getNodeInfo(nodeName);
        NativeSystem ns = nodeinfo.getNativeSystem();
        dirPath = ns.getStandardForm(dirPath);
        CommandResult res = ns.listDirectory(nodeinfo, dirPath);
        GenericResult clusterResult = new GenericResult(res);
        if (res.getStatus()) {
            return clusterResult;
        }
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16035", (Object[])new Object[]{dirPath, nodeName});
        throw new RemoteFileOperationException("PROV-16035", errorMessage, clusterResult.getResults());
    }

    public ClusterResult getHostNameForNode(SessionId sessId, String nodeName) throws FatalException, ClusterException {
        ClusterLogger.log("entering NativeSystem.getHostNameForNode()", ClusterLogger.LOG_FINER);
        Assertions.assertName(nodeName);
        this.startup(sessId, new String[]{nodeName});
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo = sess.getNodeInfo(nodeName);
        NativeSystem ns = nodeinfo.getNativeSystem();
        CommandResult result = ns.getHostName(nodeinfo);
        GenericResult clusterResult = new GenericResult(result);
        if (result.getStatus()) {
            return clusterResult;
        }
        throw new ClusterException("PROV-10002", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-10002", (Object[])new String[]{nodeName}), clusterResult.getResults());
    }

    protected abstract void checkUserEquivPrereqs(Session var1) throws RemoteShellFatalException;

    protected abstract void checkCreateListedDirPrereqs(Paths var1) throws FatalException;

    protected abstract void checkRemoveListedPathsPrereqs(Paths var1) throws FatalException;

    public abstract CommandResult runCmd(String var1, String[] var2, String[] var3, NodeInfo var4);

    public CommandResult runCmd(String cmd, String[] args, String[] env, NodeInfo nodeinfo, boolean asNormalUser) {
        return this.runCmd(cmd, args, env, nodeinfo);
    }

    public abstract CommandResult runRemoteSSHCmd(String[] var1, String[] var2, NodeInfo var3, String var4, String var5);

    public CommandResult isNodeAlive(NodeInfo nodeinfo, int timeout) {
        if (nodeinfo == null) {
            System.out.println("isNodeAlive nodinfo is null");
        }
        ClusterLogger.log("entering NativeSystem.isNodeAlive()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        String node = nodeinfo.getNodeName();
        String[] cmd = sess.getLocalNodeInfo().getNativeSystem().getPingCommand(sess, node, timeout, sess.getLocalPaths());
        CommandResult res = null;
        int i = 0;
        int nRetryCnt = Integer.getInteger(PING_RETRY_COUNT, 2);
        do {
            RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
            res = r_eng.runcmd(sess.getLocalNodeInfo(), cmd, null, null, true);
            res.setNodeName(node);
        } while (!res.getStatus() && ++i < nRetryCnt);
        return res;
    }

    abstract String[] getPingCommand(Session var1, String var2, int var3, Paths var4);

    public CommandResult isNodeAccessible(NodeInfo nodeinfo) {
        ClusterLogger.log("entering NativeSystem.isNodeAccessible()", ClusterLogger.LOG_FINER);
        CommandResult result = null;
        String node = nodeinfo.getNodeName();
        try {
            result = this.checkRemoteExecutionSetup(nodeinfo, false);
        }
        catch (RemoteShellException rse) {
            result = new CommandResult(node);
            result.setException(rse);
            result.setStatus(false);
            result.setResult(new Boolean(false));
        }
        return result;
    }

    public abstract CommandResult checkSSHSetup(NodeInfo var1);

    public abstract CommandResult checkSSHSetup(NodeInfo var1, String var2);

    public abstract CommandResult checkRSHSetup(NodeInfo var1);

    public abstract CommandResult checkRSHSetup(NodeInfo var1, String var2);

    abstract CommandResult checkRemoteExecutionSetup(NodeInfo var1, boolean var2) throws RemoteShellException;

    public abstract CommandResult getTimeOnNode(NodeInfo var1);

    public abstract CommandResult createCFSFile(NodeInfo var1, String var2);

    public abstract CommandResult testCFSFile(NodeInfo var1, String var2);

    public abstract CommandResult getFreeSpace(NodeInfo var1, String var2);

    public abstract String createFileName(NodeInfo var1, String var2);

    public CommandResult copyFile(NodeInfo nodeinfo1, String file1, NodeInfo nodeinfo2, String file2) {
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(null);
        CommandResult res = r_eng.copyFile(nodeinfo1, file1, nodeinfo2, file2);
        return res;
    }

    protected abstract CommandResult convertFile(NodeInfo var1, int var2, String var3);

    public abstract CommandResult extractArchive(String var1, NodeInfo var2, String var3, int var4, boolean var5, String var6);

    protected abstract CommandResult extractArchiveOnLocalNode(NodeInfo var1, String var2, String var3, int var4, boolean var5);

    public abstract CommandResult copyAndExtractArchive(String var1, NodeInfo var2, String var3, boolean var4, int var5, boolean var6);

    public abstract CommandResult copyAndExtractArchive(String var1, NodeInfo var2, String var3, boolean var4, int var5, boolean var6, String var7);

    public abstract CommandResult copyDirFromNode(NodeInfo var1, String var2, String var3, boolean var4, String var5);

    public CommandResult createDir(NodeInfo nodeinfo, String dir) {
        ClusterLogger.log("entering NativeSystem.createDir()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        Paths paths = nodeinfo.getPaths();
        String node = nodeinfo.getNodeName();
        boolean bSsh = nodeinfo.isSshSet();
        dir = this.getStandardForm(dir);
        String cmd = null;
        cmd = bSsh ? "'" + paths.getValue("MKDIR_PATH") + "' " + paths.getValue("MKDIR_ARGS") + " '" + dir + "'" : paths.getValue("MKDIR_PATH") + " " + paths.getValue("MKDIR_ARGS") + " " + dir;
        String[] cmdarr = null;
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        cmdarr = r_eng.formulateCmd(bSsh, sess, node, paths, cmd, "", "-n");
        return this.runcmd(nodeinfo, cmdarr, bSsh);
    }

    protected CommandResult createService(SessionId sessId, String nodeName, String servicePath, String serviceName, String serviceArgs) throws FatalException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    protected CommandResult removeService(SessionId sessId, String nodeName, String servicePath, String serviceName) throws FatalException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    public ClusterResult createServiceOnNode(SessionId sessId, String nodeName, String servicePath, String serviceName, String serviceArgs) throws FatalException, ClusterException {
        Assertions.assertName(nodeName);
        Assertions.assertName(servicePath);
        Assertions.assertName(serviceArgs);
        Assertions.assertName(serviceName);
        GenericResult clusterResult = null;
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo = null;
        NativeSystem ns = null;
        nodeinfo = sess.getNodeInfo(nodeName);
        ns = nodeinfo.getNativeSystem();
        CommandResult res = ns.createService(sessId, nodeName, servicePath, serviceName, serviceArgs);
        clusterResult = new GenericResult(res);
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            return clusterResult;
        }
        String failedNodes = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16011", (Object[])new Object[]{"createService", failedNodes});
        throw new ClusterException("PROV-16011", errorMessage, results);
    }

    public ClusterResult removeServiceOnNode(SessionId sessId, String nodeName, String servicePath, String serviceName) throws FatalException, ClusterException {
        Assertions.assertName(nodeName);
        Assertions.assertName(servicePath);
        Assertions.assertName(serviceName);
        GenericResult clusterResult = null;
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo = null;
        NativeSystem ns = null;
        nodeinfo = sess.getNodeInfo(nodeName);
        ns = nodeinfo.getNativeSystem();
        CommandResult res = ns.removeService(sessId, nodeName, servicePath, serviceName);
        clusterResult = new GenericResult(res);
        int status = clusterResult.getStatus();
        Iterator results = clusterResult.getResults();
        if (status == 0) {
            return clusterResult;
        }
        String failedNodes = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16011", (Object[])new Object[]{"deleteService", failedNodes});
        throw new ClusterException("PROV-16011", errorMessage, results);
    }

    public ClusterResult runRootCmdOnNodes(SessionId sessId, String cmd, String[] args, String[] env, String password, String[] nodeNames) throws FatalException, ClusterException {
        ClusterLogger.log("entering NativeSystem.runRootCmdOnNodes()", ClusterLogger.LOG_FINER);
        Assertions.assertList(nodeNames);
        this.startup(sessId, nodeNames);
        Session sess = (Session)s_sessions.get(sessId);
        ClusterResult clusterResult = null;
        NodeInfo nodeinfo = null;
        NativeSystem ns = null;
        if (nodeNames.length == 1) {
            nodeinfo = sess.getNodeInfo(nodeNames[0]);
            ns = nodeinfo.getNativeSystem();
            CommandResult res = null;
            res = ns.runRootCmd(cmd, args, env, password, nodeinfo);
            clusterResult = new GenericResult(res);
        } else {
            Command[] runCmds = new RunRootCommand[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                nodeinfo = sess.getNodeInfo(nodeNames[i]);
                runCmds[i] = new RunRootCommand(cmd, args, env, password, nodeinfo);
            }
            ClusterManager clusterManager = new ClusterManager();
            clusterResult = clusterManager.submit(runCmds);
        }
        Iterator results = clusterResult.getResults();
        int status = clusterResult.getStatus();
        if (status == 0) {
            return clusterResult;
        }
        String failedNodes = NativeSystem.getNodesListStr(clusterResult.getFailedNodes());
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16037", (Object[])new Object[]{cmd, failedNodes});
        throw new ClusterException("PROV-16037", errorMessage, results);
    }

    public abstract CommandResult runRootCmd(String var1, String[] var2, String[] var3, String var4, NodeInfo var5);

    public CommandResult runSudoPbrunCmd(String cmd, String[] args, String[] env, NodeInfo nodeinfo) {
        return CommandResult.FAILURE_API_NOT_SUPPORTED(nodeinfo.getNodeName());
    }

    public ClusterResult testSudoPbrun(SessionId sessId, String nodeName) throws FatalException, ClusterException {
        throw new FatalException("PROV-17000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-17000"));
    }

    public ClusterResult createSymLinkOnNode(SessionId sessId, String node, String sourceFile, String destFile) throws FatalException, RemoteFileOperationException {
        Assertions.assertName(node);
        try {
            this.startup(sessId, new String[]{node});
        }
        catch (ClusterException e) {
            throw new RemoteFileOperationException(e);
        }
        Assertions.assertName(sourceFile);
        Assertions.assertName(destFile);
        Session sess = (Session)s_sessions.get(sessId);
        NodeInfo nodeinfo = sess.getNodeInfo(node);
        NativeSystem ns = nodeinfo.getNativeSystem();
        sourceFile = this.getStandardForm(sourceFile);
        destFile = this.getStandardForm(destFile);
        sourceFile = ns.getStandardForm(sourceFile);
        destFile = ns.getStandardForm(destFile);
        CommandResult res = null;
        res = ns.linkFile(nodeinfo, sourceFile, destFile);
        GenericResult clusterResult = new GenericResult(res);
        if (res.getStatus()) {
            return clusterResult;
        }
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16032", (Object[])new Object[]{node, destFile, sourceFile});
        throw new RemoteFileOperationException("PROV-16032", errorMessage, clusterResult.getResults());
    }

    protected abstract CommandResult linkFile(NodeInfo var1, String var2, String var3);

    public abstract CommandResult createListedDirs(NodeInfo var1, String var2);

    public abstract CommandResult createListedDirs(NodeInfo var1, String var2, String var3);

    public abstract CommandResult removeFile(NodeInfo var1, String var2);

    public CommandResult removeFile(NodeInfo nodeinfo, String file, boolean asNormalUser) {
        return this.removeFile(nodeinfo, file);
    }

    public abstract CommandResult removeDir(NodeInfo var1, String var2, boolean var3, boolean var4);

    public abstract CommandResult removeListedPaths(NodeInfo var1, String var2, int var3);

    public abstract CommandResult pathExists(NodeInfo var1, String var2, int var3);

    public CommandResult pathExists(NodeInfo nodeinfo, String path, int pathType, boolean asNormalUser) {
        return this.pathExists(nodeinfo, path, pathType);
    }

    public abstract CommandResult moveFile(NodeInfo var1, String var2, String var3);

    public abstract CommandResult listDirectory(NodeInfo var1, String var2);

    public abstract CommandResult getHostName(NodeInfo var1);

    public abstract CommandResult getHostName(NodeInfo var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult isLocalOnly(NodeInfo nodeinfo) {
        ClusterLogger.log("entering NativeSystem.isLocalOnly()", ClusterLogger.LOG_FINER);
        String node = nodeinfo.getNodeName();
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        CommandResult result = null;
        String fileName = "/etc/oracle" + this.getFileSeparator() + "ocr.loc";
        File configFile = new File(fileName);
        if (!node.equalsIgnoreCase("localhost")) {
            String tmpFile = sess.getLocalNodeInfo().getScratchPath() + this.getFileSeparator() + configFile.getName() + String.valueOf(System.currentTimeMillis());
            result = this.copyFile(nodeinfo, fileName, sess.getLocalNodeInfo(), tmpFile);
            configFile = new File(tmpFile);
        }
        ClusterLogger.log("configFile=" + configFile.getAbsolutePath());
        Boolean configType = null;
        if (result == null || result.getStatus()) {
            result = new CommandResult("localhost");
            try {
                String propertyValue = NativeSystem.getPropertyValue(configFile.getAbsolutePath(), "local_only", true);
                configType = propertyValue != null ? Boolean.valueOf(propertyValue.trim()) : Boolean.valueOf(false);
            }
            catch (FileNotFoundException fnfe) {
                result.setException(new CommandException(node, fnfe));
            }
            catch (IOException ie) {
                result.setException(new CommandException(node, ie));
            }
            finally {
                if (!node.equalsIgnoreCase("localhost")) {
                    configFile.delete();
                }
            }
        }
        if (result.getException() == null) {
            configType = configType == null ? Boolean.valueOf(true) : configType;
            result.setResult(configType);
            result.setStatus(true);
        } else {
            result.setResult(null);
            result.setStatus(false);
        }
        return result;
    }

    public static String getPropertyValue(String fileName, String propName, boolean ignoreCase) throws FileNotFoundException, IOException {
        String propValue;
        block15: {
            propValue = null;
            FileInputStream fis = null;
            BufferedReader reader = null;
            try {
                String keyName;
                String line;
                fis = new FileInputStream(fileName);
                Properties props = new Properties();
                props.load(fis);
                reader = new BufferedReader(new FileReader(fileName));
                while ((line = reader.readLine()) != null) {
                    if (line.indexOf(File.separator) == -1) continue;
                    StringTokenizer st = new StringTokenizer(line, "=");
                    keyName = st.nextToken();
                    if (!st.hasMoreTokens()) continue;
                    propValue = st.nextToken().trim();
                    ClusterLogger.log("keyName=" + keyName + " props.val=" + props.getProperty(keyName) + " propValue=" + propValue, ClusterLogger.LOG_FINEST);
                    props.setProperty(keyName, propValue);
                }
                propValue = null;
                StringTokenizer st1 = new StringTokenizer(propName);
                if (!ignoreCase && st1.countTokens() == 1) {
                    propValue = props.getProperty(propName);
                    break block15;
                }
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    keyName = (String)e.nextElement();
                    st1 = new StringTokenizer(propName);
                    StringTokenizer st2 = new StringTokenizer(keyName);
                    if (st1.countTokens() != st2.countTokens()) continue;
                    boolean propMatched = true;
                    while (st1.hasMoreTokens()) {
                        String token1 = st1.nextToken().trim();
                        String token2 = st2.nextToken().trim();
                        propMatched &= ignoreCase ? token1.equalsIgnoreCase(token2) : token1.equals(token2);
                    }
                    if (!propMatched) continue;
                    propValue = props.getProperty(keyName);
                    break;
                }
            }
            catch (FileNotFoundException e) {
                ClusterLogger.log(e);
                throw e;
            }
            catch (IOException e) {
                ClusterLogger.log(e);
                throw e;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        ClusterLogger.log("propName=" + propName + " propValue=" + propValue, ClusterLogger.LOG_FINEST);
        return propValue;
    }

    public CommandResult getPrivateNodeName(NodeInfo nodeinfo) {
        String outStr;
        StringTokenizer st;
        ClusterLogger.log("entering NativeSystem.getPrivateNodeName()", ClusterLogger.LOG_FINER);
        Session sess = (Session)s_sessions.get(nodeinfo.getSessionId());
        String node = nodeinfo.getNodeName();
        String pvtNodeNameCmd = null;
        File file = new File("/opt/ORCLcluster/bin/clspvtname");
        pvtNodeNameCmd = file.exists() ? "/opt/ORCLcluster/bin/clspvtname -n " : ((file = new File("/usr/cluster/bin/scha_cluster_get")).exists() ? "/usr/cluster/bin/scha_cluster_get -O PRIVATELINK_HOSTNAME_NODE " : null);
        if (pvtNodeNameCmd == null) {
            CommandResult result = new CommandResult("localhost");
            result.setException(new CommandException(node, "PROV-10007", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"GET_PRIVATE_NODE_NAME_FAIL0", (Object[])new Object[]{"/opt/ORCLcluster/bin/clspvtname", "/usr/cluster/bin/scha_cluster_get"})));
            result.setStatus(false);
            result.setResult(null);
            return result;
        }
        String cmd = pvtNodeNameCmd + " " + node;
        ClusterLogger.log(cmd, ClusterLogger.LOG_INFO);
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        CommandResult result = r_eng.runcmd(sess.getLocalNodeInfo(), NativeSystem.getCmdArr(cmd), null, null, true);
        if (result.getStatus() && (st = new StringTokenizer(outStr = result.getOutStr())).countTokens() > 0) {
            result.setResult(st.nextToken());
        }
        return result;
    }

    public abstract String getExeName(String var1);

    public CommandResult runcmd(NodeInfo nodeinfo, String cmd, boolean bSsh) {
        SessionId sessId = nodeinfo.getSessionId();
        Session sess = (Session)s_sessions.get(sessId);
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        return r_eng.runcmd(nodeinfo, NativeSystem.getCmdArr(cmd), null, null, bSsh);
    }

    protected String convertToStr(String[] arr) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            buffer.append(arr[i]);
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public CommandResult runcmd(NodeInfo nodeinfo, String[] cmdarr, boolean bSsh) {
        SessionId sessId = nodeinfo.getSessionId();
        Session sess = (Session)s_sessions.get(sessId);
        RemoteExecutionEngine r_eng = this.getRemoteExecutionEngine(sess);
        return r_eng.runcmd(nodeinfo, cmdarr, null, null, bSsh);
    }

    protected CommandResult runCmdOnLocalNode(String cmd) {
        SessionId sessId = NativeSystem.getDefaultSessionId();
        Session sess = (Session)s_sessions.get(sessId);
        Paths localPaths = sess.getLocalPaths();
        String[] cmdArray = new String[]{localPaths.getValue("SH_PATH"), "-c", cmd};
        return this.runcmd(sess.getLocalNodeInfo(), cmdArray, true);
    }

    public ClusterResult runCmdOnLocalNode(SessionId sessid, String cmd) throws FatalException, ClusterException {
        Session sess = (Session)s_sessions.get(sessid);
        Paths localPaths = sess.getLocalPaths();
        String[] cmdArray = new String[]{localPaths.getValue("SHELL_PATH"), localPaths.getValue("SHELL_ARGS"), cmd};
        CommandResult localresult = this.runcmd(sess.getLocalNodeInfo(), cmdArray, true);
        GenericResult clusterResult = new GenericResult(localresult);
        if (localresult.getStatus()) {
            return clusterResult;
        }
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16011", (Object[])new Object[]{cmd, s_sHostnameLocal});
        throw new ClusterException("PROV-16011", errorMessage, clusterResult.getResults());
    }

    public String getStandardForm(String nativePath) {
        char nativeFileSeparatorChar = this.getFileSeparatorChar();
        return nativePath.replace(nativeFileSeparatorChar, '/');
    }

    public String getParentDir(String path) {
        int pathLen = path.length();
        int lastSepPos = path.lastIndexOf(47, pathLen - 2);
        if (lastSepPos != -1) {
            return path.substring(0, lastSepPos);
        }
        return null;
    }

    public boolean isClientSSH2(SessionId sessid) throws FatalException, ClusterException {
        CommandResult result = this.findSSHClientType(sessid);
        if (null != result.getOutStr() && result.getOutStr().indexOf("Tectia") != -1 || null != result.getErrStr() && result.getErrStr().indexOf("Tectia") != -1) {
            return true;
        }
        ClusterLogger.log("Client type is not Tectia.");
        return false;
    }

    public boolean isSunSSHClient(SessionId sessid) throws FatalException, ClusterException {
        CommandResult result = this.findSSHClientType(sessid);
        if (null != result.getOutStr() && result.getOutStr().indexOf("Sun_SSH") != -1 || null != result.getErrStr() && result.getErrStr().indexOf("Sun_SSH") != -1) {
            return true;
        }
        ClusterLogger.log("Client type is not SunSSH.");
        return false;
    }

    public boolean isOpenSSHClient(SessionId sessid) throws FatalException, ClusterException {
        CommandResult result = this.findSSHClientType(sessid);
        if (null != result.getOutStr() && result.getOutStr().indexOf("OpenSSH") != -1 || null != result.getErrStr() && result.getErrStr().indexOf("OpenSSH") != -1) {
            return true;
        }
        ClusterLogger.log("Client type is not OpenSSH.");
        return false;
    }

    private CommandResult findSSHClientType(SessionId sessid) throws FatalException {
        ClusterLogger.log("Inside the findSSHClientType method:");
        Paths paths = NativeSystem.getLocalPathsWithoutStartup(null);
        Session sess = (Session)s_sessions.get(sessid);
        String sshpaths = sess.getSshPath();
        ClusterLogger.log("Inside the findSSHClientType method:" + sshpaths);
        if (null == sshpaths || sshpaths.trim().length() == 0) {
            sshpaths = paths.getValue("SSH_PATH");
        }
        String[] cmd = new String[]{sshpaths, paths.getValue("SSH_VERSION_ARGS")};
        CommandResult result = this.runcmd(sess.getLocalNodeInfo(), cmd, true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String connectToSSHPort(String nodeName, int port) throws FatalException {
        if (-1 == port) {
            port = 22;
        }
        String output = null;
        Socket serverSocket = null;
        try {
            int DEFAULT_SLEEP_TIME;
            serverSocket = new Socket(nodeName, port);
            InputStream is = serverSocket.getInputStream();
            int timeout = DEFAULT_SLEEP_TIME = 15;
            String timeoutPropertyVal = System.getProperty(SOCKET_READ_TIMEOUT);
            if (null != timeoutPropertyVal && !timeoutPropertyVal.equals("")) {
                try {
                    timeout = Integer.parseInt(timeoutPropertyVal);
                }
                catch (NumberFormatException nfe) {
                    timeout = DEFAULT_SLEEP_TIME;
                }
            }
            int waitTime = 1;
            ClusterLogger.log("NativeSystem: Going to wait for a maximum time of " + timeout + " seconds to get reply from the SSH-Port: " + port + " of the node:" + nodeName);
            while (waitTime++ <= timeout) {
                int k;
                try {
                    Thread.sleep(waitTime * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((k = is.available()) <= 0) continue;
                byte[] buf = new byte[k];
                is.read(buf);
                output = new String(buf);
                ClusterLogger.log("NativeSystem: Waited for " + (waitTime - 1) + " seconds for reply from SSH-Port " + port + " of the node:" + nodeName);
                break;
            }
        }
        catch (UnknownHostException e) {
            throw new FatalException(e);
        }
        catch (IOException e) {
            if (null == output) {
                throw new FatalException(e);
            }
        }
        finally {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {}
        }
        ClusterLogger.log("NativeSystem: Output from the socket: " + output + ":: SSH-Port Used= " + port + " Node-Name: " + nodeName);
        return output;
    }

    private String decryptObfuscatedPassword(String sObfuscatedPassword) throws FatalException {
        try {
            return Formatter.hexStringMD5ToNormalString((String)sObfuscatedPassword, (String)"UTF8");
        }
        catch (Exception e) {
            ClusterLogger.log("Password seems to be incorrect.");
            ClusterLogger.log(e);
            throw new FatalException("PROV-16044", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16044", null));
        }
    }

    public static boolean isServerSSH2(String nodeName, int port) throws FatalException {
        String output = NativeSystem.connectToSSHPort(nodeName, port);
        return null != output && output.indexOf("Tectia") != -1;
    }

    public static boolean isSunSSHServer(String nodeName, int sshPort) throws FatalException {
        String output = NativeSystem.connectToSSHPort(nodeName, sshPort);
        return null != output && output.indexOf("Sun_SSH") != -1;
    }

    public static boolean isPlainOpenSSHServer(String nodeName, int sshPort) throws FatalException {
        String output = NativeSystem.connectToSSHPort(nodeName, sshPort);
        return null != output && output.indexOf("OpenSSH") != -1;
    }

    static {
        String rplugin;
        startupCount = 0;
        TMPPATH = System.getProperty("java.io.tmpdir");
        s_sHostnameLocal = null;
        s_sFullHostnameLocal = null;
        s_bUseExistingSSH = true;
        s_tmpLocs = new Hashtable();
        s_nativesystem = null;
        s_sessions = new Hashtable();
        String s_sPropertiesDir = System.getProperty("oracle.sysman.prov.PathsPropertiesLoc");
        if (s_sPropertiesDir != null) {
            String absPath = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)s_sPropertiesDir, (String)SYSTEM_PROPERTIES));
            ClusterLogger.log("Loading system properties from file: " + absPath, ClusterLogger.LOG_INFO, false);
            Properties temp = null;
            try {
                FileInputStream fs = new FileInputStream(absPath);
                temp = new Properties();
                temp.load(fs);
                fs.close();
            }
            catch (IOException fs) {
                // empty catch block
            }
            if (temp != null) {
                Enumeration<?> propNames = temp.propertyNames();
                while (propNames.hasMoreElements()) {
                    String propName = (String)propNames.nextElement();
                    String propval = (String)temp.get(propName);
                    if (System.getProperty(propName) != null) continue;
                    System.setProperty(propName, propval);
                    ClusterLogger.log("Setting property " + propName + " to " + propval, ClusterLogger.LOG_FINEST, false);
                }
            }
        }
        if (null != (rplugin = System.getProperty("oracle.sysman.prov.default_plugin"))) {
            try {
                RemoteExecutionEngine.setDefaultPlugin(rplugin);
            }
            catch (PluginException pe) {
                ClusterLogger.log((Throwable)((Object)pe));
            }
            catch (FatalException fe) {
                ClusterLogger.log((Throwable)((Object)fe));
            }
        }
    }
}

