/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.nativesystem;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Constants;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Paths;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SystemFactory;

public class Commands
implements Constants {
    private static final String PLATFORM_INFO_PROPERTIES = "platformInfo.properties";
    private static final String IGNORE_MSG_FILE = "ignoreMessages.txt";
    private static final String RESOURCE_LOC = "oracle/sysman/prov/remoteinterfaces/nativesystem/";
    private String m_sPropertiesDir = null;
    private Map m_platInfo = null;
    private Map r_platInfo = null;
    private static List s_supportedPlatforms = null;
    private Map m_platTable = new Hashtable();
    private Vector m_ignoreStrings = null;
    private static int m_numStrings = 0;
    private boolean m_reload = true;
    public static final String PROP_FILE_READ_ERR_MSG = "Error reading file ";

    public Commands() throws FatalException {
        this(null);
    }

    public Commands(String propsDir) throws FatalException {
        InputStream in;
        ClusterLogger.log("entering Commands()", ClusterLogger.LOG_FINER);
        this.m_sPropertiesDir = System.getProperty("oracle.sysman.prov.PathsPropertiesLoc");
        this.m_sPropertiesDir = null != propsDir && propsDir.trim().length() != 0 ? propsDir : System.getProperty("oracle.sysman.prov.PathsPropertiesLoc");
        Class<?> cl = null;
        try {
            cl = Class.forName("oracle.sysman.prov.remoteinterfaces.nativesystem.Commands");
        }
        catch (ClassNotFoundException e) {
            ClusterLogger.log(e);
        }
        if (this.m_platInfo == null) {
            String absPath;
            if (this.m_sPropertiesDir != null && this.m_sPropertiesDir.trim().length() != 0) {
                this.m_sPropertiesDir = OiixPathOps.getAbsolutePath((String)this.m_sPropertiesDir);
            }
            boolean loadResource = true;
            Properties temp = null;
            if (this.m_sPropertiesDir != null) {
                absPath = OiixPathOps.concatPath((String)this.m_sPropertiesDir, (String)PLATFORM_INFO_PROPERTIES);
                temp = Commands.loadPropertiesFile(absPath);
                boolean bl = loadResource = temp == null;
            }
            if (loadResource && cl != null) {
                absPath = OiixPathOps.concatPath((String)RESOURCE_LOC, (String)PLATFORM_INFO_PROPERTIES);
                ClusterLogger.log("loading platformInfo.properties from jar: " + absPath, ClusterLogger.LOG_FINEST);
                in = cl.getClassLoader().getResourceAsStream(absPath);
                if (in != null) {
                    try {
                        temp = new Properties();
                        temp.load(in);
                        in.close();
                    }
                    catch (IOException e) {
                        ClusterLogger.log(e);
                    }
                }
            }
            if (temp == null) {
                throw new FatalException("PROV-16000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16000", (Object[])new String[]{PLATFORM_INFO_PROPERTIES}));
            }
            this.m_platInfo = new Hashtable();
            Enumeration<?> propNames = temp.propertyNames();
            while (propNames.hasMoreElements()) {
                Integer propName = null;
                String tempName = null;
                try {
                    tempName = (String)propNames.nextElement();
                    propName = new Integer(tempName);
                }
                catch (NumberFormatException nfe) {
                    ClusterLogger.log(nfe);
                }
                String propVal = (String)temp.get(tempName);
                StringTokenizer st = new StringTokenizer(propVal, ",");
                int numFiles = st.countTokens();
                String[] files = new String[numFiles];
                for (int i = 0; i < numFiles; ++i) {
                    files[i] = st.nextToken();
                }
                this.m_platInfo.put(propName, files);
            }
        }
        if (this.m_ignoreStrings == null) {
            String sPath;
            this.m_ignoreStrings = new Vector();
            BufferedReader bReader = null;
            boolean loadResource = true;
            if (this.m_sPropertiesDir != null) {
                sPath = OiixPathOps.concatPath((String)this.m_sPropertiesDir, (String)IGNORE_MSG_FILE);
                try {
                    sPath = OiixPathOps.getNativeForm((String)sPath);
                    bReader = new BufferedReader(new FileReader(sPath));
                    loadResource = false;
                    ClusterLogger.log("loading ignoreMessages.txt " + sPath, ClusterLogger.LOG_FINEST);
                }
                catch (FileNotFoundException e) {
                    ClusterLogger.log(e.toString());
                }
            }
            if (loadResource && cl != null) {
                sPath = OiixPathOps.concatPath((String)RESOURCE_LOC, (String)IGNORE_MSG_FILE);
                in = cl.getClassLoader().getResourceAsStream(sPath);
                if (in != null) {
                    bReader = new BufferedReader(new InputStreamReader(in));
                }
                ClusterLogger.log("loading ignoreMessages.txt from jar " + sPath, ClusterLogger.LOG_FINEST);
            }
            if (bReader != null) {
                this.readIgnoreMessages(bReader);
            }
        }
    }

    public Paths createInstance(int platId) throws FatalException {
        return this.createInstance(platId, null);
    }

    public Paths createInstance(int platId, String remotePathsDir) throws FatalException {
        return this.createInstance(platId, remotePathsDir, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Paths createInstance(int platId, String remotePathsDir, boolean bStore) throws FatalException {
        String absPath;
        ClusterLogger.log("entering Commands.CreateInstance(int " + platId + " String " + remotePathsDir + ")", ClusterLogger.LOG_FINER);
        boolean remotefound = false;
        String[] files = null;
        if (platId == SystemFactory.s_localPlatId && this.m_reload) {
            ClusterLogger.log("Reloading local platform properties");
        }
        Paths commands = null;
        if (bStore) {
            commands = (Paths)this.m_platTable.get(new Integer(platId));
        }
        if (commands != null && (platId != SystemFactory.s_localPlatId || !this.m_reload || remotePathsDir == null)) return commands;
        if (remotePathsDir != null && remotePathsDir.trim().length() != 0) {
            String platinfoabsPath = OiixPathOps.concatPath((String)remotePathsDir, (String)PLATFORM_INFO_PROPERTIES);
            Properties remotetemp = Commands.loadPropertiesFile(platinfoabsPath);
            if (remotetemp == null) {
                ClusterLogger.log("Problem loading REMOTE platforminfo.properties");
                remotefound = false;
            } else {
                this.loadremotePlatformInfo(remotetemp);
                files = (String[])this.r_platInfo.get(new Integer(platId));
                if (files == null) {
                    files = (String[])this.r_platInfo.get(new Integer(0));
                    if (files == null) {
                        ClusterLogger.log("Default id was not found in REMOTE platforminfo.properties");
                        remotefound = false;
                    } else {
                        ClusterLogger.log("Default id was found in REMOTE platforminfo.properties");
                        remotefound = true;
                    }
                } else {
                    ClusterLogger.log("Remote id was found in REMOTE platforminfo.properties");
                    remotefound = true;
                }
            }
        }
        commands = new Paths();
        if (!(remotefound || (files = (String[])this.m_platInfo.get(new Integer(platId))) != null && files.length != 0)) {
            files = OiixPlatform.isPlatInGroup((int)-1, (int)platId) ? (String[])this.m_platInfo.get(new Integer(-1)) : (OiixPlatform.isPlatInGroup((int)-3, (int)platId) ? (String[])this.m_platInfo.get(new Integer(-3)) : (String[])this.m_platInfo.get(new Integer(0)));
            if (files == null || files.length == 0) {
                throw new FatalException("PROV-16039", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16039", (Object[])new String[]{String.valueOf(platId)}));
            }
            ClusterLogger.log("Properties file from OMS home  platforminfo.properties " + files, ClusterLogger.LOG_FINEST);
        }
        if (platId == SystemFactory.s_localPlatId) {
            absPath = null;
            boolean loadResource = true;
            for (int i2 = 0; i2 < files.length; ++i2) {
                loadResource = true;
                if (this.m_sPropertiesDir != null) {
                    absPath = OiixPathOps.concatPath((String)this.m_sPropertiesDir, (String)files[i2]);
                    ClusterLogger.log("loading LOCAL  properties: " + absPath, ClusterLogger.LOG_FINEST);
                    boolean bl = loadResource = !this.loadFile(absPath, commands.m_props);
                }
                if (!loadResource) continue;
                absPath = OiixPathOps.concatPath((String)RESOURCE_LOC, (String)files[i2]);
                ClusterLogger.log("loading LOCAL properties from jar: " + absPath, ClusterLogger.LOG_FINEST);
                this.loadResource(absPath, commands.m_props);
            }
        }
        if (remotePathsDir != null && remotePathsDir.trim().length() != 0) {
            absPath = null;
            remotePathsDir = OiixPathOps.getAbsolutePath((String)remotePathsDir);
            for (int i = 0; i < files.length; ++i) {
                absPath = OiixPathOps.concatPath((String)remotePathsDir, (String)files[i]);
                try {
                    FileInputStream i2 = new FileInputStream(absPath);
                }
                catch (FileNotFoundException fnte) {
                    if (this.m_sPropertiesDir == null) throw new FatalException("PROV-16000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16000", (Object[])new String[]{String.valueOf(platId)}));
                    absPath = OiixPathOps.concatPath((String)this.m_sPropertiesDir, (String)files[i]);
                }
                ClusterLogger.log("loading properties For REMOTE Platform from : " + absPath, ClusterLogger.LOG_FINEST);
                this.loadFile(absPath, commands.m_props);
            }
        }
        BufferedReader bReader = null;
        String sPath = null;
        if (null != remotePathsDir) {
            sPath = OiixPathOps.concatPath((String)remotePathsDir, (String)IGNORE_MSG_FILE);
        } else {
            if (platId != SystemFactory.s_localPlatId) throw new FatalException("PROV-16055", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16055"));
            if (null == this.m_sPropertiesDir) throw new FatalException("PROV-16049", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16049"));
            sPath = OiixPathOps.concatPath((String)this.m_sPropertiesDir, (String)IGNORE_MSG_FILE);
        }
        try {
            sPath = OiixPathOps.getNativeForm((String)sPath);
            bReader = new BufferedReader(new FileReader(sPath));
            ClusterLogger.log("loading ignoreMessages.txt " + sPath, ClusterLogger.LOG_FINEST);
        }
        catch (FileNotFoundException e) {
            ClusterLogger.log(e.toString());
            if (this.m_sPropertiesDir == null) throw new FatalException("PROV-16049", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16049"));
            sPath = OiixPathOps.concatPath((String)this.m_sPropertiesDir, (String)IGNORE_MSG_FILE);
            sPath = OiixPathOps.getNativeForm((String)sPath);
            try {
                bReader = new BufferedReader(new FileReader(sPath));
            }
            catch (FileNotFoundException fne) {
                throw new FatalException("PROV-16000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16000", (Object[])new String[]{sPath}));
            }
        }
        if (bReader != null) {
            commands.readIgnoreMessages(bReader);
        }
        if (ClusterLogger.isLevelFiner(ClusterLogger.LOG_FINEST)) {
            for (String propName : commands.m_props.keySet()) {
                String[] val = (String[])commands.m_props.get(propName);
                ClusterLogger.log("Set " + propName + " to " + val[0], ClusterLogger.LOG_FINEST);
            }
        }
        if (!bStore) return commands;
        this.m_platTable.put(new Integer(platId), commands);
        if (!this.m_reload || platId != SystemFactory.s_localPlatId || remotePathsDir == null) return commands;
        this.m_reload = false;
        return commands;
    }

    private void loadremotePlatformInfo(Properties temp) {
        this.r_platInfo = new Hashtable();
        Enumeration<?> propNames = temp.propertyNames();
        while (propNames.hasMoreElements()) {
            Integer propName = null;
            String tempName = null;
            try {
                tempName = (String)propNames.nextElement();
                propName = new Integer(tempName);
            }
            catch (NumberFormatException nfe) {
                ClusterLogger.log(nfe);
            }
            String propVal = (String)temp.get(tempName);
            StringTokenizer st = new StringTokenizer(propVal, ",");
            int numFiles = st.countTokens();
            String[] rfiles = new String[numFiles];
            for (int i = 0; i < numFiles; ++i) {
                rfiles[i] = st.nextToken();
            }
            this.r_platInfo.put(propName, rfiles);
        }
    }

    private void readIgnoreMessages(BufferedReader bReader) {
        try {
            m_numStrings = 0;
            String txt = bReader.readLine();
            ClusterLogger.log("Ignore error strings:", ClusterLogger.LOG_FINEST);
            while (txt != null) {
                if (!(txt = txt.trim()).equals("")) {
                    ClusterLogger.log(txt, ClusterLogger.LOG_FINEST);
                    this.m_ignoreStrings.add(txt);
                }
                txt = bReader.readLine();
            }
            bReader.close();
        }
        catch (FileNotFoundException e1) {
            ClusterLogger.log("ignoreMessages.txt not found.");
        }
        catch (IOException e2) {
            ClusterLogger.log("Exception while reading the file ignoreMessages.txt. The strings specified might not get ignored.");
        }
        m_numStrings = this.m_ignoreStrings.size();
    }

    static List getSupportedPlatforms() {
        if (s_supportedPlatforms == null) {
            s_supportedPlatforms = new ArrayList();
            try {
                Commands cmds = new Commands();
                Iterator iter = cmds.m_platInfo.keySet().iterator();
                while (iter.hasNext()) {
                    s_supportedPlatforms.add(iter.next());
                }
                return s_supportedPlatforms;
            }
            catch (FatalException e) {
                e.printStackTrace();
            }
        }
        return s_supportedPlatforms;
    }

    private boolean loadFile(String path, Map props) throws FatalException {
        Properties temp = Commands.loadPropertiesFile(path);
        if (temp == null) {
            return false;
        }
        Enumeration<?> propNames = temp.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propVal = (String)temp.get(propName);
            propVal = this.replaceVarVal(propVal);
            props.put(propName, new String[]{propVal, "0"});
        }
        return true;
    }

    private void loadResource(String path, Map props) {
        Class<?> cl = null;
        InputStream in = null;
        try {
            cl = Class.forName("oracle.sysman.prov.remoteinterfaces.nativesystem.Commands");
            in = cl.getClassLoader().getResourceAsStream(path);
        }
        catch (ClassNotFoundException e) {
            ClusterLogger.log(e);
        }
        Properties temp = null;
        if (in != null) {
            try {
                temp = new Properties();
                temp.load(in);
                in.close();
            }
            catch (IOException e) {
                ClusterLogger.log(e);
            }
            Enumeration<?> propNames = temp.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propVal = (String)temp.get(propName);
                props.put(propName, new String[]{propVal, "0"});
            }
        }
    }

    public static Properties loadPropertiesFile(String path) throws FatalException {
        path = OiixPathOps.getNativeForm((String)path);
        ClusterLogger.log("loading file: " + path, ClusterLogger.LOG_FINEST);
        Properties temp = null;
        try {
            FileInputStream fs = new FileInputStream(path);
            temp = new Properties();
            temp.load(fs);
            fs.close();
        }
        catch (IOException e2) {
            ClusterLogger.log(e2.getMessage());
        }
        catch (RuntimeException re) {
            throw new FatalException(PROP_FILE_READ_ERR_MSG + path, re);
        }
        return temp;
    }

    public synchronized boolean ignoreErrString(String str) {
        if ((str = str.trim()).equals("")) {
            return true;
        }
        for (int i = 0; i < m_numStrings; ++i) {
            String temp = (String)this.m_ignoreStrings.get(i);
            if (str.indexOf(temp) == -1) continue;
            return true;
        }
        return false;
    }

    public static String[] getLocalPathFiles(String pathsDir) throws FatalException {
        if (null == pathsDir) {
            pathsDir = System.getProperty("oracle.sysman.prov.PathsPropertiesLoc");
        }
        if (null == pathsDir) {
            throw new FatalException("PROV-16049", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16049"));
        }
        return Commands.getPathFiles(SystemFactory.s_localPlatId, pathsDir);
    }

    public static String[] getPathFiles(int platId, String pathsDir) throws FatalException {
        String platFile = OiixPathOps.concatPath((String)OiixPathOps.getStandardForm((String)pathsDir), (String)PLATFORM_INFO_PROPERTIES);
        Properties props = Commands.loadPropertiesFile(platFile);
        if (null == props && null == (props = Commands.loadPropertiesFile(platFile = OiixPathOps.concatPath((String)OiixPathOps.getStandardForm((String)pathsDir), (String)PLATFORM_INFO_PROPERTIES.toLowerCase())))) {
            throw new FatalException("PROV-16000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16000", (Object[])new String[]{platFile}));
        }
        String files = props.getProperty(String.valueOf(platId));
        if (null == files) {
            throw new FatalException("PROV-16039", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16039", (Object[])new Integer[]{new Integer(platId)}));
        }
        String[] filesList = OiixFunctionOps.explodeString((String)files, (String)",");
        return filesList;
    }

    public String replaceVarVal(String sourceString) {
        String replaceVar;
        String varVal;
        int startIdx = sourceString.indexOf("%");
        int endIdx = sourceString.lastIndexOf("%");
        if (startIdx != -1 && endIdx != startIdx && (varVal = OiixEnvironmentOps.getEnv((String)(replaceVar = sourceString.substring(startIdx + 1, endIdx)))) != null) {
            String endString = "";
            if (sourceString.length() > endIdx + 1) {
                endString = sourceString.substring(endIdx + 1);
            }
            return varVal + endString;
        }
        return sourceString;
    }

    public synchronized String replaceErrString(String str) {
        String temp = str.trim();
        if (temp.equals("")) {
            return temp;
        }
        block0: for (int i = 0; i < m_numStrings; ++i) {
            String replaceString = (String)this.m_ignoreStrings.get(i);
            while (true) {
                StringBuilder buf = new StringBuilder();
                int len = temp.length();
                int idx = temp.indexOf(replaceString);
                if (idx < 0) continue block0;
                buf.append(temp.substring(0, idx));
                buf.append("\n");
                if (idx != len) {
                    buf.append(temp.substring(idx + 1, len));
                }
                temp = buf.toString();
            }
        }
        return temp;
    }
}

