/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.logger;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import oracle.sysman.oii.oiio.oiiol.OiiolFileHandler;
import oracle.sysman.oii.oiio.oiiol.OiiolLogger;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.prov.remoteutil.logger.ConfigXMLHandler;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClusterLogger {
    private static String s_strJavaNewLine;
    private static final String CLASSNAME = "oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger";
    private static final String S_SEPERATOR = ": ";
    private static final String S_DELIMITER = ".";
    private static final String LOGGING_XML_LOC_PROPERTY = "oracle.sysman.prov.loggingXmlLoc";
    private static final String RI_LOGLOC_PROPERTY = "oracle.sysman.prov.riLogLoc";
    private static final String LOGGER_DEFNAME = "RemoteInterfaces";
    private static final String LOGGER_DEFEXTN = ".log";
    private static final String LOGGING_CONF_FILE = "logging_conf.xml";
    private static final String LOGGING_CONF_LOADCLASS = "oracle/sysman/prov/remoteinterfaces/logger/logging_conf.xml";
    private static OiiolLogger s_clusterLogger;
    private static Hashtable s_packageTraceTable;
    private static boolean s_bCallerInfo;
    private static boolean s_bTraceThreads;
    private static boolean s_bWriteToConsole;
    public static Level LOG_OFF;
    public static Level LOG_SEVERE;
    public static Level LOG_WARNING;
    public static Level LOG_CONFIG;
    public static Level LOG_INFO;
    public static Level LOG_FINE;
    public static Level LOG_FINER;
    public static Level LOG_FINEST;
    public static Level LOG_ALL;
    public static final String SEVERE = "SEVERE";
    public static final String WARNING = "WARNING";
    public static final String INFO = "INFO";
    public static final String CONFIG = "CONFIG";
    public static final String FINE = "FINE";
    public static final String FINER = "FINER";
    public static final String FINEST = "FINEST";
    public static final String ALL = "ALL";

    public static void log(String msg) {
        ClusterLogger.log(msg, LOG_INFO, false);
    }

    public static void log(Throwable thrown, Level level) {
        String msg = thrown.toString();
        try {
            StringWriter sw = new StringWriter();
            PrintWriter p = new PrintWriter(sw);
            thrown.printStackTrace(p);
            p.flush();
            msg = msg + s_strJavaNewLine + sw.toString();
            p.close();
            sw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        ClusterLogger.log(msg, level, false);
    }

    public static void log(Throwable thrown) {
        ClusterLogger.log(thrown, LOG_SEVERE);
    }

    public static void log(String msg, Level level) {
        ClusterLogger.log(msg, level, false);
    }

    public static void log(String msg, Level level, boolean writeToConsole) {
        try {
            String caller = ClusterLogger.inferCaller();
            String packageName = null;
            if (caller.length() > 0) {
                packageName = ClusterLogger.extractPackageName(caller);
            }
            Boolean val = null;
            if (s_packageTraceTable != null && packageName != null && (val = (Boolean)s_packageTraceTable.get(packageName)) != null && !val.booleanValue()) {
                return;
            }
            int levelValue = s_clusterLogger.getLevel().intValue();
            if (levelValue <= Level.FINEST.intValue()) {
                if (s_bCallerInfo) {
                    msg = caller + S_SEPERATOR + msg;
                }
                if (s_bTraceThreads) {
                    msg = Thread.currentThread().getName() + S_SEPERATOR + msg;
                }
            }
            if (writeToConsole && s_bWriteToConsole && levelValue <= level.intValue()) {
                System.out.println(msg);
            }
            s_clusterLogger.log(level, msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String extractPackageName(String name) {
        StringTokenizer st = new StringTokenizer(name, S_DELIMITER);
        int count = st.countTokens();
        StringBuffer buf = new StringBuffer();
        String packagename = null;
        for (int i = 0; i < count - 4; ++i) {
            String newtoken = st.nextToken();
            buf.append(newtoken + S_DELIMITER);
        }
        if (st.hasMoreTokens()) {
            buf.append(st.nextToken());
        }
        packagename = buf.toString();
        return packagename;
    }

    private static String inferCaller() {
        StackTraceElement frame;
        String cname;
        int ix;
        String caller = "";
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals(CLASSNAME); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(CLASSNAME)) {
                int lineNum = frame.getLineNumber();
                caller = cname + S_DELIMITER + frame.getMethodName() + S_SEPERATOR + (lineNum >= 0 ? String.valueOf(lineNum) : "");
                break;
            }
            ++ix;
        }
        return caller;
    }

    public static boolean isLevelFiner(Level level) {
        return s_clusterLogger.getLevel().intValue() <= level.intValue();
    }

    public static Level getLogLevel(String sLogLevel) {
        if (sLogLevel == null) {
            return LOG_INFO;
        }
        if ((sLogLevel = sLogLevel.trim()).equalsIgnoreCase(INFO)) {
            return LOG_INFO;
        }
        if (sLogLevel.equalsIgnoreCase(SEVERE)) {
            return LOG_SEVERE;
        }
        if (sLogLevel.equalsIgnoreCase(WARNING)) {
            return LOG_WARNING;
        }
        if (sLogLevel.equalsIgnoreCase(CONFIG)) {
            return LOG_CONFIG;
        }
        if (sLogLevel.equalsIgnoreCase(FINE)) {
            return LOG_FINE;
        }
        if (sLogLevel.equalsIgnoreCase(FINER)) {
            return LOG_FINER;
        }
        if (sLogLevel.equalsIgnoreCase(FINEST)) {
            return LOG_FINEST;
        }
        return LOG_INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String logLoc;
        s_strJavaNewLine = System.getProperty("line.separator");
        s_packageTraceTable = null;
        s_bCallerInfo = false;
        s_bTraceThreads = false;
        s_bWriteToConsole = true;
        LOG_OFF = Level.OFF;
        LOG_SEVERE = Level.SEVERE;
        LOG_WARNING = Level.WARNING;
        LOG_CONFIG = Level.CONFIG;
        LOG_INFO = Level.INFO;
        LOG_FINE = Level.FINE;
        LOG_FINER = Level.FINER;
        LOG_FINEST = Level.FINEST;
        LOG_ALL = Level.ALL;
        String sDir = System.getProperty(LOGGING_XML_LOC_PROPERTY);
        String sFile = LOGGING_CONF_FILE;
        ConfigXMLHandler handler = null;
        Vector logHandlers = null;
        BufferedReader bReader = null;
        boolean loadResource = true;
        InputStream in = null;
        if (sDir != null && sDir.trim().length() != 0) {
            sFile = OiixPathOps.concatPath((String)OiixPathOps.getStandardForm((String)sDir), (String)sFile);
            sFile = OiixPathOps.getNativeForm((String)OiixPathOps.getAbsolutePath((String)sFile));
            System.out.println("Logger configuration settings will be loaded from the file: " + sFile);
            try {
                bReader = new BufferedReader(new FileReader(new File(sFile)));
                loadResource = false;
            }
            catch (FileNotFoundException e) {
                System.out.println(sFile + " not found.");
                e.printStackTrace();
            }
        }
        if (loadResource) {
            Class<?> cl = null;
            try {
                cl = Class.forName(CLASSNAME);
                in = cl.getClassLoader().getResourceAsStream(LOGGING_CONF_LOADCLASS);
                if (in != null) {
                    bReader = new BufferedReader(new InputStreamReader(in));
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        logLoc = (logLoc = System.getProperty(RI_LOGLOC_PROPERTY)) != null && logLoc.trim().length() != 0 ? OiixPathOps.getNativeForm((String)OiixPathOps.getAbsolutePath((String)logLoc)) : null;
        if (bReader != null) {
            try {
                SAXParser parser = new SAXParser();
                parser.setValidationMode(0);
                handler = new ConfigXMLHandler();
                if (logLoc != null) {
                    handler.setLogLoc(logLoc);
                }
                parser.setContentHandler((ContentHandler)handler);
                parser.setErrorHandler((ErrorHandler)handler);
                parser.parse(new InputSource(bReader));
                s_clusterLogger = handler.getLogger();
                logHandlers = handler.getLogHandlers();
                s_packageTraceTable = handler.getPackageTraceTable();
                s_bCallerInfo = handler.getPrintSourceInfo();
                s_bTraceThreads = handler.getTraceThreads();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    bReader.close();
                }
                catch (IOException e) {}
            }
        }
        if (s_clusterLogger == null) {
            s_clusterLogger = OiiolLogger.getOiiolLogger((String)LOGGER_DEFNAME);
        }
        if (logHandlers == null || logHandlers.size() == 0) {
            if (logLoc != null) {
                OiiolFileHandler fHandler = (OiiolFileHandler)s_clusterLogger.setLogLocationWithTimestamp(logLoc, LOGGER_DEFNAME, LOGGER_DEFEXTN, LOG_INFO, null, 0, 1, 0);
                System.out.println("log file is present in " + logLoc);
                System.out.println(fHandler.getLogFileName());
                logHandlers.add(fHandler);
            } else {
                System.out.println("Registering console handler with the logger.");
                s_clusterLogger.addOiiolConsoleHandler(LOG_ALL, "SIMPLE");
                s_bWriteToConsole = false;
            }
        }
        if (null != logHandlers) {
            for (int i = 0; i < logHandlers.size(); ++i) {
                OiiolFileHandler fHandler = (OiiolFileHandler)logHandlers.elementAt(i);
                System.out.println("ClusterLogger - log file location: " + fHandler.getLogFileName());
            }
        } else {
            System.out.println("ClusterLogger: log messages are going to Console");
        }
    }
}

