/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;

public class ClusterException
extends OiixException {
    Map m_exceptions = null;
    List m_results = null;
    StringBuffer m_errorMessage = null;

    public ClusterException() {
    }

    public ClusterException(ClusterException e) {
        super(e.getErrorID(), e.getMessage(), e.getCause());
        this.m_exceptions = e.m_exceptions;
        this.m_errorMessage = e.m_errorMessage;
        this.m_results = e.m_results;
    }

    public ClusterException(String msg) {
        super(msg);
    }

    public ClusterException(String msg, Iterator commandResults) {
        this(null, msg, commandResults);
    }

    public ClusterException(String sID, String msg, Iterator commandResults) {
        super(sID, msg);
        if (commandResults != null) {
            this.m_results = new ArrayList();
            while (commandResults.hasNext()) {
                CommandException ex;
                CommandResult res = (CommandResult)commandResults.next();
                this.m_results.add(res);
                if (res == null || (ex = res.getException()) == null) continue;
                if (this.m_exceptions == null) {
                    this.m_exceptions = new HashMap();
                }
                if (this.m_errorMessage == null) {
                    this.m_errorMessage = new StringBuffer();
                }
                this.m_exceptions.put(res.getNodeName(), ex);
                this.m_errorMessage.append(ex.getMessage() + " ");
            }
        }
    }

    public int getCollectionLength() {
        if (this.m_results != null) {
            return this.m_results.size();
        }
        return 0;
    }

    public Iterator getFailedNodes() {
        if (this.m_exceptions != null) {
            return this.m_exceptions.keySet().iterator();
        }
        return null;
    }

    public Iterator getCommandResults() {
        if (this.m_results != null) {
            return this.m_results.iterator();
        }
        return null;
    }

    public String getErrorIDOnNode(String nodename) {
        CommandException ex;
        String errID = null;
        if (nodename != null && this.m_exceptions != null && (ex = (CommandException)((Object)this.m_exceptions.get(nodename))) != null) {
            errID = ex.getErrorID();
        }
        return errID;
    }

    public Throwable getExceptionOnNode(String nodename) {
        CommandException cause = null;
        if (nodename != null && this.m_exceptions != null) {
            CommandException ex;
            cause = ex = (CommandException)((Object)this.m_exceptions.get(nodename));
        }
        return cause;
    }

    public String getErrorMessageOnNode(String nodename) {
        CommandException ex;
        String errMsg = null;
        if (nodename != null && this.m_exceptions != null && (ex = (CommandException)((Object)this.m_exceptions.get(nodename))) != null) {
            errMsg = ex.getErrorMessage();
        }
        return errMsg;
    }

    public int getErrLevelOnNode(String nodename) {
        CommandException ex;
        int errLevel = -1;
        if (nodename != null && this.m_exceptions != null && (ex = (CommandException)((Object)this.m_exceptions.get(nodename))) != null) {
            errLevel = ex.getErrLevel();
        }
        return errLevel;
    }

    public String getErrorMessage() {
        String errorID;
        Throwable cause;
        String msg = this.getMessage();
        if (msg == null) {
            msg = "";
        }
        if (this.m_errorMessage != null) {
            msg = msg + " " + this.m_errorMessage.toString();
        }
        if ((cause = this.getCause()) != null) {
            msg = msg + "\n" + cause.getMessage();
        }
        if ((errorID = this.getErrorID()) != null) {
            Object[] args = new String[]{errorID, msg};
            msg = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"S_ERROR_MSG_FORMAT", (Object[])args);
        }
        return msg;
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.m_exceptions != null) {
            for (CommandException ex : this.m_exceptions.values()) {
                if (ex == null) continue;
                ex.printStackTrace(s);
            }
        }
    }

    public void printStackTrace(PrintWriter w) {
        super.printStackTrace(w);
        if (this.m_exceptions != null) {
            for (CommandException ex : this.m_exceptions.values()) {
                if (ex == null) continue;
                ex.printStackTrace(w);
            }
        }
    }
}

