/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.command;

import oracle.sysman.prov.remoteinterfaces.cluster.NodeInfo;
import oracle.sysman.prov.remoteinterfaces.command.Command;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;

public class UserEquivCommand
extends Command {
    public static int SSH = 0;
    public static int RSH = 1;
    public static int BOTH = 2;
    private int m_bSsh = BOTH;
    private String m_sUser = null;

    public UserEquivCommand(NodeInfo nodeinfo) {
        this.m_nodeInfo = nodeinfo;
        this.setNativeSystem(nodeinfo.getNativeSystem());
    }

    public UserEquivCommand(NodeInfo nodeinfo, int shell) {
        this(nodeinfo);
        this.m_bSsh = shell;
    }

    public UserEquivCommand(NodeInfo nodeinfo, String user, int shell) {
        this(nodeinfo, shell);
        this.m_sUser = user;
    }

    @Override
    public CommandResult execute() {
        if (this.m_bSsh == SSH) {
            return this.m_nativeSystem.checkSSHSetup(this.m_nodeInfo, this.m_sUser);
        }
        if (this.m_bSsh == RSH) {
            return this.m_nativeSystem.checkRSHSetup(this.m_nodeInfo, this.m_sUser);
        }
        return this.m_nativeSystem.isNodeAccessible(this.m_nodeInfo);
    }
}

