/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.command;

import oracle.sysman.prov.remoteinterfaces.cluster.NodeInfo;
import oracle.sysman.prov.remoteinterfaces.command.Command;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;

public class CopyCommand
extends Command {
    private String m_sourceFile;
    private NodeInfo m_sourceNode;
    private String m_destFile;
    private NodeInfo m_destNode;
    private String m_nodename;
    private boolean m_platformConversion = false;

    public CopyCommand(NodeInfo sourceNode, String sourceFile, NodeInfo destNode, String destFile) {
        this.m_sourceFile = sourceFile;
        this.m_sourceNode = sourceNode;
        this.m_destFile = destFile;
        this.m_destNode = destNode;
        String source = this.m_sourceNode.getNodeName();
        String dest = this.m_destNode.getNodeName();
        if (!source.equals("localhost")) {
            this.m_nodename = source;
            this.setNativeSystem(this.m_sourceNode.getNativeSystem());
            if (!destNode.equals("localhost")) {
                this.m_nodename = this.m_nodename + "," + dest;
            }
        } else {
            this.m_nodename = dest;
            this.setNativeSystem(this.m_destNode.getNativeSystem());
        }
    }

    @Override
    public String getNodeName() {
        return this.m_nodename;
    }

    @Override
    public CommandResult execute() {
        return this.m_nativeSystem.copyFile(this.m_sourceNode, this.m_sourceFile, this.m_destNode, this.m_destFile);
    }
}

