/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.clusterops;

import oracle.sysman.prov.remoteinterfaces.clusterops.ClusterBaseOps;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteFileOperationException;
import oracle.sysman.prov.remoteinterfaces.nativesystem.SessionId;
import oracle.sysman.prov.remoteinterfaces.result.ClusterResult;

public class ClusterFileOps
extends ClusterBaseOps {
    public static final int TAR = 5;
    public static final int ZIP = 6;

    public static ClusterBaseOps getInstance(SessionId id) throws FatalException {
        if (id == null) {
            id = SessionId.getId();
        }
        Object[] objs = (Object[])s_sessions.get(id);
        ClusterFileOps fileops = null;
        if (objs != null) {
            fileops = (ClusterFileOps)objs[1];
        }
        if (fileops != null) {
            return fileops;
        }
        fileops = new ClusterFileOps(id);
        return fileops;
    }

    public static ClusterBaseOps getInstance() throws FatalException {
        return ClusterFileOps.getInstance(null);
    }

    protected ClusterFileOps(SessionId id) throws FatalException {
        super(id);
        Object[] objs = (Object[])s_sessions.get(this.m_sessionId);
        objs[1] = this;
    }

    public ClusterFileOps() throws FatalException {
        Object[] objs = (Object[])s_sessions.get(this.m_sessionId);
        ClusterFileOps fileops = (ClusterFileOps)objs[1];
        if (fileops == null) {
            objs[1] = this;
        }
    }

    @Override
    public ClusterResult copyFileToNode(String fileName1, String nodeName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyFileBetweenNodes(this.m_sessionId, "localhost", fileName1, nodeName, fileName1);
    }

    @Override
    public ClusterResult copyFileToNodes(String fileName1, String[] nodeNames) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyFileToNodes(this.m_sessionId, fileName1, nodeNames, fileName1);
    }

    @Override
    public ClusterResult copyFileToNode(String fileName1, String nodeName, String fileName2) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyFileBetweenNodes(this.m_sessionId, "localhost", fileName1, nodeName, fileName2);
    }

    @Override
    public ClusterResult copyFileToNodes(String fileName1, String[] nodeNames, String fileName2) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyFileToNodes(this.m_sessionId, fileName1, nodeNames, fileName2);
    }

    @Override
    public ClusterResult copyFileFromNode(String sourceNode, String sourceFile, String destFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyFileBetweenNodes(this.m_sessionId, sourceNode, sourceFile, "localhost", destFile);
    }

    @Override
    public ClusterResult extractArchiveOnNode(String filename, String nodename, String destdir, int cmd) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.extractArchiveOnNode(this.m_sessionId, filename, nodename, destdir, cmd, true, null);
    }

    @Override
    public ClusterResult copyDirToNode(String nodeName, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, new String[]{nodeName}, dirName, dirName, null, null, true);
    }

    @Override
    public ClusterResult copyDirToNodes(String[] nodeNames, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, nodeNames, dirName, dirName, null, null, true);
    }

    @Override
    public ClusterResult copyDirToNodes(String sourceDir, String[] nodeNames, String destDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, nodeNames, sourceDir, destDir, null, null, true);
    }

    @Override
    public ClusterResult copyDirToNodes(String[] nodeNames, String dirName, String excludeListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, nodeNames, dirName, dirName, excludeListFile, null, true);
    }

    @Override
    public ClusterResult copyDirToNodes(String[] nodeNames, String dirName, String excludeListFile, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, nodeNames, dirName, dirName, excludeListFile, tmpDir, true);
    }

    @Override
    public ClusterResult copyDirToNodes(String[] nodeNames, String srcdir, String destdir, String excludeListFile, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, nodeNames, srcdir, destdir, excludeListFile, tmpDir, true);
    }

    @Override
    public ClusterResult copyDirContentsToNodes(String[] nodeNames, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirToNodes(this.m_sessionId, nodeNames, dirName, dirName, null, null, false);
    }

    @Override
    public ClusterResult copyListedDirsToNode(String nodeName, String dirName, String copyListFile, String excludeListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, new String[]{nodeName}, dirName, copyListFile, excludeListFile, null, true);
    }

    @Override
    public ClusterResult copyListedDirsToNodes(String[] nodeNames, String dirName, String copyListFile, String excludeListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, nodeNames, dirName, copyListFile, excludeListFile, null, true);
    }

    @Override
    public ClusterResult copyListedDirsToNode(String nodeName, String dirName, String copyListFile, String excludeListFile, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, new String[]{nodeName}, dirName, copyListFile, excludeListFile, tmpDir, true);
    }

    @Override
    public ClusterResult copyListedDirsToNodes(String[] nodeNames, String dirName, String copyListFile, String excludeListFile, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, nodeNames, dirName, copyListFile, excludeListFile, tmpDir, true);
    }

    @Override
    public ClusterResult copyListedFilesToNode(String nodeName, String dirName, String copyListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, new String[]{nodeName}, dirName, copyListFile, null, null, true);
    }

    @Override
    public ClusterResult copyListedFilesToNodes(String[] nodeNames, String dirName, String copyListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, nodeNames, dirName, copyListFile, null, null, true);
    }

    @Override
    public ClusterResult copyListedFilesToNode(String nodeName, String dirName, String copyListFile, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, new String[]{nodeName}, dirName, copyListFile, null, tmpDir, true);
    }

    @Override
    public ClusterResult copyListedFilesToNodes(String[] nodeNames, String dirName, String copyListFile, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, nodeNames, dirName, copyListFile, null, tmpDir, true);
    }

    @Override
    public ClusterResult copyListedFilesToNode(String nodeName, String copyListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, new String[]{nodeName}, null, copyListFile, null, null, false);
    }

    @Override
    public ClusterResult copyListedFilesToNodes(String[] nodeNames, String copyListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyListedPathsToNodes(this.m_sessionId, nodeNames, null, copyListFile, null, null, false);
    }

    @Override
    public ClusterResult createDirInNode(String nodeName, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createDirInNodes(this.m_sessionId, new String[]{nodeName}, dirName);
    }

    @Override
    public ClusterResult createDirInNodes(String[] nodeNames, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createDirInNodes(this.m_sessionId, nodeNames, dirName);
    }

    @Override
    public ClusterResult createListedDirsOnNode(String nodeName, String createListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createListedDirsOnNodes(this.m_sessionId, new String[]{nodeName}, createListFile, null, null);
    }

    @Override
    public ClusterResult createListedDirsOnNodes(String[] nodeNames, String createListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createListedDirsOnNodes(this.m_sessionId, nodeNames, createListFile, null, null);
    }

    @Override
    public ClusterResult createListedDirsOnNode(String nodeName, String createListFile, String parentDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createListedDirsOnNodes(this.m_sessionId, new String[]{nodeName}, createListFile, parentDir, null);
    }

    @Override
    public ClusterResult createListedDirsOnNodes(String[] nodeNames, String createListFile, String parentDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createListedDirsOnNodes(this.m_sessionId, nodeNames, createListFile, parentDir, null);
    }

    @Override
    public ClusterResult createListedDirsOnNode(String nodeName, String createListFile, String parentDir, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createListedDirsOnNodes(this.m_sessionId, new String[]{nodeName}, createListFile, parentDir, tmpDir);
    }

    @Override
    public ClusterResult createListedDirsOnNodes(String[] nodeNames, String createListFile, String parentDir, String tmpDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.createListedDirsOnNodes(this.m_sessionId, nodeNames, createListFile, parentDir, tmpDir);
    }

    @Override
    public ClusterResult removeDirRecurseFromNode(String nodeName, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeDirFromNodes(this.m_sessionId, new String[]{nodeName}, dirName, true, false);
    }

    @Override
    public ClusterResult removeDirRecurseFromNodes(String[] nodeNames, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeDirFromNodes(this.m_sessionId, nodeNames, dirName, true, false);
    }

    @Override
    public ClusterResult removeDirFromNode(String nodeName, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeDirFromNodes(this.m_sessionId, new String[]{nodeName}, dirName, false, false);
    }

    @Override
    public ClusterResult removeDirFromNodes(String[] nodeNames, String dirName) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeDirFromNodes(this.m_sessionId, nodeNames, dirName, false, false);
    }

    @Override
    public ClusterResult removeDirFromNode(String nodeName, String dirName, boolean deleteEmptyParent) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeDirFromNodes(this.m_sessionId, new String[]{nodeName}, dirName, false, deleteEmptyParent);
    }

    @Override
    public ClusterResult removeDirFromNodes(String[] nodeNames, String dirName, boolean deleteEmptyParent) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeDirFromNodes(this.m_sessionId, nodeNames, dirName, false, deleteEmptyParent);
    }

    @Override
    public ClusterResult dirExists(String node, String dir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.pathExistsOnNode(this.m_sessionId, node, dir, 8);
    }

    @Override
    public ClusterResult fileExists(String node, String file) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.pathExistsOnNode(this.m_sessionId, node, file, 9);
    }

    @Override
    public ClusterResult isDirWritable(String node, String dir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.isDirWritable(this.m_sessionId, node, dir);
    }

    @Override
    public ClusterResult removeFileFromNode(String nodeName, String filename) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeFileFromNodes(this.m_sessionId, new String[]{nodeName}, filename);
    }

    @Override
    public ClusterResult removeFileFromNodes(String[] nodeNames, String filename) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeFileFromNodes(this.m_sessionId, nodeNames, filename);
    }

    @Override
    public ClusterResult removeListedFilesFromNode(String nodeName, String removeListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeListedPathsFromNodes(this.m_sessionId, new String[]{nodeName}, removeListFile, 9);
    }

    @Override
    public ClusterResult removeListedFilesFromNodes(String[] nodeNames, String removeListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeListedPathsFromNodes(this.m_sessionId, nodeNames, removeListFile, 9);
    }

    @Override
    public ClusterResult removeListedDirsFromNode(String nodeName, String removeListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeListedPathsFromNodes(this.m_sessionId, new String[]{nodeName}, removeListFile, 8);
    }

    @Override
    public ClusterResult removeListedDirsFromNodes(String[] nodeNames, String removeListFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.removeListedPathsFromNodes(this.m_sessionId, nodeNames, removeListFile, 8);
    }

    @Override
    public ClusterResult moveFileOnNode(String node, String sourceFile, String destFile) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.moveFileOnNode(this.m_sessionId, node, sourceFile, destFile);
    }

    @Override
    public ClusterResult listDirectoryOnNode(String nodeName, String dirPath) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.listDirectoryOnNode(this.m_sessionId, nodeName, dirPath);
    }

    @Override
    public ClusterResult copyDirFromNodes(String[] nodeNames, String srcDir, String destDir, String tmpDir, boolean extractModificationTime) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirFromNodes(this.m_sessionId, nodeNames, srcDir, destDir, tmpDir, extractModificationTime);
    }

    @Override
    public ClusterResult copyDirFromNodes(String[] nodeNames, String srcDir, String destDir) throws FatalException, RemoteFileOperationException {
        return this.m_nativeSystem.copyDirFromNodes(this.m_sessionId, nodeNames, srcDir, destDir, null, true);
    }
}

