/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.remoteinterfaces.cluster;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.prov.remoteinterfaces.cluster.NodeInfo;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterInfoException;
import oracle.sysman.prov.remoteinterfaces.exception.CommandException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.logger.ClusterLogger;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Assertions;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Constants;
import oracle.sysman.prov.remoteinterfaces.nativesystem.NativeSystem;
import oracle.sysman.prov.remoteinterfaces.nativesystem.Session;
import oracle.sysman.prov.remoteinterfaces.result.ClusterResult;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;
import oracle.sysman.prov.remoteinterfaces.result.GenericResult;

class ClusterInfo
implements Constants {
    private String m_CRSActiveVersion = null;
    private CommandResult m_CRSActiveVersionResult = null;
    private String m_localnode = null;
    private CommandResult m_localnodeResult = null;
    private String m_olsnodesPath = null;
    private String m_crsctlPath = null;
    private Map m_nodeInfoTable = null;
    private CommandResult m_nodeNamesResult = null;
    private static NativeSystem s_nativesystem = null;

    ClusterInfo(String CRSHome, NativeSystem nativesystem) throws FatalException, ClusterInfoException {
        Assertions.assertHome(CRSHome);
        if (nativesystem == null) {
            throw new FatalException("PROV-16001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16001"));
        }
        s_nativesystem = nativesystem;
        this.m_olsnodesPath = CRSHome + s_nativesystem.getFileSeparator() + "bin" + s_nativesystem.getFileSeparator() + s_nativesystem.getExeName("olsnodes");
        File exe = new File(this.m_olsnodesPath);
        if (!exe.exists()) {
            String path = CRSHome + s_nativesystem.getFileSeparator() + s_nativesystem.getExeName("olsnodes");
            exe = new File(path);
            if (!exe.exists()) {
                throw new FatalException("PROV-16000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-16000", (Object[])new String[]{this.m_olsnodesPath}));
            }
            this.m_olsnodesPath = path;
        }
        ClusterLogger.log("m_olsnodesPath = " + this.m_olsnodesPath);
        this.m_crsctlPath = CRSHome + s_nativesystem.getFileSeparator() + "bin" + s_nativesystem.getFileSeparator() + s_nativesystem.getExeName("crsctl");
        ClusterLogger.log("m_crsctlPath = " + this.m_crsctlPath);
        CommandResult result = this.getNodeNames().getResultOnNode("localhost");
        String[] nodes = (String[])result.getResult();
        this.m_nodeInfoTable = new HashMap(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            this.m_nodeInfoTable.put(nodes[i], new NodeInfo(nodes[i]));
        }
    }

    private String convertToStr(String[] arr) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            buffer.append(arr[i] + " ");
        }
        return buffer.toString();
    }

    ClusterResult getCRSActiveVersionString() throws ClusterInfoException {
        ClusterLogger.log("entering ClusterInfo.getCRSActiveVersionString()", ClusterLogger.LOG_FINER);
        if (this.m_CRSActiveVersion != null) {
            GenericResult clusterResult = new GenericResult(this.m_CRSActiveVersionResult);
            ClusterLogger.log("retuning the cached result ...", ClusterLogger.LOG_FINEST);
            return clusterResult;
        }
        String[] cmd = new String[]{this.m_crsctlPath, "query", "crs", "activeversion"};
        Session sess = (Session)NativeSystem.getSessions().get(NativeSystem.getDefaultSessionId());
        ClusterLogger.log(this.convertToStr(cmd), ClusterLogger.LOG_INFO, true);
        this.m_CRSActiveVersionResult = s_nativesystem.runcmd(sess.getLocalNodeInfo(), cmd, true);
        GenericResult clusterResult = new GenericResult(this.m_CRSActiveVersionResult);
        if (this.m_CRSActiveVersionResult.getStatus()) {
            String outStr = this.m_CRSActiveVersionResult.getOutStr();
            StringTokenizer st = new StringTokenizer(outStr, "[]", true);
            if (st.countTokens() >= 4) {
                st.nextToken();
                st.nextToken();
                String versionString = st.nextToken();
                ClusterLogger.log("Active version = " + versionString);
                if (versionString != null && versionString.length() != 0) {
                    this.m_CRSActiveVersion = versionString;
                    this.m_CRSActiveVersionResult.setResult(this.m_CRSActiveVersion);
                }
            }
            if (this.m_CRSActiveVersion == null) {
                this.m_CRSActiveVersionResult.setException(new CommandException("localhost", "PROV-10000", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"GET_CRS_ACTIVE_VERSION_FAIL0")));
                this.m_CRSActiveVersionResult.setStatus(false);
            }
        }
        if (this.m_CRSActiveVersion != null) {
            return clusterResult;
        }
        this.m_CRSActiveVersionResult.setResult(null);
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-10000");
        throw new ClusterInfoException("PROV-10000", errorMessage, clusterResult.getResults());
    }

    ClusterResult getCRSSoftwareVersionString(String nodeName) throws FatalException, ClusterInfoException {
        ClusterLogger.log("entering ClusterInfo.getCRSSoftwareVersionString()", ClusterLogger.LOG_FINER);
        Assertions.assertName(nodeName);
        NodeInfo nodeinfo = (NodeInfo)this.m_nodeInfoTable.get(nodeName);
        String softwareVersion = nodeinfo.getCRSSoftwareVersionString();
        if (softwareVersion != null) {
            GenericResult clusterResult = new GenericResult(nodeinfo.getCRSSoftwareVersionResult());
            ClusterLogger.log("retuning the cached result ...", ClusterLogger.LOG_FINEST);
            return clusterResult;
        }
        String[] cmd = new String[]{this.m_crsctlPath, "query", "crs", "softwareversion", nodeName};
        ClusterLogger.log(this.convertToStr(cmd), ClusterLogger.LOG_INFO, true);
        Session sess = (Session)NativeSystem.getSessions().get(NativeSystem.getDefaultSessionId());
        CommandResult result = s_nativesystem.runcmd(sess.getLocalNodeInfo(), cmd, true);
        if (result.getStatus()) {
            String outStr = result.getOutStr();
            StringTokenizer st = new StringTokenizer(outStr, "[]", true);
            if (st.countTokens() >= 8) {
                for (int i = 0; i < 6; ++i) {
                    st.nextToken();
                }
                String versionString = st.nextToken();
                ClusterLogger.log("Software version = " + versionString);
                if (versionString != null && versionString.length() != 0) {
                    softwareVersion = versionString;
                    result.setResult(softwareVersion);
                }
            }
            if (softwareVersion == null) {
                result.setException(new CommandException("localhost", "PROV-10001", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"GET_CRS_SOFTWARE_VERSION_FAIL0")));
                result.setStatus(false);
            }
        }
        GenericResult clusterResult = new GenericResult(result);
        nodeinfo.setCRSSoftwareVersionResult(result);
        if (softwareVersion != null) {
            nodeinfo.setCRSSoftwareVersionString(softwareVersion);
            return clusterResult;
        }
        result.setResult(null);
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-10001", (Object[])new String[]{nodeName});
        throw new ClusterInfoException("PROV-10001", errorMessage, clusterResult.getResults());
    }

    ClusterResult getHostName(String nodeName) throws FatalException, ClusterInfoException {
        ClusterLogger.log("entering ClusterInfo.getHostName()", ClusterLogger.LOG_FINER);
        Assertions.assertName(nodeName);
        NodeInfo nodeinfo = (NodeInfo)this.m_nodeInfoTable.get(nodeName);
        String hostname = nodeinfo.getHostName();
        if (hostname != null) {
            GenericResult clusterResult = new GenericResult(nodeinfo.getHostNameResult());
            ClusterLogger.log("retuning the cached result ...", ClusterLogger.LOG_FINEST);
            return clusterResult;
        }
        CommandResult result = s_nativesystem.getHostName(nodeinfo);
        GenericResult clusterResult = new GenericResult(result);
        nodeinfo.setHostNameResult(result);
        if (result.getStatus()) {
            nodeinfo.setHostName((String)result.getResult());
            return clusterResult;
        }
        result.setResult(null);
        throw new ClusterInfoException("PROV-10002", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-10002", (Object[])new String[]{nodeName}), clusterResult.getResults());
    }

    ClusterResult getLocalNodeName() throws ClusterInfoException {
        ClusterLogger.log("entering ClusterInfo.getLocalNodeName()", ClusterLogger.LOG_FINER);
        if (this.m_localnode != null) {
            GenericResult clusterResult = new GenericResult(this.m_localnodeResult);
            ClusterLogger.log("retuning the cached result ...", ClusterLogger.LOG_FINEST);
            return clusterResult;
        }
        String[] cmd = new String[]{this.m_olsnodesPath, "-l"};
        ClusterLogger.log(this.convertToStr(cmd), ClusterLogger.LOG_INFO, true);
        Session sess = (Session)NativeSystem.getSessions().get(NativeSystem.getDefaultSessionId());
        this.m_localnodeResult = s_nativesystem.runcmd(sess.getLocalNodeInfo(), cmd, true);
        if (this.m_localnodeResult.getStatus()) {
            String outStr = this.m_localnodeResult.getOutStr();
            StringTokenizer st = new StringTokenizer(outStr, "\n");
            if (st.countTokens() > 0) {
                this.m_localnode = st.nextToken();
                this.m_localnodeResult.setResult(this.m_localnode);
            } else {
                this.m_localnodeResult.setException(new CommandException("localhost", "PROV-10003", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"NO_LOCAL_NODE_NAME0")));
                this.m_localnodeResult.setStatus(false);
            }
        }
        GenericResult clusterResult = new GenericResult(this.m_localnodeResult);
        if (this.m_localnode != null) {
            return clusterResult;
        }
        this.m_localnodeResult.setResult(null);
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-10003");
        throw new ClusterInfoException("PROV-10003", errorMessage, clusterResult.getResults());
    }

    ClusterResult getNodeNames() throws ClusterInfoException {
        ClusterLogger.log("entering ClusterInfo.getNodeNames()", ClusterLogger.LOG_FINER);
        if (this.m_nodeInfoTable != null) {
            GenericResult clusterResult = new GenericResult(this.m_nodeNamesResult);
            ClusterLogger.log("retuning the cached result ...", ClusterLogger.LOG_FINEST);
            return clusterResult;
        }
        ClusterLogger.log(this.m_olsnodesPath, ClusterLogger.LOG_INFO, true);
        Session sess = (Session)NativeSystem.getSessions().get(NativeSystem.getDefaultSessionId());
        this.m_nodeNamesResult = s_nativesystem.runcmd(sess.getLocalNodeInfo(), this.m_olsnodesPath, true);
        String[] nodes = null;
        if (this.m_nodeNamesResult.getStatus()) {
            String outStr = this.m_nodeNamesResult.getOutStr();
            StringTokenizer st = new StringTokenizer(outStr, "\n");
            int num = st.countTokens();
            if (num > 0) {
                nodes = new String[num];
                for (int i = 0; i < num; ++i) {
                    nodes[i] = st.nextToken();
                }
                this.m_nodeNamesResult.setResult(nodes);
            } else {
                this.m_nodeNamesResult.setException(new CommandException("localhost", "PROV-10004", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"NO_NODE_NAMES0")));
                this.m_nodeNamesResult.setStatus(false);
            }
        }
        GenericResult clusterResult = new GenericResult(this.m_nodeNamesResult);
        if (nodes != null) {
            return clusterResult;
        }
        this.m_nodeNamesResult.setResult(null);
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-10004");
        throw new ClusterInfoException("PROV-10004", errorMessage, clusterResult.getResults());
    }

    ClusterResult getNodeVIP(String nodeName) throws FatalException, ClusterInfoException {
        ClusterLogger.log("entering ClusterInfo.getNodeVIP()", ClusterLogger.LOG_FINER);
        Assertions.assertName(nodeName);
        NodeInfo nodeinfo = (NodeInfo)this.m_nodeInfoTable.get(nodeName);
        String nodeVIP = nodeinfo.getNodeVIP();
        if (nodeVIP != null) {
            GenericResult clusterResult = new GenericResult(nodeinfo.getNodeVIPResult());
            ClusterLogger.log("retuning the cached result ...", ClusterLogger.LOG_FINEST);
            return clusterResult;
        }
        String[] cmd = new String[]{this.m_olsnodesPath, "-i", nodeName};
        ClusterLogger.log(this.convertToStr(cmd), ClusterLogger.LOG_INFO, true);
        Session sess = (Session)NativeSystem.getSessions().get(NativeSystem.getDefaultSessionId());
        CommandResult result = s_nativesystem.runcmd(sess.getLocalNodeInfo(), cmd, true);
        if (result.getStatus()) {
            String outStr = result.getOutStr();
            StringTokenizer st = new StringTokenizer(outStr);
            if (st.countTokens() >= 2) {
                st.nextToken();
                nodeVIP = st.nextToken();
                if (nodeVIP != null && nodeVIP.charAt(0) == '<') {
                    nodeVIP = null;
                }
            }
            if (nodeVIP == null) {
                result.setException(new CommandException("localhost", "PROV-10005", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"GET_NODE_VIP_FAIL0")));
                result.setStatus(false);
            }
        }
        GenericResult clusterResult = new GenericResult(result);
        nodeinfo.setNodeVIPResult(result);
        if (nodeVIP != null) {
            nodeinfo.setNodeVIP(nodeVIP);
            result.setResult(nodeVIP);
            return clusterResult;
        }
        result.setResult(null);
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-10005", (Object[])new String[]{nodeName});
        throw new ClusterInfoException("PROV-10005", errorMessage, clusterResult.getResults());
    }

    ClusterResult getOraclePrivateName(String nodeName) throws FatalException, ClusterInfoException {
        ClusterLogger.log("entering ClusterInfo.getOraclePrivateName()", ClusterLogger.LOG_FINER);
        Assertions.assertName(nodeName);
        NodeInfo nodeinfo = (NodeInfo)this.m_nodeInfoTable.get(nodeName);
        Session sess = (Session)NativeSystem.getSessions().get(NativeSystem.getDefaultSessionId());
        String privateName = nodeinfo.getOraclePrivateName();
        if (privateName != null) {
            GenericResult clusterResult = new GenericResult(nodeinfo.getOraclePrivateNameResult());
            ClusterLogger.log("retuning the cached result ...", ClusterLogger.LOG_FINEST);
            return clusterResult;
        }
        String[] cmd = new String[]{this.m_olsnodesPath, "-p", nodeName};
        ClusterLogger.log(this.convertToStr(cmd), ClusterLogger.LOG_INFO, true);
        CommandResult result = s_nativesystem.runcmd(sess.getLocalNodeInfo(), cmd, true);
        if (result.getStatus()) {
            String outStr = result.getOutStr();
            StringTokenizer st = new StringTokenizer(outStr);
            if (st.countTokens() >= 2) {
                st.nextToken();
                privateName = st.nextToken();
            } else {
                result.setException(new CommandException("localhost", "PROV-10006", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"GET_ORACLE_PRIVATE_NAME_FAIL0")));
                result.setStatus(false);
            }
        }
        GenericResult clusterResult = new GenericResult(result);
        nodeinfo.setOraclePrivateNameResult(result);
        if (privateName != null) {
            nodeinfo.setOraclePrivateName(privateName);
            result.setResult(privateName);
            return clusterResult;
        }
        result.setResult(null);
        String errorMessage = OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-10006", (Object[])new String[]{nodeName});
        throw new ClusterInfoException("PROV-10006", errorMessage, clusterResult.getResults());
    }

    ClusterResult getPrivateNodeName(String nodeName) throws FatalException, ClusterInfoException {
        ClusterLogger.log("entering ClusterInfo.getPrivateNodeName()", ClusterLogger.LOG_FINER);
        Assertions.assertName(nodeName);
        NodeInfo nodeinfo = (NodeInfo)this.m_nodeInfoTable.get(nodeName);
        String privateName = nodeinfo.getPrivateNodeName();
        if (privateName != null) {
            GenericResult clusterResult = new GenericResult(nodeinfo.getPrivateNodeNameResult());
            ClusterLogger.log("retuning the cached result ...", ClusterLogger.LOG_FINEST);
            return clusterResult;
        }
        CommandResult result = s_nativesystem.getPrivateNodeName(nodeinfo);
        GenericResult clusterResult = new GenericResult(result);
        nodeinfo.setPrivateNodeNameResult(result);
        if (result.getStatus()) {
            nodeinfo.setPrivateNodeName((String)result.getResult());
            return clusterResult;
        }
        result.setResult(null);
        throw new ClusterInfoException("PROV-10007", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-10007", (Object[])new String[]{nodeName}), clusterResult.getResults());
    }

    ClusterResult isLocalOnly(String nodeName) throws FatalException, ClusterInfoException {
        ClusterLogger.log("entering ClusterInfo.isLocalOnly()", ClusterLogger.LOG_FINER);
        Assertions.assertName(nodeName);
        NodeInfo nodeinfo = (NodeInfo)this.m_nodeInfoTable.get(nodeName);
        Boolean localOnly = nodeinfo.isLocalOnly();
        if (localOnly != null) {
            GenericResult clusterResult = new GenericResult(nodeinfo.isLocalOnlyResult());
            ClusterLogger.log("retuning the cached result ...", ClusterLogger.LOG_FINEST);
            return clusterResult;
        }
        CommandResult result = s_nativesystem.isLocalOnly(nodeinfo);
        GenericResult clusterResult = new GenericResult(result);
        nodeinfo.setLocalOnlyResult(result);
        if (result.getStatus()) {
            nodeinfo.setLocalOnly((Boolean)result.getResult());
            return clusterResult;
        }
        throw new ClusterInfoException("PROV-10008", OiixResourceBundle.getString((String)"oracle.sysman.prov.remoteinterfaces.resources.RuntimeRes", (String)"PROV-10008", (Object[])new String[]{nodeName}), clusterResult.getResults());
    }
}

