/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLConnection;
import oracle.xml.xsql.XSQLConnectionManager;
import oracle.xml.xsql.XSQLConnectionManagerFactory;
import oracle.xml.xsql.XSQLError;
import oracle.xml.xsql.XSQLErrorHandler;
import oracle.xml.xsql.XSQLInitializationException;
import oracle.xml.xsql.XSQLNoSuchConnectionException;
import oracle.xml.xsql.XSQLPage;
import oracle.xml.xsql.XSQLPageManager;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLRequestObjectListener;
import oracle.xml.xsql.XSQLUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public abstract class XSQLPageRequestImpl
implements XSQLPageRequest {
    private static final String SEMICOLON = ";";
    private static final String CHARSET = "charset";
    protected static final String EQUALS = "=";
    protected String outputEncoding = null;
    protected OutputStream outStream = null;
    protected PrintWriter out = null;
    protected PrintWriter err = null;
    protected String styleURI = null;
    protected String pageurl = null;
    protected String baseuri = null;
    protected boolean alreadyGotWriter = false;
    protected boolean alreadyGotOutputStream = false;
    protected XSQLError processingError = null;
    protected XSQLErrorHandler perPageErrorWriter = null;
    protected XSQLConnectionManagerFactory connFactory = null;
    protected Dictionary parameters = null;
    protected Hashtable _pageParameters = null;
    protected Hashtable _styleParams = null;
    protected boolean errorHeader = false;
    protected String requestedPageEncoding;
    protected XSQLConnection conn = null;
    boolean usingExistingNamedConnection = false;
    boolean isIncluded = false;
    private String connNameRequested = null;
    protected Document postedDocument = null;
    private XSQLPageRequest topReq = null;
    private Hashtable _requestObjects = null;

    @Override
    public boolean printedErrorHeader() {
        return this.errorHeader;
    }

    @Override
    public void setPrintedErrorHeader(boolean bl) {
        this.errorHeader = bl;
    }

    public XSQLPageRequestImpl() {
    }

    public XSQLPageRequestImpl(String string, Hashtable hashtable) {
        this.pageurl = string;
        this.parameters = hashtable;
    }

    @Override
    public boolean isUseOutputStream() {
        return this.outStream != null;
    }

    protected void setupWriter() {
        if (this.outputEncoding != null) {
            try {
                this.out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, this.outputEncoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (this.out == null) {
            this.out = new PrintWriter(System.out);
        }
    }

    protected void setupErrorWriter() {
        this.err = new PrintWriter(System.err);
    }

    @Override
    public String getParameter(String string) {
        String string2 = this.getPageParam(string);
        if (string2 != null) {
            return string2;
        }
        return this.parameters != null ? XSQLUtil.stringParamValue(this.parameters.get(string)) : null;
    }

    @Override
    public String[] getParameterValues(String string) {
        String[] stringArray = this.getPageParamValues(string);
        if (stringArray != null) {
            return stringArray;
        }
        return this.parameters != null ? XSQLUtil.stringParamValues(this.parameters.get(string)) : null;
    }

    @Override
    public String getSourceDocumentURI() {
        return this.pageurl;
    }

    @Override
    public String getBaseURI() {
        return this.baseuri;
    }

    @Override
    public PrintWriter getWriter() {
        if (!this.alreadyGotOutputStream) {
            if (this.outStream != null) {
                this.out = new PrintWriter(this.outStream);
            } else if (this.out == null) {
                this.setupWriter();
            }
            this.alreadyGotWriter = true;
            return this.out;
        }
        this.signalError(25024, null, null);
        return null;
    }

    @Override
    public PrintWriter getErrorWriter() {
        if (this.err == null) {
            this.setupErrorWriter();
        }
        return this.err;
    }

    @Override
    public boolean useConnectionPooling() {
        return true;
    }

    @Override
    public String getUserAgent() {
        String string = this.getParameter("useragent");
        return string == null ? "programmatic" : string;
    }

    @Override
    public void setContentType(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.indexOf(SEMICOLON)) >= 0 && (n = (string2 = string.substring(n + 1)).indexOf(CHARSET)) >= 0 && (n = (string2 = string2.substring(n + 1)).indexOf(EQUALS)) >= 0 && (string2 = string2.substring(n + 1)) != null) {
            this.outputEncoding = string2.trim();
        }
    }

    @Override
    public boolean useHTMLErrors() {
        return false;
    }

    @Override
    public String translateURL(String string) {
        return string;
    }

    @Override
    public void setStylesheetURI(String string) {
        this.styleURI = string;
    }

    @Override
    public String getStylesheetURI() {
        return this.styleURI;
    }

    @Override
    public Document getRequestParamsAsXMLDocument() {
        return XSQLUtil.DictionaryOfParamsAsXMLDocument(this.parameters);
    }

    @Override
    public void setPostedDocument(Document document) {
        this.postedDocument = document;
    }

    @Override
    public Document getPostedDocument() {
        return this.postedDocument;
    }

    @Override
    public void setStylesheetParameter(String string, String string2) {
        if (string != null && string2 != null) {
            if (this._styleParams == null) {
                this._styleParams = new Hashtable(5);
            }
            this._styleParams.put(string, string2);
        }
    }

    @Override
    public Enumeration getStylesheetParameters() {
        if (this._styleParams == null) {
            return null;
        }
        return this._styleParams.keys();
    }

    @Override
    public String getStylesheetParameter(String string) {
        return (String)this._styleParams.get(string);
    }

    @Override
    public void setPageEncoding(String string) {
        this.requestedPageEncoding = string;
    }

    @Override
    public String getPageEncoding() {
        return this.requestedPageEncoding;
    }

    @Override
    public void setConnectionName(String string) throws SQLException {
        this.connNameRequested = string;
        if (string != null && !string.equals("")) {
            if (this.conn == null || this.conn != null && !this.conn.getConnectionName().equals(string)) {
                try {
                    this.conn = this.getXSQLConnectionManager().getConnection(string, this);
                }
                catch (XSQLNoSuchConnectionException xSQLNoSuchConnectionException) {
                    throw xSQLNoSuchConnectionException;
                }
                catch (SQLException sQLException) {
                    this.signalError(25007, null, new Object[]{sQLException.getMessage()});
                    throw sQLException;
                }
            } else {
                this.usingExistingNamedConnection = true;
            }
        }
    }

    @Override
    public Connection getJDBCConnection() {
        return this.conn != null ? this.conn.getJDBCConnection() : null;
    }

    @Override
    public XSQLConnection getXSQLConnection() {
        return this.conn;
    }

    @Override
    public void setIncludingRequest(XSQLPageRequest xSQLPageRequest) {
        this.freeConnection();
        this.conn = xSQLPageRequest.getXSQLConnection();
        this.isIncluded = true;
    }

    @Override
    public String getConnectionName() {
        return this.conn != null ? this.conn.getConnectionName() : null;
    }

    @Override
    public void requestProcessed() {
        try {
            if (this.topReq == null && this.isErrorSignalled()) {
                if (this.perPageErrorWriter != null) {
                    this.perPageErrorWriter.handleError(this.processingError, this);
                } else {
                    XSQLUtil.getErrorHandler().handleError(this.processingError, this);
                }
            }
        }
        finally {
            this.freeConnection();
        }
    }

    @Override
    public boolean isOracleDriver() {
        return this.conn != null ? this.conn.isOracleDriver() : false;
    }

    private void freeConnection() {
        if (this.topReq == null && this._requestObjects != null) {
            Enumeration enumeration = this._requestObjects.elements();
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                if (!(v instanceof XSQLRequestObjectListener)) continue;
                ((XSQLRequestObjectListener)v).pageProcessingCompleted();
            }
        }
        if (this.conn != null && this.connNameRequested != null && !this.usingExistingNamedConnection) {
            this.getXSQLConnectionManager().releaseConnection(this.conn, this);
        }
    }

    @Override
    public boolean isIncludedRequest() {
        return this.isIncluded;
    }

    @Override
    public void setPageParam(String string, String string2) {
        if (this._pageParameters == null) {
            this._pageParameters = new Hashtable(5);
        }
        this._pageParameters.put(string, string2);
    }

    @Override
    public void setPageParam(String string, String[] stringArray) {
        if (this._pageParameters == null) {
            this._pageParameters = new Hashtable(5);
        }
        this._pageParameters.put(string, stringArray);
    }

    protected String getPageParam(String string) {
        if (this._pageParameters != null) {
            Object v = this._pageParameters.get(string);
            if (v == null) {
                return null;
            }
            if (v instanceof String) {
                return (String)v;
            }
            if (v instanceof String[]) {
                String[] stringArray = (String[])v;
                if (stringArray.length > 0) {
                    return stringArray[0];
                }
                return null;
            }
        }
        return null;
    }

    protected String[] getPageParamValues(String string) {
        if (this._pageParameters != null) {
            Object v = this._pageParameters.get(string);
            if (v == null) {
                return null;
            }
            if (v instanceof String) {
                return new String[]{(String)v};
            }
            if (v instanceof String[]) {
                String[] stringArray = (String[])v;
                if (stringArray.length > 0) {
                    return stringArray;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void setRequestObject(String string, Object object) {
        if (this.topReq != null) {
            this.topReq.setRequestObject(string, object);
        } else {
            if (this._requestObjects == null) {
                this._requestObjects = new Hashtable(2);
            }
            this._requestObjects.put(string, object);
        }
    }

    @Override
    public Object getRequestObject(String string) {
        if (this.topReq != null) {
            return this.topReq.getRequestObject(string);
        }
        if (this._requestObjects == null) {
            return null;
        }
        return this._requestObjects.get(string);
    }

    protected void setTopRequest(XSQLPageRequest xSQLPageRequest) {
        this.topReq = xSQLPageRequest;
    }

    protected XSQLPageRequest getTopRequest() {
        return this.topReq;
    }

    protected void setupOutputStream() {
        if (this.outStream == null) {
            this.outStream = System.out;
        }
    }

    @Override
    public OutputStream getOutputStream() {
        if (!this.alreadyGotWriter) {
            this.setupOutputStream();
            this.alreadyGotOutputStream = true;
            return this.outStream;
        }
        this.signalError(25025, null, null);
        return null;
    }

    @Override
    public XSQLPage getXSQLPage() throws SAXParseException, FileNotFoundException {
        try {
            XSQLPage xSQLPage = XSQLPageManager.getManager().getPage(this.getSourceDocumentURI(), this);
            this.setPageEncoding(xSQLPage.getDocument().getEncoding());
            return xSQLPage;
        }
        catch (SAXParseException sAXParseException) {
            throw sAXParseException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (XSQLInitializationException xSQLInitializationException) {
            throw xSQLInitializationException;
        }
        catch (RuntimeException runtimeException) {
            this.signalError(25017, null, new Object[]{runtimeException});
            throw runtimeException;
        }
    }

    private XSQLConnectionManager getXSQLConnectionManager() {
        return this.getConnectionManagerFactory().create();
    }

    @Override
    public XSQLConnectionManagerFactory getConnectionManagerFactory() {
        XSQLPageRequest xSQLPageRequest = this.getTopRequest();
        if (xSQLPageRequest != null) {
            return xSQLPageRequest.getConnectionManagerFactory();
        }
        if (this.connFactory == null) {
            this.connFactory = XSQLConfigManager.getManager().getDefaultConnectionManagerFactory();
        }
        return this.connFactory;
    }

    @Override
    public boolean isErrorSignalled() {
        return this.processingError != null;
    }

    @Override
    public void signalError(int n, String[] stringArray, Object[] objectArray) {
        this.processingError = new XSQLError(n, stringArray, objectArray);
    }

    @Override
    public void signalError(String string) {
        this.processingError = new XSQLError(string);
    }

    @Override
    public void setErrorHandlerClass(String string) throws XSQLInitializationException {
        if (this.topReq == null && string != null && !string.equals("") && this.perPageErrorWriter == null) {
            this.perPageErrorWriter = XSQLUtil.createErrorHandler(string, this);
            if (this.perPageErrorWriter == null) {
                throw new XSQLInitializationException();
            }
        }
    }
}

